﻿[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy


$testargs=$args
$userName=$testargs[0]
$Password=Eg-O365Dcr -EncStr $testargs[1]
$proxyUsr=$testargs[2]
$proxyPass=Eg-O365Dcr -EncStr $testargs[3]
$rName=$testargs[4]
if($proxyUsr.toString().toLower().Trim() -eq 'none') { $proxyUsr=$proxyUsr.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }

$RprtNameAndmTime=$rName.split("#")
$reportingname=$RprtNameAndmTime[0]
$mTime=$RprtNameAndmTime[1]
$prxyHostNport=$RprtNameAndmTime[2]
$proxyserverip='http://'+$prxyHostNport

#--------------------------------------
$domainSpecific=$false
if($reportingname -match '_exd'){
    $domainSpecific=$true
    $alldomainnames=@()
    $dhash=@{}
    $dmnsPhash=Eg-O635Domains -username $userName -password $Password -rptNam $reportingname -proxyserverip $proxyserverip -proxyUsr $proxyUsr -proxyPass $proxyPass
    $proctArr=$dmnsPhash[$reportingname].split('~')
    $dhash.Add('SupersetName',$proctArr[1])
    $dhash.Add($proctArr[0],$reportingname)
    $reportingname=$dhash['SupersetName']
    foreach($h in $dhash.Keys){
        if($h -ne 'SupersetName'){
            $alldomainnames+=$h
        }
    }
    $ds_MPTr_Key='';$ds_MPTr_fpth='';$ds_MPTr_nam='';
    $ds_MPMl_Key='';$ds_MPMl_fpth='';$ds_MPMl_nam='';
    $ds_MPSpm_Key='';$ds_MPSpm_fpth='';$ds_MPSpm_nam='';
    $ds_MPMsg_Key='';$ds_MPMsg_fpth='';$ds_MPMsg_nam='';
}
$rptPath='EXO/'+$reportingname
$chkwritPath=$egurkhaPath+'/agent/'+$rptPath
if($domainSpecific){ 
    $isWrite=Check-WriteFile -rptPath $chkwritPath -srchWrd 'EXOMailProtection' -mTimInMin $mTime
}
$isProceed=$false
if($isWrite){
    $isProceed=$true
}elseif($domainSpecific -eq $false){
    $isProceed=$true
}else{
    $isProceed=$false
}
#--------------------------------------

if($isProceed){
    $azureVal=Eg-GetAzureEnv -UserName $userName
    $azureEnvArr=$azureVal.Split(',')
    $ManualThrottle=0
    [double]$ActiveThrottle=.25
    $ResetSeconds=870
    $WriteLog=$true
    $LogFile = $egurkhaPath+'/agent/EXO/'+$reportingname+"\mailprotection.log"
    $LogFile1 = $egurkhaPath+'/agent/EXO/'+$reportingname+"\mailprotection1.log"
    $isFrstTimLog=$true

    # Writes output to a log file with a time date stamp
    Function Write-Log {
	    Param ([string]$string)
	    [string]$date = Get-Date -Format G
        if ($WriteLog) {
           ( "[" + $date + "] - [" + $reportingname+"] mTime -  " + $mTime + " - " + $string ) | Out-File -FilePath $LogFile -Append }
        if($isFrstTimLog){     
            if ($WriteLog -eq $true){ #if flag is true 
                if ([System.IO.File]::Exists($LogFile) -and (Get-Item $LogFile).length -gt 2mb) {  #if the size of file is greater than 1MB 
                    if([System.IO.File]::Exists($LogFile1)){  #if logfile1 already exists, delete logfile1 
                        Remove-Item $LogFile1 
                    } 
                    Rename-Item $LogFile $LogFile1 
                }
            }
            $isFrstTimLog=$false
        }
    }

    Function Start-SleepWithProgress {
	    Param([int]$sleeptime)
	    For ($i=0;$i -le $sleeptime;$i++){
		    $timeleft = ($sleeptime - $i);
		    Write-Progress -Activity "Sleeping" -CurrentOperation "$Timeleft More Seconds" -PercentComplete (($i/$sleeptime)*100);
		    start-sleep 1
	    }
	    Write-Progress -Completed -Activity "Sleeping"
    }

    Function New-CleanO365Session {
        $Credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $Password -asplaintext -force)
        $i = 0
	    while (($Credential -eq $Null) -and ($i -lt 5)){
		    $script:Credential = Get-Credential -Message "Please provide your Exchange Online Credentials"
		    $i++
	    }
	    if ($Credential -eq $null){
		    Write-log "[Error] - Failed to get credentials"
		    Write-Error -Message "Failed to get credentials" -ErrorAction Stop
	    }
	    Write-Log "Removing all PS Sessions"
        $getSession=Get-PSSession -ErrorAction SilentlyContinue
        if($getSession -ne $null -and $getSession -ne ''){
	        Disconnect-ExchangeOnline -Confirm:$false
        }
	    [System.GC]::Collect()
	    Write-Log ("Sleeping 15 seconds for Session Tear Down")
	    Start-SleepWithProgress -SleepTime 15
	    $Error.Clear()
	
	    # Create the session
	    Write-Log "Creating new PS Session"
	    $sessionOption = New-PSSessionOption -SkipRevocationCheck
        if(!$proxyserverip.ToString().ToLower().Contains('none')){
            [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserverip)
	        if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
	            $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
	            $sessionOption = New-PSSessionOption -SkipRevocationCheck -ProxyAccessType WinHttpConfig -ProxyAuthentication basic -ProxyCredential $proxyCred
	        }
        }

	    # Check for an error while creating the session
	    if ($Error.Count -gt 0){
		    Write-Log "[ERROR] - Error while setting up session"
		    Write-log $Error
		    $ErrorCount++
		    if ($ErrorCount -gt 3){
			    Write-log "[ERROR] - Failed to setup session after multiple tries"
			    Write-log "[ERROR] - Aborting Script"
			    exit
		    }
		    Write-Log "Sleeping 60s so that issue can potentially be resolved"
		    Start-SleepWithProgress -sleeptime 60
		    New-CleanO365Session
	    }
	    else{
		    $ErrorCount = 0
	    }
	
	    # Connect the ExchangeOnline
        Connect-ExchangeOnline  -ExchangeEnvironmentName $azureEnvArr[4] -ConnectionUri $azureEnvArr[1] -Credential $Credential -PSSessionOption $sessionOption
	
	    # Set the Start time for the current session
	    Set-Variable -Scope script -Name SessionStartTime -Value (Get-Date)
    }

    Function Test-O365Session {
	    $ObjectTime = Get-Date
	    $SessionInfo = $null
	    $SessionInfo = Get-PSSession
	    if ($SessionInfo -eq $null) { 
		    Write-Log "[ERROR] - No Session Found"
		    Write-log "Recreating Session"
		    New-CleanO365Session
	    }	
	    elseif ($SessionInfo.State -ne "Opened"){
		    Write-Log "[ERROR] - Session not in Open State"
		    Write-log ($SessionInfo | fl | Out-String )
		    Write-log "Recreating Session"
		    New-CleanO365Session
	    }
	    elseif (($ObjectTime - $SessionStartTime).totalseconds -gt $ResetSeconds){
		    Write-Log ("Session Has been active for greater than " + $ResetSeconds + " seconds" )
		    Write-Log "Rebuilding Connection"
		    [int]$DelayinSeconds = ((($ResetSeconds * $ActiveThrottle) / 2) - 15)
		    if ($DelayinSeconds -gt 0){
			    Write-Log ("Sleeping " + $DelayinSeconds + " addtional seconds to allow throttle recovery")
			    Start-SleepWithProgress -SleepTime $DelayinSeconds
		    }
		    else{
			    Write-Log ("Active Delay calculated to be " + ($DelayinSeconds + 15) + " seconds no addtional delay needed")
		    }
		    New-CleanO365Session
	    }
	    else {
	    }
	    if ($ManualThrottle -gt 0){
		    Write-log ("Sleeping " + $ManualThrottle + " milliseconds")
		    Start-Sleep -Milliseconds $ManualThrottle
	    }
    }

    Function Get-EstimatedTimeToCompletion {
	    param([int]$ProcessedCount)
	    $ProcessedCount++
	    if (($ProcessedCount % 100) -eq 0){
		    $CurrentDate = Get-Date
		    $AveragePerObject = (((($CurrentDate) - $ScriptStartTime).totalseconds) / $ProcessedCount)
		    Write-Log ("[STATS] - Total Number of Objects:     " + $ObjectCount)
		    Write-Log ("[STATS] - Number of Objects processed: " + $ProcessedCount)
		    Write-Log ("[STATS] - Average seconds per object:  " + $AveragePerObject)
		    Write-Log ("[STATS] - Estimated completion time:   " + $CurrentDate.addseconds((($ObjectCount - $ProcessedCount) * $AveragePerObject)))
	    }
	    return $ProcessedCount
    }


    $rptPath='EXO/'+$reportingname
    $MyDir=$egurkhaPath+'/agent/EXO/'+$reportingname
    if(!(Test-Path -Path $MyDir )){
        New-Item -ItemType directory -Path $MyDir
    }
    $isErrorOccur= $false

    $endDat = Get-Date
    $startDat = Get-Date -Hour 00 -Minute 00 -Second 00
    $startDat=$startDat.AddMinutes(-1440)
    $startingDat=$endDat.AddMinutes(-$mTime)

    Set-StrictMode -Version 2
    $ErrorCount = 0
    New-CleanO365Session
    $ScriptStartTime = Get-Date 
     
    try{
        Test-O365Session
        $Error.Clear()
        #$ruledetail   = Get-MailDetailTransportRuleReport |select EventType,MessageSize,Direction,SenderAddress,RecipientAddress,Date,Domain,Subject,MessageId | Where-Object {$_.Date -gt $startDat} | export-csv $transportRules
        $rulePageval=1
        try{
            $Error.Clear()
            $transportRules = Eg-WriteFile -ComntRptPath $rptPath -FileName "transportrules" -keyFileName "ktransportrules" -EgPath $egurkhaPath
            $trnptflag=$true
            while($trnptflag){
	            $ruleCount=0
	            $ruleDetails=Get-MailDetailTransportRuleReport -StartDate $startDat -EndDate $endDat -page $rulePageval -pagesize 5000 |select EventType,MessageSize,Direction,SenderAddress,RecipientAddress,Date,Domain,Subject,MessageId,Action,TransportRule
                $ruleDetails|Export-Csv -Append  -LiteralPath $transportRules[1]
                try{$ruleCount=$ruleDetails.Count}catch{$ruleCount=0}
                Test-O365Session
                if($ruleCount -lt 5000){
                    $trnptflag=$false
                }
                $rulePageval++
            }
        }
        Catch{
            $ErrorMessage = $_.Exception.Message
            write-Log ("ErrorMessage while running   TransportRule Report : "+$ErrorMessage)   
            $isErrorOccur=$true
        } 
        if($isErrorOccur -eq $true -and (Get-Item $transportRules[1]).length -le 2kb){
            write-Log (" Deleting file ErrorMessage while running  TransportRule Report  : "+$Error)  
            Remove-Item $transportRules[1]
            $isErrorOccur=$false
        }else{
            $ds_MPTr_Key=$transportRules[0];$ds_MPTr_fpth=$transportRules[1];$ds_MPTr_nam=$transportRules[2];
            $null=Protect-File  $transportRules[1] -Algorithm AES -KeyAsPlainText $transportRules[0] -RemoveSource
        } 

        Test-O365Session
        $Error.Clear()
        $MalwarePageval=1
        try{
            $Error.Clear()
            $malwareDetails = Eg-WriteFile -ComntRptPath $rptPath -FileName "malware" -keyFileName "kmalware" -EgPath $egurkhaPath
            $malwareflag=$true
            while($malwareflag){
	            $MalwareCount=0
		        $Malwaredata=Get-MailDetailMalwareReport -StartDate $startDat -EndDate $endDat -page $MalwarePageval -pagesize 5000 |select Date,SenderAddress,RecipientAddress,MessageSize,Direction,EventType,MalwareName,FileName
		        $Malwaredata|Export-Csv -Append  -LiteralPath $malwareDetails[1]
                try{$MalwareCount=$Malwaredata.Count }catch{$MalwareCount=0}
                Test-O365Session
                if($MalwareCount -lt 5000){
                    $malwareflag=$false
                }
                $MalwarePageval++
            }
        }Catch{
            $ErrorMessage = $_.Exception.Message
            write-Log ("ErrorMessage while running  Malware Report  : "+$ErrorMessage)   
            $isErrorOccur=$true
        } 
        if($isErrorOccur -eq $true -and (Get-Item $malwareDetails[1]).length -le 200){
            write-Log (" Deleting File ErrorMessage while running  Malware Report : "+$ErrorMessage)  
            Remove-Item $malwareDetails[1]
            $isErrorOccur=$false
        }else{
            $ds_MPMl_Key=$malwareDetails[0];$ds_MPMl_fpth=$malwareDetails[1];$ds_MPMl_nam=$malwareDetails[2];
            $null=Protect-File  $malwareDetails[1] -Algorithm AES -KeyAsPlainText $malwareDetails[0] -RemoveSource
        }

        Test-O365Session
        $SpamPageval=1
        try{
            $Error.Clear()
            $spamDetails = Eg-WriteFile -ComntRptPath $rptPath -FileName "spam" -keyFileName "kspam" -EgPath $egurkhaPath
            $spmflag=$true
            while($spmflag){
	            $spamCount=0
		        $spamdata=Get-MailDetailSpamReport -StartDate $startDat -EndDate $endDat -page $SpamPageval -pagesize 5000 |select -Property @{Name='Current Date';Expression={$endDat}},Date,SenderAddress,RecipientAddress,MessageSize,Direction,EventType,Subject,MessageTraceId,Domain,Organization,MessageId 
		        $spamdata|Export-Csv -Append  -LiteralPath $spamDetails[1]
		        try{$spamCount=$spamdata.Count}catch{$spamCount=0}
                Test-O365Session
                if($spamCount -lt 5000){
                    $spmflag=$false
                }
                $SpamPageval++
            }
        }Catch{
            $ErrorMessage = $_.Exception.Message
            write-Log ("ErrorMessage while running  spam Details : "+$ErrorMessage)   
            $isErrorOccur=$true
        } 
        if($isErrorOccur -eq $true -and (Get-Item $spamDetails[1]).length -le 2kb){
            write-Log ("Deleting file ErrorMessage while running   spam Details : "+$Error)  
            Remove-Item $spamDetails[1]
            $isErrorOccur=$false
        }else{
            $ds_MPSpm_Key=$spamDetails[0];$ds_MPSpm_fpth=$spamDetails[1];$ds_MPSpm_nam=$spamDetails[2];
            $null=Protect-File  $spamDetails[1] -Algorithm AES -KeyAsPlainText $spamDetails[0] -RemoveSource
        } 

        Test-O365Session
        $val=1
        try{
            $Error.Clear()
            $MsgTrace = Eg-WriteFile -ComntRptPath $rptPath -FileName "msgs" -keyFileName "kmsgs" -EgPath $egurkhaPath
            $msgflag=$true
            while($msgflag){
                $count=0
                $output=Get-MessageTrace -StartDate $startingDat -EndDate $endDat -page $val -pagesize 5000 | select-object senderaddress ,RecipientAddress ,FromIP ,ToIP ,Size ,Status, Subject, Received
                $output | Export-Csv -Append  -LiteralPath $MsgTrace[1]
                try{$count=$output.Count}catch{$count=0}
                Test-O365Session
                if($count -lt 5000){
                    $msgflag=$false
                }
                $val++
            }
        }Catch{
            $ErrorMessage = $_.Exception.Message
            write-Log ("ErrorMessage while running  Message Trace : "+$ErrorMessage)   
            $isErrorOccur=$true
        } 
        if($isErrorOccur -eq $true -and (Get-Item $MsgTrace[1]).length -le 2kb){
            write-Log ("Deleting File ErrorMessage while running   Message Trace : "+$Error)  
            Remove-Item $MsgTrace[1]
            $isErrorOccur=$false
        }else{
            $ds_MPMsg_Key=$MsgTrace[0];$ds_MPMsg_fpth=$MsgTrace[1];$ds_MPMsg_nam=$MsgTrace[2];
            $null=Protect-File  $MsgTrace[1] -Algorithm AES -KeyAsPlainText $MsgTrace[0] -RemoveSource
        } 
    }
    catch{
        $ErrorMessage = $_.Exception.Message
        $FailedItem = $_.Exception.ItemName
        write-log "ErrorMessage : " + $ErrorMessage   
        write-log "FailedItem : " + $FailedItem
    } 
    Write-Log "Script Complete Destroying PS Sessions"
    $getSession=Get-PSSession -ErrorAction SilentlyContinue
    if($getSession -ne $null -and $getSession -ne ''){
        Disconnect-ExchangeOnline -Confirm:$false
    }
}

if($domainSpecific){
    #------------- 1.For Domain Specific - transportrules ----------------------
    if($ds_MPTr_fpth -ne ''){
        $mptrFilePth=$ds_MPTr_fpth -replace (".csv",".dat")   
        if((Get-Item -Path $mptrFilePth).Length -gt 2KB){
            $null=Unprotect-File $mptrFilePth -Algorithm AES -KeyAsPlainText $ds_MPTr_Key
            $tpRls= import-csv $ds_MPTr_fpth
            $trnam=$ds_MPTr_nam.ToString()
            foreach($domain in $alldomainnames){
                $isAddContent=$false
                $domainDir=$egurkhaPath+'/agent/EXO/'+$dhash[$domain]
                if(!(Test-Path -Path $domainDir )){
                    New-Item -ItemType directory -Path $domainDir
                }        
                $rptDpth=$domainDir+'/'+$trnam
                foreach($tmpRes in $tpRls){
                    $chkAddres='';$addrs=$tmpRes.Domain
                    if($addrs.Contains('@')){
                        $chkAddres=$addrs.Split('@')[1]
                    }
                    #if($tmpRes.Domain -match $domain){
                    if($domain -match $chkAddres){
                        $isAddContent=$true
                        $tmpRes| export-csv $rptDpth -Append
                    }
                }
                if($isAddContent){
                    $knam=$trnam.Replace("csv","dat")
                    $kDpth=$domainDir+'/k'+$knam
                    $ds_MPTr_Key|Add-Content $kDpth
                    $null=Protect-File $rptDpth -Algorithm AES -KeyAsPlainText $ds_MPTr_Key -RemoveSource
                }
            }
        }
    }

    #------------- 2.For Domain Specific - malware ----------------------
    if($ds_MPMl_fpth -ne ''){
        $mpmlFilePth=$ds_MPMl_fpth -replace (".csv",".dat")
        if((Get-Item -Path $mpmlFilePth).Length -gt 200){
            $null=Unprotect-File $mpmlFilePth -Algorithm AES -KeyAsPlainText $ds_MPMl_Key
            $mwDtls= import-csv $ds_MPMl_fpth
            $mwnam=$ds_MPMl_nam.ToString()
            foreach($domain in $alldomainnames){
                $isAddContent=$false
                $domainDir=$egurkhaPath+'/agent/EXO/'+$dhash[$domain]
                if(!(Test-Path -Path $domainDir )){
                    New-Item -ItemType directory -Path $domainDir
                }        
                $rptDpth=$domainDir+'/'+$mwnam
                foreach($tmpRes in $mwDtls){
                    $sendrChkAddres='';$addrs=$tmpRes.SenderAddress
                    if($addrs.Contains('@')){
                        $sendrChkAddres=$addrs.Split('@')[1]
                    }
                    $recpChkAddres='';$recpAddrs=$tmpRes.RecipientAddress
                    if($recpAddrs.Contains('@')){
                        $recpChkAddres=$recpAddrs.Split('@')[1]
                    }
                    
                    #if($tmpRes.SenderAddress -match $domain -or $tmpRes.RecipientAddress -match $domain){
                    if($domain -match $sendrChkAddres -or $domain -match $recpChkAddres){
                        $isAddContent=$true
                        $tmpRes| export-csv $rptDpth -Append
                    }
                }
                if($isAddContent){
                    $knam=$mwnam.Replace("csv","dat")
                    $kDpth=$domainDir+'/k'+$knam
                    $ds_MPMl_Key|Add-Content $kDpth
                    $null=Protect-File $rptDpth -Algorithm AES -KeyAsPlainText $ds_MPMl_Key -RemoveSource
                }
            }
        }
    }

    #------------- 3.For Domain Specific - spam ----------------------
    if($ds_MPSpm_fpth -ne ''){
        $mpspmFilePth=$ds_MPSpm_fpth -replace (".csv",".dat")
        if((Get-Item -Path $mpspmFilePth).Length -gt 2KB){
            $null=Unprotect-File $mpspmFilePth -Algorithm AES -KeyAsPlainText $ds_MPSpm_Key
            $spmDtls= import-csv $ds_MPSpm_fpth
            $spmnam=$ds_MPSpm_nam.ToString()
            foreach($domain in $alldomainnames){
                $isAddContent=$false
                $domainDir=$egurkhaPath+'/agent/EXO/'+$dhash[$domain]
                if(!(Test-Path -Path $domainDir )){
                    New-Item -ItemType directory -Path $domainDir
                }        
                $rptDpth=$domainDir+'/'+$spmnam
                foreach($tmpRes in $spmDtls){
                    $chkAddres='';$addrs=$tmpRes.Domain
                    if($addrs.Contains('@')){
                        $chkAddres=$addrs.Split('@')[1]
                    }
                    #if($tmpRes.Domain -match $domain){
                    if($domain -match $chkAddres){
                        $isAddContent=$true
                        $tmpRes| export-csv $rptDpth -Append
                    }
                }
                if($isAddContent){
                    $knam=$spmnam.Replace("csv","dat")
                    $kDpth=$domainDir+'/k'+$knam
                    $ds_MPSpm_Key|Add-Content $kDpth
                    $null=Protect-File $rptDpth -Algorithm AES -KeyAsPlainText $ds_MPSpm_Key -RemoveSource
                }
            }
        }
    }

    #------------- 4.For Domain Specific - msgs ----------------------
     if($ds_MPMsg_fpth -ne ''){
        $mpmsgFilePth=$ds_MPMsg_fpth -replace (".csv",".dat")
        if((Get-Item -Path $mpmsgFilePth).Length -gt 2KB){
            $null=Unprotect-File $mpmsgFilePth -Algorithm AES -KeyAsPlainText $ds_MPMsg_Key
            $mtDtls= import-csv $ds_MPMsg_fpth
            $mtnam=$ds_MPMsg_nam.ToString()
            foreach($domain in $alldomainnames){
                $isAddContent=$false
                $domainDir=$egurkhaPath+'/agent/EXO/'+$dhash[$domain]
                if(!(Test-Path -Path $domainDir )){
                    New-Item -ItemType directory -Path $domainDir
                }        
                $rptDpth=$domainDir+'/'+$mtnam
                foreach($tmpRes in $mtDtls){
                    $sendrChkAddres='';$sendrAddrs=$tmpRes.SenderAddress
                    if($sendrAddrs.Contains('@')){
                        $sendrChkAddres=$sendrAddrs.Split('@')[1]
                    }
                    $recpChkAddres='';$recpAddrs=$tmpRes.RecipientAddress
                    if($recpAddrs.Contains('@')){
                        $recpChkAddres=$recpAddrs.Split('@')[1]
                    }
                    if($domain -match $sendrChkAddres -or $domain -match $recpChkAddres){
                        $isAddContent=$true
                        $tmpRes| export-csv $rptDpth -Append
                    }
                }
                if($isAddContent){
                    $knam=$mtnam.Replace("csv","dat")
                    $kDpth=$domainDir+'/k'+$knam
                    $ds_MPMsg_Key|Add-Content $kDpth
                    $null=Protect-File $rptDpth -Algorithm AES -KeyAsPlainText $ds_MPMsg_Key -RemoveSource
                }
            }
        }
    }
}

$csvDir=$egurkhaPath+'/agent/EXO/'+$reportingname+'/'
Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'transportrules'
Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'malware'
Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'spam'
Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'msgs'
# SIG # Begin signature block
# MIIcdAYJKoZIhvcNAQcCoIIcZTCCHGECAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUzjLfjNPrtT51EUOAkZCS7NMk
# 6ZiggherMIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFNDCC
# BBygAwIBAgIQAuEYSxAWnqD3sU8D3BMzUjANBgkqhkiG9w0BAQsFADByMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29k
# ZSBTaWduaW5nIENBMB4XDTE4MDcxMDAwMDAwMFoXDTIxMDkxNTEyMDAwMFowcTEL
# MAkGA1UEBhMCVVMxEzARBgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxp
# bjEdMBsGA1UEChMUZUcgSW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElu
# bm92YXRpb25zLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# oNt7XWB1y9xwtvCGO/XipXallOkZ3ScdXunWCONnBzryRdCj7C/WX9s1CU8KkjRP
# FjWW+BOXvvC4ZUqw0Ad2uJAXyBY2/lV9eaoTRFB6Kb2/tJzG3je7Vcu8MxGJlwzP
# QQrr6icEJeqAPFE7vmzThVbd9H1n5Zdmwx20WCFe2V9qyVYHt7/6GS7WB2CwwjT6
# iVmiKP8HZXgr3tHZeAEb7tdQqd5//9e+8Mp8anb8ZdNgC9PQjBmbrQ/wH3kV65gK
# L+5kbgRvIfsmYxXiU1IFkq4rSQ+tfsDtYqBhGfovef9Gt8ZTjx7S4fortxwR7tlz
# i+wLO5m8I9sm4I2ouyIOQQIDAQABo4IBxTCCAcEwHwYDVR0jBBgwFoAUWsS5eyoK
# o6XqcQPAYPkt9mV1DlgwHQYDVR0OBBYEFD3yRqdsw6UIddfMPwhUMv2AaGRAMA4G
# A1UdDwEB/wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzB3BgNVHR8EcDBuMDWg
# M6Axhi9odHRwOi8vY3JsMy5kaWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcx
# LmNybDA1oDOgMYYvaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJl
# ZC1jcy1nMS5jcmwwTAYDVR0gBEUwQzA3BglghkgBhv1sAwEwKjAoBggrBgEFBQcC
# ARYcaHR0cHM6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAP1QnJ6TEczaeGxVokMinsKam1mJB+zDk4B9rfm31
# iaZe9OeNvR/UJAs+5b0gKBZF9NmTVdayAYV74vZU5IElRo59q6hbg/20Wu87UyoE
# Yjwrv2DxHgl3z80piuLllmoe79vEu/bYvreBamzZmHlyxRP0us2KRfEsLBH23y1o
# zBATLc3yBu+mCfDg9E1RfhpKyD1iMHkbC90To6bpOlP9Pd6R4WEAFROILgm2bofQ
# ZhN4UNKbJ1uLCvV2NiUbU7+YSC3NP9SdphaDBiOnUWiK8MjTIPZbhh3QjI5f342q
# cUiR4LGx/Z/6pq4w6YHWd8c1czexD7xVCom7ZafCOKFWyzCCBmowggVSoAMCAQIC
# EAMBmgI6/1ixa9bV6uYX8GYwDQYJKoZIhvcNAQEFBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgQXNzdXJlZCBJRCBDQS0xMB4XDTE0MTAyMjAw
# MDAwMFoXDTI0MTAyMjAwMDAwMFowRzELMAkGA1UEBhMCVVMxETAPBgNVBAoTCERp
# Z2lDZXJ0MSUwIwYDVQQDExxEaWdpQ2VydCBUaW1lc3RhbXAgUmVzcG9uZGVyMIIB
# IjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAo2Rd/Hyz4II14OD2xirmSXU7
# zG7gU6mfH2RZ5nxrf2uMnVX4kuOe1VpjWwJJUNmDzm9m7t3LhelfpfnUh3SIRDsZ
# yeX1kZ/GFDmsJOqoSyyRicxeKPRktlC39RKzc5YKZ6O+YZ+u8/0SeHUOplsU/UUj
# joZEVX0YhgWMVYd5SEb3yg6Np95OX+Koti1ZAmGIYXIYaLm4fO7m5zQvMXeBMB+7
# NgGN7yfj95rwTDFkjePr+hmHqH7P7IwMNlt6wXq4eMfJBi5GEMiN6ARg27xzdPpO
# 2P6qQPGyznBGg+naQKFZOtkVCVeZVjCT88lhzNAIzGvsYkKRrALA76TwiRGPdwID
# AQABo4IDNTCCAzEwDgYDVR0PAQH/BAQDAgeAMAwGA1UdEwEB/wQCMAAwFgYDVR0l
# AQH/BAwwCgYIKwYBBQUHAwgwggG/BgNVHSAEggG2MIIBsjCCAaEGCWCGSAGG/WwH
# ATCCAZIwKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMw
# ggFkBggrBgEFBQcCAjCCAVYeggFSAEEAbgB5ACAAdQBzAGUAIABvAGYAIAB0AGgA
# aQBzACAAQwBlAHIAdABpAGYAaQBjAGEAdABlACAAYwBvAG4AcwB0AGkAdAB1AHQA
# ZQBzACAAYQBjAGMAZQBwAHQAYQBuAGMAZQAgAG8AZgAgAHQAaABlACAARABpAGcA
# aQBDAGUAcgB0ACAAQwBQAC8AQwBQAFMAIABhAG4AZAAgAHQAaABlACAAUgBlAGwA
# eQBpAG4AZwAgAFAAYQByAHQAeQAgAEEAZwByAGUAZQBtAGUAbgB0ACAAdwBoAGkA
# YwBoACAAbABpAG0AaQB0ACAAbABpAGEAYgBpAGwAaQB0AHkAIABhAG4AZAAgAGEA
# cgBlACAAaQBuAGMAbwByAHAAbwByAGEAdABlAGQAIABoAGUAcgBlAGkAbgAgAGIA
# eQAgAHIAZQBmAGUAcgBlAG4AYwBlAC4wCwYJYIZIAYb9bAMVMB8GA1UdIwQYMBaA
# FBUAEisTmLKZB+0e36K+Vw0rZwLNMB0GA1UdDgQWBBRhWk0ktkkynUoqeRqDS/Qe
# icHKfTB9BgNVHR8EdjB0MDigNqA0hjJodHRwOi8vY3JsMy5kaWdpY2VydC5jb20v
# RGlnaUNlcnRBc3N1cmVkSURDQS0xLmNybDA4oDagNIYyaHR0cDovL2NybDQuZGln
# aWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEQ0EtMS5jcmwwdwYIKwYBBQUHAQEE
# azBpMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYB
# BQUHMAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3Vy
# ZWRJRENBLTEuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQCdJX4bM02yJoFcm4bOIyAP
# gIfliP//sdRqLDHtOhcZcRfNqRu8WhY5AJ3jbITkWkD73gYBjDf6m7GdJH7+IKRX
# rVu3mrBgJuppVyFdNC8fcbCDlBkFazWQEKB7l8f2P+fiEUGmvWLZ8Cc9OB0obzpS
# CfDscGLTYkuw4HOmksDTjjHYL+NtFxMG7uQDthSr849Dp3GdId0UyhVdkkHa+Q+B
# 0Zl0DSbEDn8btfWg8cZ3BigV6diT5VUW8LsKqxzbXEgnZsijiwoc5ZXarsQuWaBh
# 3drzbaJh6YoLbewSGL33VVRAA5Ira8JRwgpIr7DUbuD0FAo6G+OPPcqvao173NhE
# MIIGzTCCBbWgAwIBAgIQBv35A5YDreoACus/J7u6GzANBgkqhkiG9w0BAQUFADBl
# MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
# d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJv
# b3QgQ0EwHhcNMDYxMTEwMDAwMDAwWhcNMjExMTEwMDAwMDAwWjBiMQswCQYDVQQG
# EwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNl
# cnQuY29tMSEwHwYDVQQDExhEaWdpQ2VydCBBc3N1cmVkIElEIENBLTEwggEiMA0G
# CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDogi2Z+crCQpWlgHNAcNKeVlRcqcTS
# QQaPyTP8TUWRXIGf7Syc+BZZ3561JBXCmLm0d0ncicQK2q/LXmvtrbBxMevPOkAM
# Rk2T7It6NggDqww0/hhJgv7HxzFIgHweog+SDlDJxofrNj/YMMP/pvf7os1vcyP+
# rFYFkPAyIRaJxnCI+QWXfaPHQ90C6Ds97bFBo+0/vtuVSMTuHrPyvAwrmdDGXRJC
# geGDboJzPyZLFJCuWWYKxI2+0s4Grq2Eb0iEm09AufFM8q+Y+/bOQF1c9qjxL6/s
# iSLyaxhlscFzrdfx2M8eCnRcQrhofrfVdwonVnwPYqQ/MhRglf0HBKIJAgMBAAGj
# ggN6MIIDdjAOBgNVHQ8BAf8EBAMCAYYwOwYDVR0lBDQwMgYIKwYBBQUHAwEGCCsG
# AQUFBwMCBggrBgEFBQcDAwYIKwYBBQUHAwQGCCsGAQUFBwMIMIIB0gYDVR0gBIIB
# yTCCAcUwggG0BgpghkgBhv1sAAEEMIIBpDA6BggrBgEFBQcCARYuaHR0cDovL3d3
# dy5kaWdpY2VydC5jb20vc3NsLWNwcy1yZXBvc2l0b3J5Lmh0bTCCAWQGCCsGAQUF
# BwICMIIBVh6CAVIAQQBuAHkAIAB1AHMAZQAgAG8AZgAgAHQAaABpAHMAIABDAGUA
# cgB0AGkAZgBpAGMAYQB0AGUAIABjAG8AbgBzAHQAaQB0AHUAdABlAHMAIABhAGMA
# YwBlAHAAdABhAG4AYwBlACAAbwBmACAAdABoAGUAIABEAGkAZwBpAEMAZQByAHQA
# IABDAFAALwBDAFAAUwAgAGEAbgBkACAAdABoAGUAIABSAGUAbAB5AGkAbgBnACAA
# UABhAHIAdAB5ACAAQQBnAHIAZQBlAG0AZQBuAHQAIAB3AGgAaQBjAGgAIABsAGkA
# bQBpAHQAIABsAGkAYQBiAGkAbABpAHQAeQAgAGEAbgBkACAAYQByAGUAIABpAG4A
# YwBvAHIAcABvAHIAYQB0AGUAZAAgAGgAZQByAGUAaQBuACAAYgB5ACAAcgBlAGYA
# ZQByAGUAbgBjAGUALjALBglghkgBhv1sAxUwEgYDVR0TAQH/BAgwBgEB/wIBADB5
# BggrBgEFBQcBAQRtMGswJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0
# LmNvbTBDBggrBgEFBQcwAoY3aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0Rp
# Z2lDZXJ0QXNzdXJlZElEUm9vdENBLmNydDCBgQYDVR0fBHoweDA6oDigNoY0aHR0
# cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNy
# bDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJl
# ZElEUm9vdENBLmNybDAdBgNVHQ4EFgQUFQASKxOYspkH7R7for5XDStnAs0wHwYD
# VR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNtyA8wDQYJKoZIhvcNAQEFBQADggEB
# AEZQPsm3KCSnOB22WymvUs9S6TFHq1Zce9UNC0Gz7+x1H3Q48rJcYaKclcNQ5IK5
# I9G6OoZyrTh4rHVdFxc0ckeFlFbR67s2hHfMJKXzBBlVqefj56tizfuLLZDCwNK1
# lL1eT7EF0g49GqkUW6aGMWKoqDPkmzmnxPXOHXh2lCVz5Cqrz5x2S+1fwksW5Etw
# TACJHvzFebxMElf+X+EevAJdqP77BzhPDcZdkbkPZ0XN1oPt55INjbFpjE/7WeAj
# D9KqrgB87pxCDs+R1ye3Fu4Pw718CqDuLAhVhSK46xgaTfwqIa1JMYNHlXdx3LEb
# S0scEJx3FMGdTy9alQgpECYxggQzMIIELwIBATCBhjByMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5n
# IENBAhAC4RhLEBaeoPexTwPcEzNSMAkGBSsOAwIaBQCgcDAQBgorBgEEAYI3AgEM
# MQIwADAZBgkqhkiG9w0BCQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4w
# DAYKKwYBBAGCNwIBFTAjBgkqhkiG9w0BCQQxFgQUfgCSgut/yJBo0KZfOJKrWJRi
# Lb0wDQYJKoZIhvcNAQEBBQAEggEAMPeri4XbRuPCY5EojIKTMXGa8xHoZaDHQoxe
# xCf2kd5xESDUblRRADUI3UFrvKKCf9Cnv5yYQKA98i6hwN1j6b0Wn3x4A1u5tKZD
# wOo3U9XdZP4kZBWuE5BFiNxDXGo6J4Il9DkbT0VvIlSJl7bVwYBAdTYC99JAT2mf
# YsBfCL/3snWxuszlLK2dj9ZCMdY7v3io+l6xzTQIgskeAXiJEoM79pitkC54hGzk
# T8OcA7iFGym0V/cI0g76YUVQXtvvj2Q6m+ZAd+MFh5RiVLSZvRUX/svqJoY1HUBO
# 3iZN3lelblkP0k3jjVAzP1rWXkKsG4PXnF9QrW82uaioKOftK6GCAg8wggILBgkq
# hkiG9w0BCQYxggH8MIIB+AIBATB2MGIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxE
# aWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMT
# GERpZ2lDZXJ0IEFzc3VyZWQgSUQgQ0EtMQIQAwGaAjr/WLFr1tXq5hfwZjAJBgUr
# DgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUx
# DxcNMjAwOTE1MTIyNjIxWjAjBgkqhkiG9w0BCQQxFgQUtM6xlqGciicniJAr1qpS
# 87pqXsQwDQYJKoZIhvcNAQEBBQAEggEANI5wqK9AuZhym4rPzmX1inG+tZWyWz0N
# yKUTNccVGfsBzHck/8tYjsMTaBl1chJKNToJYCjG9mkT99qsbFaNBuS5Vr+OG3Ab
# tiGeaa5wjGOZDRCb3R3GiaW57tSyysAUE/pGlCbjgVhC8m0IWQrlLXdgg6Dod/RL
# V7t7erHqCx5EvFaAuiZtqsEsp2bgOAdiRqD53wIRXs53Q2pm8UrPH9nBhlRa0lj9
# ZmNlDvAzuROfconhXt2ptIVd6mI2xuFBMU17LNxRuyqBiklej+c2pbbltY1dh1C2
# tYXSGntd5h/IF8irRu0d+PZB1srHdQtFMzjtfHT14ZbYXfyxaloLHA==
# SIG # End signature block
