# This Script will give all details of XenDesktop for Discovery

$Global:ErrorActionPreference="SilentlyContinue"
Add-pssnapin "Citrix.Common.Commands"
Add-pssnapin "Citrix.Host.Admin.V2"
Add-pssnapin "Citrix.Broker.Admin.V2"
Function Get-BrokerMachinesPaged
{
    param (
    $MachineName,
    $AgentVersion,
    $AllocationType,
    $ApplicationInUse,
    $AssignedClientName,
    $AssignedIPAddress,
    $AssociatedUserFullName,
    $AssociatedUserName,
    $AssociatedUserSID,
    $AssociatedUserUPN,
    $BrowserName,
    $CatalogName,
    $CatalogUid,
    $CatalogUUID,
    $ColorDepth,
    $ControllerDNSName,
    $DeliveryType,
    $Description,
    $DesktopCondition,
    $DesktopGroupName,
    $DesktopGroupUid,
    $DesktopGroupUUID,
    $DesktopKind,
    $DesktopUid,
    $DNSName,
    $FaultState,
    $FunctionalLevel,
    $HostedMachineId,
    $HostedMachineName,
    $HostingServerName,
    $HypervisorConnectionName,
    $HypervisorConnectionUid,
    $HypHypervisorConnectionUid,
    $IconUid,
    $ImageOutOfDate,
    $InMaintenanceMode,
    $IPAddress,
    $IsAssigned,
    $IsPhysical,
    $LastConnectionFailure,
    $LastConnectionTime,
    $LastConnectionUser,
    $LastDeregistrationReason,
    $LastDeregistrationTime,
    $LastErrorReason,
    $LastErrorTime,
    $LastHostingUpdateTime,
    $LastPvdErrorReason,
    $LastPvdErrorTime,
    $LoadIndex,
    $MachineInternalState,
    $Metadata,
    $OSType,
    $OSVersion,
    $PersistUserChanges,
    $PowerActionPending,
    $PowerState,
    $ProvisioningType,
    $PublishedApplication,
    $PublishedName,
    $PvdEstimatedCompletionTime,
    $PvdPercentDone,
    $PvdStage,
    $PvdUpdateStartTime,
    $RegistrationState,
    $ScheduledReboot,
    $SecureIcaRequired,
    $SessionAutonomouslyBrokered,
    $SessionClientAddress,
    $SessionClientName,
    $SessionClientVersion,
    $SessionConnectedViaHostName,
    $SessionConnectedViaIP,
    $SessionCount,
    $SessionDeviceId,
    $SessionHardwareId,
    $SessionHidden,
    $SessionKey,
    $SessionLaunchedViaHostName,
    $SessionLaunchedViaIP,
    $SessionProtocol,
    $SessionSecureIcaActive,
    $SessionsEstablished,
    $SessionSmartAccessTag,
    $SessionsPending,
    $SessionStartTime,
    $SessionState,
    $SessionStateChangeTime,
    $SessionSupport,
    $SessionType,
    $SessionUid,
    $SessionUserName,
    $SessionUserSID,
    $SID,
    $SummaryState,
    $SupportedPowerActions,
    $Tag,
    $UUID,
    $VMToolsState,
    $WillShutdownAfterUse,
    $WindowsConnectionSetting,
    $AssignedUserSID,
    $AdminAddress,
    $MaxRecordCount = 250
    )

    $argumentList = $PSBoundParameters
    $argumentList.Add("SortBy", "MachineName")
    $desktops = @()
    $desktops += Get-BrokerMachine -ReturnTotalRecordCount:$true -ErrorVariable RecordCount -ErrorAction SilentlyContinue @argumentList
    $total = $RecordCount.TotalAvailableResultCount
    while ($RecordCount.TotalAvailableResultCount -gt $MaxRecordCount)
    {
        $remainingPerc= [math]::round($desktops.count / $total * 100, 1)
        #Write-Host  "Getting Broker Machines. Retrieved $($desktops.count) of $total machines completed in $remainingPerc%"
        $last = $desktops[-1].MachineName
        $desktops += Get-BrokerMachine -ReturnTotalRecordCount:$true -ErrorVariable RecordCount -ErrorAction SilentlyContinue -Filter { MachineName -gt $last } @argumentList
    }
     
    return $desktops
}

Write-Host "[License_server]"
$ips = @{}
$count = 0
$tips = ""
$Site = Get-BrokerSite
$SiteName=""
if ($Site -ne $null)
{
    $SiteName = $Site.Name
    $ips = @(([net.dns]::GetHostEntry($Site.LicenseServerName)).AddressList)
	$tips = ""
	$count = 0
	if($? -and $ips)
	{
	    foreach($ip in $ips)
		{
			if($ip.AddressFamily -eq "InterNetwork")
			{
				if($count -eq 0)
				{
					$tips = $ip.IPAddressToString +":"+$Site.LicenseServerPort
				}
				else
				{
					$tips = $tips + "," + $ip.IPAddressToString+":"+$Site.LicenseServerPort
				}
				$count = $count + 1
			}	
		
		}	
		Write-Host $Site.LicenseServerName "=" $tips
	}	
}
$ips = @{}
$count = 0
$tips = ""

Write-Host "[Controllers]"
$Controllers = Get-BrokerController
$BrokerToHypIDs = @{}
if($Controllers -ne $null)
{
	foreach($Controller in $Controllers)
	{
		#Write-Host($Controller.DNSName)
		$ips = @(([net.dns]::GetHostEntry($Controller.DNSName)).AddressList)
		$tips = ""
		$count = 0
		if($? -and $ips)
		{
			foreach($ip in $ips)
			{
				if($ip.AddressFamily -eq "InterNetwork")
				{
					if($count -eq 0)
					{
						$tips = $ip.IPAddressToString
					}
					else
					{
						$tips = $tips + "," + $ip.IPAddressToString
					}
					$count = $count + 1
				}	
			
			}	
			Write-Host $Controller.DNSName "=" $tips
                    
      	}
        $AssociatedHypervisorConnectionUids = $Controller.AssociatedHypervisorConnectionUids
        if($AssociatedHypervisorConnectionUids -ne $null)
        {
            $BrokerToHypIDs[$controller.DNSName] = $AssociatedHypervisorConnectionUids
        }	
	}
}
$ips = @{}
$count = 0
$tips = ""


Write-Host "[Hypervisor_Details]"
$BrokerHypConns = Get-BrokerHypervisorConnection -State On
$HypConnsToBroker = @{}
if($BrokerHypConns -ne $null)
{
    foreach($BrokerHypConn in $BrokerHypConns)
    {
        $Value = $BrokerHypConn.HypHypervisorConnectionUid
        $Key = $BrokerHypConn.Uid
        $HypConnsToBroker[$Key] = $Value
    }
}

$HypConns = @{}
$HypConnPath = "XDHyp:\Connections\"
$HypConnections = Get-ChildItem $HypConnPath
if ($HypConnections -ne $null)
{
	foreach ($HypConn in $HypConnections)
	{
        $Key1 = $HypConn.HypervisorConnectionUid
        $Value1 = $HypConn.ConnectionType.toString() + ";" + $HypConn.HypervisorAddress[0].toString()
        $HypConns[$Key1] = $Value1
	}
}
if($BrokerToHypIDs -ne $null)
{
    $Keys = $BrokerToHypIDs.Keys
    foreach($key2 in $keys)
    {
        $Values = $BrokerToHypIDs[$key2]
        if($Values.Count -ge 1)
        {
            foreach($Value in $Values)
            {
                $hypuobj = Get-BrokerHypervisorConnection -Uid $Value 
                if($hypuobj)
                {
                    $hypuid = $hypuobj.HypHypervisorConnectionUid  
                    $output = $HypConns[$hypuid]
                    $outputStr = $key2.toString() + "=" + $output
                    Write-Host $outputStr
                }
            }
        }

    }
}

Write-Host "[Hypervisor_Type]"
#Support XenServer only
$HypConnPath = "XDHyp:\Connections\"
$HypConnections = Get-ChildItem $HypConnPath
if ($HypConnections -ne $null)
{
	foreach ($HypConn in $HypConnections)
	{
	        $ConnUid = $HypConn.HypervisorConnectionUid
		$Value1 = $HypConn.ConnectionType.toString() + ";" + $HypConn.HypervisorAddress[0].toString()
		if ($HypConn.ConnectionType.toString() -ieq "XenServer")
		{
			$machines = Get-BrokerMachinesPaged -SessionSupport 'MultiSession' -HypHypervisorConnectionUid $ConnUid
			if ($machines -ne $null)
			{
				Write-Host $Value1"=Server"
			}
			else
			{	
				Write-Host $Value1"=VDI"
			}
		}
        elseif ($HypConn.ConnectionType.toString() -ieq "vcenter")
        {
                Write-Host $Value1"=vCenter"
        }
	}
}

Write-Host "[DataSource]"
$DataSource = Get-BrokerDBConnection
if ($DataSource -ne $null)
{
	Write-Host ($DataSource)
}


$ips = @{}
$count = 0
$tips = ""
Write-Host "[ActiveDirectory_server]"

$d =  (gwmi win32_computersystem).domain
$ips = @(([net.dns]::GetHostEntry($d)).AddressList) 
if($? -and $ips)
{
	foreach($ip in $ips)
	{
		if($ip.AddressFamily -eq "InterNetwork")
		{
			if($count -eq 0)
			{
				$tips = $ip.IPAddressToString
			}
			else
			{
				$tips = $tips +","+ $ip.IPAddressToString
			}
			$count = $count + 1
		}	
		
	}
	Write-Host $d "=" $tips
}	

$ips = ""
$tips = ""
Write-Host "[XenApp]"
$XenApps = Get-BrokerMachinesPaged -SessionSupport MultiSession | Select DNSName,IPAddress,ControllerDNSName,DesktopGroupName
if($XenApps -ne $null)
{
	foreach($XenApp in $XenApps)
	{
		$tips = ""
		$count = 0
		$ips = $XenApp.IPAddress
		if($? -and $ips)
		{
			Write-Host $XenApp.ControllerDNSName  "^^"  $XenApp.DNSName "^^" $XenApp.DesktopGroupName "="   $ips
		}
		else
		{
			$ips = @(([net.dns]::GetHostEntry($XenApp.DNSName)).AddressList)
			if($? -and $ips)
			{
				foreach($ip in $ips)
				{
					if($ip.AddressFamily -eq "InterNetwork")
					{
						if($count -eq 0)
						{
							$tips = $ip.IPAddressToString
						}
						else
						{
							$tips = $tips +","+ $ip.IPAddressToString
						}
						$count = $count + 1
					}
				}
			}

			If ($XenApp.ControllerDNSName -ne $null -and $XenApp.ControllerDNSName.length -gt 0)
			{
				Write-Host $XenApp.ControllerDNSName  "^^"  $XenApp.DNSName "^^" $XenApp.DesktopGroupName "="   $tips 	
			}
			else
			{
				Write-Host "-^^"  $XenApp.DNSName "^^" $XenApp.DesktopGroupName "="   $tips	
			}
		}
	}
}

Write-Host "[PVS]"
$PVSIPAddresses = @()
$Catalogs = Get-BrokerCatalog -MaxRecordCount 2147483647
if($Catalogs -ne $null)
{
	foreach($Catalog in $Catalogs)
	{
		if ($Catalog.PvsAddress.length -gt 0)
		{
			$PvsAddress = $Catalog.PvsAddress
			if($PVSIPAddresses -Contains $PvsAddress)
			{
			}
			else
			{
				$PVSIPAddresses += $PvsAddress
			}
		}
	}
	Write-Host $PVSIPAddresses
}

Write-Host "[XD_Site]"
if ( $SiteName.Length -gt 0)
{
    $objIPProperties = [System.Net.NetworkInformation.IPGlobalProperties]::GetIPGlobalProperties()
    $fqdn = "{0}.{1}" -f $SiteName, $objIPProperties.DomainName
    $ips = ""
    $ips = @(([net.dns]::GetHostEntry($env:COMPUTERNAME)).AddressList)
    $tips = ""
    $count = 0
    if($? -and $ips)
    {
	    foreach($ip in $ips)
        {
	        if($ip.AddressFamily -eq "InterNetwork")
	        {
		        if($count -eq 0)
		        {
			        $tips = $ip.IPAddressToString +":80"
		        }
		        else
		        {
			        $tips = $tips + "," + $ip.IPAddressToString+":80"
		        }
		        $count = $count + 1
	        }	

        }	
        Write-Host $fqdn "=" $tips
    }
}

Remove-pssnapin "Citrix.Common.Commands"
Remove-pssnapin "Citrix.Host.Admin.V2"
Remove-pssnapin "Citrix.Broker.Admin.V2"



# SIG # Begin signature block
# MIIcdAYJKoZIhvcNAQcCoIIcZTCCHGECAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUdfc76CwjRg/Z4mk+qVEtbxf4
# QBSggherMIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFNDCC
# BBygAwIBAgIQAuEYSxAWnqD3sU8D3BMzUjANBgkqhkiG9w0BAQsFADByMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29k
# ZSBTaWduaW5nIENBMB4XDTE4MDcxMDAwMDAwMFoXDTIxMDkxNTEyMDAwMFowcTEL
# MAkGA1UEBhMCVVMxEzARBgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxp
# bjEdMBsGA1UEChMUZUcgSW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElu
# bm92YXRpb25zLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# oNt7XWB1y9xwtvCGO/XipXallOkZ3ScdXunWCONnBzryRdCj7C/WX9s1CU8KkjRP
# FjWW+BOXvvC4ZUqw0Ad2uJAXyBY2/lV9eaoTRFB6Kb2/tJzG3je7Vcu8MxGJlwzP
# QQrr6icEJeqAPFE7vmzThVbd9H1n5Zdmwx20WCFe2V9qyVYHt7/6GS7WB2CwwjT6
# iVmiKP8HZXgr3tHZeAEb7tdQqd5//9e+8Mp8anb8ZdNgC9PQjBmbrQ/wH3kV65gK
# L+5kbgRvIfsmYxXiU1IFkq4rSQ+tfsDtYqBhGfovef9Gt8ZTjx7S4fortxwR7tlz
# i+wLO5m8I9sm4I2ouyIOQQIDAQABo4IBxTCCAcEwHwYDVR0jBBgwFoAUWsS5eyoK
# o6XqcQPAYPkt9mV1DlgwHQYDVR0OBBYEFD3yRqdsw6UIddfMPwhUMv2AaGRAMA4G
# A1UdDwEB/wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzB3BgNVHR8EcDBuMDWg
# M6Axhi9odHRwOi8vY3JsMy5kaWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcx
# LmNybDA1oDOgMYYvaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJl
# ZC1jcy1nMS5jcmwwTAYDVR0gBEUwQzA3BglghkgBhv1sAwEwKjAoBggrBgEFBQcC
# ARYcaHR0cHM6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAP1QnJ6TEczaeGxVokMinsKam1mJB+zDk4B9rfm31
# iaZe9OeNvR/UJAs+5b0gKBZF9NmTVdayAYV74vZU5IElRo59q6hbg/20Wu87UyoE
# Yjwrv2DxHgl3z80piuLllmoe79vEu/bYvreBamzZmHlyxRP0us2KRfEsLBH23y1o
# zBATLc3yBu+mCfDg9E1RfhpKyD1iMHkbC90To6bpOlP9Pd6R4WEAFROILgm2bofQ
# ZhN4UNKbJ1uLCvV2NiUbU7+YSC3NP9SdphaDBiOnUWiK8MjTIPZbhh3QjI5f342q
# cUiR4LGx/Z/6pq4w6YHWd8c1czexD7xVCom7ZafCOKFWyzCCBmowggVSoAMCAQIC
# EAMBmgI6/1ixa9bV6uYX8GYwDQYJKoZIhvcNAQEFBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgQXNzdXJlZCBJRCBDQS0xMB4XDTE0MTAyMjAw
# MDAwMFoXDTI0MTAyMjAwMDAwMFowRzELMAkGA1UEBhMCVVMxETAPBgNVBAoTCERp
# Z2lDZXJ0MSUwIwYDVQQDExxEaWdpQ2VydCBUaW1lc3RhbXAgUmVzcG9uZGVyMIIB
# IjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAo2Rd/Hyz4II14OD2xirmSXU7
# zG7gU6mfH2RZ5nxrf2uMnVX4kuOe1VpjWwJJUNmDzm9m7t3LhelfpfnUh3SIRDsZ
# yeX1kZ/GFDmsJOqoSyyRicxeKPRktlC39RKzc5YKZ6O+YZ+u8/0SeHUOplsU/UUj
# joZEVX0YhgWMVYd5SEb3yg6Np95OX+Koti1ZAmGIYXIYaLm4fO7m5zQvMXeBMB+7
# NgGN7yfj95rwTDFkjePr+hmHqH7P7IwMNlt6wXq4eMfJBi5GEMiN6ARg27xzdPpO
# 2P6qQPGyznBGg+naQKFZOtkVCVeZVjCT88lhzNAIzGvsYkKRrALA76TwiRGPdwID
# AQABo4IDNTCCAzEwDgYDVR0PAQH/BAQDAgeAMAwGA1UdEwEB/wQCMAAwFgYDVR0l
# AQH/BAwwCgYIKwYBBQUHAwgwggG/BgNVHSAEggG2MIIBsjCCAaEGCWCGSAGG/WwH
# ATCCAZIwKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMw
# ggFkBggrBgEFBQcCAjCCAVYeggFSAEEAbgB5ACAAdQBzAGUAIABvAGYAIAB0AGgA
# aQBzACAAQwBlAHIAdABpAGYAaQBjAGEAdABlACAAYwBvAG4AcwB0AGkAdAB1AHQA
# ZQBzACAAYQBjAGMAZQBwAHQAYQBuAGMAZQAgAG8AZgAgAHQAaABlACAARABpAGcA
# aQBDAGUAcgB0ACAAQwBQAC8AQwBQAFMAIABhAG4AZAAgAHQAaABlACAAUgBlAGwA
# eQBpAG4AZwAgAFAAYQByAHQAeQAgAEEAZwByAGUAZQBtAGUAbgB0ACAAdwBoAGkA
# YwBoACAAbABpAG0AaQB0ACAAbABpAGEAYgBpAGwAaQB0AHkAIABhAG4AZAAgAGEA
# cgBlACAAaQBuAGMAbwByAHAAbwByAGEAdABlAGQAIABoAGUAcgBlAGkAbgAgAGIA
# eQAgAHIAZQBmAGUAcgBlAG4AYwBlAC4wCwYJYIZIAYb9bAMVMB8GA1UdIwQYMBaA
# FBUAEisTmLKZB+0e36K+Vw0rZwLNMB0GA1UdDgQWBBRhWk0ktkkynUoqeRqDS/Qe
# icHKfTB9BgNVHR8EdjB0MDigNqA0hjJodHRwOi8vY3JsMy5kaWdpY2VydC5jb20v
# RGlnaUNlcnRBc3N1cmVkSURDQS0xLmNybDA4oDagNIYyaHR0cDovL2NybDQuZGln
# aWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEQ0EtMS5jcmwwdwYIKwYBBQUHAQEE
# azBpMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYB
# BQUHMAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3Vy
# ZWRJRENBLTEuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQCdJX4bM02yJoFcm4bOIyAP
# gIfliP//sdRqLDHtOhcZcRfNqRu8WhY5AJ3jbITkWkD73gYBjDf6m7GdJH7+IKRX
# rVu3mrBgJuppVyFdNC8fcbCDlBkFazWQEKB7l8f2P+fiEUGmvWLZ8Cc9OB0obzpS
# CfDscGLTYkuw4HOmksDTjjHYL+NtFxMG7uQDthSr849Dp3GdId0UyhVdkkHa+Q+B
# 0Zl0DSbEDn8btfWg8cZ3BigV6diT5VUW8LsKqxzbXEgnZsijiwoc5ZXarsQuWaBh
# 3drzbaJh6YoLbewSGL33VVRAA5Ira8JRwgpIr7DUbuD0FAo6G+OPPcqvao173NhE
# MIIGzTCCBbWgAwIBAgIQBv35A5YDreoACus/J7u6GzANBgkqhkiG9w0BAQUFADBl
# MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
# d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJv
# b3QgQ0EwHhcNMDYxMTEwMDAwMDAwWhcNMjExMTEwMDAwMDAwWjBiMQswCQYDVQQG
# EwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNl
# cnQuY29tMSEwHwYDVQQDExhEaWdpQ2VydCBBc3N1cmVkIElEIENBLTEwggEiMA0G
# CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDogi2Z+crCQpWlgHNAcNKeVlRcqcTS
# QQaPyTP8TUWRXIGf7Syc+BZZ3561JBXCmLm0d0ncicQK2q/LXmvtrbBxMevPOkAM
# Rk2T7It6NggDqww0/hhJgv7HxzFIgHweog+SDlDJxofrNj/YMMP/pvf7os1vcyP+
# rFYFkPAyIRaJxnCI+QWXfaPHQ90C6Ds97bFBo+0/vtuVSMTuHrPyvAwrmdDGXRJC
# geGDboJzPyZLFJCuWWYKxI2+0s4Grq2Eb0iEm09AufFM8q+Y+/bOQF1c9qjxL6/s
# iSLyaxhlscFzrdfx2M8eCnRcQrhofrfVdwonVnwPYqQ/MhRglf0HBKIJAgMBAAGj
# ggN6MIIDdjAOBgNVHQ8BAf8EBAMCAYYwOwYDVR0lBDQwMgYIKwYBBQUHAwEGCCsG
# AQUFBwMCBggrBgEFBQcDAwYIKwYBBQUHAwQGCCsGAQUFBwMIMIIB0gYDVR0gBIIB
# yTCCAcUwggG0BgpghkgBhv1sAAEEMIIBpDA6BggrBgEFBQcCARYuaHR0cDovL3d3
# dy5kaWdpY2VydC5jb20vc3NsLWNwcy1yZXBvc2l0b3J5Lmh0bTCCAWQGCCsGAQUF
# BwICMIIBVh6CAVIAQQBuAHkAIAB1AHMAZQAgAG8AZgAgAHQAaABpAHMAIABDAGUA
# cgB0AGkAZgBpAGMAYQB0AGUAIABjAG8AbgBzAHQAaQB0AHUAdABlAHMAIABhAGMA
# YwBlAHAAdABhAG4AYwBlACAAbwBmACAAdABoAGUAIABEAGkAZwBpAEMAZQByAHQA
# IABDAFAALwBDAFAAUwAgAGEAbgBkACAAdABoAGUAIABSAGUAbAB5AGkAbgBnACAA
# UABhAHIAdAB5ACAAQQBnAHIAZQBlAG0AZQBuAHQAIAB3AGgAaQBjAGgAIABsAGkA
# bQBpAHQAIABsAGkAYQBiAGkAbABpAHQAeQAgAGEAbgBkACAAYQByAGUAIABpAG4A
# YwBvAHIAcABvAHIAYQB0AGUAZAAgAGgAZQByAGUAaQBuACAAYgB5ACAAcgBlAGYA
# ZQByAGUAbgBjAGUALjALBglghkgBhv1sAxUwEgYDVR0TAQH/BAgwBgEB/wIBADB5
# BggrBgEFBQcBAQRtMGswJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0
# LmNvbTBDBggrBgEFBQcwAoY3aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0Rp
# Z2lDZXJ0QXNzdXJlZElEUm9vdENBLmNydDCBgQYDVR0fBHoweDA6oDigNoY0aHR0
# cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNy
# bDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJl
# ZElEUm9vdENBLmNybDAdBgNVHQ4EFgQUFQASKxOYspkH7R7for5XDStnAs0wHwYD
# VR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNtyA8wDQYJKoZIhvcNAQEFBQADggEB
# AEZQPsm3KCSnOB22WymvUs9S6TFHq1Zce9UNC0Gz7+x1H3Q48rJcYaKclcNQ5IK5
# I9G6OoZyrTh4rHVdFxc0ckeFlFbR67s2hHfMJKXzBBlVqefj56tizfuLLZDCwNK1
# lL1eT7EF0g49GqkUW6aGMWKoqDPkmzmnxPXOHXh2lCVz5Cqrz5x2S+1fwksW5Etw
# TACJHvzFebxMElf+X+EevAJdqP77BzhPDcZdkbkPZ0XN1oPt55INjbFpjE/7WeAj
# D9KqrgB87pxCDs+R1ye3Fu4Pw718CqDuLAhVhSK46xgaTfwqIa1JMYNHlXdx3LEb
# S0scEJx3FMGdTy9alQgpECYxggQzMIIELwIBATCBhjByMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5n
# IENBAhAC4RhLEBaeoPexTwPcEzNSMAkGBSsOAwIaBQCgcDAQBgorBgEEAYI3AgEM
# MQIwADAZBgkqhkiG9w0BCQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4w
# DAYKKwYBBAGCNwIBFTAjBgkqhkiG9w0BCQQxFgQU13zg8n7XM/pgnZd/92uEzSwy
# eywwDQYJKoZIhvcNAQEBBQAEggEAb6GrA+RlfrdQPj4jzYLoeQroGJEaj162+1m5
# onlBdoyyev9wv4qF62ZcDJcmoRJFDf9+dampRyFpuTM/kaQYXZluRmihP2Gl2Avf
# hzbpasdEtQUUdAQnAulNdg2nY3KqtWd0bTAg45MV6r02iFbJc8j95cOh4WXCdaPc
# 6bCpoimNZ+CAU3BrsexJvxiKI5hZm0lFbWal8eSrMZjI5i0NKzo4BN5fTFyhWJPM
# bo5as6DMpOh8ovKP/8B226vaVeaHj7+vOMsHzkdpnB19rutykqrMbOh2nb6r5AVA
# Dmm4+3u0HX4tNEGWcDtJ6mqjT1ZTYnJt+HfzJXa58QZ95I+6IqGCAg8wggILBgkq
# hkiG9w0BCQYxggH8MIIB+AIBATB2MGIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxE
# aWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMT
# GERpZ2lDZXJ0IEFzc3VyZWQgSUQgQ0EtMQIQAwGaAjr/WLFr1tXq5hfwZjAJBgUr
# DgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUx
# DxcNMjAwOTI0MTQwNzQxWjAjBgkqhkiG9w0BCQQxFgQUcsmuaCK/b6M5EkUqJYfL
# qH1a6fEwDQYJKoZIhvcNAQEBBQAEggEADnjFxbOuiK1iZuPL/w/2ztszTM+LTOYA
# tbvwas7pQQfOCGib30jr94c5YArXwPsLACQPa1/r/67ZOYk0Mi6jBV3mpEkI0Kdj
# OMpYJS/9jE7EJnd8j+XFD+qejTyfq9fm9T6Wa3jUvHA5wLT8gP0zUOGSlXqxLRjQ
# 0w0E/2RvX3oF7TS5Er7YYNTMyFvAj4jpn1974zP8nQtn2/6KoaCcPUedr39/0g+G
# ZuqEz7HMf4Mn1VGWkRBALmAS4521f8G+JpXafMdr96ErnZ1gdZ+hPpXxt3/lIAYp
# Q16G9bbW2Jgb+gBk4hVXC3km6J8vUpneAy0GsyQfN/I8jDUL9b6nug==
# SIG # End signature block
