﻿<#
    /*****************************************************************************
    Author            :       Mounika Kuna
    Purpose           :       Provides Teams Users Details
    Created           :       15/09/2020    
    /*****************************************************************************
#>

clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue

#<#
$TestInputs=$args
$username=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyUser=$TestInputs[2]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[3]
$proxyserver=$TestInputs[4]
$toreadDate_UsersActvty=[datetime]$TestInputs[5]
$toreadDate_UsersDevUsage=[datetime]$TestInputs[6]
$rptNam=$TestInputs[7]
#>

$rptPath=$egurkhaPath+'\agent\MTM\'+$rptNam
if(!(Test-Path -Path $rptPath )){
   $null =  New-Item -ItemType directory -Path $rptPath -WarningAction SilentlyContinue
}
$o365Domain=Eg-GetDomain -userName $username -Password $password -proxyUsr $proxyUser -proxyPass $proxyPass -IsIntial $true -proxyserver $proxyserver

$appId=''
$appSecret=''
$tenantID=''
$authString=''
$resource=''
$typePath=(([XML]((Get-Package -Name AzureAD  | select SwidTagText)).SwidTagText).SoftwareIdentity.Meta.InstalledLocation)+'\Microsoft.IdentityModel.Clients.ActiveDirectory.dll'
Add-Type -Path $typePath

#------Get App Reg Details ------------
$GraphDir=$egurkhaPath+'\agent\O365\MsGraph'
$unProtPath=$GraphDir+'\GraphDetails.dat'
$keyFileNam='\GraphDetailsKey.dat'
$kvalue=Get-Content -Path $GraphDir$keyFileNam
$null=Unprotect-File $unProtPath -Algorithm AES -KeyAsPlainText $kvalue -DstSuffix '.ini'
$spoGraphDtls=$GraphDir+"\GraphDetails.ini"
$getInputs=Get-Content -Path $spoGraphDtls
Remove-Item $spoGraphDtls
$flag=$false
foreach($input in $getInputs){
    if($input.StartsWith('[') -and $input.ToLower().Contains($o365Domain.ToLower())){
        $flag=$true
    }
    if($flag){
        if($input.Contains("client_id")){
            $appId=$input.ToString().Substring($input.IndexOf('~')+1)
        }
        if($input.Contains("client_secret")){
            $appSecret=$input.ToString().Substring($input.IndexOf('~')+1)
        }
        if($input.Contains("TenantName")){
            $tenantID=$input.ToString().Substring($input.IndexOf('~')+1)
        }
        if($input.Contains("Authority")){
            $authString=$input.ToString().Substring($input.IndexOf('~')+1)
            $authString=$authString+$o365Domain
        }
        if($input.Contains("Resource")){
            $resource=$input.ToString().Substring($input.IndexOf('~')+1)
            $flag=$false
        }
    }         
}

$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$TeamsUsrActvtyDtlCSV=$rptPath+'\TeamsUsrActvtyDtl'+$timenow+'.csv'
$url1 = "https://graph.microsoft.com/v1.0/reports/getTeamsUserActivityUserDetail(period='D7')"
while($true){
    Eg-InvokeGraphUrl -Url $url1 -filePath $TeamsUsrActvtyDtlCSV -appId $appId -appSecret $appSecret -authString $authString -resource $resource
    $TeamsUsrActvtytotal=Import-Csv $TeamsUsrActvtyDtlCSV
    $url1=$TeamsUsrActvtytotal.'@odata.nextLink'
    if($url1 -eq $null -or $url1 -eq ''){
        break
    }
}
$firstRecord1=$TeamsUsrActvtytotal | select ReportRefreshDate -First 1
$ReportRefreshDate1=($firstRecord1.ReportRefreshDate)
$diffence1=(NEW-TIMESPAN –Start $toreadDate_UsersActvty –End $ReportRefreshDate1 | Select-Object Days).Days
if($diffence1 -ge 1){$reportRefreshed1=$true}

$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$DeviceUsgByUsrCSV=$rptPath+'\DeviceUsgByUsr'+$timenow+'.csv'
$url2="https://graph.microsoft.com/v1.0/reports/getTeamsDeviceUsageUserDetail(period='D7')"
while($true){
    Eg-InvokeGraphUrl -Url $url2 -filePath $DeviceUsgByUsrCSV -appId $appId -appSecret $appSecret -authString $authString -resource $resource
    $TotalDeviceUsgByUsr=Import-Csv $DeviceUsgByUsrCSV
    $url2=$TotalDeviceUsgByUsr.'@odata.nextLink'
    if($url2 -eq $null -or $url2 -eq ''){
        break
    }
}
$firstRecord2=$TotalDeviceUsgByUsr | select ReportRefreshDate -First 1
$ReportRefreshDate2=($firstRecord2.ReportRefreshDate)
$diffence2=(NEW-TIMESPAN –Start $toreadDate_UsersDevUsage –End $ReportRefreshDate2 | Select-Object Days).Days
if($diffence2 -ge 1){$reportRefreshed2=$true}

if($reportRefreshed1 -and $reportRefreshed2){
    $diffence=(NEW-TIMESPAN –Start $toreadDate_UsersActvty –End (Get-Date) | Select-Object Days).Days
    $notFirsttime = $false
    while($diffence -ge 1)
    {
        if($notFirsttime){ $toreadDate_UsersActvty=$toreadDate_UsersActvty.AddDays(1) }
        $actualdate=$toreadDate_UsersActvty
        $notFirsttime = $true
        $TeamsUsrActivity =$TeamsUsrActvtytotal | Where-Object { [datetime]$_.ReportRefreshDate -eq $actualdate }       
        if($TeamsUsrActivity)
        {
            Write-Host 'ReadDate of UsersActvty Data on#'$actualdate.tostring(“yyyy-MM-dd”);
            break
        }
        else
        {
            Write-Host 'thereIs No UsersActvty Data on#'$actualdate.tostring(“yyyy-MM-dd”)
        }
        $diffence=$diffence-1
    }

    $diffence=(NEW-TIMESPAN –Start $toreadDate_UsersDevUsage –End (Get-Date) | Select-Object Days).Days
    $notFirsttime = $false
    while($diffence -ge 1)
    {
        if($notFirsttime){ $toreadDate_UsersDevUsage=$toreadDate_UsersDevUsage.AddDays(1) }
        $actualdate=$toreadDate_UsersDevUsage
        $notFirsttime = $true
        $TotalDeviceUsg =$TotalDeviceUsgByUsr | Where-Object { [datetime]$_.ReportRefreshDate -eq $actualdate }       
        if($TotalDeviceUsg)
        {
            Write-Host 'ReadDate of UsersDevUsage Data on#'$actualdate.tostring(“yyyy-MM-dd”)
            break
        }
        else
        {
            Write-Host 'thereIs No UsersDevUsage Data on#'$actualdate.tostring(“yyyy-MM-dd”)
        }
        $diffence=$diffence-1
    }
}

foreach($usr in $TeamsUsrActivity) {
    $flag = 0;
    if($usr.HasOtherAction -eq 'Yes') {
        $flag = 1;
    }
    $Output='info&Measures='+$usr.UserPrincipalName+'~'+$usr.TeamChatMessageCount+'~'+$usr.PrivateChatMessageCount+'~'+$usr.CallCount+'~'+$usr.MeetingCount+'~'+$flag
    Write-Host $Output
}
Remove-Item $TeamsUsrActvtyDtlCSV


foreach($dev in $TotalDeviceUsg) {
    $Web = 0;
    $winPh = 0;
    $ios = 0;
    $mac = 0;
    $androidPh = 0;
    $windows = 0;

    if($dev.UsedWeb -eq 'Yes') {
        $Web = 1;
    }
    
    if($dev.UsedWindowsPhone -eq 'Yes') {
        $winPh = 1;
    }
    
    if($dev.UsediOS -eq 'Yes') {
        $ios = 1;
    }
    
    if($dev.UsedMac -eq 'Yes') {
        $mac = 1;
    }
    
    if($dev.UsedAndroidPhone -eq 'Yes') {
        $androidPh = 1;
    }
    
    if($dev.UsedWindows -eq 'Yes') {
        $windows = 1;
    }    
    $Output='info&Measures='+$dev.UserPrincipalName+'~'+$web+'~'+$winPh+'~'+$ios+'~'+$mac+'~'+$androidPh+'~'+$windows
    Write-Host $Output
}
Remove-Item $DeviceUsgByUsrCSV
