﻿<#
    /*****************************************************************************
    Author            :       Mounika Kuna
    Purpose           :       Provides OneDrive Users Details
    Created           :       15/09/2020    
    /*****************************************************************************
#>

clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue

#<#
$TestInputs=$args
$username=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyUser=$TestInputs[2]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[3]
$proxyserver=$TestInputs[4]
$toreadDate_UsersUsage=[datetime]$TestInputs[5]
$toreadDate_UsersActvtyDtl=[datetime]$TestInputs[6]
$rptNam=$TestInputs[7]
#>

$rptPath=$egurkhaPath+'\agent\ODB\'+$rptNam
if(!(Test-Path -Path $rptPath )){
   $null =  New-Item -ItemType directory -Path $rptPath -WarningAction SilentlyContinue
}
$o365Domain=Eg-GetDomain -userName $username -Password $password -proxyUsr $proxyUser -proxyPass $proxyPass -IsIntial $true -proxyserver $proxyserver

$appId=''
$appSecret=''
$tenantID=''
$authString=''
$resource=''
$typePath=(([XML]((Get-Package -Name AzureAD  | select SwidTagText)).SwidTagText).SoftwareIdentity.Meta.InstalledLocation)+'\Microsoft.IdentityModel.Clients.ActiveDirectory.dll'
Add-Type -Path $typePath

#------Get App Reg Details ------------
$GraphDir=$egurkhaPath+'\agent\O365\MsGraph'
$unProtPath=$GraphDir+'\GraphDetails.dat'
$keyFileNam='\GraphDetailsKey.dat'
$kvalue=Get-Content -Path $GraphDir$keyFileNam
$null=Unprotect-File $unProtPath -Algorithm AES -KeyAsPlainText $kvalue -DstSuffix '.ini'
$spoGraphDtls=$GraphDir+"\GraphDetails.ini"
$getInputs=Get-Content -Path $spoGraphDtls
Remove-Item $spoGraphDtls
$flag=$false
foreach($input in $getInputs){
    if($input.StartsWith('[') -and $input.ToLower().Contains($o365Domain.ToLower())){
        $flag=$true
    }
    if($flag){
        if($input.Contains("client_id")){
            $appId=$input.ToString().Substring($input.IndexOf('~')+1)
        }
        if($input.Contains("client_secret")){
            $appSecret=$input.ToString().Substring($input.IndexOf('~')+1)
        }
        if($input.Contains("TenantName")){
            $tenantID=$input.ToString().Substring($input.IndexOf('~')+1)
        }
        if($input.Contains("Authority")){
            $authString=$input.ToString().Substring($input.IndexOf('~')+1)
            $authString=$authString+$o365Domain
        }
        if($input.Contains("Resource")){
            $resource=$input.ToString().Substring($input.IndexOf('~')+1)
            $flag=$false
        }
    }         
}
$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$ODBUsersUsageCSV=$rptPath+'\ODBUsersUsage'+$timenow+'.csv'
$url1 = "https://graph.microsoft.com/v1.0/reports/getOneDriveUsageAccountDetail(period='D7')"
while($true){
    Eg-InvokeGraphUrl -Url $url1 -filePath $ODBUsersUsageCSV -appId $appId -appSecret $appSecret -authString $authString -resource $resource
    $TotalUsersUsage=Import-Csv $ODBUsersUsageCSV
    $url1=$TotalUsersUsage.'@odata.nextLink'
    if($url1 -eq $null -or $url1 -eq ''){
        break
    }
}
$firstRecord1=$TotalUsersUsage | select ReportRefreshDate -First 1
$ReportRefreshDate1=($firstRecord1.ReportRefreshDate)
$diffence1=(NEW-TIMESPAN –Start $toreadDate_UsersUsage –End $ReportRefreshDate1 | Select-Object Days).Days
if($diffence1 -ge 1){$reportRefreshed1=$true}

$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$ODBUsrActvtyDtlCSV=$rptPath+'\ODBUsrActvtyDtl'+$timenow+'.csv'
$url2="https://graph.microsoft.com/v1.0/reports/getOneDriveActivityUserDetail(period='D7')"
while($true){
    Eg-InvokeGraphUrl -Url $url2 -filePath $ODBUsrActvtyDtlCSV -appId $appId -appSecret $appSecret -authString $authString -resource $resource
    $ODBUsrActvtytotal=Import-Csv $ODBUsrActvtyDtlCSV
    $url2=$ODBUsrActvtytotal.'@odata.nextLink'
    if($url2 -eq $null -or $url2 -eq ''){
        break
    }
}
$firstRecord2=$ODBUsrActvtytotal | select ReportRefreshDate -First 1
$ReportRefreshDate2=($firstRecord2.ReportRefreshDate)
$diffence2=(NEW-TIMESPAN –Start $toreadDate_UsersActvtyDtl –End $ReportRefreshDate2 | Select-Object Days).Days
if($diffence2 -ge 1){$reportRefreshed2=$true}

if($reportRefreshed1 -and $reportRefreshed2){
    $diffence=(NEW-TIMESPAN –Start $toreadDate_UsersUsage –End (Get-Date) | Select-Object Days).Days
    $notFirsttime = $false
    while($diffence -ge 1)
    {
        if($notFirsttime){ $toreadDate_UsersUsage=$toreadDate_UsersUsage.AddDays(1) }
        $actualdate=$toreadDate_UsersUsage
        $notFirsttime = $true
        $TotalUsersUsg =$TotalUsersUsage | Where-Object { [datetime]$_.ReportRefreshDate -eq $actualdate }       
        if($TotalUsersUsg)
        {
            Write-Host 'ReadDate of UsersUsage Data on#'$actualdate.tostring(“yyyy-MM-dd”)
            break
        }
        else
        {
            Write-Host 'thereIs No UsersUsage Data on#'$actualdate.tostring(“yyyy-MM-dd”)
        }
        $diffence=$diffence-1
    }

    $diffence=(NEW-TIMESPAN –Start $toreadDate_UsersActvtyDtl –End (Get-Date) | Select-Object Days).Days
    $notFirsttime = $false
    while($diffence -ge 1)
    {
        if($notFirsttime){ $toreadDate_UsersActvtyDtl=$toreadDate_UsersActvtyDtl.AddDays(1) }
        $actualdate=$toreadDate_UsersActvtyDtl
        $notFirsttime = $true
        $ODBUsrActivity =$ODBUsrActvtytotal | Where-Object { [datetime]$_.ReportRefreshDate -eq $actualdate }
        if($ODBUsrActivity)
        {
            Write-Host 'ReadDate of UsersActvtyDtl Data on#'$actualdate.tostring(“yyyy-MM-dd”)
            break
        }
        else
        {
            Write-Host 'thereIs No UsersActvtyDtl Data on#'$actualdate.tostring(“yyyy-MM-dd”)
        }
        $diffence=$diffence-1
    }
}

foreach($dev in $TotalUsersUsg) {
    $StorageAllocated=(([math]::Round(([long]$dev.StorageUsed/1073741824),2))/([math]::Round(([long]$dev.StorageAllocated/1073741824),2)))*100
    $Storageusedprcnt =[math]::Round($StorageAllocated,2)
    $Output='info&Measures='+$dev.OwnerPrincipalName+'~'+$dev.FileCount+'~'+$dev.ActiveFileCount+'~'+[math]::Round(($dev.StorageUsed/1073741824),2)+'~'+[math]::Round(($dev.StorageAllocated/1073741824),2)+'~'+$Storageusedprcnt
    Write-Host $Output
}
Remove-Item $ODBUsersUsageCSV

foreach($usr in $ODBUsrActivity) {
    $Output='info&Measures='+$usr.UserPrincipalName+'~'+$usr.ViewedOrEditedFileCount+'~'+$usr.SyncedFileCount+'~'+$usr.SharedInternallyFileCount+'~'+$usr.SharedExternallyFileCount
    Write-Host $Output
}
Remove-Item $ODBUsrActvtyDtlCSV