﻿##/*********************************************************************************************
##Author                :  Vishnu
##Purpose               :  Display the different feedback ratings given by end users about skype audio calls
##Created               :  11/08/2018
##Modified By		    :
##reference link        :((https://msconfiggallery.cloudapp.net/packages/CxdCallData/1.2.2.0/Content/CxdCallData.psm1))

clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egInstallpath=Get-ChildItem Env:EGURKHA_INSTALL_DIR |Select Value
$egurkhaPath=$egInstallpath.Value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy

$testargs=$args
$reportingname='SBO\'+$testargs[0]

    $readfiles=Eg-ReadFile -ComntRptPath $reportingname -FileName "SyRatMycalFeedBack" -keyFileName "kSyRatMycalFeedBack" -EgPath $egurkhaPath
    $datafile=$readfiles[1] -replace (".csv",".dat") 
    $csvfile=Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]	
    $userSession= import-csv $csvfile|Where-Object { $_.QoeReport} | select-object FromUri,ToUri,MediaTypesDescription,QoEReport -Unique 
    Remove-Item $csvfile
    Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'SyRatMycalFeedBack' -InputFile $readfiles[3]
    Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'kSyRatMycalFeedBack' -InputFile $readfiles[4]
    Write-Host "ReadFile:"$readfiles[3]

Function ProcessFeedback
{
	process{
		    try{ 
		        $newObject = [PSCustomObject][ordered]@{
		            FromUri = $_.FromUri.trim()
		            ToUri = $_.ToUri.trim()
		            MediaType = $_.MediaTypesDescription.trim()
                    QoEReport = $_.QoEReport | ConvertFrom-Json
			    }
		    }
            catch{
		        Write-Warning -Message "Could not process all Rate My Call feedback data correctly" $_.Exception.Message
		    }
		return $newObject
	}
}

function ProcessFeedbackQoe{
    begin{}
    process{
        #check for multiple QoE reports in this call (very rare)
        $QoeFeedbackCount=$_.QoeReport.FeedbackReports.Count

        #build array of objects with interesting information about the poor feedback for this given call with multiple QoE reports.
        for($indx=0;$indx -lt $QoeFeedbackCount;$indx++){
            $FeedbackReports = $_.QoeReport.FeedbackReports[$indx]
            try{
                $newObject = [PSCustomObject][ordered]@{
                    FromUri = $_.FromUri
                    ToUri = $_.ToUri
                    Rating = $FeedbackReports.Rating
                    FeedBackUser = $FeedbackReports.FromUserUri
                    MediaType = $_.MediaType
                    MediaStartTime = [datetime]$_.QoeReport.Session.MediaStartTime
                    MediaEndTime = [datetime]$_.QoeReport.Session.MediaEndTime
                    MediaDurationInSeconds = ([datetime]$_.QoeReport.Session.MediaEndTime - [datetime]$_.QoeReport.Session.MediaStartTime).TotalSeconds
                    FromIPAddr = $_.QoeReport.MediaLines.FromIPAddr
                    ToIPAddr = $_.QoeReport.MediaLines.ToIPAddr
                }
            }catch{
                Write-Warning -Message "Could not process all Rate My Call feedback data correctly"
            }
        }
        return $newObject
    }
    end{
    }
}


Function processoutput
{
    process{
        
        $PercentOfGoodFeedBack =0
        $PercentOfPoorFeedBack = 0              
        $processedFeedback = $processedFeedback | Where-Object {$_.Rating -ne $null   -and $_.Rating -ne ''}
        $GoodFeedBack      = $processedFeedback | Where-Object {$_.Rating -like "5 *" -or  $_.Rating -like "4 *"}
        $ThirdFeedBack     = $processedFeedback | Where-Object {$_.Rating -like "3 *"}
        $PoorFeedBack      = $processedFeedback | Where-Object {$_.Rating -like "1 *" -or $_.Rating -like "2 *"}       
        $AvoidFeedBack     = $processedFeedback | Where-Object {$_.Rating -like '0 *'}
       
        $totalGoodFeedBack  = $GoodFeedBack.FromUri.Count
        $totalPoorFeedBack  = $PoorFeedBack.FromUri.Count
        $totalAvoidFeedBack = $AvoidFeedBack.FromUri.Count
        $totalFeedBack      = $processedFeedback.FromUri.Count

        if($totalFeedBack -gt 0){
        $PercentOfGoodFeedBack = ($totalGoodFeedBack/$totalFeedBack) * 100
        $PercentOfPoorFeedBack = ($totalPoorFeedBack/$totalFeedBack) * 100
        }

        Write-Host '#TotalFeedBack#'$totalFeedBack
        Write-Host '#TotalGoodFeedBack#'$totalGoodFeedBack
        Write-Host '#TotalAvoidFeedBack#'$totalAvoidFeedBack
        Write-Host '#TotalPoorFeedBack#'$totalPoorFeedBack
        Write-Host '#PercentOfGoodFeedBack#'$PercentOfGoodFeedBack.tostring("#.##")
        Write-Host '#PercentOfPoorFeedBack#'$PercentOfPoorFeedBack.tostring("#.##")

		foreach($PoorFdBk in $PoorFeedBack){
            Write-Host "PoorFeedBackDD" $PoorFdBk.FromUri'~!~'$PoorFdBk.ToUri'~!~'$PoorFdBk.FromIPAddr'~!~'$PoorFdBk.ToIPAddr'~!~'($PoorFdBk.MediaType -replace '[[\]]','')'~!~'$PoorFdBk.MediaStartTime'~!~'$PoorFdBk.MediaEndTime'~!~'$PoorFdBk.MediaDurationInSeconds
        }
    }
}

if($userSession){
    [array]$userSession       = $userSession  | ProcessFeedback  
    [array]$processedFeedback = $userSession  | Where-Object { $_.QoeReport.FeedbackReports -ne $null  -and $_.QoeReport.FeedbackReports -ne ''} | ProcessFeedbackQoe
    processoutput
}else{
        Write-Host '#TotalFeedBack#0'
        Write-Host '#TotalGoodFeedBack#0'
        Write-Host '#TotalAvoidFeedBack#0'
        Write-Host '#TotalPoorFeedBack#0'
        Write-Host '#PercentOfGoodFeedBack#0'
        Write-Host '#PercentOfPoorFeedBack#0'
}