﻿<#
    /*****************************************************************************
    Author            :       Mounika Kuna
    Purpose           :       Provides Yammer Users By Device Details
    Created           :       26/07/2020    
    /*****************************************************************************
#>


clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue

#<#
$TestInputs=$args
$username=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyUser=$TestInputs[2]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[3]
$proxyserver=$TestInputs[4]
$readingdate=[datetime]$TestInputs[5]
$rptNam=$TestInputs[6]
#>

$rptPath=$egurkhaPath+'\agent\YMR\'+$rptNam
if(!(Test-Path -Path $rptPath )){
   $null =  New-Item -ItemType directory -Path $rptPath -WarningAction SilentlyContinue
}
$o365Domain=Eg-GetDomain -userName $username -Password $password -proxyUsr $proxyUser -proxyPass $proxyPass -IsIntial $true -proxyserver $proxyserver

$appId=''
$appSecret=''
$tenantID=''
$authString=''
$resource=''
$typePath=(([XML]((Get-Package -Name AzureAD  | select SwidTagText)).SwidTagText).SoftwareIdentity.Meta.InstalledLocation)+'\Microsoft.IdentityModel.Clients.ActiveDirectory.dll'
Add-Type -Path $typePath

#------Get App Reg Details ------------
$GraphDir=$egurkhaPath+'\agent\O365\MsGraph'
$unProtPath=$GraphDir+'\GraphDetails.dat'
$keyFileNam='\GraphDetailsKey.dat'
$kvalue=Get-Content -Path $GraphDir$keyFileNam
$null=Unprotect-File $unProtPath -Algorithm AES -KeyAsPlainText $kvalue -DstSuffix '.ini'
$GraphDtls=$GraphDir+"\GraphDetails.ini"
$getInputs=Get-Content -Path $GraphDtls
Remove-Item $GraphDtls
$flag=$false
foreach($input in $getInputs){
    if($input.StartsWith('[') -and $input.ToLower().Contains($o365Domain.ToLower())){
        $flag=$true
    }
    if($flag){
        if($input.Contains("client_id")){
            $appId=$input.ToString().Substring($input.IndexOf('~')+1)
        }
        if($input.Contains("client_secret")){
            $appSecret=$input.ToString().Substring($input.IndexOf('~')+1)
        }
        if($input.Contains("TenantName")){
            $tenantID=$input.ToString().Substring($input.IndexOf('~')+1)
        }
        if($input.Contains("Authority")){
            $authString=$input.ToString().Substring($input.IndexOf('~')+1)
            $authString=$authString+$o365Domain
        }
        if($input.Contains("Resource")){
            $resource=$input.ToString().Substring($input.IndexOf('~')+1)
            $flag=$false
        }
    }         
}

$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$YammerUsersByDeviceCSV=$rptPath+'\YammerUsersByDevice'+$timenow+'.csv'

Eg-InvokeGraphUrl -Url "https://graph.microsoft.com/v1.0/reports/getYammerDeviceUsageUserCounts(period='D7')" -filePath $YammerUsersByDeviceCSV -appId $appId -appSecret $appSecret -authString $authString -resource $resource

$TotalYammerUsersByDevice=Import-Csv $YammerUsersByDeviceCSV

$diffence=(NEW-TIMESPAN –Start $readingdate –End (Get-Date) | Select-Object Days).Days

$notFirsttime = $false
while($diffence -ge 1)
{
    if($notFirsttime){ $readingdate=$readingdate.AddDays(1) }
    $actualdate=$readingdate
    $notFirsttime = $true
    $UnqUsrsbyDev =$TotalYammerUsersByDevice | Where-Object { [datetime]$_.ReportDate -eq $actualdate }       
    if($UnqUsrsbyDev)
    {
        Write-Host 'ReadDate for the Date#'$actualdate.tostring(“yyyy-MM-dd”)
        break
    }
    else
    {
        Write-Host 'thereIs No Data on#'$actualdate.tostring(“yyyy-MM-dd”)
    }
    $diffence=$diffence-1
}
try{
    if($UnqUsrsbyDev.Web -eq ""){ $Web = 0 }else{ $Web = $UnqUsrsbyDev.Web }
    if($UnqUsrsbyDev.WindowsPhone -eq ""){ $WindowsPhone = 0 }else{ $WindowsPhone = $UnqUsrsbyDev.WindowsPhone }
    if($UnqUsrsbyDev.AndroidPhone -eq ""){ $AndroidPhone = 0 }else{ $AndroidPhone = $UnqUsrsbyDev.AndroidPhone }
    if($UnqUsrsbyDev.iPhone -eq ""){ $iPhone = 0 }else{ $iPhone = $UnqUsrsbyDev.iPhone }
    if($UnqUsrsbyDev.iPad -eq ""){ $iPad = 0 }else{ $iPad = $UnqUsrsbyDev.iPad }
    if($UnqUsrsbyDev.Other -eq ""){ $Other = 0 }else{ $Other = $UnqUsrsbyDev.Other }
    if($Web.Length -ge 0){
    $Web='info&Metrics='+'Web'+'~'+$Web    
    Write-Host $Web
    }
    if($WindowsPhone.Length -ge 0){
    $WindowsPhone='info&Metrics='+'WindowsPhone'+'~'+$WindowsPhone
    Write-Host $WindowsPhone
    }
    if($AndroidPhone.Length -ge 0){
    $AndroidPhone='info&Metrics='+'AndroidPhone'+'~'+$AndroidPhone
    Write-Host $AndroidPhone
    }
    if($iPhone.Length -ge 0){
    $iPhone='info&Metrics='+'iPhone'+'~'+$iPhone
    Write-Host $iPhone
    }
    if($iPad.Length -ge 0){
    $iPad='info&Metrics='+'iPad'+'~'+$iPad
    Write-Host $iPad
    }
    if($Other.Length -ge 0){
    $Other='info&Metrics='+'Other'+'~'+$Other
    Write-Host $Other
    }
}catch{    
    $exceptionmsg=($_.Exception.Message)+($_.ScriptStackTrace) 
	Write-error "Error Occured in Yammer Users by Device Script >>> "$exceptionmsg
}
Remove-Item $YammerUsersByDeviceCSV
