/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.RSAPrivateCrtKey;
import com.ibm.crypto.provider.RSAPrivateKey;
import com.ibm.crypto.provider.RSAPublicKey;
import com.ibm.security.rsa.RSAUtil;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.PSSParameterSpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import sun.security.action.GetPropertyAction;

public class RSAKeyFactory
extends KeyFactorySpi {
    public static final int MIN_MODLEN = 512;
    public static final int MAX_MODLEN = 16384;
    private static final BigInteger a;
    public static final int MAX_MODLEN_RESTRICT_EXP = 3072;
    public static final int MAX_RESTRICTED_EXPLEN = 64;
    private RSAUtil.KeyType b = RSAUtil.KeyType.RSA;
    static RSAKeyFactory c;
    private static final boolean d;
    private static final RSAKeyFactory e;
    private static final RSAKeyFactory f;
    private static final String[] z;

    private RSAKeyFactory() {
        this.b = RSAUtil.KeyType.RSA;
    }

    public RSAKeyFactory(RSAUtil.KeyType keyType) {
        this.b = keyType;
    }

    public static RSAKeyFactory getInstance(RSAUtil.KeyType keyType) {
        return new RSAKeyFactory(keyType);
    }

    public static RSAKey toRSAKey(Key key) throws InvalidKeyException {
        java.security.interfaces.RSAPrivateCrtKey rSAPrivateCrtKey;
        block20: {
            block19: {
                block18: {
                    if (!(key instanceof RSAPrivateCrtKey) && !(key instanceof java.security.interfaces.RSAPrivateCrtKey)) break block18;
                    rSAPrivateCrtKey = (java.security.interfaces.RSAPrivateCrtKey)key;
                    if (rSAPrivateCrtKey.getCrtCoefficient() == null) {
                        return new RSAPrivateKey(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent());
                    }
                }
                if (key instanceof RSAPrivateKey || key instanceof RSAPrivateCrtKey) break block19;
                if (!(key instanceof RSAPublicKey)) break block20;
            }
            return (RSAKey)((Object)key);
        }
        try {
            rSAPrivateCrtKey = RSAUtil.KeyType.lookup((String)key.getAlgorithm());
            if (rSAPrivateCrtKey == RSAUtil.KeyType.RSA) {
                return (RSAKey)((Object)e.engineTranslateKey(key));
            }
            if (rSAPrivateCrtKey == RSAUtil.KeyType.PSS) {
                return (RSAKey)((Object)f.engineTranslateKey(key));
            }
        }
        catch (ProviderException providerException) {
            throw new InvalidKeyException(providerException);
        }
        RSAKeyFactory rSAKeyFactory = RSAKeyFactory.getInstance((RSAUtil.KeyType)rSAPrivateCrtKey);
        return (RSAKey)((Object)rSAKeyFactory.engineTranslateKey(key));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void checkKeyLengths(int n2, BigInteger bigInteger, int n3, int n4) throws InvalidKeyException {
        if (n3 > 0 && n2 < n3) {
            throw new InvalidKeyException(z[11] + n3 + z[15]);
        }
        int n5 = Math.min(n4, 16384);
        if (n2 > n5) {
            throw new InvalidKeyException(z[14] + n5 + z[12]);
        }
        if (d && bigInteger != null && n2 > 3072 && bigInteger.bitLength() > 64) {
            throw new InvalidKeyException(z[13]);
        }
        RSAKeyFactory.a(n2, bigInteger);
    }

    private static void a(int n2, BigInteger bigInteger) throws InvalidKeyException {
        if (bigInteger == null) {
            return;
        }
        if ((bigInteger.bitLength() + 7 & 0xFFFFFFF8) > n2) {
            throw new InvalidKeyException(z[10]);
        }
        if (bigInteger.compareTo(a) < 0) {
            throw new InvalidKeyException(z[9]);
        }
    }

    static void b(int n2, BigInteger bigInteger) throws InvalidKeyException {
        RSAKeyFactory.checkKeyLengths(n2 + 7 & 0xFFFFFFF8, bigInteger, 512, Integer.MAX_VALUE);
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof RSAPublicKeySpec) {
                RSAPublicKeySpec rSAPublicKeySpec = (RSAPublicKeySpec)keySpec;
                return new RSAPublicKey(rSAPublicKeySpec.getModulus(), rSAPublicKeySpec.getPublicExponent());
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                return new RSAPublicKey(((X509EncodedKeySpec)keySpec).getEncoded());
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(z[17] + invalidKeyException.getMessage());
        }
        throw new InvalidKeySpecException(z[16]);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec var1_1) throws InvalidKeySpecException {
        if (!(var1_1 instanceof PKCS8EncodedKeySpec)) ** GOTO lbl10
        return new RSAPrivateCrtKey(((PKCS8EncodedKeySpec)var1_1).getEncoded());
        catch (InvalidKeyException var2_2) {
            try {
                return new RSAPrivateKey(((PKCS8EncodedKeySpec)var1_1).getEncoded());
lbl10:
                // 1 sources

                if (var1_1 instanceof RSAPrivateCrtKeySpec) {
                    var2_3 = (RSAPrivateCrtKeySpec)var1_1;
                    var3_6 = var2_3.getParams();
                    if (var3_6 != null && var3_6 instanceof PSSParameterSpec) {
                        this.b = RSAUtil.KeyType.PSS;
                        return RSAPrivateCrtKey.newKey(this.b, var3_6, var2_3.getModulus(), var2_3.getPrivateExponent(), var2_3.getPublicExponent(), var2_3.getPrimeP(), var2_3.getPrimeQ(), var2_3.getPrimeExponentP(), var2_3.getPrimeExponentQ(), var2_3.getCrtCoefficient());
                    }
                    this.b = RSAUtil.KeyType.RSA;
                    return RSAPrivateCrtKey.newKey(this.b, var3_6, var2_3.getModulus(), var2_3.getPrivateExponent(), var2_3.getPublicExponent(), var2_3.getPrimeP(), var2_3.getPrimeQ(), var2_3.getPrimeExponentP(), var2_3.getPrimeExponentQ(), var2_3.getCrtCoefficient());
                }
                if (var1_1 instanceof RSAPrivateKeySpec == false) throw new InvalidKeySpecException(RSAKeyFactory.z[18]);
                var2_4 = (RSAPrivateKeySpec)var1_1;
                var3_7 = ((RSAPrivateKeySpec)var1_1).getParams();
                if (var3_7 != null && var3_7 instanceof PSSParameterSpec) {
                    this.b = RSAUtil.KeyType.PSS;
                    return RSAPrivateKey.newKey(var2_4.getModulus(), var2_4.getPrivateExponent());
                }
                this.b = RSAUtil.KeyType.RSA;
                return RSAPrivateKey.newKey(var2_4.getModulus(), var2_4.getPrivateExponent());
            }
            catch (InvalidKeyException var2_5) {
                throw new InvalidKeySpecException(RSAKeyFactory.z[19] + var2_5.getMessage());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> clazz) throws InvalidKeySpecException {
        block14: {
            try {
                Class<T> clazz2;
                if (key instanceof java.security.interfaces.RSAPublicKey) {
                    clazz2 = Class.forName(z[28]);
                    Class<T> clazz3 = Class.forName(z[38]);
                    if (clazz2.isAssignableFrom(clazz)) {
                        java.security.interfaces.RSAPublicKey rSAPublicKey = (java.security.interfaces.RSAPublicKey)key;
                        return (T)((KeySpec)clazz.cast(new RSAPublicKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent())));
                    }
                    if (!clazz3.isAssignableFrom(clazz)) throw new InvalidKeySpecException(z[35]);
                    return (T)((KeySpec)clazz.cast(new X509EncodedKeySpec(key.getEncoded())));
                }
                if (key instanceof java.security.interfaces.RSAPrivateCrtKey) {
                    clazz2 = Class.forName(z[29]);
                    Class<T> clazz4 = Class.forName(z[36]);
                    Class<T> clazz5 = Class.forName(z[30]);
                    if (clazz2.isAssignableFrom(clazz)) {
                        java.security.interfaces.RSAPrivateCrtKey rSAPrivateCrtKey = (java.security.interfaces.RSAPrivateCrtKey)key;
                        return (T)((KeySpec)clazz.cast(new RSAPrivateCrtKeySpec(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient())));
                    }
                    if (clazz4.isAssignableFrom(clazz)) {
                        return (T)((KeySpec)clazz.cast(new PKCS8EncodedKeySpec(key.getEncoded())));
                    }
                    if (!clazz5.isAssignableFrom(clazz)) throw new InvalidKeySpecException(z[31]);
                    java.security.interfaces.RSAPrivateKey rSAPrivateKey = (java.security.interfaces.RSAPrivateKey)key;
                    return (T)((KeySpec)clazz.cast(new RSAPrivateKeySpec(rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent(), rSAPrivateKey.getParams())));
                }
                if (!(key instanceof java.security.interfaces.RSAPrivateKey)) throw new InvalidKeySpecException(z[33]);
                clazz2 = Class.forName(z[34]);
                Class<T> clazz6 = Class.forName(z[32]);
                if (clazz2.isAssignableFrom(clazz)) {
                    java.security.interfaces.RSAPrivateKey rSAPrivateKey = (java.security.interfaces.RSAPrivateKey)key;
                    return (T)((KeySpec)clazz.cast(new RSAPrivateKeySpec(rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent(), rSAPrivateKey.getParams())));
                }
                if (!clazz6.isAssignableFrom(clazz)) break block14;
                return (T)((KeySpec)clazz.cast(new PKCS8EncodedKeySpec(key.getEncoded())));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new InvalidKeySpecException(z[27] + classNotFoundException.getMessage());
            }
        }
        throw new InvalidKeySpecException(z[37]);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException(z[25]);
        }
        RSAKeyFactory.a(key, this.b.keyAlgo());
        if (key instanceof RSAPrivateKey || key instanceof RSAPrivateCrtKey || key instanceof RSAPublicKey) {
            return key;
        }
        if (!(key instanceof PublicKey)) {
            if (key instanceof java.security.interfaces.RSAPublicKey) {
            }
            if (!(key instanceof PrivateKey) && !(key instanceof java.security.interfaces.RSAPrivateKey)) {
                if (!(key instanceof java.security.interfaces.RSAPrivateCrtKey)) throw new InvalidKeyException(z[23]);
            }
        } else {
            try {}
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new InvalidKeyException(z[26]);
            }
            return this.a((PublicKey)key);
            catch (InvalidKeyException invalidKeyException) {
                throw invalidKeyException;
            }
        }
        try {}
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException(z[24]);
        }
        return this.a((PrivateKey)key);
        catch (InvalidKeyException invalidKeyException) {
            throw invalidKeyException;
        }
    }

    private PublicKey a(PublicKey publicKey) throws InvalidKeyException, InvalidKeySpecException {
        block8: {
            block9: {
                if (!(publicKey instanceof java.security.interfaces.RSAPublicKey)) break block8;
                if (!(publicKey instanceof RSAPublicKey)) break block9;
                return publicKey;
            }
            RSAPublicKeySpec rSAPublicKeySpec = this.engineGetKeySpec(publicKey, RSAPublicKeySpec.class);
            return this.engineGeneratePublic(rSAPublicKeySpec);
        }
        if (publicKey instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
            try {
                return new RSAPublicKey(RSAUtil.createAlgorithmId((RSAUtil.KeyType)this.b, (AlgorithmParameterSpec)rSAPublicKey.getParams()), rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
            }
            catch (ProviderException providerException) {
                throw new InvalidKeyException(z[22], providerException);
            }
        }
        if (z[21].equals(publicKey.getFormat())) {
            RSAPublicKey rSAPublicKey = new RSAPublicKey(publicKey.getEncoded());
            RSAKeyFactory.a(rSAPublicKey, this.b.keyAlgo());
            return rSAPublicKey;
        }
        throw new InvalidKeyException(z[20]);
    }

    private PrivateKey a(PrivateKey privateKey) throws InvalidKeyException, InvalidKeySpecException {
        block17: {
            block18: {
                block15: {
                    block16: {
                        if (!(privateKey instanceof java.security.interfaces.RSAPrivateCrtKey)) break block15;
                        if (!(privateKey instanceof RSAPrivateCrtKey)) break block16;
                        return privateKey;
                    }
                    RSAPrivateKeySpec rSAPrivateKeySpec = this.engineGetKeySpec(privateKey, RSAPrivateCrtKeySpec.class);
                    return this.engineGeneratePrivate(rSAPrivateKeySpec);
                }
                if (privateKey instanceof RSAPrivateCrtKey) {
                    RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)privateKey;
                    try {
                        return new RSAPrivateCrtKey(RSAUtil.createAlgorithmId((RSAUtil.KeyType)this.b, (AlgorithmParameterSpec)rSAPrivateCrtKey.getParams()), rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
                    }
                    catch (ProviderException providerException) {
                        throw new InvalidKeyException(z[39], providerException);
                    }
                }
                if (!(privateKey instanceof java.security.interfaces.RSAPrivateKey)) break block17;
                if (!(privateKey instanceof RSAPrivateKey)) break block18;
                return privateKey;
            }
            RSAPrivateKeySpec rSAPrivateKeySpec = this.engineGetKeySpec(privateKey, RSAPrivateKeySpec.class);
            return this.engineGeneratePrivate(rSAPrivateKeySpec);
        }
        if (privateKey instanceof RSAPrivateKey) {
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)privateKey;
            try {
                return new RSAPrivateKey(RSAUtil.createAlgorithmId((RSAUtil.KeyType)this.b, (AlgorithmParameterSpec)rSAPrivateKey.getParams()), rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent());
            }
            catch (ProviderException providerException) {
                throw new InvalidKeyException(z[40], providerException);
            }
        }
        if (z[41].equals(privateKey.getFormat())) {
            RSAPrivateCrtKey rSAPrivateCrtKey = RSAPrivateCrtKey.newKey(privateKey.getEncoded());
            RSAKeyFactory.a(rSAPrivateCrtKey, this.b.keyAlgo());
            return rSAPrivateCrtKey;
        }
        throw new InvalidKeyException(z[42]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void a(Key key, String string) throws InvalidKeyException {
        String string2 = key.getAlgorithm();
        if (string2 == null) {
            throw new InvalidKeyException(z[1] + string + z[8] + string2);
        }
        if (key.getAlgorithm().equalsIgnoreCase(z[2])) {
            if (!string.equalsIgnoreCase(z[3]) && !string.equalsIgnoreCase(z[7])) return;
            return;
        } else {
            if (key.getAlgorithm().equalsIgnoreCase(z[4]) && string.equalsIgnoreCase(z[0])) {
                return;
            }
            if (key.getAlgorithm().equalsIgnoreCase(string)) return;
            throw new InvalidKeyException(z[5] + string + z[6] + string2);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block66: {
            int n2;
            int n3;
            block65: {
                String string;
                String[] stringArray = new String[45];
                String[] stringArray2 = stringArray;
                String[] stringArray3 = stringArray;
                int n4 = 0;
                String string2 = "\r\u000f7+\u000b\f";
                int n5 = -1;
                block58: while (true) {
                    char[] cArray2;
                    block64: {
                        int n6;
                        block63: {
                            char[] cArray3 = string2.toCharArray();
                            cArray2 = cArray3;
                            n6 = cArray3.length;
                            n3 = 0;
                            if (!true) break block63;
                            n6 = n6;
                            if (n6 <= n3) break block64;
                        }
                        do {
                            int n7;
                            cArray2 = cArray2;
                            int n8 = n3;
                            char c2 = cArray2[n8];
                            switch (n3 % 5) {
                                case 0: {
                                    n7 = 95;
                                    break;
                                }
                                case 1: {
                                    n7 = 92;
                                    break;
                                }
                                case 2: {
                                    n7 = 118;
                                    break;
                                }
                                case 3: {
                                    n7 = 123;
                                    break;
                                }
                                default: {
                                    n7 = 88;
                                }
                            }
                            cArray2[n8] = (char)(c2 ^ n7);
                            ++n3;
                            n6 = n6;
                        } while (n6 > n3);
                    }
                    string = new String(cArray2);
                    switch (n5) {
                        default: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 1;
                            string2 = "\u001a$\u0006\u001e;+9\u0012[9\u007f";
                            n5 = 0;
                            continue block58;
                        }
                        case 0: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 2;
                            string2 = "\r\u000f7+\u000b\f";
                            n5 = 1;
                            continue block58;
                        }
                        case 1: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 3;
                            string2 = "\r\u000f7+\u000b\f";
                            n5 = 2;
                            continue block58;
                        }
                        case 2: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 4;
                            string2 = "\r\u000f7";
                            n5 = 3;
                            continue block58;
                        }
                        case 3: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 5;
                            string2 = "\u001a$\u0006\u001e;+9\u0012[9\u007f";
                            n5 = 4;
                            continue block58;
                        }
                        case 4: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 6;
                            string2 = "\u007f7\u0013\u0002t\u007f>\u0003\u000fx83\u0002[";
                            n5 = 5;
                            continue block58;
                        }
                        case 5: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 7;
                            string2 = "\r\u000f7";
                            n5 = 6;
                            continue block58;
                        }
                        case 6: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 8;
                            string2 = "\u007f7\u0013\u0002t\u007f>\u0003\u000fx83\u0002[";
                            n5 = 7;
                            continue block58;
                        }
                        case 7: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 9;
                            string2 = ":$\u0006\u00146:2\u0002[1,|\u0005\u0016930\u0013\tx+4\u0017\u0015xl";
                            n5 = 8;
                            continue block58;
                        }
                        case 8: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 10;
                            string2 = ":$\u0006\u00146:2\u0002[1,|\u001a\u001a*89\u0004[,7=\u0018[508\u0003\u0017-,";
                            n5 = 9;
                            continue block58;
                        }
                        case 9: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 11;
                            string2 = "\r\u000f7[3:%\u0005[5*/\u0002[::|\u0017\u000fx39\u0017\b,\u007f";
                            n5 = 10;
                            continue block58;
                        }
                        case 10: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 12;
                            string2 = "\u007f>\u001f\u000f+";
                            n5 = 11;
                            continue block58;
                        }
                        case 11: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 13;
                            string2 = "\r\u000f7[=',\u0019\u0015=1(\u0005[;>2V\u0019=\u007f2\u0019[402\u0011\u001e*\u007f(\u001e\u001a6\u007fjB[:6(\u0005[x6:V\u00167;)\u001a\u000e+\u007f5\u0005[?-9\u0017\u000f=-|\u0002\u001391|EKom|\u0014\u0012,,";
                            n5 = 12;
                            continue block58;
                        }
                        case 12: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 14;
                            string2 = "\r\u000f7[3:%\u0005[5*/\u0002[::|\u0018\u0014x33\u0018\u001c=-|\u0002\u001391|";
                            n5 = 13;
                            continue block58;
                        }
                        case 13: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 15;
                            string2 = "\u007f>\u001f\u000f+\u007f0\u0019\u0015?";
                            n5 = 14;
                            continue block58;
                        }
                        case 14: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 16;
                            string2 = "\u00162\u0017\u000b(-3\u0006\t1>(\u0013[3:%V\b(:?\u001f\u001d1<=\u0002\u001271";
                            n5 = 15;
                            continue block58;
                        }
                        case 15: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 17;
                            string2 = "\u00162\u0017\u000b(-3\u0006\t1>(\u0013[3:%V\b(:?\u001f\u001d1<=\u0002\u001271fV";
                            n5 = 16;
                            continue block58;
                        }
                        case 16: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 18;
                            string2 = "\u00162\u0017\u000b(-3\u0006\t1>(\u0013[3:%V\b(:?\u001f\u001d1<=\u0002\u001271";
                            n5 = 17;
                            continue block58;
                        }
                        case 17: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 19;
                            string2 = "\u00162\u0017\u000b(-3\u0006\t1>(\u0013[3:%V\b(:?\u001f\u001d1<=\u0002\u001271fV";
                            n5 = 18;
                            continue block58;
                        }
                        case 18: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 20;
                            string2 = "\u000f)\u0014\u00171<|\u001d\u001e!,|\u001b\u000e++|\u0014\u001ex62\u0005\u000f91?\u0013[79|$(\u0019\u000f)\u0014\u00171<\u0017\u0013\u0002x0.V\u00139)9V#vjlO[=1?\u0019\u001f11;";
                            n5 = 19;
                            continue block58;
                        }
                        case 19: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 21;
                            string2 = "\u0007rCKa";
                            n5 = 20;
                            continue block58;
                        }
                        case 20: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 22;
                            string2 = "\u00162\u0000\u001a468V\u0010=&";
                            n5 = 21;
                            continue block58;
                        }
                        case 21: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 23;
                            string2 = "\u00119\u001f\u000f0:.V\u001ax/)\u0014\u00171<|\u0018\u0014*\u007f=V\u000b*6*\u0017\u000f=\u007f7\u0013\u0002";
                            n5 = 22;
                            continue block58;
                        }
                        case 22: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 24;
                            string2 = "\n2\u0017\u00194:|\u0002\u0014x/.\u0019\u0018=,/V\u000f0:%V+*6*\u0017\u000f=\u00149\u000f";
                            n5 = 23;
                            continue block58;
                        }
                        case 23: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 25;
                            string2 = "\u00149\u000f[5*/\u0002[60(V\u0019=\u007f2\u0003\u00174";
                            n5 = 24;
                            continue block58;
                        }
                        case 24: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 26;
                            string2 = "\n2\u0017\u00194:|\u0002\u0014x/.\u0019\u0018=,/V\u000f0:%V+-=0\u001f\u0018\u0013:%";
                            n5 = 25;
                            continue block58;
                        }
                        case 25: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 27;
                            string2 = "\n2\u0005\u000e(/3\u0004\u000f=;|\u001d\u001e!\u007f/\u0006\u001e;6:\u001f\u00189+5\u0019\u0015b\u007f";
                            n5 = 26;
                            continue block58;
                        }
                        case 26: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 28;
                            string2 = "5=\u0000\u001av,9\u0015\u000e*6(\u000fU+/9\u0015U\n\f\u001d&\u000e:35\u00150=&\u000f\u0006\u001e;";
                            n5 = 27;
                            continue block58;
                        }
                        case 27: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 29;
                            string2 = "5=\u0000\u001av,9\u0015\u000e*6(\u000fU+/9\u0015U\n\f\u001d&\t1)=\u0002\u001e\u001b-(=\u001e!\f,\u0013\u0018";
                            n5 = 28;
                            continue block58;
                        }
                        case 28: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 30;
                            string2 = "5=\u0000\u001av,9\u0015\u000e*6(\u000fU+/9\u0015U\n\f\u001d&\t1)=\u0002\u001e\u0013:%%\u000b=<";
                            n5 = 29;
                            continue block58;
                        }
                        case 29: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 31;
                            string2 = "\u00162\u0017\u000b(-3\u0006\t1>(\u0013[3:%V\b(:?\u001f\u001d1<=\u0002\u001271|$(\u0019\u000f.\u001f\r9+95\t,\u00149\u000f((:?";
                            n5 = 30;
                            continue block58;
                        }
                        case 30: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 32;
                            string2 = "5=\u0000\u001av,9\u0015\u000e*6(\u000fU+/9\u0015U\b\u0014\u001f%C\u001d1?\u0019\u001f=;\u0017\u0013\u0002\u000b/9\u0015";
                            n5 = 31;
                            continue block58;
                        }
                        case 31: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 33;
                            string2 = "\u00162\u0017\u000b(-3\u0006\t1>(\u0013[3:%V\u000f!/9";
                            n5 = 32;
                            continue block58;
                        }
                        case 32: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 34;
                            string2 = "5=\u0000\u001av,9\u0015\u000e*6(\u000fU+/9\u0015U\n\f\u001d&\t1)=\u0002\u001e\u0013:%%\u000b=<";
                            n5 = 33;
                            continue block58;
                        }
                        case 33: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 35;
                            string2 = "\u00162\u0017\u000b(-3\u0006\t1>(\u0013[3:%V\b(:?\u001f\u001d1<=\u0002\u001271";
                            n5 = 34;
                            continue block58;
                        }
                        case 34: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 36;
                            string2 = "5=\u0000\u001av,9\u0015\u000e*6(\u000fU+/9\u0015U\b\u0014\u001f%C\u001d1?\u0019\u001f=;\u0017\u0013\u0002\u000b/9\u0015";
                            n5 = 35;
                            continue block58;
                        }
                        case 35: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 37;
                            string2 = "\u00162\u0017\u000b(-3\u0006\t1>(\u0013[3:%V\b(:?\u001f\u001d1<=\u0002\u001271|\u0006\t1)=\u0002\u001e\u0013:%";
                            n5 = 36;
                            continue block58;
                        }
                        case 36: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 38;
                            string2 = "5=\u0000\u001av,9\u0015\u000e*6(\u000fU+/9\u0015U\u0000jlO>6<3\u0012\u001e<\u00149\u000f((:?";
                            n5 = 37;
                            continue block58;
                        }
                        case 37: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 39;
                            string2 = "\u00162\u0000\u001a468V\u0010=&";
                            n5 = 38;
                            continue block58;
                        }
                        case 38: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 40;
                            string2 = "\u00162\u0000\u001a468V\u0010=&";
                            n5 = 39;
                            continue block58;
                        }
                        case 39: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 41;
                            string2 = "\u000f\u00175({g";
                            n5 = 40;
                            continue block58;
                        }
                        case 40: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 42;
                            string2 = "\u000f.\u001f\r9+9V\u0010=&/V\u0016-,(V\u0019=\u007f5\u0018\b,>2\u0015\u001ex0:V)\u000b\u001e\f\u0004\u0012.>(\u0013S\u001b-(_0=&|\u0019\tx7=\u0000\u001ex\u000f\u00175({g|\u0013\u0015;08\u001f\u0015?";
                            n5 = 41;
                            continue block58;
                        }
                        case 41: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 43;
                            string2 = "<3\u001bU1=1X\u0018*&,\u0002\u0014v/.\u0019\r1;9\u0004U*:/\u0002\t1<($(\u0019\u001a$\u0006\u00146:2\u0002";
                            n5 = 42;
                            continue block58;
                        }
                        case 42: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 44;
                            string2 = "+.\u0003\u001e";
                            n5 = 43;
                            continue block58;
                        }
                        case 43: 
                    }
                    break;
                }
                stringArray2[n4] = string.intern();
                z = stringArray3;
                a = BigInteger.valueOf(3L);
                c = null;
                char[] cArray4 = "+.\u0003\u001e".toCharArray();
                cArray = cArray4;
                n2 = cArray4.length;
                n3 = 0;
                if (!true) break block65;
                n2 = n2;
                if (n2 <= n3) break block66;
            }
            do {
                int n9;
                cArray = cArray;
                int n10 = n3;
                char c3 = cArray[n10];
                switch (n3 % 5) {
                    case 0: {
                        n9 = 95;
                        break;
                    }
                    case 1: {
                        n9 = 92;
                        break;
                    }
                    case 2: {
                        n9 = 118;
                        break;
                    }
                    case 3: {
                        n9 = 123;
                        break;
                    }
                    default: {
                        n9 = 88;
                    }
                }
                cArray[n10] = (char)(c3 ^ n9);
                ++n3;
                n2 = n2;
            } while (n2 > n3);
        }
        d = new String(cArray).intern().equalsIgnoreCase(AccessController.doPrivileged(new GetPropertyAction(z[43], z[44])));
        e = new RSAKeyFactory(RSAUtil.KeyType.RSA);
        f = new RSAKeyFactory(RSAUtil.KeyType.PSS);
    }
}

