/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.common.datamodel.impl.data;

import com.ibm.java.diagnostics.common.datamodel.data.DataPoint;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.axes.AxisPair;
import com.ibm.java.diagnostics.common.datamodel.data.axes.XDataAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.YDataAxis;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.AxisPairImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.XDataAxisImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.YDataAxisImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.data.DataImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.data.DataPointImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.data.FullDataPointImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.data.Messages;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;

public class TwoDimensionalDataImpl
extends DataImpl
implements TwoDimensionalDataBuilder {
    private static final Logger TRACE = LogFactory.getTrace(TwoDimensionalDataImpl.class);
    protected AxisPair axisPair;
    private XDataAxisImpl xAxis;
    private YDataAxisImpl yAxis;
    protected DataPointBuilder minX = null;
    protected DataPointBuilder minY = null;
    protected DataPointBuilder maxX = null;
    protected DataPointBuilder maxY = null;
    protected DataPointBuilder masterMaxX = null;
    protected DataPointBuilder masterMaxY = null;
    protected DataPointBuilder masterMinX = null;
    protected DataPointBuilder masterMinY = null;
    protected double masterRawTotalX = 0.0;
    protected double masterRawTotalY = 0.0;
    protected double rawTotalX = -1.0;
    protected double rawTotalY = -1.0;
    protected DataPointBuilder[] dataPointBuilders;
    protected List<DataPointBuilder> dataPointBuilderList;
    private int lastSequence;
    private int index = 0;
    private static final DataPointBuilder[] DATA_POINT_TEMPLATE_ARRAY = new DataPointBuilder[0];
    private static final int UNSET = -1;
    private Object listLock = new Object();

    public Object getListLock() {
        return this.listLock;
    }

    public TwoDimensionalDataImpl(String string, AxisPair axisPair) {
        this(string, string, axisPair);
    }

    public TwoDimensionalDataImpl(String string, String string2, AxisPair axisPair) {
        super(string, string2);
        this.axisPair = axisPair;
        this.dataPointBuilders = null;
        this.xAxis = (XDataAxisImpl)axisPair.getXAxis();
        this.yAxis = (YDataAxisImpl)axisPair.getYAxis();
        this.lastSequence = -1;
        this.dataPointBuilderList = new ArrayList<DataPointBuilder>();
        ((AxisPairImpl)axisPair).addListener(this);
    }

    @Override
    public void setLabel(String string) {
        this.label = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataPointBuilder getMaxX() {
        Object object = this.listLock;
        synchronized (object) {
            if (this.dataPointBuilders == null) {
                this.crop();
            }
            return this.maxX;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataPointBuilder getMaxY() {
        Object object = this.listLock;
        synchronized (object) {
            if (this.dataPointBuilders == null) {
                this.crop();
            }
            return this.maxY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataPointBuilder getMinX() {
        Object object = this.listLock;
        synchronized (object) {
            if (this.dataPointBuilders == null) {
                this.crop();
            }
            return this.minX;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataPointBuilder getMinY() {
        Object object = this.listLock;
        synchronized (object) {
            if (this.dataPointBuilders == null) {
                this.crop();
            }
            return this.minY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getTotalX() {
        Object object = this.listLock;
        synchronized (object) {
            return this.xAxis.convert(this.getRawTotalX());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getTotalY() {
        Object object = this.listLock;
        synchronized (object) {
            return this.yAxis.convert(this.getRawTotalY());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getMeanX() {
        Object object = this.listLock;
        synchronized (object) {
            return this.xAxis.convert(this.getRawMeanX());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getMeanY() {
        Object object = this.listLock;
        synchronized (object) {
            return this.yAxis.convert(this.getRawMeanY());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getRawTotalX() {
        Object object = this.listLock;
        synchronized (object) {
            if (this.dataPointBuilders == null) {
                this.crop();
            }
            return this.rawTotalX;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getRawTotalY() {
        Object object = this.listLock;
        synchronized (object) {
            if (this.dataPointBuilders == null) {
                this.crop();
            }
            return this.rawTotalY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getRawMeanX() {
        Object object = this.listLock;
        synchronized (object) {
            if (this.dataPointBuilders == null) {
                this.crop();
            }
            if (this.dataPointBuilders != null && this.dataPointBuilders.length > 0) {
                return this.rawTotalX / (double)this.dataPointBuilders.length;
            }
            return 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getRawMeanY() {
        Object object = this.listLock;
        synchronized (object) {
            if (this.dataPointBuilders == null) {
                this.crop();
            }
            if (this.dataPointBuilders != null && this.dataPointBuilders.length > 0) {
                return this.rawTotalY / (double)this.dataPointBuilders.length;
            }
            return 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataPointBuilder[] getDataPoints() {
        Object object = this.listLock;
        synchronized (object) {
            if (this.dataPointBuilders == null) {
                this.crop();
            }
            return this.dataPointBuilders;
        }
    }

    @Override
    public List<DataPointBuilder> getAllDataPoints() {
        return new ArrayList<DataPointBuilder>(this.dataPointBuilderList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataPointBuilder getLastDataPoint() {
        Object object = this.listLock;
        synchronized (object) {
            if (this.dataPointBuilders == null) {
                this.crop();
            }
            if (this.dataPointBuilders.length > 0) {
                return this.dataPointBuilders[this.dataPointBuilders.length - 1];
            }
            return null;
        }
    }

    @Override
    protected DataPointBuilder getCurrentNodeBiggestXAxisValue() {
        return this.getUncroppedMaxX();
    }

    @Override
    protected DataPointBuilder getCurrentNodeSmallestXAxisValue() {
        return this.getUncroppedMinX();
    }

    private boolean isValidUnitForDeletion(String string) {
        return this.getXAxis().getAxis().getPossibleUnits().contains(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void evaluateDataForDeletion(double d, String string) {
        if (!this.isValidUnitForDeletion(string)) {
            TRACE.warning(Messages.getString("TwoDimensionalDataImpl.incompatible.x.units") + this.xAxis.getUnits());
            return;
        }
        Object object = this.listLock;
        synchronized (object) {
            Object object2;
            if (this.dataPointBuilderList == null) {
                return;
            }
            this.dataPointBuilders = null;
            ListIterator<DataPointBuilder> listIterator = this.dataPointBuilderList.listIterator();
            while (listIterator.hasNext()) {
                object2 = listIterator.next();
                if (!(object2.getX(string) < d)) continue;
                listIterator.remove();
            }
            object2 = this.dataPointBuilderList.listIterator();
            this.masterMinX = null;
            this.masterMaxX = null;
            this.masterMinY = null;
            this.masterMaxY = null;
            this.masterRawTotalX = 0.0;
            this.masterRawTotalY = 0.0;
            while (object2.hasNext()) {
                DataPointBuilder dataPointBuilder = (DataPointBuilder)object2.next();
                if (this.masterMinX == null || dataPointBuilder.getRawX() < this.masterMinX.getRawX()) {
                    this.masterMinX = dataPointBuilder;
                }
                if (this.masterMaxX == null || dataPointBuilder.getRawX() > this.masterMaxX.getRawX()) {
                    this.masterMaxX = dataPointBuilder;
                }
                if (this.masterMinY == null || dataPointBuilder.getRawY() < this.masterMinY.getRawY()) {
                    this.masterMinY = dataPointBuilder;
                }
                if (this.masterMaxY == null || dataPointBuilder.getRawY() > this.masterMaxY.getRawY()) {
                    this.masterMaxY = dataPointBuilder;
                }
                this.masterRawTotalX += dataPointBuilder.getRawX();
                this.masterRawTotalY += dataPointBuilder.getRawY();
            }
            this.resetCropping();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deleteHalfTheData() {
        Object object = this.listLock;
        synchronized (object) {
            int n;
            if (this.dataPointBuilderList == null) {
                return;
            }
            if (this.dataPointBuilderList.size() >= 2 && (n = this.dataPointBuilderList.indexOf(this.getMaxX())) > 0) {
                int n2 = 0;
                int n3 = this.dataPointBuilderList.size() - 1;
                if (n < n3) {
                    n2 = n3 / 2;
                    if (n2 > n) {
                        n2 = n;
                    }
                } else {
                    n2 = n / 2;
                }
                this.dataPointBuilderList = new ArrayList<DataPointBuilder>(this.dataPointBuilderList.subList(n2, n));
            }
            ListIterator<DataPointBuilder> listIterator = this.dataPointBuilderList.listIterator();
            this.masterMinX = null;
            this.masterMaxX = null;
            this.masterMinY = null;
            this.masterMaxY = null;
            this.masterRawTotalX = 0.0;
            this.masterRawTotalY = 0.0;
            while (listIterator.hasNext()) {
                DataPointBuilder dataPointBuilder = listIterator.next();
                if (this.masterMinX == null || dataPointBuilder.getRawX() < this.masterMinX.getRawX()) {
                    this.masterMinX = dataPointBuilder;
                }
                if (this.masterMaxX == null || dataPointBuilder.getRawX() > this.masterMaxX.getRawX()) {
                    this.masterMaxX = dataPointBuilder;
                }
                if (this.masterMinY == null || dataPointBuilder.getRawY() < this.masterMinY.getRawY()) {
                    this.masterMinY = dataPointBuilder;
                }
                if (this.masterMaxY == null || dataPointBuilder.getRawY() > this.masterMaxY.getRawY()) {
                    this.masterMaxY = dataPointBuilder;
                }
                this.masterRawTotalX += dataPointBuilder.getRawX();
                this.masterRawTotalY += dataPointBuilder.getRawY();
            }
            this.resetCropping();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateDataPointXValues(double d) {
        Object object = this.listLock;
        synchronized (object) {
            if (this.dataPointBuilderList == null) {
                return;
            }
            this.dataPointBuilders = null;
            ListIterator<DataPointBuilder> listIterator = this.dataPointBuilderList.listIterator();
            while (listIterator.hasNext()) {
                DataPointBuilder dataPointBuilder = listIterator.next();
                dataPointBuilder.setRawX(dataPointBuilder.getRawX() - d);
            }
            this.resetCropping();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataPointBuilder getDataPoint(int n) {
        Object object = this.listLock;
        synchronized (object) {
            DataPointBuilder dataPointBuilder = null;
            DataPointBuilder[] dataPointBuilderArray = this.getDataPoints();
            dataPointBuilder = this.binarySearch(n, dataPointBuilderArray, 0, dataPointBuilderArray.length - 1);
            if (dataPointBuilder == null) {
                dataPointBuilder = this.linearSearch(n, dataPointBuilderArray);
            }
            return dataPointBuilder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataPointBuilder getDataPointFromUncroppedData(int n) {
        Object object = this.listLock;
        synchronized (object) {
            DataPointBuilder dataPointBuilder = null;
            DataPointBuilder[] dataPointBuilderArray = this.dataPointBuilderList.toArray(DATA_POINT_TEMPLATE_ARRAY);
            dataPointBuilder = this.binarySearch(n, dataPointBuilderArray, 0, dataPointBuilderArray.length - 1);
            if (dataPointBuilder == null) {
                dataPointBuilder = this.linearSearch(n, dataPointBuilderArray);
            }
            return dataPointBuilder;
        }
    }

    private DataPointBuilder binarySearch(int n, DataPointBuilder[] dataPointBuilderArray, int n2, int n3) {
        if (dataPointBuilderArray.length > 0) {
            int n4 = n2 + n3 >>> 1;
            DataPointBuilder dataPointBuilder = dataPointBuilderArray[n4];
            int n5 = dataPointBuilder.getSequenceUID();
            if (n == n5) {
                return dataPointBuilder;
            }
            if (n2 == n3) {
                return null;
            }
            if (n3 - n2 == 1) {
                return this.binarySearch(n, dataPointBuilderArray, n3, n3);
            }
            if (n5 > n) {
                return this.binarySearch(n, dataPointBuilderArray, n2, n4);
            }
            return this.binarySearch(n, dataPointBuilderArray, n4, n3);
        }
        return null;
    }

    private DataPointBuilder linearSearch(int n, DataPointBuilder[] dataPointBuilderArray) {
        for (int i = 0; i < dataPointBuilderArray.length; ++i) {
            DataPointBuilder dataPointBuilder = dataPointBuilderArray[i];
            int n2 = dataPointBuilder.getSequenceUID();
            if (n != n2) continue;
            return dataPointBuilder;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataPointBuilder getDataPoint(double d) {
        Object object = this.listLock;
        synchronized (object) {
            DataPointBuilder dataPointBuilder = null;
            DataPointBuilder[] dataPointBuilderArray = this.getDataPoints();
            dataPointBuilder = this.binaryRawXSearch(d, dataPointBuilderArray, 0, dataPointBuilderArray.length - 1);
            if (dataPointBuilder == null) {
                for (int i = 0; i < dataPointBuilderArray.length; ++i) {
                    DataPointBuilder dataPointBuilder2 = dataPointBuilderArray[i];
                    if (d != dataPointBuilder2.getRawX()) continue;
                    return dataPointBuilder2;
                }
            }
            return dataPointBuilder;
        }
    }

    private DataPointBuilder binaryRawXSearch(double d, DataPointBuilder[] dataPointBuilderArray, int n, int n2) {
        if (dataPointBuilderArray.length > 0) {
            int n3 = n + n2 >>> 1;
            DataPointBuilder dataPointBuilder = dataPointBuilderArray[n3];
            double d2 = dataPointBuilder.getRawX();
            if (d == d2) {
                return dataPointBuilder;
            }
            if (n == n2) {
                return null;
            }
            if (n2 - n == 1) {
                return this.binaryRawXSearch(d, dataPointBuilderArray, n2, n2);
            }
            if (d2 > d) {
                return this.binaryRawXSearch(d, dataPointBuilderArray, n, n3);
            }
            return this.binaryRawXSearch(d, dataPointBuilderArray, n3, n2);
        }
        return null;
    }

    @Override
    public XDataAxis getXAxis() {
        return this.axisPair.getXAxis();
    }

    @Override
    public YDataAxis getYAxis() {
        return this.axisPair.getYAxis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final DataPointBuilder addDataPointBuilder(double d, String string) {
        Object object = this.listLock;
        synchronized (object) {
            this.lastSequence = this.xAxis.checkSequenceUID(this.lastSequence);
            FullDataPointImpl fullDataPointImpl = new FullDataPointImpl(this.xAxis.getSequenceUID(), this.xAxis.getX(), d, string, this.axisPair);
            this.addDataPointBuilder(fullDataPointImpl);
            return fullDataPointImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final DataPointBuilder addDataPointBuilder(double d) {
        Object object = this.listLock;
        synchronized (object) {
            this.lastSequence = this.xAxis.checkSequenceUID(this.lastSequence);
            DataPointImpl dataPointImpl = new DataPointImpl(this.xAxis.getSequenceUID(), this.xAxis.getX(), d, this.axisPair);
            this.addDataPointBuilder(dataPointImpl);
            return dataPointImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addDataPoint(int n, double d, double d2, String string) {
        Object object = this.listLock;
        synchronized (object) {
            this.lastSequence = this.xAxis.checkSequenceUID(this.lastSequence);
            FullDataPointImpl fullDataPointImpl = new FullDataPointImpl(n, d, d2, string, this.axisPair);
            this.addDataPointBuilder(fullDataPointImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addDataPoint(int n, double d, double d2) {
        Object object = this.listLock;
        synchronized (object) {
            this.lastSequence = this.xAxis.checkSequenceUID(this.lastSequence);
            DataPointImpl dataPointImpl = new DataPointImpl(n, d, d2, this.axisPair);
            this.addDataPointBuilder(dataPointImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDataPointBuilder(DataPointBuilder dataPointBuilder) {
        double d = dataPointBuilder.getRawX();
        double d2 = dataPointBuilder.getRawY();
        Object object = this.listLock;
        synchronized (object) {
            this.dataPointBuilders = null;
            if (this.dataPointBuilderList.size() > 0) {
                double d3 = this.dataPointBuilderList.get(this.dataPointBuilderList.size() - 1).getRawX();
                if (d >= d3) {
                    this.dataPointBuilderList.add(dataPointBuilder);
                } else {
                    this.index = Math.min(this.index, this.dataPointBuilderList.size() - 1);
                    d3 = this.dataPointBuilderList.get(this.index).getRawX();
                    if (d3 > d) {
                        while (d3 > d && this.index > 0) {
                            --this.index;
                            d3 = this.dataPointBuilderList.get(this.index).getRawX();
                        }
                        if (d >= d3) {
                            this.dataPointBuilderList.add(this.index + 1, dataPointBuilder);
                        } else {
                            this.dataPointBuilderList.add(0, dataPointBuilder);
                        }
                    } else {
                        while (d3 < d && this.index < this.dataPointBuilderList.size() - 1) {
                            ++this.index;
                            d3 = this.dataPointBuilderList.get(this.index).getRawX();
                        }
                        this.dataPointBuilderList.add(this.index, dataPointBuilder);
                    }
                }
            } else {
                this.dataPointBuilderList.add(dataPointBuilder);
            }
            if (this.masterMinX == null || dataPointBuilder.getRawX() < this.masterMinX.getRawX()) {
                this.masterMinX = dataPointBuilder;
            }
            if (this.masterMaxX == null || dataPointBuilder.getRawX() > this.masterMaxX.getRawX()) {
                this.masterMaxX = dataPointBuilder;
            }
            if (this.masterMinY == null || dataPointBuilder.getRawY() < this.masterMinY.getRawY()) {
                this.masterMinY = dataPointBuilder;
            }
            if (this.masterMaxY == null || dataPointBuilder.getRawY() > this.masterMaxY.getRawY()) {
                this.masterMaxY = dataPointBuilder;
            }
            this.masterRawTotalX += dataPointBuilder.getRawX();
            this.masterRawTotalY += dataPointBuilder.getRawY();
        }
        this.xAxis.updateNormalisation(d);
        this.yAxis.updateNormalisation(d2);
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDataPoints(DataPointBuilder[] dataPointBuilderArray) {
        Object object = this.listLock;
        synchronized (object) {
            this.resetDerivedValues();
            this.dataPointBuilders = null;
            this.dataPointBuilderList.clear();
            this.masterMaxX = null;
            this.masterMaxY = null;
            this.masterMinX = null;
            this.masterMinY = null;
            this.masterRawTotalX = 0.0;
            this.masterRawTotalY = 0.0;
            for (DataPointBuilder dataPointBuilder : dataPointBuilderArray) {
                this.addDataPointBuilder(dataPointBuilder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetDerivedValues() {
        Object object = this.listLock;
        synchronized (object) {
            this.resetMaximaAndMinima();
            this.dataPointBuilders = null;
        }
    }

    private void resetMaximaAndMinima() {
        this.minX = null;
        this.minY = null;
        this.maxX = null;
        this.maxY = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCropping() {
        Object object = this.listLock;
        synchronized (object) {
            this.resetMaximaAndMinima();
            this.dataPointBuilders = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.listLock;
        synchronized (object) {
            if (this.dataPointBuilders == null) {
                this.crop();
            }
            return this.dataPointBuilders == null || this.dataPointBuilders.length == 0;
        }
    }

    @Override
    public AxisPair getAxisPair() {
        return this.axisPair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataPointBuilder getUncroppedMinX() {
        Object object = this.listLock;
        synchronized (object) {
            return this.masterMinX;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataPointBuilder getUncroppedMaxX() {
        Object object = this.listLock;
        synchronized (object) {
            return this.masterMaxX;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataPointBuilder getUncroppedMinY() {
        Object object = this.listLock;
        synchronized (object) {
            return this.masterMinY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void crop() {
        boolean bl;
        YDataAxis yDataAxis = this.axisPair.getYAxis();
        DataPoint dataPoint = this.xAxis.getMinimumBound();
        DataPoint dataPoint2 = this.xAxis.getMaximumBound();
        DataPoint dataPoint3 = yDataAxis.getMinimumBound();
        DataPoint dataPoint4 = yDataAxis.getMaximumBound();
        boolean bl2 = dataPoint != null || dataPoint2 != null;
        boolean bl3 = bl = dataPoint3 != null || dataPoint4 != null;
        if (!bl2 && !bl) {
            this.dataPointBuilders = this.dataPointBuilderList.toArray(DATA_POINT_TEMPLATE_ARRAY);
            this.maxX = this.masterMaxX;
            this.maxY = this.masterMaxY;
            this.minX = this.masterMinX;
            this.minY = this.masterMinY;
            this.rawTotalX = this.masterRawTotalX;
            this.rawTotalY = this.masterRawTotalY;
        } else {
            double d = -1.7976931348623157E308;
            double d2 = -1.7976931348623157E308;
            double d3 = Double.MAX_VALUE;
            double d4 = Double.MAX_VALUE;
            if (dataPoint != null) {
                d = dataPoint.getX();
            }
            if (dataPoint3 != null) {
                d2 = dataPoint3.getY();
            }
            if (dataPoint2 != null) {
                d3 = dataPoint2.getX();
            }
            if (dataPoint4 != null) {
                d4 = dataPoint4.getY();
            }
            this.rawTotalX = 0.0;
            this.rawTotalY = 0.0;
            ArrayList<DataPointBuilder> arrayList = new ArrayList<DataPointBuilder>();
            Object object = this.listLock;
            synchronized (object) {
                ListIterator<DataPointBuilder> listIterator = this.dataPointBuilderList.listIterator();
                while (listIterator.hasNext()) {
                    double d5;
                    DataPointBuilder dataPointBuilder = (DataPointBuilder)listIterator.next();
                    boolean bl4 = true;
                    boolean bl5 = true;
                    if (bl2) {
                        d5 = dataPointBuilder.getX();
                        boolean bl6 = bl4 = d5 >= d && d5 <= d3;
                    }
                    if (bl) {
                        d5 = dataPointBuilder.getY();
                        boolean bl7 = bl5 = d5 >= d2 && d5 <= d4;
                    }
                    if (!bl4 || !bl5) continue;
                    arrayList.add(dataPointBuilder);
                    if (this.minX == null || dataPointBuilder.getX() < this.minX.getX()) {
                        this.minX = dataPointBuilder;
                    }
                    if (this.maxX == null || dataPointBuilder.getX() > this.maxX.getX()) {
                        this.maxX = dataPointBuilder;
                    }
                    if (this.minY == null || dataPointBuilder.getY() < this.minY.getY()) {
                        this.minY = dataPointBuilder;
                    }
                    if (this.maxY == null || dataPointBuilder.getY() > this.maxY.getY()) {
                        this.maxY = dataPointBuilder;
                    }
                    this.rawTotalX += dataPointBuilder.getRawX();
                    this.rawTotalY += dataPointBuilder.getRawY();
                }
                this.dataPointBuilders = arrayList.toArray(DATA_POINT_TEMPLATE_ARRAY);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long countDataPoints() {
        long l = 0L;
        Object object = this.listLock;
        synchronized (object) {
            if (this.dataPointBuilderList == null) {
                return l;
            }
            ListIterator<DataPointBuilder> listIterator = this.dataPointBuilderList.listIterator();
            while (listIterator.hasNext()) {
                DataPointBuilder dataPointBuilder = (DataPointBuilder)listIterator.next();
                l += (long)dataPointBuilder.getDataPointSize();
            }
            return l;
        }
    }
}

