/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.datatruncation;

import com.ibm.java.diagnostics.common.datamodel.impl.preferences.PreferencesHelper;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.MarshallingPreferenceInitalizer;
import java.util.prefs.Preferences;

public class DataStoragePreferenceHelper
extends PreferencesHelper {
    public static final String TRUNCATION_JOB_RUN_INTERVAL = "DataStoragePreferenceHelper.classTruncationJobRunInterval";
    public static final String MINUTES_TO_KEEP = "DataStoragePreferenceHelper.classMinutesToKeep";
    public static final String USE_SLIDING_WINDOW = "DataStoragePreferenceHelper.classUseSlidingWindow";
    public static final String SIZE_OF_BACKING_FILE = "DataStoragePreferenceHelper.classSizeOfBackingFile";
    public static final String USE_BACKING_FILE = "DataStoragePreferenceHelper.classUseBackingFile";
    public static final String MAX_MEMORY_USAGE = "DataStoragePreferenceHelper.classmaxMemoryUsage";
    public static final String USE_MEMORY_SIZE_LIMIT = "DataStoragePreferenceHelper.classuseMemorySizeLimit";
    public static final String MAX_MEMORY_PERCENTAGE = "DataStoragePreferenceHelper.classmaxMemoryPercentage";
    public static final String MAX_HCD_TO_KEEP = "DataStoragePreferenceHelper.classmaxHCDToKeep";
    private static final int DEFAULT_PERCENTAGE = 80;
    private static final int DEFAULT_MAX_MEMORY_USAGE = 0xC800000;
    private static final int DEFAULT_TRUNCATION_JOB_RUN_INTERVAL = 15;
    private static final int DEFAULT_MINUTES_TO_KEEP = 60;
    private static final int DEFAULT_BACKING_FILE_SIZE = Integer.MAX_VALUE;
    private static final int DEFAULT_MAX_HCD_TO_KEEP = 5;
    protected static Preferences preferences = null;

    public DataStoragePreferenceHelper() {
        preferences = this.instantiatePreferences();
        if (preferences.getInt(TRUNCATION_JOB_RUN_INTERVAL, -1) == -1) {
            this.initializeDefaultPreferences();
        }
    }

    protected Preferences instantiatePreferences() {
        return MarshallingPreferenceInitalizer.getInstance().getPreferences();
    }

    public int getMaxMemoryUse() {
        return preferences.getInt(MAX_MEMORY_USAGE, 0xC800000);
    }

    public boolean useMaxMemoryLimit() {
        return preferences.getBoolean(USE_MEMORY_SIZE_LIMIT, false);
    }

    public int getMaxMemoryPercentage() {
        return preferences.getInt(MAX_MEMORY_PERCENTAGE, 80);
    }

    public int getTruncationJobRunInterval() {
        return preferences.getInt(TRUNCATION_JOB_RUN_INTERVAL, 15);
    }

    public int getMinutesToKeep() {
        return preferences.getInt(MINUTES_TO_KEEP, 60);
    }

    public boolean getUseSlidingWindowTruncation() {
        return preferences.getBoolean(USE_SLIDING_WINDOW, false);
    }

    public boolean useBackingFiles() {
        return preferences.getBoolean(USE_BACKING_FILE, true);
    }

    public int getBackingFileSize() {
        return preferences.getInt(SIZE_OF_BACKING_FILE, Integer.MAX_VALUE);
    }

    public int getMaxHCD() {
        return preferences.getInt(MAX_HCD_TO_KEEP, 5);
    }

    public static void initializeDefaults(Preferences preferences) {
        preferences.putInt(TRUNCATION_JOB_RUN_INTERVAL, 15);
        preferences.putInt(MINUTES_TO_KEEP, 60);
        preferences.putBoolean(USE_SLIDING_WINDOW, false);
        preferences.putInt(SIZE_OF_BACKING_FILE, Integer.MAX_VALUE);
        preferences.putBoolean(USE_BACKING_FILE, true);
        preferences.putInt(MAX_HCD_TO_KEEP, 5);
        preferences.putInt(MAX_MEMORY_PERCENTAGE, 80);
        preferences.putInt(MAX_MEMORY_USAGE, 0xC800000);
        preferences.putBoolean(USE_MEMORY_SIZE_LIMIT, false);
    }

    @Override
    public void initializeDefaultPreferences() {
        preferences.putInt(TRUNCATION_JOB_RUN_INTERVAL, 15);
        preferences.putInt(MINUTES_TO_KEEP, 60);
        preferences.putBoolean(USE_SLIDING_WINDOW, false);
        preferences.putInt(SIZE_OF_BACKING_FILE, Integer.MAX_VALUE);
        preferences.putBoolean(USE_BACKING_FILE, true);
        preferences.putInt(MAX_HCD_TO_KEEP, 5);
        preferences.putInt(MAX_MEMORY_PERCENTAGE, 80);
        preferences.putInt(MAX_MEMORY_USAGE, 0xC800000);
        preferences.putBoolean(USE_MEMORY_SIZE_LIMIT, false);
    }
}

