/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.marshalling;

import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterMBean;
import com.ibm.java.diagnostics.healthcenter.connection.ConnectionType;
import com.ibm.java.diagnostics.healthcenter.impl.jmx.JMXAgentConnection;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.StatusManager;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.connection.ConnectionDataImpl;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.source.JmxSourceImpl;
import com.ibm.java.diagnostics.healthcenter.marshalling.Marshaller;
import com.ibm.java.diagnostics.healthcenter.marshalling.util.Messages;
import com.ibm.java.diagnostics.healthcenter.sources.Source;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;

public class JMXConnectionDataImpl
extends ConnectionDataImpl {
    private final JMXAgentConnection agentConnection;

    public JMXConnectionDataImpl(JMXAgentConnection jMXAgentConnection) {
        super(jMXAgentConnection.getDescription());
        this.agentConnection = jMXAgentConnection;
    }

    @Override
    public boolean spawnSources(Marshaller marshaller) {
        boolean bl;
        this.isConnectionAlive = bl = this.agentConnection.startSession();
        this.hasToldAboutConnection = false;
        if (bl) {
            Object object;
            HealthCenterMBean healthCenterMBean = this.agentConnection.getProxy();
            List<Map<String, String>> list = healthCenterMBean.getLiveSourceDetails();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    object = new JmxSourceImpl(healthCenterMBean, i, this.agentConnection.getSessionId(), this, list, marshaller);
                    marshaller.addSource((Source)object);
                    marshaller.addSource(((JmxSourceImpl)object).spawnConfigurationSource());
                }
            }
            String string = Messages.getString("AgentConnection.connected.to");
            object = MessageFormat.format(string, this.getDetails());
            StatusManager.setSources((String)object);
        } else {
            String string = Messages.getString("AgentConnection.connection.failed");
            String string2 = MessageFormat.format(string, this.getDetails());
            StatusManager.setSources(string2);
        }
        return bl;
    }

    @Override
    public ConnectionType getConnectionType() {
        return ConnectionType.JMX;
    }

    public JMXAgentConnection getAgentConnection() {
        return this.agentConnection;
    }

    @Override
    public void destroyConnection() {
    }
}

