/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.marshalling;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.AgentInfo;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterMBean;
import com.ibm.java.diagnostics.healthcenter.impl.jmx.JMXAgentConnection;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.JMXConnectionDataImpl;
import java.lang.reflect.UndeclaredThrowableException;

public class MarshallerUtil {
    private static MarshallerUtil marshallerUtilInstance = null;
    private boolean haveConnectionProxy = false;
    private static HealthCenterMBean proxy = null;

    public static synchronized MarshallerUtil getMarshallerUtil() {
        if (marshallerUtilInstance == null) {
            marshallerUtilInstance = new MarshallerUtil();
        }
        return marshallerUtilInstance;
    }

    private HealthCenterMBean getProxy(DataBuilder dataBuilder) {
        if (this.haveConnectionProxy) {
            return proxy;
        }
        DataBuilder dataBuilder2 = dataBuilder.findRootData();
        Data data = dataBuilder2.getData(JVMLabels.CONNECTION);
        if (data instanceof JMXConnectionDataImpl) {
            JMXConnectionDataImpl jMXConnectionDataImpl = (JMXConnectionDataImpl)data;
            JMXAgentConnection jMXAgentConnection = jMXConnectionDataImpl.getAgentConnection();
            proxy = jMXAgentConnection.getProxy();
        }
        return proxy;
    }

    public AgentInfo getAgentInfo(DataBuilder dataBuilder) {
        HealthCenterMBean healthCenterMBean = this.getProxy(dataBuilder);
        try {
            if (healthCenterMBean != null) {
                return healthCenterMBean.getAgentInfo();
            }
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            // empty catch block
        }
        return null;
    }
}

