/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.marshalling.source;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NameAnalyser {
    private static final Random RANDOM = new Random();
    private static final String FILE = "file";
    private static final int UNSET = 0;
    private static final Pattern STRING_WITH_NUMBERS = Pattern.compile("(.*/)?([^\\.-]*)([0-9])[^/]");
    private static final Pattern STRING = Pattern.compile("(.*/)?([^\\.-]*)");
    private static final Pattern NUMBERS = Pattern.compile("(.*/)?(..*[^0-9])([0-9][0-9]*)");
    private static final Pattern NUMBERS_PRECEDED_BY_HYPHEN = Pattern.compile("(.*/)?(..*[^0-9])-([0-9][0-9]*)");
    private static final Pattern BASENAME = Pattern.compile("(.*)\\.");
    private static Map<String, String> variants = new HashMap<String, String>();

    public static void resetClashDetection() {
        variants = new HashMap<String, String>();
    }

    public static String getVariantIdentifier(String string) {
        String string2 = FILE;
        try {
            Matcher matcher = NUMBERS_PRECEDED_BY_HYPHEN.matcher(string);
            boolean bl = matcher.find();
            if (bl) {
                string2 = matcher.group(2);
            } else {
                matcher = STRING_WITH_NUMBERS.matcher(string);
                bl = matcher.find();
                if (bl) {
                    string2 = matcher.group(2);
                } else {
                    matcher = STRING.matcher(string);
                    bl = matcher.find();
                    if (bl) {
                        string2 = matcher.group(2);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            string2 = FILE;
        }
        string2 = NameAnalyser.disambiguateVariantName(string, string2);
        return string2;
    }

    private static String disambiguateVariantName(String string, String string2) {
        Matcher matcher = BASENAME.matcher(string);
        String string3 = matcher.find() ? matcher.group(1) : string;
        if (variants.containsKey(string2)) {
            int n;
            int n2;
            String string4 = variants.get(string2);
            if (!string3.equals(string4) && (n2 = NameAnalyser.getRunIdentifier(string3)) == (n = NameAnalyser.getRunIdentifier(string4))) {
                string2 = string2 + RANDOM.nextInt();
                variants.put(string2, string3);
            }
        } else {
            variants.put(string2, string3);
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getRunIdentifier(String string) {
        Matcher matcher = NUMBERS_PRECEDED_BY_HYPHEN.matcher(string);
        boolean bl = matcher.find();
        try {
            if (bl) {
                String string2 = matcher.group(3);
                return Integer.parseInt(string2);
            }
            matcher = NUMBERS.matcher(string);
            bl = matcher.find();
            if (bl) {
                String string3 = matcher.group(3);
                return Integer.parseInt(string3);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        finally {
            return 0;
        }
    }
}

