/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.marshalling.source;

import com.ibm.java.diagnostics.healthcenter.connection.ConnectionDataBuilder;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.source.SourceImpl;
import com.ibm.java.diagnostics.healthcenter.marshalling.util.Messages;
import com.ibm.java.diagnostics.healthcenter.sources.SourceListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipEntrySourceImpl
extends SourceImpl {
    private ZipEntry zipentry;
    private ZipFile zipFile;
    private boolean hasSizeBeenRegistered;

    public ZipEntrySourceImpl(ZipEntry zipEntry, File file, ConnectionDataBuilder connectionDataBuilder) {
        super(zipEntry.getName(), connectionDataBuilder);
        try {
            this.zipFile = new ZipFile(file);
        }
        catch (IOException iOException) {
            String string = Messages.getString("ZipFileSourceImpl.error.creating.temp.file");
            String string2 = MessageFormat.format(string, zipEntry.getName(), file.getName());
            this.tellConnectionAboutError(string2, string2, iOException);
        }
        this.zipentry = zipEntry;
    }

    @Override
    protected void tellNewSlicerAboutExistingData(SourceListener sourceListener) {
        InputStream inputStream = this.getBackingStream();
        sourceListener.notifySourceChanged(inputStream);
    }

    @Override
    public InputStream getBackingStream() {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(this.zipFile.getInputStream(this.zipentry));
            if (!this.hasSizeBeenRegistered) {
                this.hasSizeBeenRegistered = true;
                this.tellConnectionAboutDataReceived(bufferedInputStream.available());
            }
        }
        catch (IOException iOException) {
            String string = MessageFormat.format("An exception occurred reading from the zip file: {0}", iOException);
            this.tellConnectionAboutError(string, string, iOException);
        }
        return bufferedInputStream;
    }
}

