/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.memory.postprocessor;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.StructuredStringDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.axes.AxisPair;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.NumberFormatter;
import com.ibm.java.diagnostics.common.datamodel.impl.data.StructuredStringDataImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.data.TwoDimensionalDataImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.postprocessing.PostProcessor;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.environment.EnvironmentData;
import com.ibm.java.diagnostics.healthcenter.environment.data.EnvironmentDataImpl;
import com.ibm.java.diagnostics.healthcenter.environment.labels.EnvironmentLabels;
import com.ibm.java.diagnostics.healthcenter.gc.parser.constants.GCAxes;
import com.ibm.java.diagnostics.healthcenter.gc.parser.constants.GCLabels;
import com.ibm.java.diagnostics.healthcenter.memory.MemoryLabels;
import com.ibm.java.diagnostics.healthcenter.memory.Messages;
import com.ibm.java.diagnostics.healthcenter.memory.postprocessor.LookForNativeLeaks;
import com.ibm.java.diagnostics.healthcenter.postprocessor.PostProcessorBase;
import com.ibm.java.diagnostics.healthcenter.postprocessor.VMLevelChecker;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MemoryAnalyserPostProcessor
extends PostProcessorBase
implements PostProcessor {
    private static final Logger TRACE = LogFactory.getTrace(MemoryAnalyserPostProcessor.class);
    private static final String CLASS_NAME = MemoryAnalyserPostProcessor.class.getName();
    private static final Pattern AGENT_VERSION_REGEX = Pattern.compile("(\\d+)\\.(\\d+).(\\d+).(\\d+)");
    String label = null;
    String units = null;
    double value = 0.0;

    @Override
    public void postprocess(DataBuilder dataBuilder, OutputProperties outputProperties) {
        TRACE.entering(CLASS_NAME, "postprocess");
        SubsystemDataBuilder subsystemDataBuilder = (SubsystemDataBuilder)dataBuilder.getTopLevelData(JVMLabels.MEMORY);
        if (subsystemDataBuilder != null) {
            subsystemDataBuilder.clearValue();
            subsystemDataBuilder.removeData(MemoryLabels.RECOMMENDATION_LABEL);
            StructuredStringDataImpl structuredStringDataImpl = new StructuredStringDataImpl(MemoryLabels.RECOMMENDATION_LABEL);
            subsystemDataBuilder.addData(structuredStringDataImpl);
            TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(dataBuilder, MemoryLabels.VIRTUAL_MEMORY_SIZE);
            if (twoDimensionalDataBuilder == null || twoDimensionalDataBuilder.getMaxY() == null || twoDimensionalDataBuilder.getMaxY().getRawY() < 0.0) {
                structuredStringDataImpl.addInformation(Messages.getString("Memory.advice"));
                subsystemDataBuilder.addValue(Messages.getString("Memory.advice"));
            } else {
                try {
                    long l = this.getMaxHeapSize(dataBuilder);
                    TwoDimensionalDataImpl twoDimensionalDataImpl = (TwoDimensionalDataImpl)this.getTwoDimensionalData(dataBuilder, MemoryLabels.TOTAL_PHYSICAL_MEMORY_SIZE);
                    if (twoDimensionalDataImpl != null && twoDimensionalDataImpl.getLastDataPoint() != null) {
                        long l2 = (long)twoDimensionalDataImpl.getLastDataPoint().getRawY();
                        if (l < 0L) {
                            TRACE.fine(Messages.getString("invalid.max.heap.size"));
                        } else if (l2 < 0L) {
                            TRACE.fine(Messages.getString("invalid.physical.memory.size"));
                        } else if (l > l2) {
                            structuredStringDataImpl.addWarning(Messages.getString("Memory.heap.larger.than.physical"));
                            subsystemDataBuilder.addValue(Messages.getString("Memory.heap.larger.than.physical"));
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.print("NumberFormatException in MemoryAnalyserPostProcessor: " + numberFormatException.getMessage());
                }
                this.fixNormalisationToMatchGC(dataBuilder);
                this.findLargestCounter(structuredStringDataImpl, dataBuilder);
                LookForNativeLeaks lookForNativeLeaks = new LookForNativeLeaks();
                lookForNativeLeaks.recommend(dataBuilder, structuredStringDataImpl);
                this.checkForVMLevelNativeCounter(structuredStringDataImpl, dataBuilder);
                this.isAppropriateAgentLevel(structuredStringDataImpl, dataBuilder);
                if (this.hasNoRecommendation(structuredStringDataImpl)) {
                    structuredStringDataImpl.addGoodThing(Messages.getString("Memory.no.problem.detected"));
                }
                this.setHighLevelMessage(subsystemDataBuilder, structuredStringDataImpl);
            }
        }
        TRACE.exiting(CLASS_NAME, "postprocess");
    }

    private synchronized void findLargestCounter(StructuredStringDataBuilder structuredStringDataBuilder, DataBuilder dataBuilder) {
        Data[] dataArray;
        Data data;
        this.label = null;
        this.value = 0.0;
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(JVMLabels.MEMORY);
        if (dataBuilder2 != null && (data = dataBuilder2.getData(MemoryLabels.BYTES_SHALLOW_LABEL)) != null && (dataArray = data.getChildren()) != null) {
            for (Data data2 : dataArray) {
                TwoDimensionalDataImpl twoDimensionalDataImpl;
                if (!(data2 instanceof TwoDimensionalDataImpl) || (twoDimensionalDataImpl = (TwoDimensionalDataImpl)data2) == null || twoDimensionalDataImpl.getLastDataPoint() == null || twoDimensionalDataImpl.getLabel() == null) continue;
                if (this.value < twoDimensionalDataImpl.getLastDataPoint().getY() && !twoDimensionalDataImpl.getLabel().equals("Java Heap")) {
                    this.label = twoDimensionalDataImpl.getLabel();
                    this.value = twoDimensionalDataImpl.getLastDataPoint().getY();
                    this.units = twoDimensionalDataImpl.getYAxis().getUnits();
                }
                if (!twoDimensionalDataImpl.hasChildren()) continue;
                this.findChildren(twoDimensionalDataImpl);
            }
            if (this.label != null) {
                structuredStringDataBuilder.addInformation(MessageFormat.format(Messages.getString("MemoryCounters.largest.counter"), this.label, NumberFormatter.prettyString(this.value) + " " + this.units));
            }
        }
    }

    private synchronized void findChildren(TwoDimensionalDataImpl twoDimensionalDataImpl) {
        DataBuilder[] dataBuilderArray = twoDimensionalDataImpl.getChildren();
        if (dataBuilderArray != null) {
            for (DataBuilder dataBuilder : dataBuilderArray) {
                TwoDimensionalDataImpl twoDimensionalDataImpl2;
                if (!(dataBuilder instanceof TwoDimensionalDataImpl) || (twoDimensionalDataImpl2 = (TwoDimensionalDataImpl)dataBuilder).getLastDataPoint() == null || twoDimensionalDataImpl2.getLabel() == null) continue;
                if (this.value < twoDimensionalDataImpl2.getLastDataPoint().getY() && !twoDimensionalDataImpl2.getLabel().equals("Java Heap")) {
                    this.value = twoDimensionalDataImpl2.getLastDataPoint().getY();
                    this.label = twoDimensionalDataImpl2.getLabel();
                    this.units = twoDimensionalDataImpl.getYAxis().getUnits();
                }
                if (!twoDimensionalDataImpl2.hasChildren()) continue;
                this.findChildren(twoDimensionalDataImpl2);
            }
        }
    }

    private void checkForVMLevelNativeCounter(StructuredStringDataBuilder structuredStringDataBuilder, DataBuilder dataBuilder) {
        double d;
        EnvironmentData environmentData;
        VMLevelChecker vMLevelChecker;
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(EnvironmentLabels.ENVIRONMENT_LABEL);
        String string = null;
        if (dataBuilder2 instanceof EnvironmentData && (vMLevelChecker = (environmentData = (EnvironmentData)((Object)dataBuilder2)).getVMLevelChecker()) != null && (d = Double.parseDouble(string = vMLevelChecker.getVMVersion())) < 2.6) {
            structuredStringDataBuilder.addInformation(Messages.getString("MemoryCounters.unavailable"));
        }
    }

    private void isAppropriateAgentLevel(StructuredStringDataBuilder structuredStringDataBuilder, DataBuilder dataBuilder) {
        String string;
        Matcher matcher;
        EnvironmentData environmentData = (EnvironmentData)((Object)dataBuilder.getTopLevelData(EnvironmentLabels.ENVIRONMENT_LABEL));
        if (environmentData != null && (matcher = AGENT_VERSION_REGEX.matcher(string = environmentData.getAgentVersion())).matches() && matcher.groupCount() == 4) {
            int n = -1;
            try {
                n = Integer.valueOf(matcher.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                TRACE.log(Level.WARNING, numberFormatException.getLocalizedMessage(), numberFormatException);
            }
            if (n < 2) {
                structuredStringDataBuilder.addInformation(Messages.getString("MemoryCounters.unavailable.old.agent"));
            }
        }
    }

    private void fixNormalisationToMatchGC(DataBuilder dataBuilder) {
        SubsystemDataBuilder subsystemDataBuilder = (SubsystemDataBuilder)dataBuilder.getTopLevelData(JVMLabels.MEMORY);
        SubsystemDataBuilder subsystemDataBuilder2 = (SubsystemDataBuilder)dataBuilder.getTopLevelData(JVMLabels.GARBAGE_COLLECTION);
        if (subsystemDataBuilder != null && subsystemDataBuilder2 != null) {
            TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(dataBuilder, MemoryLabels.VIRTUAL_MEMORY_SIZE);
            TwoDimensionalDataBuilder twoDimensionalDataBuilder2 = (TwoDimensionalDataBuilder)subsystemDataBuilder2.getData(GCLabels.FLAT_HEAP_SIZE);
            if (twoDimensionalDataBuilder != null && twoDimensionalDataBuilder2 != null && twoDimensionalDataBuilder2.getMinX() != null) {
                double d = twoDimensionalDataBuilder2.getMinX().getX(GCAxes.DATE);
                AxisPair axisPair = twoDimensionalDataBuilder.getAxisPair();
                axisPair.getXAxis().updateNormalisation(d);
            }
        }
    }

    private TwoDimensionalDataBuilder getTwoDimensionalData(Data data, String string) {
        Data data2 = data.getData(string);
        if (data2 instanceof TwoDimensionalDataBuilder) {
            return (TwoDimensionalDataBuilder)data2;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long getMaxHeapSize(DataBuilder dataBuilder) throws NumberFormatException {
        int n;
        String string = "-Xmx";
        long l = -1L;
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(EnvironmentLabels.ENVIRONMENT_LABEL);
        if (!(dataBuilder2 instanceof EnvironmentDataImpl)) return l;
        String string2 = ((EnvironmentDataImpl)dataBuilder2).getJavaParameter(string);
        int n2 = -1;
        int n3 = -1;
        if (string2 == null) {
            return -1L;
        }
        string2 = string2.trim();
        for (n = 1; n < string2.length(); ++n) {
            if (!Character.isDigit(string2.charAt(n))) continue;
            n2 = n;
            break;
        }
        if (n2 == -1) {
            return -1L;
        }
        for (n = n2; n < string2.length(); ++n) {
            if (!Character.isDigit(string2.charAt(n))) {
                n3 = n;
            }
            if (n3 != -1) continue;
            n3 = string2.length();
        }
        long l2 = Long.parseLong(string2.substring(n2, n3));
        if (n3 == string2.length()) {
            return l2;
        }
        if (n3 != string2.length() - 1) return -1L;
        char c = string2.charAt(n3);
        if (c == 'm') return l2 * 1024L * 1024L;
        if (c == 'M') {
            return l2 * 1024L * 1024L;
        }
        if (c == 'k') return l2 * 1024L;
        if (c != 'K') return -1L;
        return l2 * 1024L;
    }
}

