/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.methodprofiling.parser.nodejs;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.impl.data.Method;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.MarshallerImpl;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.impl.Messages;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.impl.TraceParser;
import com.ibm.java.diagnostics.healthcenter.marshalling.data.events.ProfilingInternalObject;
import com.ibm.java.diagnostics.healthcenter.methodprofiling.MethodTree;
import com.ibm.java.diagnostics.healthcenter.methodprofiling.ProfilingDataImpl;
import com.ibm.java.diagnostics.healthcenter.methodprofiling.ProfilingLabels;
import com.ibm.java.diagnostics.healthcenter.methodprofiling.parser.nodejs.CSVParser;
import com.ibm.java.diagnostics.healthcenter.methodprofiling.parser.nodejs.JSMethod;
import com.ibm.java.diagnostics.healthcenter.sources.DynamicSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NodeProfilingParser
extends CSVParser {
    public static final String EYECATCHER = "NodeProfData";
    public static final String TYPE_START = "Start";
    public static final String TYPE_NODE = "Node";
    public static final String TYPE_END = "End";
    private static final Logger TRACE = LogFactory.getTrace(NodeProfilingParser.class);
    private final String CLASSNAME = TraceParser.class.getName();
    private static final String BAD_DATA_PROVIDED = Messages.getString("GCDataCSVParser.bad.data");
    private boolean seenGoodEyecatcher;
    private Map<String, JSMethod> methodDictionary = new HashMap<String, JSMethod>();
    private int nextMethodId = 1;
    private Profile currentProfile;
    OutputProperties props;

    @Override
    protected void prepare(DynamicSource dynamicSource, OutputProperties outputProperties) {
        this.seenGoodEyecatcher = false;
        this.props = outputProperties;
    }

    private int extractStack(MNode mNode, List<Method> list) {
        if (mNode.samples > 0) {
            int n = mNode.samples;
            mNode.samples = 0;
            list.add(mNode.method);
            return n;
        }
        list.add(mNode.method);
        for (MNode mNode2 : mNode.children) {
            int n;
            if (mNode2.dead || (n = this.extractStack(mNode2, list)) <= 0) continue;
            return n;
        }
        mNode.dead = true;
        list.remove(list.size() - 1);
        return 0;
    }

    private SubsystemDataBuilder createProfilingData(OutputProperties outputProperties) {
        ProfilingDataImpl profilingDataImpl = new ProfilingDataImpl();
        MethodTree methodTree = new MethodTree(outputProperties, null);
        profilingDataImpl.addData(methodTree);
        return profilingDataImpl;
    }

    private SubsystemDataBuilder getProfilingData(DataBuilder dataBuilder, OutputProperties outputProperties) {
        SubsystemDataBuilder subsystemDataBuilder;
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(ProfilingLabels.DATA_LABEL);
        if (dataBuilder2 instanceof ProfilingDataImpl) {
            subsystemDataBuilder = (ProfilingDataImpl)dataBuilder2;
        } else {
            subsystemDataBuilder = this.createProfilingData(outputProperties);
            dataBuilder.addData(subsystemDataBuilder);
        }
        return subsystemDataBuilder;
    }

    private void handleStart(double d) {
        this.currentProfile = new Profile();
        this.currentProfile.timestamp = d;
    }

    private void handleNode(int n, int n2, String string, String string2, int n3, int n4) {
        JSMethod jSMethod;
        String string3 = string + " " + string2 + " " + n3;
        if (!this.methodDictionary.containsKey(string3)) {
            jSMethod = new JSMethod(this.nextMethodId++, string, string2, n3);
            this.methodDictionary.put(string3, jSMethod);
        }
        jSMethod = this.methodDictionary.get(string3);
        assert (jSMethod != null);
        MNode mNode = new MNode(jSMethod, n, this.currentProfile.nodes.get(n2), n4);
        if (this.currentProfile.root == null) {
            assert (mNode.parent == null);
            this.currentProfile.root = mNode;
        } else {
            assert (mNode.parent != null);
            mNode.parent.children.add(mNode);
        }
        this.currentProfile.nodes.put(mNode.id, mNode);
    }

    private boolean isValid(Profile profile) {
        return profile != null && profile.timestamp != 0.0 && profile.root != null && profile.nodes.size() != 0;
    }

    private void handleEnd(DataBuilder dataBuilder) {
        int n;
        if (!this.isValid(this.currentProfile)) {
            System.err.println("Bad profile");
            return;
        }
        MethodTree methodTree = (MethodTree)this.getProfilingData(dataBuilder, this.props).getData(ProfilingLabels.PROFILE_DATA);
        ArrayList<Method> arrayList = new ArrayList<Method>();
        if (arrayList.size() > 0) {
            Method[] methodArray = arrayList.toArray(new Method[arrayList.size()]);
            ProfilingInternalObject profilingInternalObject = new ProfilingInternalObject((long)this.currentProfile.timestamp, methodArray[0]);
            profilingInternalObject.setCallStack(methodArray);
            MarshallerImpl.getMarshaller().getProfilingEventHandler().addEvent(profilingInternalObject);
        }
        while ((n = this.extractStack(this.currentProfile.root, arrayList)) > 0) {
            if ("(root)".equals(((Method)arrayList.get(0)).getName())) {
                arrayList.remove(0);
            }
            Collections.reverse(arrayList);
            if (!MarshallerImpl.getMarshaller().isEventOnlyMode()) {
                for (int i = 0; i < n; ++i) {
                    methodTree.addCallStack(arrayList, this.currentProfile.timestamp);
                }
            }
            arrayList.clear();
        }
        this.currentProfile = null;
    }

    @Override
    protected boolean handleData(DataBuilder dataBuilder, String[] stringArray) {
        if (EYECATCHER.equals(stringArray[CommonColumns.EYECATCHER.ordinal()])) {
            this.seenGoodEyecatcher = true;
            if (TYPE_START.equals(stringArray[CommonColumns.TYPE.ordinal()]) && stringArray.length == StartColumns.values().length) {
                try {
                    double d = new Double(stringArray[StartColumns.TIME.ordinal()]);
                    this.handleStart(d);
                }
                catch (NumberFormatException numberFormatException) {
                    TRACE.logp(Level.WARNING, this.CLASSNAME, "parse", BAD_DATA_PROVIDED, numberFormatException);
                }
            } else if (TYPE_NODE.equals(stringArray[CommonColumns.TYPE.ordinal()]) && stringArray.length == NodeColumns.values().length) {
                try {
                    int n = Integer.parseInt(stringArray[NodeColumns.METHOD_ID.ordinal()]);
                    int n2 = Integer.parseInt(stringArray[NodeColumns.PARENT_ID.ordinal()]);
                    String string = stringArray[NodeColumns.SCRIPT.ordinal()];
                    String string2 = stringArray[NodeColumns.FUNCTION.ordinal()];
                    int n3 = Integer.parseInt(stringArray[NodeColumns.LINE.ordinal()]);
                    int n4 = Integer.parseInt(stringArray[NodeColumns.SELF_SAMPLES.ordinal()]);
                    this.handleNode(n, n2, string, string2, n3, n4);
                }
                catch (NumberFormatException numberFormatException) {
                    TRACE.logp(Level.WARNING, this.CLASSNAME, "parse", BAD_DATA_PROVIDED, numberFormatException);
                }
            } else if (TYPE_END.equals(stringArray[CommonColumns.TYPE.ordinal()]) && stringArray.length == EndColumns.values().length) {
                this.handleEnd(dataBuilder);
            }
        }
        return this.seenGoodEyecatcher;
    }

    class MNode {
        public JSMethod method;
        public int id;
        public MNode parent;
        public List<MNode> children;
        public int samples;
        public boolean dead;

        public MNode(JSMethod jSMethod, int n, MNode mNode, int n2) {
            this.method = jSMethod;
            this.id = n;
            this.parent = mNode;
            this.samples = n2;
            this.children = new ArrayList<MNode>();
            this.dead = false;
        }
    }

    private static class Profile {
        public Map<Integer, MNode> nodes = new HashMap<Integer, MNode>();
        public MNode root;
        public double timestamp;

        private Profile() {
        }
    }

    public static enum EndColumns {
        EYECATCHER,
        TYPE;

    }

    public static enum NodeColumns {
        EYECATCHER,
        TYPE,
        METHOD_ID,
        PARENT_ID,
        SCRIPT,
        FUNCTION,
        LINE,
        SELF_SAMPLES;

    }

    public static enum StartColumns {
        EYECATCHER,
        TYPE,
        TIME;

    }

    public static enum CommonColumns {
        EYECATCHER,
        TYPE;

    }
}

