/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.io;

import com.ibm.rmi.iiop.EncoderInputStream;
import com.ibm.rmi.iiop.EncoderOutputStream;
import com.ibm.rmi.io.ObjectSerializer;
import com.ibm.rmi.io.ObjectStreamClass;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.omg.CORBA.NO_IMPLEMENT;

public final class GregorianCalendarSerializer
extends ObjectSerializer {
    private static final GregorianCalendarSerializer instance = new GregorianCalendarSerializer();

    private GregorianCalendarSerializer() {
        this.vTag = (byte)75;
    }

    public static GregorianCalendarSerializer getInstance() {
        return instance;
    }

    @Override
    public Object write(EncoderOutputStream encoderOutputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        GregorianCalendar gregorianCalendar = (GregorianCalendar)object;
        long l = gregorianCalendar.getTimeInMillis();
        encoderOutputStream.write_longlongInVarint(l);
        boolean bl = gregorianCalendar.isLenient();
        encoderOutputStream.write_boolean(bl);
        int n = gregorianCalendar.getFirstDayOfWeek();
        encoderOutputStream.write_longInVarint(n);
        int n2 = gregorianCalendar.getMinimalDaysInFirstWeek();
        encoderOutputStream.write_longInVarint(n2);
        TimeZone timeZone = gregorianCalendar.getTimeZone();
        Class<?> clazz = timeZone.getClass();
        if (clazz == SimpleTimeZone.class) {
            encoderOutputStream.write_boolean(false);
            this.writeToLoop(encoderOutputStream, timeZone);
        } else {
            encoderOutputStream.write_boolean(true);
            this.writeTimeZone(encoderOutputStream, timeZone);
        }
        Date date = gregorianCalendar.getGregorianChange();
        this.writeDate(encoderOutputStream, date);
        return null;
    }

    @Override
    public Object read(EncoderInputStream encoderInputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        GregorianCalendar gregorianCalendar = (GregorianCalendar)Calendar.getInstance();
        encoderInputStream.addToValueCache(gregorianCalendar);
        long l = encoderInputStream.read_longlongInVarint();
        boolean bl = encoderInputStream.read_boolean();
        int n = encoderInputStream.read_longInVarint();
        int n2 = encoderInputStream.read_longInVarint();
        boolean bl2 = encoderInputStream.read_boolean();
        TimeZone timeZone = null;
        timeZone = bl2 ? (TimeZone)this.readTimeZone(encoderInputStream) : (TimeZone)this.readFromLoop(encoderInputStream);
        Date date = (Date)this.readDate(encoderInputStream);
        gregorianCalendar.setTimeInMillis(l);
        gregorianCalendar.setLenient(bl);
        gregorianCalendar.setFirstDayOfWeek(n);
        gregorianCalendar.setMinimalDaysInFirstWeek(n2);
        gregorianCalendar.setTimeZone(timeZone);
        gregorianCalendar.setGregorianChange(date);
        return gregorianCalendar;
    }

    @Override
    public Object writeFields(EncoderOutputStream encoderOutputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        throw new NO_IMPLEMENT("Not implemented for " + this.getClass().getName() + "Serializer");
    }

    @Override
    public Object readFields(EncoderInputStream encoderInputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        throw new NO_IMPLEMENT("Not implemented for " + this.getClass().getName() + "Serializer");
    }

    @Override
    public Object writeReferenceFields(EncoderOutputStream encoderOutputStream, Object object, ObjectStreamClass objectStreamClass, int n) {
        throw new NO_IMPLEMENT("Not implemented for " + this.getClass().getName() + "Serializer");
    }

    @Override
    public Object readReferenceFields(EncoderInputStream encoderInputStream, Object object, ObjectStreamClass objectStreamClass, int n) {
        throw new NO_IMPLEMENT("Not implemented for " + this.getClass().getName() + "Serializer");
    }

    @Override
    public Object writeFn(EncoderOutputStream encoderOutputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        throw new NO_IMPLEMENT("Not implemented for " + this.getClass().getName() + "Serializer");
    }

    @Override
    public Object readFn(EncoderInputStream encoderInputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        throw new NO_IMPLEMENT("Not implemented for " + this.getClass().getName() + "Serializer");
    }
}

