/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm;

import com.ibm.jvm.DumpConfigurationUnavailableException;
import com.ibm.jvm.DumpPermission;
import com.ibm.jvm.InvalidDumpOptionException;
import com.ibm.jvm.ToolDumpPermission;
import com.ibm.oti.vm.VM;
import openj9.management.internal.DumpConfigurationUnavailableExceptionBase;
import openj9.management.internal.InvalidDumpOptionExceptionBase;

public class Dump {
    private static final String SystemRequestPrefix = "z/OS".equalsIgnoreCase(System.getProperty("os.name")) ? "system:dsn=" : "system:file=";
    private static final DumpPermission DUMP_PERMISSION = new DumpPermission();
    private static final ToolDumpPermission TOOL_DUMP_PERMISSION = new ToolDumpPermission();
    private static final String LEGACY_DUMP_PERMISSION_PROPERTY = "com.ibm.jvm.enableLegacyDumpSecurity";
    private static final DumpOptionsLock dumpLock = new DumpOptionsLock();

    public static void JavaDump() {
        Dump.checkLegacySecurityPermssion();
        Dump.JavaDumpImpl();
    }

    public static void HeapDump() {
        Dump.checkLegacySecurityPermssion();
        Dump.HeapDumpImpl();
    }

    public static void SystemDump() {
        Dump.checkLegacySecurityPermssion();
        Dump.SystemDumpImpl();
    }

    private Dump() {
    }

    public static void SnapDump() {
        Dump.checkLegacySecurityPermssion();
        Dump.SnapDumpImpl();
    }

    public static String javaDumpToFile(String fileNamePattern) throws InvalidDumpOptionException {
        String request = null;
        if ("".equals(fileNamePattern)) {
            fileNamePattern = null;
        }
        if (fileNamePattern != null) {
            Dump.checkForExtraOptions(fileNamePattern);
            request = "java:file=" + fileNamePattern;
        } else {
            request = "java";
        }
        String dump = null;
        dump = Dump.triggerDump(request, "javaDumpToFile");
        return dump;
    }

    public static String javaDumpToFile() {
        try {
            return Dump.triggerDump("java", "javaDumpToFile");
        }
        catch (InvalidDumpOptionException e) {
            return null;
        }
    }

    public static String heapDumpToFile(String fileNamePattern) throws InvalidDumpOptionException {
        String request = null;
        if ("".equals(fileNamePattern)) {
            fileNamePattern = null;
        }
        if (fileNamePattern != null) {
            Dump.checkForExtraOptions(fileNamePattern);
            request = "heap:file=" + fileNamePattern + ",";
        } else {
            request = "heap:";
        }
        request = request + "opts=PHD";
        String dump = null;
        dump = Dump.triggerDump(request, "heapDumpToFile");
        return dump;
    }

    public static String heapDumpToFile() {
        try {
            return Dump.triggerDump("heap:opts=PHD", "heapDumpToFile");
        }
        catch (InvalidDumpOptionException e) {
            return null;
        }
    }

    public static String systemDumpToFile(String fileNamePattern) throws InvalidDumpOptionException {
        String request = null;
        if ("".equals(fileNamePattern)) {
            fileNamePattern = null;
        }
        if (fileNamePattern != null) {
            Dump.checkForExtraOptions(fileNamePattern);
            request = SystemRequestPrefix + fileNamePattern;
        } else {
            request = "system";
        }
        String dump = null;
        dump = Dump.triggerDump(request, "systemDumpToFile");
        return dump;
    }

    public static String systemDumpToFile() {
        try {
            return Dump.triggerDump("system", "systemDumpToFile");
        }
        catch (InvalidDumpOptionException e) {
            return null;
        }
    }

    public static String snapDumpToFile(String fileNamePattern) throws InvalidDumpOptionException {
        String request = null;
        if ("".equals(fileNamePattern)) {
            fileNamePattern = null;
        }
        if (fileNamePattern != null) {
            Dump.checkForExtraOptions(fileNamePattern);
            request = "snap:file=" + fileNamePattern;
        } else {
            request = "snap";
        }
        String dump = null;
        dump = Dump.triggerDump(request, "snapDumpToFile");
        return dump;
    }

    public static String snapDumpToFile() {
        try {
            return Dump.triggerDump("snap", "snapDumpToFile");
        }
        catch (InvalidDumpOptionException e) {
            return null;
        }
    }

    private static void checkForExtraOptions(String fileNamePattern) throws InvalidDumpOptionException {
        if (fileNamePattern.contains(",")) {
            throw new InvalidDumpOptionException("Invalid dump filename specified.");
        }
    }

    private static void checkDumpSecurityPermssion() throws SecurityException {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(DUMP_PERMISSION);
        }
    }

    private static void checkToolSecurityPermssion() throws SecurityException {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(TOOL_DUMP_PERMISSION);
        }
    }

    private static void checkLegacySecurityPermssion() throws SecurityException {
        if (!"false".equalsIgnoreCase(VM.getVMLangAccess().internalGetProperties().getProperty(LEGACY_DUMP_PERMISSION_PROPERTY))) {
            Dump.checkDumpSecurityPermssion();
        }
    }

    public static String triggerDump(String dumpOptions) throws InvalidDumpOptionException {
        if (dumpOptions == null) {
            throw new NullPointerException();
        }
        if (Dump.isToolDump(dumpOptions)) {
            Dump.checkToolSecurityPermssion();
        }
        return Dump.triggerDump(dumpOptions, "triggerDump");
    }

    private static String triggerDump(String dumpSettings, String event) throws InvalidDumpOptionException {
        Dump.checkDumpSecurityPermssion();
        try {
            return Dump.triggerDumpsImpl(dumpSettings, event);
        }
        catch (InvalidDumpOptionExceptionBase e) {
            throw new InvalidDumpOptionException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDumpOptions(String dumpOptions) throws InvalidDumpOptionException, DumpConfigurationUnavailableException {
        Dump.checkDumpSecurityPermssion();
        if (Dump.isToolDump(dumpOptions)) {
            Dump.checkToolSecurityPermssion();
        }
        if (dumpOptions == null) {
            throw new NullPointerException();
        }
        try {
            DumpOptionsLock dumpOptionsLock = dumpLock;
            synchronized (dumpOptionsLock) {
                Dump.setDumpOptionsImpl(dumpOptions);
            }
        }
        catch (InvalidDumpOptionExceptionBase e) {
            throw new InvalidDumpOptionException(e);
        }
        catch (DumpConfigurationUnavailableExceptionBase e) {
            throw new DumpConfigurationUnavailableException(e);
        }
    }

    public static String[] queryDumpOptions() {
        Dump.checkDumpSecurityPermssion();
        String options = Dump.queryDumpOptionsImpl();
        if (options != null) {
            if ("".equals(options)) {
                String[] empty = new String[]{};
                return empty;
            }
            return options.split("\n");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetDumpOptions() throws DumpConfigurationUnavailableException {
        Dump.checkDumpSecurityPermssion();
        try {
            DumpOptionsLock dumpOptionsLock = dumpLock;
            synchronized (dumpOptionsLock) {
                Dump.resetDumpOptionsImpl();
            }
        }
        catch (DumpConfigurationUnavailableExceptionBase e) {
            throw new DumpConfigurationUnavailableException(e);
        }
    }

    private static native int JavaDumpImpl();

    private static native int HeapDumpImpl();

    private static native int SnapDumpImpl();

    private static native int SystemDumpImpl();

    private static native void setDumpOptionsImpl(String var0) throws InvalidDumpOptionExceptionBase, DumpConfigurationUnavailableExceptionBase;

    private static native String queryDumpOptionsImpl();

    private static native void resetDumpOptionsImpl() throws DumpConfigurationUnavailableExceptionBase;

    private static native String triggerDumpsImpl(String var0, String var1) throws InvalidDumpOptionExceptionBase;

    private static native boolean isToolDump(String var0);

    private static final class DumpOptionsLock {
        DumpOptionsLock() {
        }
    }
}

