/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.jit.JITHelpers;
import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Formatter;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import sun.misc.Unsafe;

public final class String
implements Serializable,
Comparable<String>,
CharSequence {
    private static final long serialVersionUID = -6849794470754667710L;
    static final boolean COMPACT_STRINGS;
    public static final Comparator<String> CASE_INSENSITIVE_ORDER;
    private static final char[] emptyValue;
    private static final char[][] compressedAsciiTable;
    private static final char[][] decompressedAsciiTable;
    private static final JITHelpers helpers;
    private static StringCompressionFlag compressionFlag;
    private static final int uncompressedBit = Integer.MIN_VALUE;
    private static String[] stringArray;
    private static final int stringArraySize = 10;
    static boolean enableSharingInSubstringWhenOffsetIsZero;
    private final char[] value;
    private final int count;
    private int hash;
    private static char[] startCombiningAbove;
    private static char[] endCombiningAbove;
    private static char[] upperValues;
    private static char[] upperIndexs;
    private static final char[] regexMetaChars;
    private static final ObjectStreamField[] serialPersistentFields;

    private void checkLastChar(char lastChar) {
        if (lastChar == '\\') {
            throw new IllegalArgumentException(Msg.getString("K0801"));
        }
        if (lastChar == '$') {
            throw new IllegalArgumentException(Msg.getString("K0802"));
        }
    }

    static void initCompressionFlag() {
        if (compressionFlag == null) {
            compressionFlag = new StringCompressionFlag();
        }
    }

    static boolean canEncodeAsLatin1(char[] c, int start, int length) {
        for (int i = start; i < start + length; ++i) {
            if (c[i] <= '\u00ff') continue;
            return false;
        }
        return true;
    }

    static void compress(byte[] array1, int start1, byte[] array2, int start2, int length) {
        for (int i = 0; i < length; ++i) {
            helpers.putByteInArrayByIndex(array2, start2 + i, (byte)helpers.getCharFromArrayByIndex(array1, start1 + i));
        }
    }

    static void compress(char[] array1, int start1, byte[] array2, int start2, int length) {
        for (int i = 0; i < length; ++i) {
            helpers.putByteInArrayByIndex(array2, start2 + i, (byte)helpers.getCharFromArrayByIndex(array1, start1 + i));
        }
    }

    static void compress(byte[] array1, int start1, char[] array2, int start2, int length) {
        for (int i = 0; i < length; ++i) {
            helpers.putByteInArrayByIndex(array2, start2 + i, (byte)helpers.getCharFromArrayByIndex(array1, start1 + i));
        }
    }

    static void compress(char[] array1, int start1, char[] array2, int start2, int length) {
        for (int i = 0; i < length; ++i) {
            helpers.putByteInArrayByIndex(array2, start2 + i, (byte)helpers.getCharFromArrayByIndex(array1, start1 + i));
        }
    }

    static void decompress(byte[] array1, int start1, byte[] array2, int start2, int length) {
        for (int i = 0; i < length; ++i) {
            helpers.putCharInArrayByIndex(array2, start2 + i, helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(array1, start1 + i)));
        }
    }

    static void decompress(char[] array1, int start1, byte[] array2, int start2, int length) {
        for (int i = 0; i < length; ++i) {
            helpers.putCharInArrayByIndex(array2, start2 + i, helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(array1, start1 + i)));
        }
    }

    static void decompress(byte[] array1, int start1, char[] array2, int start2, int length) {
        for (int i = 0; i < length; ++i) {
            helpers.putCharInArrayByIndex(array2, start2 + i, helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(array1, start1 + i)));
        }
    }

    static void decompress(char[] array1, int start1, char[] array2, int start2, int length) {
        for (int i = 0; i < length; ++i) {
            helpers.putCharInArrayByIndex(array2, start2 + i, helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(array1, start1 + i)));
        }
    }

    static void compressedArrayCopy(byte[] array1, int start1, byte[] array2, int start2, int length) {
        if (array1 == array2 && start1 < start2) {
            for (int i = length - 1; i >= 0; --i) {
                helpers.putByteInArrayByIndex(array2, start2 + i, helpers.getByteFromArrayByIndex(array1, start1 + i));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                helpers.putByteInArrayByIndex(array2, start2 + i, helpers.getByteFromArrayByIndex(array1, start1 + i));
            }
        }
    }

    static void compressedArrayCopy(byte[] array1, int start1, char[] array2, int start2, int length) {
        for (int i = 0; i < length; ++i) {
            helpers.putByteInArrayByIndex(array2, start2 + i, helpers.getByteFromArrayByIndex(array1, start1 + i));
        }
    }

    static void compressedArrayCopy(char[] array1, int start1, byte[] array2, int start2, int length) {
        for (int i = 0; i < length; ++i) {
            helpers.putByteInArrayByIndex(array2, start2 + i, helpers.getByteFromArrayByIndex(array1, start1 + i));
        }
    }

    static void compressedArrayCopy(char[] array1, int start1, char[] array2, int start2, int length) {
        if (array1 == array2 && start1 < start2) {
            for (int i = length - 1; i >= 0; --i) {
                helpers.putByteInArrayByIndex(array2, start2 + i, helpers.getByteFromArrayByIndex(array1, start1 + i));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                helpers.putByteInArrayByIndex(array2, start2 + i, helpers.getByteFromArrayByIndex(array1, start1 + i));
            }
        }
    }

    static void decompressedArrayCopy(char[] array1, int start1, char[] array2, int start2, int length) {
        System.arraycopy((Object)array1, start1, (Object)array2, start2, length);
    }

    boolean isCompressed() {
        return COMPACT_STRINGS && (null == compressionFlag || this.count >= 0);
    }

    public String() {
        this.value = emptyValue;
        this.count = 0;
    }

    public String(byte[] data) {
        this(data, 0, data.length);
    }

    @Deprecated
    public String(byte[] data, int high) {
        this(data, high, 0, data.length);
    }

    public String(byte[] data, int start, int length) {
        data.getClass();
        if (start >= 0 && 0 <= length && length <= data.length - start) {
            char[] buffer = StringCoding.decode((byte[])data, (int)start, (int)length);
            if (COMPACT_STRINGS) {
                if (String.canEncodeAsLatin1(buffer, 0, buffer.length)) {
                    this.value = new char[buffer.length + 1 >>> 1];
                    this.count = buffer.length;
                    String.compress(buffer, 0, this.value, 0, buffer.length);
                } else {
                    this.value = buffer;
                    this.count = buffer.length | Integer.MIN_VALUE;
                    String.initCompressionFlag();
                }
            } else {
                this.value = buffer;
                this.count = buffer.length;
            }
        } else {
            throw new StringIndexOutOfBoundsException();
        }
    }

    @Deprecated
    public String(byte[] data, int high, int start, int length) {
        data.getClass();
        if (start >= 0 && 0 <= length && length <= data.length - start) {
            if (COMPACT_STRINGS) {
                if (high == 0) {
                    this.value = new char[length + 1 >>> 1];
                    this.count = length;
                    String.compressedArrayCopy(data, start, this.value, 0, length);
                } else {
                    this.value = new char[length];
                    this.count = length | Integer.MIN_VALUE;
                    high <<= 8;
                    for (int i = 0; i < length; ++i) {
                        this.value[i] = (char)(high + (data[start++] & 0xFF));
                    }
                    String.initCompressionFlag();
                }
            } else {
                this.value = new char[length];
                this.count = length;
                high <<= 8;
                for (int i = 0; i < length; ++i) {
                    this.value[i] = (char)(high + (data[start++] & 0xFF));
                }
            }
        } else {
            throw new StringIndexOutOfBoundsException();
        }
    }

    public String(byte[] data, int start, int length, String encoding) throws UnsupportedEncodingException {
        encoding.getClass();
        data.getClass();
        if (start >= 0 && 0 <= length && length <= data.length - start) {
            char[] buffer = StringCoding.decode((String)encoding, (byte[])data, (int)start, (int)length);
            if (COMPACT_STRINGS) {
                if (String.canEncodeAsLatin1(buffer, 0, buffer.length)) {
                    this.value = new char[buffer.length + 1 >>> 1];
                    this.count = buffer.length;
                    String.compress(buffer, 0, this.value, 0, buffer.length);
                } else {
                    this.value = buffer;
                    this.count = buffer.length | Integer.MIN_VALUE;
                    String.initCompressionFlag();
                }
            } else {
                this.value = buffer;
                this.count = buffer.length;
            }
        } else {
            throw new StringIndexOutOfBoundsException();
        }
    }

    public String(byte[] data, String encoding) throws UnsupportedEncodingException {
        this(data, 0, data.length, encoding);
    }

    private String(String s, char c) {
        int slen;
        int concatlen;
        if (s == null) {
            s = "null";
        }
        if ((concatlen = (slen = s.lengthInternal()) + 1) < 0) {
            throw new OutOfMemoryError(Msg.getString("K0D01"));
        }
        if (COMPACT_STRINGS) {
            if ((null == compressionFlag || s.count >= 0) && c <= '\u00ff') {
                this.value = new char[concatlen + 1 >>> 1];
                this.count = concatlen;
                String.compressedArrayCopy(s.value, 0, this.value, 0, slen);
                helpers.putByteInArrayByIndex(this.value, slen, (byte)c);
            } else {
                this.value = new char[concatlen];
                this.count = concatlen | Integer.MIN_VALUE;
                if (COMPACT_STRINGS && s.count >= 0) {
                    String.decompress(s.value, 0, this.value, 0, slen);
                } else {
                    String.decompressedArrayCopy(s.value, 0, this.value, 0, slen);
                }
                this.value[slen] = c;
                String.initCompressionFlag();
            }
        } else {
            this.value = new char[concatlen];
            this.count = concatlen;
            System.arraycopy((Object)s.value, 0, (Object)this.value, 0, slen);
            this.value[slen] = c;
        }
    }

    public String(char[] data) {
        this(data, 0, data.length);
    }

    String(char[] data, boolean ignore) {
        if (COMPACT_STRINGS) {
            if (String.canEncodeAsLatin1(data, 0, data.length)) {
                this.value = new char[data.length + 1 >>> 1];
                this.count = data.length;
                String.compress(data, 0, this.value, 0, data.length);
            } else {
                this.value = new char[data.length];
                this.count = data.length | Integer.MIN_VALUE;
                System.arraycopy((Object)data, 0, (Object)this.value, 0, data.length);
                String.initCompressionFlag();
            }
        } else {
            this.value = new char[data.length];
            this.count = data.length;
            System.arraycopy((Object)data, 0, (Object)this.value, 0, data.length);
        }
    }

    public String(char[] data, int start, int length) {
        if (start >= 0 && 0 <= length && length <= data.length - start) {
            if (COMPACT_STRINGS) {
                if (String.canEncodeAsLatin1(data, start, length)) {
                    this.value = new char[length + 1 >>> 1];
                    this.count = length;
                    String.compress(data, start, this.value, 0, length);
                } else {
                    this.value = new char[length];
                    this.count = length | Integer.MIN_VALUE;
                    System.arraycopy((Object)data, start, (Object)this.value, 0, length);
                    String.initCompressionFlag();
                }
            } else {
                this.value = new char[length];
                this.count = length;
                System.arraycopy((Object)data, start, (Object)this.value, 0, length);
            }
        } else {
            throw new StringIndexOutOfBoundsException();
        }
    }

    String(char[] data, int start, int length, boolean compressed) {
        if (COMPACT_STRINGS) {
            if (length == 0) {
                this.value = emptyValue;
                this.count = 0;
            } else if (length == 1) {
                if (compressed) {
                    char theChar = helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(data, start));
                    this.value = compressedAsciiTable[theChar];
                    this.count = 1;
                    this.hash = theChar;
                } else {
                    char theChar = data[start];
                    this.value = theChar <= '\u00ff' ? decompressedAsciiTable[theChar] : new char[]{theChar};
                    this.count = -2147483647;
                    this.hash = theChar;
                    String.initCompressionFlag();
                }
            } else if (compressed) {
                if (start == 0) {
                    this.value = data;
                    this.count = length;
                } else {
                    this.value = new char[length + 1 >>> 1];
                    this.count = length;
                    String.compressedArrayCopy(data, start, this.value, 0, length);
                }
            } else {
                if (start == 0) {
                    this.value = data;
                    this.count = length | Integer.MIN_VALUE;
                } else {
                    this.value = new char[length];
                    this.count = length | Integer.MIN_VALUE;
                    System.arraycopy((Object)data, start, (Object)this.value, 0, length);
                }
                String.initCompressionFlag();
            }
        } else if (length == 0) {
            this.value = emptyValue;
            this.count = 0;
        } else if (length == 1 && data[start] <= '\u00ff') {
            int theChar = data[start];
            this.value = decompressedAsciiTable[theChar];
            this.count = 1;
            this.hash = theChar;
        } else if (start == 0) {
            this.value = data;
            this.count = length;
        } else {
            this.value = new char[length];
            this.count = length;
            System.arraycopy((Object)data, start, (Object)this.value, 0, length);
        }
    }

    String(char[] data, int start, int length, boolean compressed, boolean sharingIsAllowed) {
        if (COMPACT_STRINGS) {
            if (length == 0) {
                this.value = emptyValue;
                this.count = 0;
            } else if (length == 1) {
                if (compressed) {
                    char theChar = helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(data, start));
                    this.value = compressedAsciiTable[theChar];
                    this.count = 1;
                    this.hash = theChar;
                } else {
                    char theChar = data[start];
                    this.value = theChar <= '\u00ff' ? decompressedAsciiTable[theChar] : new char[]{theChar};
                    this.count = -2147483647;
                    this.hash = theChar;
                    String.initCompressionFlag();
                }
            } else if (compressed) {
                if (start == 0 && sharingIsAllowed) {
                    this.value = data;
                    this.count = length;
                } else {
                    this.value = new char[length + 1 >>> 1];
                    this.count = length;
                    String.compressedArrayCopy(data, start, this.value, 0, length);
                }
            } else {
                if (start == 0 && sharingIsAllowed) {
                    this.value = data;
                    this.count = length | Integer.MIN_VALUE;
                } else {
                    this.value = new char[length];
                    this.count = length | Integer.MIN_VALUE;
                    System.arraycopy((Object)data, start, (Object)this.value, 0, length);
                }
                String.initCompressionFlag();
            }
        } else if (length == 0) {
            this.value = emptyValue;
            this.count = 0;
        } else if (length == 1 && data[start] <= '\u00ff') {
            int theChar = data[start];
            this.value = decompressedAsciiTable[theChar];
            this.count = 1;
            this.hash = theChar;
        } else if (start == 0 && sharingIsAllowed) {
            this.value = data;
            this.count = length;
        } else {
            this.value = new char[length];
            this.count = length;
            System.arraycopy((Object)data, start, (Object)this.value, 0, length);
        }
    }

    public String(String string) {
        this.value = string.value;
        this.count = string.count;
        this.hash = string.hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String(StringBuffer buffer) {
        StringBuffer stringBuffer = buffer;
        synchronized (stringBuffer) {
            char[] chars = buffer.shareValue();
            if (COMPACT_STRINGS) {
                if (buffer.isCompressed()) {
                    this.value = chars;
                    this.count = buffer.length();
                } else {
                    this.value = chars;
                    this.count = buffer.length() | Integer.MIN_VALUE;
                    String.initCompressionFlag();
                }
            } else {
                this.value = chars;
                this.count = buffer.length();
            }
        }
    }

    private String(String s1, String s2) {
        int s2len;
        int s1len;
        int concatlen;
        if (s1 == null) {
            s1 = "null";
        }
        if (s2 == null) {
            s2 = "null";
        }
        if ((concatlen = (s1len = s1.lengthInternal()) + (s2len = s2.lengthInternal())) < 0) {
            throw new OutOfMemoryError(Msg.getString("K0D01"));
        }
        if (COMPACT_STRINGS) {
            if (null == compressionFlag || (s1.count | s2.count) >= 0) {
                this.value = new char[concatlen + 1 >>> 1];
                this.count = concatlen;
                String.compressedArrayCopy(s1.value, 0, this.value, 0, s1len);
                String.compressedArrayCopy(s2.value, 0, this.value, s1len, s2len);
            } else {
                this.value = new char[concatlen];
                this.count = concatlen | Integer.MIN_VALUE;
                if (s1.count >= 0) {
                    String.decompress(s1.value, 0, this.value, 0, s1len);
                } else {
                    System.arraycopy((Object)s1.value, 0, (Object)this.value, 0, s1len);
                }
                if (s2.count >= 0) {
                    String.decompress(s2.value, 0, this.value, s1len, s2len);
                } else {
                    System.arraycopy((Object)s2.value, 0, (Object)this.value, s1len, s2len);
                }
                String.initCompressionFlag();
            }
        } else {
            this.value = new char[concatlen];
            this.count = concatlen;
            System.arraycopy((Object)s1.value, 0, (Object)this.value, 0, s1len);
            System.arraycopy((Object)s2.value, 0, (Object)this.value, s1len, s2len);
        }
    }

    private String(String s1, String s2, String s3) {
        int s3len;
        int s2len;
        int s1len;
        long totalLen;
        if (s1 == null) {
            s1 = "null";
        }
        if (s2 == null) {
            s2 = "null";
        }
        if (s3 == null) {
            s3 = "null";
        }
        if ((totalLen = (long)(s1len = s1.lengthInternal()) + (long)(s2len = s2.lengthInternal()) + (long)(s3len = s3.lengthInternal())) > Integer.MAX_VALUE) {
            throw new OutOfMemoryError(Msg.getString("K0D01"));
        }
        int concatlen = (int)totalLen;
        if (COMPACT_STRINGS) {
            if (null == compressionFlag || (s1.count | s2.count | s3.count) >= 0) {
                this.value = new char[concatlen + 1 >>> 1];
                this.count = concatlen;
                String.compressedArrayCopy(s1.value, 0, this.value, 0, s1len);
                String.compressedArrayCopy(s2.value, 0, this.value, s1len, s2len);
                String.compressedArrayCopy(s3.value, 0, this.value, s1len + s2len, s3len);
            } else {
                this.value = new char[concatlen];
                this.count = concatlen | Integer.MIN_VALUE;
                if (s1.count >= 0) {
                    String.decompress(s1.value, 0, this.value, 0, s1len);
                } else {
                    System.arraycopy((Object)s1.value, 0, (Object)this.value, 0, s1len);
                }
                if (s2.count >= 0) {
                    String.decompress(s2.value, 0, this.value, s1len, s2len);
                } else {
                    System.arraycopy((Object)s2.value, 0, (Object)this.value, s1len, s2len);
                }
                if (s3.count >= 0) {
                    String.decompress(s3.value, 0, this.value, s1len + s2len, s3len);
                } else {
                    System.arraycopy((Object)s3.value, 0, (Object)this.value, s1len + s2len, s3len);
                }
                String.initCompressionFlag();
            }
        } else {
            this.value = new char[concatlen];
            this.count = concatlen;
            System.arraycopy((Object)s1.value, 0, (Object)this.value, 0, s1len);
            System.arraycopy((Object)s2.value, 0, (Object)this.value, s1len, s2len);
            System.arraycopy((Object)s3.value, 0, (Object)this.value, s1len + s2len, s3len);
        }
    }

    private String(String s1, int v1) {
        int quot;
        if (s1 == null) {
            s1 = "null";
        }
        int s1len = s1.lengthInternal();
        int v1len = 1;
        int i = v1;
        while ((i /= 10) != 0) {
            ++v1len;
        }
        if (v1 >= 0) {
            quot = -v1;
        } else {
            ++v1len;
            quot = v1;
        }
        int len = s1len + v1len;
        if (len < 0) {
            throw new OutOfMemoryError(Msg.getString("K0D01"));
        }
        if (COMPACT_STRINGS) {
            if (null == compressionFlag || s1.count >= 0) {
                this.value = new char[len + 1 >>> 1];
                this.count = len;
                int index = len - 1;
                do {
                    int res = quot / 10;
                    int rem = quot - res * 10;
                    quot = res;
                    helpers.putByteInArrayByIndex(this.value, index--, (byte)(48 - rem));
                } while (quot != 0);
                if (v1 < 0) {
                    helpers.putByteInArrayByIndex(this.value, index, (byte)45);
                }
                String.compressedArrayCopy(s1.value, 0, this.value, 0, s1len);
            } else {
                this.value = new char[len];
                this.count = len | Integer.MIN_VALUE;
                int index = len - 1;
                do {
                    int res = quot / 10;
                    int rem = quot - res * 10;
                    quot = res;
                    this.value[index--] = (char)(48 - rem);
                } while (quot != 0);
                if (v1 < 0) {
                    this.value[index] = 45;
                }
                System.arraycopy((Object)s1.value, 0, (Object)this.value, 0, s1len);
                String.initCompressionFlag();
            }
        } else {
            this.value = new char[len];
            this.count = len;
            int index = len - 1;
            do {
                int res = quot / 10;
                int rem = quot - res * 10;
                quot = res;
                this.value[index--] = (char)(48 - rem);
            } while (quot != 0);
            if (v1 < 0) {
                this.value[index] = 45;
            }
            System.arraycopy((Object)s1.value, 0, (Object)this.value, 0, s1len);
        }
    }

    private String(int v1, String s1, int v2, String s2, String s3) {
        int quot2;
        int quot1;
        if (s1 == null) {
            s1 = "null";
        }
        if (s2 == null) {
            s2 = "null";
        }
        if (s3 == null) {
            s3 = "null";
        }
        int s1len = s1.lengthInternal();
        int s2len = s2.lengthInternal();
        int s3len = s3.lengthInternal();
        int v1len = 1;
        int v2len = 1;
        int i1 = v1;
        while ((i1 /= 10) != 0) {
            ++v1len;
        }
        if (v1 >= 0) {
            quot1 = -v1;
        } else {
            ++v1len;
            quot1 = v1;
        }
        int i2 = v2;
        while ((i2 /= 10) != 0) {
            ++v2len;
        }
        if (v2 >= 0) {
            quot2 = -v2;
        } else {
            ++v2len;
            quot2 = v2;
        }
        long totalLen = (long)s1len + (long)v1len + (long)v2len + (long)s2len + (long)s3len;
        if (totalLen > Integer.MAX_VALUE) {
            throw new OutOfMemoryError(Msg.getString("K0D01"));
        }
        int len = (int)totalLen;
        if (COMPACT_STRINGS) {
            if (null == compressionFlag || (s1.count | s2.count | s3.count) >= 0) {
                this.value = new char[len + 1 >>> 1];
                this.count = len;
                int start = len;
                String.compressedArrayCopy(s3.value, 0, this.value, start -= s3len, s3len);
                String.compressedArrayCopy(s2.value, 0, this.value, start -= s2len, s2len);
                int index2 = start - 1;
                do {
                    int res = quot2 / 10;
                    int rem = quot2 - res * 10;
                    quot2 = res;
                    helpers.putByteInArrayByIndex(this.value, index2--, (byte)(48 - rem));
                } while (quot2 != 0);
                if (v2 < 0) {
                    helpers.putByteInArrayByIndex(this.value, index2--, (byte)45);
                }
                start = index2 + 1 - s1len;
                String.compressedArrayCopy(s1.value, 0, this.value, start, s1len);
                int index1 = start - 1;
                do {
                    int res = quot1 / 10;
                    int rem = quot1 - res * 10;
                    quot1 = res;
                    helpers.putByteInArrayByIndex(this.value, index1--, (byte)(48 - rem));
                } while (quot1 != 0);
                if (v1 < 0) {
                    helpers.putByteInArrayByIndex(this.value, index1--, (byte)45);
                }
            } else {
                this.value = new char[len];
                this.count = len | Integer.MIN_VALUE;
                int start = len;
                start -= s3len;
                if (s3.count >= 0) {
                    String.decompress(s3.value, 0, this.value, start, s3len);
                } else {
                    System.arraycopy((Object)s3.value, 0, (Object)this.value, start, s3len);
                }
                start -= s2len;
                if (s2.count >= 0) {
                    String.decompress(s2.value, 0, this.value, start, s2len);
                } else {
                    System.arraycopy((Object)s2.value, 0, (Object)this.value, start, s2len);
                }
                int index2 = start - 1;
                do {
                    int res = quot2 / 10;
                    int rem = quot2 - res * 10;
                    quot2 = res;
                    this.value[index2--] = (char)(48 - rem);
                } while (quot2 != 0);
                if (v2 < 0) {
                    this.value[index2--] = 45;
                }
                start = index2 + 1 - s1len;
                if (s1.count >= 0) {
                    String.decompress(s1.value, 0, this.value, start, s1len);
                } else {
                    System.arraycopy((Object)s1.value, 0, (Object)this.value, start, s1len);
                }
                int index1 = start - 1;
                do {
                    int res = quot1 / 10;
                    int rem = quot1 - res * 10;
                    quot1 = res;
                    this.value[index1--] = (char)(48 - rem);
                } while (quot1 != 0);
                if (v1 < 0) {
                    this.value[index1--] = 45;
                }
                String.initCompressionFlag();
            }
        } else {
            this.value = new char[len];
            this.count = len;
            int start = len;
            System.arraycopy((Object)s3.value, 0, (Object)this.value, start -= s3len, s3len);
            System.arraycopy((Object)s2.value, 0, (Object)this.value, start -= s2len, s2len);
            int index2 = start - 1;
            do {
                int res = quot2 / 10;
                int rem = quot2 - res * 10;
                quot2 = res;
                this.value[index2--] = (char)(48 - rem);
            } while (quot2 != 0);
            if (v2 < 0) {
                this.value[index2--] = 45;
            }
            start = index2 + 1 - s1len;
            System.arraycopy((Object)s1.value, 0, (Object)this.value, start, s1len);
            int index1 = start - 1;
            do {
                int res = quot1 / 10;
                int rem = quot1 - res * 10;
                quot1 = res;
                this.value[index1--] = (char)(48 - rem);
            } while (quot1 != 0);
            if (v1 < 0) {
                this.value[index1--] = 45;
            }
        }
    }

    private static String cachedConstantString(String s1, String s2, int index) {
        if (index < 10) {
            if (stringArray[index] == null) {
                String.stringArray[index] = new String(s1, s2);
            }
        } else {
            return new String(s1, s2);
        }
        return stringArray[index];
    }

    @Override
    public char charAt(int index) {
        if (0 <= index && index < this.lengthInternal()) {
            if (COMPACT_STRINGS && (null == compressionFlag || this.count >= 0)) {
                return helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(this.value, index));
            }
            return this.value[index];
        }
        throw new StringIndexOutOfBoundsException();
    }

    char charAtInternal(int index) {
        if (COMPACT_STRINGS && (null == compressionFlag || this.count >= 0)) {
            return helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(this.value, index));
        }
        return this.value[index];
    }

    char charAtInternal(int index, char[] value) {
        if (COMPACT_STRINGS && (null == compressionFlag || this.count >= 0)) {
            return helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(value, index));
        }
        return value[index];
    }

    @Override
    public int compareTo(String string) {
        int s2len;
        String s1 = this;
        String s2 = string;
        int s1len = s1.lengthInternal();
        int end = s1len < (s2len = s2.lengthInternal()) ? s1len : s2len;
        int o1 = 0;
        int o2 = 0;
        char[] s1Value = s1.value;
        char[] s2Value = s2.value;
        if (COMPACT_STRINGS && (null == compressionFlag || (s1.count | s2.count) >= 0)) {
            while (o1 < end) {
                int result;
                if ((result = helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(s1Value, o1++)) - helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(s2Value, o2++))) == 0) continue;
                return result;
            }
        } else {
            while (o1 < end) {
                int result;
                if ((result = s1.charAtInternal(o1++, s1Value) - s2.charAtInternal(o2++, s2Value)) == 0) continue;
                return result;
            }
        }
        return s1len - s2len;
    }

    private static char compareValue(char c) {
        if ('A' <= c && c <= 'Z') {
            return (char)(c + 32);
        }
        return Character.toLowerCase(Character.toUpperCase(c));
    }

    private static char compareValue(byte b) {
        if (65 <= b && b <= 90) {
            return (char)(helpers.byteToCharUnsigned(b) + 32);
        }
        return Character.toLowerCase(Character.toUpperCase(helpers.byteToCharUnsigned(b)));
    }

    private static boolean charValuesEqualIgnoreCase(char c1, char c2) {
        boolean charValuesEqual = false;
        char c1upper = (char)String.toUpperCase(c1);
        char c2upper = (char)String.toUpperCase(c2);
        if ((c1 <= '\u00ff' || c2 <= '\u00ff') && c1upper == c2upper || String.toLowerCase(c1upper) == String.toLowerCase(c2upper)) {
            charValuesEqual = true;
        }
        return charValuesEqual;
    }

    public int compareToIgnoreCase(String string) {
        int s2len;
        String s1 = this;
        String s2 = string;
        int s1len = s1.lengthInternal();
        int end = s1len < (s2len = s2.lengthInternal()) ? s1len : s2len;
        int o1 = 0;
        int o2 = 0;
        char[] s1Value = s1.value;
        char[] s2Value = s2.value;
        if (COMPACT_STRINGS && (null == compressionFlag || (s1.count | s2.count) >= 0)) {
            while (o1 < end) {
                int result;
                byte byteAtO2;
                byte byteAtO1;
                if ((byteAtO1 = helpers.getByteFromArrayByIndex(s1Value, o1++)) == (byteAtO2 = helpers.getByteFromArrayByIndex(s2Value, o2++)) || (result = String.compareValue(byteAtO1) - String.compareValue(byteAtO2)) == 0) continue;
                return result;
            }
        } else {
            while (o1 < end) {
                int result;
                char charAtO2;
                char charAtO1;
                if ((charAtO1 = s1.charAtInternal(o1++, s1Value)) == (charAtO2 = s2.charAtInternal(o2++, s2Value)) || (result = String.compareValue(charAtO1) - String.compareValue(charAtO2)) == 0) continue;
                return result;
            }
        }
        return s1len - s2len;
    }

    public String concat(String string) {
        String s1 = this;
        String s2 = string;
        int s1len = s1.lengthInternal();
        int s2len = s2.lengthInternal();
        if (s2len == 0) {
            return s1;
        }
        int concatlen = s1len + s2len;
        if (concatlen < 0) {
            throw new OutOfMemoryError(Msg.getString("K0D01"));
        }
        if (COMPACT_STRINGS && (null == compressionFlag || (s1.count | s2.count) >= 0)) {
            char[] buffer = new char[concatlen + 1 >>> 1];
            String.compressedArrayCopy(s1.value, 0, buffer, 0, s1len);
            String.compressedArrayCopy(s2.value, 0, buffer, s1len, s2len);
            return new String(buffer, 0, concatlen, true);
        }
        char[] buffer = new char[concatlen];
        if (COMPACT_STRINGS && s1.count >= 0) {
            String.decompress(s1.value, 0, buffer, 0, s1len);
        } else {
            System.arraycopy((Object)s1.value, 0, (Object)buffer, 0, s1len);
        }
        if (COMPACT_STRINGS && s2.count >= 0) {
            String.decompress(s2.value, 0, buffer, s1len, s2len);
        } else {
            System.arraycopy((Object)s2.value, 0, (Object)buffer, s1len, s2len);
        }
        return new String(buffer, 0, concatlen, false);
    }

    public static String copyValueOf(char[] data) {
        return new String(data, 0, data.length);
    }

    public static String copyValueOf(char[] data, int start, int length) {
        return new String(data, start, length);
    }

    public boolean endsWith(String suffix) {
        return this.regionMatches(this.lengthInternal() - suffix.lengthInternal(), suffix, 0, suffix.lengthInternal());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof String) {
            int s2len;
            String s1 = this;
            String s2 = (String)object;
            int s1len = s1.lengthInternal();
            if (s1len != (s2len = s2.lengthInternal())) {
                return false;
            }
            char[] s1Value = s1.value;
            char[] s2Value = s2.value;
            if (s1Value == s2Value) {
                return true;
            }
            int s1hash = s1.hash;
            int s2hash = s2.hash;
            if (s1hash != 0 && s2hash != 0 && s1hash != s2hash) {
                return false;
            }
            if (!String.regionMatchesInternal(s1, s2, s1Value, s2Value, 0, 0, s1len)) {
                return false;
            }
            if (VM.J9_JIT_STRING_DEDUP_POLICY != 0) {
                String.deduplicateStrings(s1, s1Value, s2, s2Value);
            }
            return true;
        }
        return false;
    }

    private static final void deduplicateStrings(String s1, Object value1, String s2, Object value2) {
        if (!COMPACT_STRINGS || null == compressionFlag || (s1.count ^ s2.count) >= 0) {
            long valueFieldOffset = UnsafeHelpers.valueFieldOffset;
            if (VM.J9_JIT_STRING_DEDUP_POLICY == 1) {
                if (helpers.acmplt(value1, value2)) {
                    helpers.putObjectInObject(s2, valueFieldOffset, value1);
                } else {
                    helpers.putObjectInObject(s1, valueFieldOffset, value2);
                }
            } else if (helpers.acmplt(value2, value1)) {
                helpers.putObjectInObject(s2, valueFieldOffset, value1);
            } else {
                helpers.putObjectInObject(s1, valueFieldOffset, value2);
            }
        }
    }

    public boolean equalsIgnoreCase(String string) {
        int s2len;
        String s1 = this;
        String s2 = string;
        if (s1 == s2) {
            return true;
        }
        if (s2 == null) {
            return false;
        }
        int s1len = s1.lengthInternal();
        if (s1len != (s2len = s2.lengthInternal())) {
            return false;
        }
        if (0 == s1len) {
            return true;
        }
        int o1 = 0;
        int o2 = 0;
        int end = s1len;
        char[] s1Value = s1.value;
        char[] s2Value = s2.value;
        if (COMPACT_STRINGS && (null == compressionFlag || (s1.count | s2.count) >= 0)) {
            byte byteAtO2Last;
            byte byteAtO1Last = helpers.getByteFromArrayByIndex(s1Value, s1len - 1);
            if (byteAtO1Last != (byteAtO2Last = helpers.getByteFromArrayByIndex(s2Value, s1len - 1)) && String.toUpperCase(helpers.byteToCharUnsigned(byteAtO1Last)) != String.toUpperCase(helpers.byteToCharUnsigned(byteAtO2Last))) {
                return false;
            }
            while (o1 < end - 1) {
                byte byteAtO2;
                byte byteAtO1;
                if ((byteAtO1 = helpers.getByteFromArrayByIndex(s1Value, o1++)) == (byteAtO2 = helpers.getByteFromArrayByIndex(s2Value, o2++)) || String.toUpperCase(helpers.byteToCharUnsigned(byteAtO1)) == String.toUpperCase(helpers.byteToCharUnsigned(byteAtO2))) continue;
                return false;
            }
        } else {
            char charAtO2Last;
            char charAtO1Last = s1.charAtInternal(s1len - 1, s1Value);
            if (charAtO1Last != (charAtO2Last = s2.charAtInternal(s1len - 1, s2Value)) && !String.charValuesEqualIgnoreCase(charAtO1Last, charAtO2Last)) {
                return false;
            }
            while (o1 < end - 1) {
                char charAtO2;
                char charAtO1;
                if ((charAtO1 = s1.charAtInternal(o1++, s1Value)) == (charAtO2 = s2.charAtInternal(o2++, s2Value)) || String.charValuesEqualIgnoreCase(charAtO1, charAtO2)) continue;
                return false;
            }
        }
        return true;
    }

    public byte[] getBytes() {
        char[] buffer;
        int currentLength = this.lengthInternal();
        if (COMPACT_STRINGS && this.count >= 0) {
            buffer = new char[currentLength];
            String.decompress(this.value, 0, buffer, 0, currentLength);
        } else {
            buffer = this.value;
        }
        return StringCoding.encode((char[])buffer, (int)0, (int)currentLength);
    }

    @Deprecated
    public void getBytes(int start, int end, byte[] data, int index) {
        if (0 <= start && start <= end && end <= this.lengthInternal() && 0 <= index && end - start <= data.length - index) {
            if (COMPACT_STRINGS && (null == compressionFlag || this.count >= 0)) {
                String.compressedArrayCopy(this.value, start, data, index, end - start);
            } else {
                String.compress(this.value, start, data, index, end - start);
            }
        } else {
            throw new StringIndexOutOfBoundsException();
        }
    }

    void getBytes(int start, int end, char[] data, int index) {
        if (0 <= start && start <= end && end <= this.lengthInternal()) {
            if (COMPACT_STRINGS && (null == compressionFlag || this.count >= 0)) {
                String.compressedArrayCopy(this.value, start, data, index, end - start);
            } else {
                String.compress(this.value, start, data, index, end - start);
            }
        } else {
            throw new StringIndexOutOfBoundsException();
        }
    }

    public byte[] getBytes(String encoding) throws UnsupportedEncodingException {
        char[] buffer;
        if (encoding == null) {
            throw new NullPointerException();
        }
        int currentLength = this.lengthInternal();
        if (COMPACT_STRINGS && this.count >= 0) {
            buffer = new char[currentLength];
            String.decompress(this.value, 0, buffer, 0, currentLength);
        } else {
            buffer = this.value;
        }
        return StringCoding.encode((String)encoding, (char[])buffer, (int)0, (int)currentLength);
    }

    public void getChars(int start, int end, char[] data, int index) {
        if (0 <= start && start <= end && end <= this.lengthInternal() && 0 <= index && end - start <= data.length - index) {
            if (COMPACT_STRINGS && (null == compressionFlag || this.count >= 0)) {
                String.decompress(this.value, start, data, index, end - start);
            } else {
                System.arraycopy((Object)this.value, start, (Object)data, index, end - start);
            }
        } else {
            throw new StringIndexOutOfBoundsException();
        }
    }

    void getCharsNoBoundChecks(int start, int end, char[] data, int index) {
        if (COMPACT_STRINGS && (null == compressionFlag || this.count >= 0)) {
            String.decompress(this.value, start, data, index, end - start);
        } else {
            String.decompressedArrayCopy(this.value, start, data, index, end - start);
        }
    }

    public int hashCode() {
        int length;
        if (this.hash == 0 && (length = this.lengthInternal()) > 0) {
            this.hash = COMPACT_STRINGS && (compressionFlag == null || this.count >= 0) ? String.hashCodeImplCompressed(this.value, 0, length) : String.hashCodeImplDecompressed(this.value, 0, length);
        }
        return this.hash;
    }

    private static int hashCodeImplCompressed(char[] value, int offset, int count) {
        int hash = 0;
        int end = offset + count;
        for (int i = offset; i < end; ++i) {
            hash = (hash << 5) - hash + helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(value, i));
        }
        return hash;
    }

    private static int hashCodeImplDecompressed(char[] value, int offset, int count) {
        int hash = 0;
        int end = offset + count;
        for (int i = offset; i < end; ++i) {
            hash = (hash << 5) - hash + value[i];
        }
        return hash;
    }

    public int indexOf(int c) {
        return this.indexOf(c, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int indexOf(int c, int start) {
        int len = this.lengthInternal();
        if (start >= len) return -1;
        if (start < 0) {
            start = 0;
        }
        if (c >= 0 && c <= 65535) {
            char[] array = this.value;
            if (!COMPACT_STRINGS || null != compressionFlag && this.count < 0) return helpers.intrinsicIndexOfUTF16(array, (char)c, start, len);
            if (c > 255) return -1;
            return helpers.intrinsicIndexOfLatin1(array, (byte)c, start, len);
        }
        if (c > 0x10FFFF) return -1;
        for (int i = start; i < len; ++i) {
            int codePoint = this.codePointAt(i);
            if (codePoint == c) {
                return i;
            }
            if (codePoint < 65536) continue;
            ++i;
        }
        return -1;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String subString, int start) {
        if (subString.length() == 1) {
            return this.indexOf(subString.charAtInternal(0), start);
        }
        if (start < 0) {
            start = 0;
        }
        String s1 = this;
        String s2 = subString;
        int s1len = s1.lengthInternal();
        int s2len = s2.lengthInternal();
        if (s2len > 0) {
            if (start > s1len - s2len) {
                return -1;
            }
            char[] s1Value = s1.value;
            char[] s2Value = s2.value;
            if (COMPACT_STRINGS) {
                if (null == compressionFlag || (s1.count | s2.count) >= 0) {
                    return helpers.intrinsicIndexOfStringLatin1(s1Value, s1len, s2Value, s2len, start);
                }
                if ((s1.count & s2.count) < 0) {
                    return helpers.intrinsicIndexOfStringUTF16(s1Value, s1len, s2Value, s2len, start);
                }
                char firstChar = s2.charAtInternal(0, s2Value);
                while (true) {
                    int i;
                    if ((i = this.indexOf(firstChar, start)) == -1 || s2len + i > s1len) {
                        return -1;
                    }
                    int o1 = i;
                    int o2 = 0;
                    while (++o2 < s2len && s1.charAtInternal(++o1, s1Value) == s2.charAtInternal(o2, s2Value)) {
                    }
                    if (o2 == s2len) {
                        return i;
                    }
                    start = i + 1;
                }
            }
            return helpers.intrinsicIndexOfStringUTF16(s1Value, s1len, s2Value, s2len, start);
        }
        return start < s1len ? start : s1len;
    }

    public native String intern();

    public int lastIndexOf(int c) {
        return this.lastIndexOf(c, this.lengthInternal() - 1);
    }

    public int lastIndexOf(int c, int start) {
        block6: {
            block7: {
                char[] array;
                block8: {
                    if (start < 0) break block6;
                    int len = this.lengthInternal();
                    if (start >= len) {
                        start = len - 1;
                    }
                    if (c < 0 || c > 65535) break block7;
                    array = this.value;
                    if (!COMPACT_STRINGS || null != compressionFlag && this.count < 0) break block8;
                    if (c > 255) break block6;
                    byte b = (byte)c;
                    for (int i = start; i >= 0; --i) {
                        if (helpers.getByteFromArrayByIndex(array, i) != b) continue;
                        return i;
                    }
                    break block6;
                }
                for (int i = start; i >= 0; --i) {
                    if (array[i] != c) continue;
                    return i;
                }
                break block6;
            }
            if (c <= 0x10FFFF) {
                for (int i = start; i >= 0; --i) {
                    int codePoint = this.codePointAt(i);
                    if (codePoint == c) {
                        return i;
                    }
                    if (codePoint < 65536) continue;
                    --i;
                }
            }
        }
        return -1;
    }

    public int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.lengthInternal());
    }

    public int lastIndexOf(String subString, int start) {
        String s1 = this;
        String s2 = subString;
        int s1len = s1.lengthInternal();
        int s2len = s2.lengthInternal();
        if (s2len <= s1len && start >= 0) {
            if (s2len > 0) {
                if (start > s1len - s2len) {
                    start = s1len - s2len;
                }
                char[] s1Value = s1.value;
                char[] s2Value = s2.value;
                if (COMPACT_STRINGS && (null == compressionFlag || (s1.count | s2.count) >= 0)) {
                    char firstChar = helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(s2Value, 0));
                    while (true) {
                        int i;
                        if ((i = this.lastIndexOf(firstChar, start)) == -1) {
                            return -1;
                        }
                        int o1 = i;
                        int o2 = 0;
                        while (++o2 < s2len && helpers.getByteFromArrayByIndex(s1Value, ++o1) == helpers.getByteFromArrayByIndex(s2Value, o2)) {
                        }
                        if (o2 == s2len) {
                            return i;
                        }
                        start = i - 1;
                    }
                }
                char firstChar = s2.charAtInternal(0, s2Value);
                while (true) {
                    int i;
                    if ((i = this.lastIndexOf(firstChar, start)) == -1) {
                        return -1;
                    }
                    int o1 = i;
                    int o2 = 0;
                    while (++o2 < s2len && s1.charAtInternal(++o1, s1Value) == s2.charAtInternal(o2, s2Value)) {
                    }
                    if (o2 == s2len) {
                        return i;
                    }
                    start = i - 1;
                }
            }
            return start < s1len ? start : s1len;
        }
        return -1;
    }

    @Override
    public int length() {
        return this.lengthInternal();
    }

    int lengthInternal() {
        if (COMPACT_STRINGS) {
            if (compressionFlag == null || this.count >= 0) {
                return this.count;
            }
            return this.count & Integer.MAX_VALUE;
        }
        return this.count;
    }

    public boolean regionMatches(int thisStart, String string, int start, int length) {
        string.getClass();
        String s1 = this;
        String s2 = string;
        int s1len = s1.lengthInternal();
        int s2len = s2.lengthInternal();
        if (start < 0 || s2len - start < length) {
            return false;
        }
        if (thisStart < 0 || s1len - thisStart < length) {
            return false;
        }
        return String.regionMatchesInternal(s1, s2, s1.value, s2.value, thisStart, start, length);
    }

    private static boolean regionMatchesInternal(String s1, String s2, char[] s1Value, char[] s2Value, int s1Start, int s2Start, int length) {
        if (length <= 0) {
            return true;
        }
        int end = length - 1;
        if (COMPACT_STRINGS && (compressionFlag == null || (s1.count | s2.count) >= 0)) {
            if (helpers.getByteFromArrayByIndex(s1Value, s1Start + end) != helpers.getByteFromArrayByIndex(s2Value, s2Start + end)) {
                return false;
            }
            for (int i = 0; i < end; ++i) {
                if (helpers.getByteFromArrayByIndex(s1Value, s1Start + i) == helpers.getByteFromArrayByIndex(s2Value, s2Start + i)) continue;
                return false;
            }
        } else {
            if (s1.charAtInternal(s1Start + end, s1Value) != s2.charAtInternal(s2Start + end, s2Value)) {
                return false;
            }
            for (int i = 0; i < end; ++i) {
                if (s1.charAtInternal(s1Start + i, s1Value) == s2.charAtInternal(s2Start + i, s2Value)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean regionMatches(boolean ignoreCase, int thisStart, String string, int start, int length) {
        if (!ignoreCase) {
            return this.regionMatches(thisStart, string, start, length);
        }
        string.getClass();
        String s1 = this;
        String s2 = string;
        int s1len = s1.lengthInternal();
        int s2len = s2.lengthInternal();
        if (thisStart < 0 || length > s1len - thisStart) {
            return false;
        }
        if (start < 0 || length > s2len - start) {
            return false;
        }
        if (length <= 0) {
            return true;
        }
        int o1 = thisStart;
        int o2 = start;
        int end = thisStart + length;
        char[] s1Value = s1.value;
        char[] s2Value = s2.value;
        if (COMPACT_STRINGS && (null == compressionFlag || (s1.count | s2.count) >= 0)) {
            while (o1 < end) {
                byte byteAtO2;
                byte byteAtO1;
                if ((byteAtO1 = helpers.getByteFromArrayByIndex(s1Value, o1++)) == (byteAtO2 = helpers.getByteFromArrayByIndex(s2Value, o2++)) || String.charValuesEqualIgnoreCase(helpers.byteToCharUnsigned(byteAtO1), helpers.byteToCharUnsigned(byteAtO2))) continue;
                return false;
            }
        } else {
            while (o1 < end) {
                char charAtO2;
                char charAtO1;
                if ((charAtO1 = s1.charAtInternal(o1++, s1Value)) == (charAtO2 = s2.charAtInternal(o2++, s2Value)) || String.charValuesEqualIgnoreCase(charAtO1, charAtO2)) continue;
                return false;
            }
        }
        return true;
    }

    public String replace(char oldChar, char newChar) {
        int index = this.indexOf(oldChar, 0);
        if (index == -1) {
            return this;
        }
        int len = this.lengthInternal();
        if (COMPACT_STRINGS && (null == compressionFlag || this.count >= 0)) {
            if (newChar <= '\u00ff') {
                char[] buffer = new char[len + 1 >>> 1];
                String.compressedArrayCopy(this.value, 0, buffer, 0, len);
                do {
                    helpers.putByteInArrayByIndex(buffer, index++, (byte)newChar);
                } while ((index = this.indexOf(oldChar, index)) != -1);
                return new String(buffer, 0, len, true);
            }
            char[] buffer = new char[len];
            String.decompress(this.value, 0, buffer, 0, len);
            do {
                buffer[index++] = newChar;
            } while ((index = this.indexOf(oldChar, index)) != -1);
            return new String(buffer, 0, len, false);
        }
        char[] buffer = new char[len];
        System.arraycopy((Object)this.value, 0, (Object)buffer, 0, len);
        do {
            buffer[index++] = newChar;
        } while ((index = this.indexOf(oldChar, index)) != -1);
        return new String(buffer, 0, len, false);
    }

    public boolean startsWith(String prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean startsWith(String prefix, int start) {
        if (prefix.length() == 1) {
            if (start < 0 || start >= this.length()) {
                return false;
            }
            return this.charAtInternal(start) == prefix.charAtInternal(0);
        }
        return this.regionMatches(start, prefix, 0, prefix.lengthInternal());
    }

    public String substring(int start) {
        if (start == 0) {
            return this;
        }
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        int len = this.lengthInternal();
        if (start <= len) {
            if (COMPACT_STRINGS && (null == compressionFlag || this.count >= 0)) {
                return new String(this.value, start, len - start, true, enableSharingInSubstringWhenOffsetIsZero);
            }
            return new String(this.value, start, len - start, false, enableSharingInSubstringWhenOffsetIsZero);
        }
        throw new StringIndexOutOfBoundsException("begin " + start + ", length " + len);
    }

    public String substring(int start, int end) {
        int len = this.lengthInternal();
        if (start == 0 && end == len) {
            return this;
        }
        if (start >= 0 && start <= end && end <= len) {
            if (COMPACT_STRINGS && (null == compressionFlag || this.count >= 0)) {
                return new String(this.value, start, end - start, true, enableSharingInSubstringWhenOffsetIsZero);
            }
            return new String(this.value, start, end - start, false, enableSharingInSubstringWhenOffsetIsZero);
        }
        throw new StringIndexOutOfBoundsException("begin " + start + ", end " + end + ", length " + len);
    }

    public char[] toCharArray() {
        int len = this.lengthInternal();
        char[] buffer = new char[len];
        if (COMPACT_STRINGS && (null == compressionFlag || this.count >= 0)) {
            String.decompress(this.value, 0, buffer, 0, len);
        } else {
            System.arraycopy((Object)this.value, 0, (Object)buffer, 0, len);
        }
        return buffer;
    }

    public String toLowerCase() {
        return this.toLowerCase(Locale.getDefault());
    }

    private static int toLowerCase(int codePoint) {
        if (codePoint < 128) {
            if (65 <= codePoint && codePoint <= 90) {
                return codePoint + 32;
            }
            return codePoint;
        }
        return Character.toLowerCase(codePoint);
    }

    private static int toUpperCase(int codePoint) {
        if (codePoint < 128) {
            if (97 <= codePoint && codePoint <= 122) {
                return codePoint - 32;
            }
            return codePoint;
        }
        return Character.toUpperCase(codePoint);
    }

    public String toLowerCase(Locale locale) {
        String language = locale.getLanguage();
        int sLength = this.lengthInternal();
        if (sLength == 0) {
            return this;
        }
        if (helpers.supportsIntrinsicCaseConversion() && language == "en") {
            char[] output;
            if (COMPACT_STRINGS && (null == compressionFlag || this.count >= 0)) {
                char[] output2 = new char[sLength + 1 >>> 1];
                if (helpers.toLowerIntrinsicLatin1(this.value, output2, sLength)) {
                    return new String(output2, 0, sLength, true);
                }
            } else if (sLength <= 0x3FFFFFFF && helpers.toLowerIntrinsicUTF16(this.value, output = new char[sLength], sLength * 2)) {
                return new String(output, 0, sLength, false);
            }
        }
        return this.toLowerCaseCore(language);
    }

    private String toLowerCaseCore(String language) {
        boolean turkishAzeri = false;
        boolean lithuanian = false;
        StringBuilder builder = null;
        int len = this.lengthInternal();
        for (int i = 0; i < len; ++i) {
            int lowerCase;
            int codePoint = this.charAtInternal(i);
            if (codePoint >= 55296 && codePoint <= 56319) {
                codePoint = this.codePointAt(i);
            }
            if (codePoint != (lowerCase = String.toLowerCase(codePoint))) {
                if (builder == null) {
                    turkishAzeri = language == "tr" || language == "az";
                    lithuanian = language == "lt";
                    builder = new StringBuilder(len);
                    if (COMPACT_STRINGS && (null == compressionFlag || this.count >= 0)) {
                        builder.append(this.value, 0, i, true);
                    } else {
                        builder.append(this.value, 0, i, false);
                    }
                }
                if (codePoint == 931) {
                    builder.append(this.convertSigma(i));
                    continue;
                }
                if (!turkishAzeri && 304 == codePoint) {
                    builder.append("i\u0307");
                    continue;
                }
                if (turkishAzeri) {
                    if (codePoint == 73) {
                        boolean combiningDotAbove = i + 1 < len && this.charAtInternal(i + 1) == '\u0307';
                        builder.append(combiningDotAbove ? (char)'i' : '\u0131');
                        if (combiningDotAbove) {
                            ++i;
                        }
                    } else {
                        builder.appendCodePoint(lowerCase);
                    }
                } else if (lithuanian) {
                    if (codePoint == 73 || codePoint == 74 || codePoint == 302) {
                        int nextPoint;
                        builder.append(codePoint == 302 ? (char)'\u012f' : (char)(codePoint + 32));
                        if (i + 1 < len && String.isCombiningAbove(nextPoint = this.codePointAt(i + 1))) {
                            builder.append('\u0307');
                        }
                    } else if (codePoint == 204) {
                        builder.append("i\u0307\u0300");
                    } else if (codePoint == 205) {
                        builder.append("i\u0307\u0301");
                    } else if (codePoint == 296) {
                        builder.append("i\u0307\u0303");
                    } else {
                        builder.appendCodePoint(lowerCase);
                    }
                } else {
                    builder.appendCodePoint(lowerCase);
                }
            } else if (builder != null) {
                builder.appendCodePoint(codePoint);
            }
            if (codePoint < 65536) continue;
            ++i;
        }
        if (builder == null) {
            return this;
        }
        return builder.toString();
    }

    private static int binarySearchRange(char[] data, char c) {
        char value = '\u0000';
        int low = 0;
        int mid = -1;
        int high = data.length - 1;
        while (low <= high) {
            mid = low + high >>> 1;
            value = data[mid];
            if (c > value) {
                low = mid + 1;
                continue;
            }
            if (c == value) {
                return mid;
            }
            high = mid - 1;
        }
        return mid - (c < value ? 1 : 0);
    }

    private static boolean isCombiningAbove(int codePoint) {
        if (codePoint < 65535) {
            int index = String.binarySearchRange(startCombiningAbove, (char)codePoint);
            return index >= 0 && endCombiningAbove[index] >= codePoint;
        }
        return codePoint == 68111 || codePoint == 68152 || codePoint >= 69888 && codePoint <= 69890 || codePoint >= 119173 && codePoint <= 119177 || codePoint >= 119210 && codePoint <= 119213 || codePoint >= 119362 && codePoint <= 119364;
    }

    private static boolean isWordPart(int codePoint) {
        return codePoint == 837 || String.isWordStart(codePoint);
    }

    private static boolean isWordStart(int codePoint) {
        int type = Character.getType(codePoint);
        return type >= 1 && type <= 3 || codePoint >= 688 && codePoint <= 696 || codePoint >= 704 && codePoint <= 705 || codePoint >= 736 && codePoint <= 740 || codePoint == 890 || codePoint >= 8544 && codePoint <= 8575 || codePoint >= 7468 && codePoint <= 7521;
    }

    private char convertSigma(int pos) {
        if (pos == 0 || !String.isWordStart(this.codePointBefore(pos)) || pos + 1 < this.lengthInternal() && String.isWordPart(this.codePointAt(pos + 1))) {
            return '\u03c3';
        }
        return '\u03c2';
    }

    @Override
    public String toString() {
        return this;
    }

    public String toUpperCase() {
        return this.toUpperCase(Locale.getDefault());
    }

    private static int upperIndex(int ch) {
        int index = -1;
        if (ch <= 1415) {
            if (ch == 223) {
                index = 0;
            } else if (ch <= 329) {
                if (ch == 329) {
                    index = 1;
                }
            } else if (ch <= 496) {
                if (ch == 496) {
                    index = 2;
                }
            } else if (ch <= 912) {
                if (ch == 912) {
                    index = 3;
                }
            } else if (ch <= 944) {
                if (ch == 944) {
                    index = 4;
                }
            } else if (ch <= 1415 && ch == 1415) {
                index = 5;
            }
        } else if (ch >= 7830) {
            if (ch <= 7834) {
                index = 6 + ch - 7830;
            } else if (ch >= 8016 && ch <= 8188) {
                index = upperIndexs[ch - 8016];
                if (index == 0) {
                    index = -1;
                }
            } else if (ch >= 64256) {
                if (ch <= 64262) {
                    index = 90 + ch - 64256;
                } else if (ch >= 64275 && ch <= 64279) {
                    index = 97 + ch - 64275;
                }
            }
        }
        return index;
    }

    public String toUpperCase(Locale locale) {
        String language = locale.getLanguage();
        int sLength = this.lengthInternal();
        if (sLength == 0) {
            return this;
        }
        if (helpers.supportsIntrinsicCaseConversion() && language == "en") {
            char[] output;
            if (COMPACT_STRINGS && (null == compressionFlag || this.count >= 0)) {
                char[] output2 = new char[sLength + 1 >>> 1];
                if (helpers.toUpperIntrinsicLatin1(this.value, output2, sLength)) {
                    return new String(output2, 0, sLength, true);
                }
            } else if (sLength <= 0x3FFFFFFF && helpers.toUpperIntrinsicUTF16(this.value, output = new char[sLength], sLength * 2)) {
                return new String(output, 0, sLength, false);
            }
        }
        return this.toUpperCaseCore(language);
    }

    private String toUpperCaseCore(String language) {
        boolean turkishAzeri = language == "tr" || language == "az";
        boolean lithuanian = language == "lt";
        StringBuilder builder = null;
        int len = this.lengthInternal();
        for (int i = 0; i < len; ++i) {
            int codePoint = this.charAtInternal(i);
            if (codePoint >= 55296 && codePoint <= 56319) {
                codePoint = this.codePointAt(i);
            }
            int index = -1;
            if (codePoint >= 223 && codePoint <= 64279) {
                index = String.upperIndex(codePoint);
            }
            if (index == -1) {
                int upper;
                int n = upper = !turkishAzeri || codePoint != 105 ? String.toUpperCase(codePoint) : 304;
                if (codePoint != upper) {
                    if (builder == null) {
                        builder = new StringBuilder(len);
                        if (COMPACT_STRINGS && (null == compressionFlag || this.count >= 0)) {
                            builder.append(this.value, 0, i, true);
                        } else {
                            builder.append(this.value, 0, i, false);
                        }
                    }
                    builder.appendCodePoint(upper);
                } else if (builder != null) {
                    builder.appendCodePoint(codePoint);
                }
                if (lithuanian && codePoint <= 7883 && i + 1 < len && this.charAt(i + 1) == '\u0307' && "ij\u012f\u0268\u0456\u0458\u1e2d\u1ecb".indexOf(codePoint, 0) != -1) {
                    ++i;
                }
            } else {
                if (builder == null) {
                    builder = new StringBuilder(len + len / 6 + 2).append(this, 0, i);
                }
                int target = index * 3;
                builder.append(upperValues[target]);
                builder.append(upperValues[target + 1]);
                char val = upperValues[target + 2];
                if (val != '\u0000') {
                    builder.append(val);
                }
            }
            if (codePoint < 65536) continue;
            ++i;
        }
        if (builder == null) {
            return this;
        }
        return builder.toString();
    }

    public String trim() {
        int start;
        int last;
        int end = last = this.lengthInternal() - 1;
        if (COMPACT_STRINGS && (null == compressionFlag || this.count >= 0)) {
            for (start = 0; start <= end && helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(this.value, start)) <= ' '; ++start) {
            }
            while (end >= start && helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(this.value, end)) <= ' ') {
                --end;
            }
            if (start == 0 && end == last) {
                return this;
            }
            return new String(this.value, start, end - start + 1, true);
        }
        while (start <= end && this.charAtInternal(start) <= ' ') {
            ++start;
        }
        while (end >= start && this.charAtInternal(end) <= ' ') {
            --end;
        }
        if (start == 0 && end == last) {
            return this;
        }
        return new String(this.value, start, end - start + 1, false);
    }

    public static String valueOf(char[] data) {
        return new String(data, 0, data.length);
    }

    public static String valueOf(char[] data, int start, int length) {
        return new String(data, start, length);
    }

    public static String valueOf(char value) {
        String string = value <= '\u00ff' ? (COMPACT_STRINGS ? new String(compressedAsciiTable[value], 0, 1, true) : new String(decompressedAsciiTable[value], 0, 1, false)) : new String(new char[]{value}, 0, 1, false);
        return string;
    }

    public static String valueOf(double value) {
        return Double.toString(value);
    }

    public static String valueOf(float value) {
        return Float.toString(value);
    }

    public static String valueOf(int value) {
        return Integer.toString(value);
    }

    public static String valueOf(long value) {
        return Long.toString(value);
    }

    public static String valueOf(Object value) {
        return value != null ? value.toString() : "null";
    }

    public static String valueOf(boolean value) {
        return value ? "true" : "false";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contentEquals(StringBuffer buffer) {
        StringBuffer stringBuffer = buffer;
        synchronized (stringBuffer) {
            int size = buffer.length();
            if (this.lengthInternal() != size) {
                return false;
            }
            if (COMPACT_STRINGS && buffer.isCompressed()) {
                return this.regionMatches(0, new String(buffer.getValue(), 0, size, true), 0, size);
            }
            return this.regionMatches(0, new String(buffer.getValue(), 0, size, false), 0, size);
        }
    }

    public boolean matches(String expr) {
        return Pattern.matches(expr, this);
    }

    public String replaceAll(String regex, String substitute) {
        if (regex != null && substitute != null && regex.lengthInternal() == 1 && !String.hasMetaChars(regex)) {
            int substituteLength = substitute.lengthInternal();
            int length = this.lengthInternal();
            if (substituteLength < 2) {
                if (COMPACT_STRINGS && this.isCompressed() && (substituteLength == 0 || substitute.isCompressed())) {
                    char[] newChars = new char[length + 1 >>> 1];
                    byte toReplace = helpers.getByteFromArrayByIndex(regex.value, 0);
                    byte replacement = -1;
                    if (substituteLength == 1) {
                        replacement = helpers.getByteFromArrayByIndex(substitute.value, 0);
                        this.checkLastChar((char)replacement);
                    }
                    int newCharIndex = 0;
                    for (int i = 0; i < length; ++i) {
                        byte current = helpers.getByteFromArrayByIndex(this.value, i);
                        if (current != toReplace) {
                            helpers.putByteInArrayByIndex(newChars, newCharIndex++, current);
                            continue;
                        }
                        if (substituteLength != 1) continue;
                        helpers.putByteInArrayByIndex(newChars, newCharIndex++, replacement);
                    }
                    return new String(newChars, 0, newCharIndex, true);
                }
                if (!COMPACT_STRINGS || !this.isCompressed()) {
                    char[] newChars = new char[length];
                    char toReplace = regex.charAtInternal(0);
                    char replacement = '\uffff';
                    if (substituteLength == 1) {
                        replacement = substitute.charAtInternal(0);
                        this.checkLastChar(replacement);
                    }
                    int newCharIndex = 0;
                    for (int i = 0; i < length; ++i) {
                        char current = helpers.getCharFromArrayByIndex(this.value, i);
                        if (current != toReplace) {
                            helpers.putCharInArrayByIndex(newChars, newCharIndex++, current);
                            continue;
                        }
                        if (substituteLength != 1) continue;
                        helpers.putCharInArrayByIndex(newChars, newCharIndex++, replacement);
                    }
                    return new String(newChars, 0, newCharIndex, false);
                }
            }
        }
        return Pattern.compile(regex).matcher(this).replaceAll(substitute);
    }

    public String replaceFirst(String expr, String substitute) {
        return Pattern.compile(expr).matcher(this).replaceFirst(substitute);
    }

    public String[] split(String regex) {
        return this.split(regex, 0);
    }

    private static final boolean hasMetaChars(String s) {
        for (int i = 0; i < s.lengthInternal(); ++i) {
            char ch = s.charAtInternal(i);
            if (ch >= '\ud800' && ch <= '\udfff') {
                return true;
            }
            for (int j = 0; j < regexMetaChars.length; ++j) {
                if (ch != regexMetaChars[j]) continue;
                return true;
            }
        }
        return false;
    }

    private static final boolean isSingleEscapeLiteral(String s) {
        if (s != null && s.lengthInternal() == 2 && s.charAtInternal(0) == '\\') {
            char literal = s.charAtInternal(1);
            for (int j = 0; j < regexMetaChars.length; ++j) {
                if (literal != regexMetaChars[j]) continue;
                return true;
            }
        }
        return false;
    }

    public String[] split(String regex, int max) {
        boolean singleEscapeLiteral = String.isSingleEscapeLiteral(regex);
        if (regex != null && regex.lengthInternal() > 0 && (!String.hasMetaChars(regex) || singleEscapeLiteral)) {
            int current;
            if (max == 1) {
                return new String[]{this};
            }
            ArrayList<String> parts = new ArrayList<String>(max > 0 && max < 100 ? max : 10);
            char[] chars = this.value;
            boolean compressed = COMPACT_STRINGS && (null == compressionFlag || this.count >= 0);
            int start = 0;
            int end = this.lengthInternal();
            if (regex.lengthInternal() == 1 || singleEscapeLiteral) {
                char splitChar = regex.charAtInternal(singleEscapeLiteral ? 1 : 0);
                for (current = 0; current < end; ++current) {
                    if (this.charAtInternal(current, chars) != splitChar) continue;
                    parts.add(new String(chars, start, current - start, compressed));
                    start = current + 1;
                    if (max <= 0 || parts.size() != max - 1) continue;
                    parts.add(new String(chars, start, end - start, compressed));
                    break;
                }
            } else {
                int rLength = regex.lengthInternal();
                char[] splitChars = regex.value;
                char firstChar = this.charAtInternal(0, regex.value);
                while (current < end) {
                    if (this.charAtInternal(current, chars) == firstChar) {
                        int matchIdx;
                        int idx = current + 1;
                        for (matchIdx = 1; matchIdx < rLength && idx < end && this.charAtInternal(idx, chars) == this.charAtInternal(matchIdx, splitChars); ++matchIdx, ++idx) {
                        }
                        if (matchIdx == rLength) {
                            parts.add(new String(chars, start, current - start, compressed));
                            start = current + rLength;
                            if (max > 0 && parts.size() == max - 1) {
                                parts.add(new String(chars, start, end - start, compressed));
                                break;
                            }
                            current += rLength;
                            continue;
                        }
                    }
                    ++current;
                }
            }
            if (parts.size() == 0) {
                return new String[]{this};
            }
            if (start <= current && parts.size() != max) {
                parts.add(new String(chars, start, current - start, compressed));
            }
            if (max == 0) {
                end = parts.size();
                while (end > 0 && ((String)parts.get(end - 1)).lengthInternal() == 0) {
                    parts.remove(--end);
                }
            }
            return parts.toArray(new String[parts.size()]);
        }
        return Pattern.compile(regex).split(this, max);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.substring(start, end);
    }

    public String(int[] data, int start, int length) {
        if (start >= 0 && 0 <= length && length <= data.length - start) {
            int codePoint;
            int j;
            int i;
            int size = 0;
            boolean canEncodeAsLatin1 = COMPACT_STRINGS;
            for (i = start; i < start + length; ++i) {
                int codePoint2 = data[i];
                if (codePoint2 < 0) {
                    throw new IllegalArgumentException();
                }
                if (codePoint2 < 65536) {
                    if (canEncodeAsLatin1 && codePoint2 > 255) {
                        canEncodeAsLatin1 = false;
                    }
                    ++size;
                    continue;
                }
                if (codePoint2 <= 0x10FFFF) {
                    if (canEncodeAsLatin1) {
                        int codePoint1 = 55296 + ((codePoint2 -= 65536) >> 10);
                        int codePoint22 = 56320 + (codePoint2 & 0x3FF);
                        if (codePoint1 > 255 || codePoint22 > 255) {
                            canEncodeAsLatin1 = false;
                        }
                    }
                    size += 2;
                    continue;
                }
                throw new IllegalArgumentException();
            }
            if (canEncodeAsLatin1) {
                this.value = new char[size + 1 >>> 1];
                this.count = size;
                j = 0;
                for (i = start; i < start + length; ++i) {
                    codePoint = data[i];
                    if (codePoint < 65536) {
                        helpers.putByteInArrayByIndex(this.value, j++, (byte)codePoint);
                        continue;
                    }
                    int codePoint1 = 55296 + ((codePoint -= 65536) >> 10);
                    int codePoint2 = 56320 + (codePoint & 0x3FF);
                    helpers.putByteInArrayByIndex(this.value, j++, (byte)codePoint1);
                    helpers.putByteInArrayByIndex(this.value, j++, (byte)codePoint2);
                }
            } else {
                this.value = new char[size];
                if (COMPACT_STRINGS) {
                    this.count = size | Integer.MIN_VALUE;
                    String.initCompressionFlag();
                } else {
                    this.count = size;
                }
                j = 0;
                for (i = start; i < start + length; ++i) {
                    codePoint = data[i];
                    if (codePoint < 65536) {
                        this.value[j++] = (char)codePoint;
                        continue;
                    }
                    this.value[j++] = (char)(55296 + ((codePoint -= 65536) >> 10));
                    this.value[j++] = (char)(56320 + (codePoint & 0x3FF));
                }
            }
        } else {
            throw new StringIndexOutOfBoundsException();
        }
    }

    public String(StringBuilder builder) {
        char[] chars = builder.shareValue();
        if (COMPACT_STRINGS) {
            if (builder.isCompressed()) {
                this.value = chars;
                this.count = builder.lengthInternal();
            } else {
                this.value = chars;
                this.count = builder.lengthInternal() | Integer.MIN_VALUE;
                String.initCompressionFlag();
            }
        } else {
            this.value = chars;
            this.count = builder.lengthInternal();
        }
    }

    public int codePointAt(int index) {
        int len = this.lengthInternal();
        if (index >= 0 && index < len) {
            char low;
            if (COMPACT_STRINGS && (null == compressionFlag || this.count >= 0)) {
                return helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(this.value, index));
            }
            char high = this.charAtInternal(index);
            if (index < len - 1 && Character.isHighSurrogate(high) && Character.isLowSurrogate(low = this.charAtInternal(index + 1))) {
                return Character.toCodePoint(high, low);
            }
            return high;
        }
        throw new StringIndexOutOfBoundsException(index);
    }

    public int codePointBefore(int index) {
        int len = this.lengthInternal();
        if (index > 0 && index <= len) {
            char high;
            if (COMPACT_STRINGS && (null == compressionFlag || this.count >= 0)) {
                return helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(this.value, index - 1));
            }
            char low = this.charAtInternal(index - 1);
            if (index > 1 && Character.isLowSurrogate(low) && Character.isHighSurrogate(high = this.charAtInternal(index - 2))) {
                return Character.toCodePoint(high, low);
            }
            return low;
        }
        throw new StringIndexOutOfBoundsException(index);
    }

    public int codePointCount(int start, int end) {
        int len = this.lengthInternal();
        if (start >= 0 && start <= end && end <= len) {
            if (COMPACT_STRINGS && (null == compressionFlag || this.count >= 0)) {
                return end - start;
            }
            int count = 0;
            for (int i = start; i < end; ++i) {
                if (i < end - 1 && Character.isHighSurrogate(this.charAtInternal(i)) && Character.isLowSurrogate(this.charAtInternal(i + 1))) {
                    ++i;
                }
                ++count;
            }
            return count;
        }
        throw new IndexOutOfBoundsException();
    }

    public int offsetByCodePoints(int start, int codePointCount) {
        int len = this.lengthInternal();
        if (start >= 0 && start <= len) {
            if (COMPACT_STRINGS && (null == compressionFlag || this.count >= 0)) {
                int index = start + codePointCount;
                if (index > len) {
                    throw new IndexOutOfBoundsException();
                }
                return index;
            }
            int index = start;
            if (codePointCount == 0) {
                return start;
            }
            if (codePointCount > 0) {
                for (int i = 0; i < codePointCount; ++i) {
                    if (index == len) {
                        throw new IndexOutOfBoundsException();
                    }
                    if (index < len - 1 && Character.isHighSurrogate(this.charAtInternal(index)) && Character.isLowSurrogate(this.charAtInternal(index + 1))) {
                        ++index;
                    }
                    ++index;
                }
            } else {
                for (int i = codePointCount; i < 0; ++i) {
                    if (index < 1) {
                        throw new IndexOutOfBoundsException();
                    }
                    if (index > 1 && Character.isLowSurrogate(this.charAtInternal(index - 1)) && Character.isHighSurrogate(this.charAtInternal(index - 2))) {
                        --index;
                    }
                    --index;
                }
            }
            return index;
        }
        throw new IndexOutOfBoundsException();
    }

    public boolean contentEquals(CharSequence sequence) {
        int len = this.lengthInternal();
        if (len != sequence.length()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.charAtInternal(i) == sequence.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(CharSequence sequence) {
        int len = this.lengthInternal();
        int sequencelen = sequence.length();
        if (sequencelen > len) {
            return false;
        }
        int start = 0;
        if (sequencelen > 0) {
            if (sequencelen + start > len) {
                return false;
            }
            char charAt0 = sequence.charAt(0);
            while (true) {
                int i;
                if ((i = this.indexOf(charAt0, start)) == -1 || sequencelen + i > len) {
                    return false;
                }
                int o1 = i;
                int o2 = 0;
                while (++o2 < sequencelen && this.charAtInternal(++o1) == sequence.charAt(o2)) {
                }
                if (o2 == sequencelen) {
                    return true;
                }
                start = i + 1;
            }
        }
        return true;
    }

    public String replace(CharSequence sequence1, CharSequence sequence2) {
        int firstIndex;
        if (sequence2 == null) {
            throw new NullPointerException();
        }
        int len = this.lengthInternal();
        int sequence1len = sequence1.length();
        if (sequence1len == 0) {
            int sequence2len = sequence2.length();
            if (sequence2len != 0 && len >= (Integer.MAX_VALUE - len) / sequence2len) {
                throw new OutOfMemoryError(Msg.getString("K0D01"));
            }
            StringBuilder builder = new StringBuilder(len + (len + 1) * sequence2len);
            builder.append(sequence2);
            for (int i = 0; i < len; ++i) {
                builder.append(this.charAt(i)).append(sequence2);
            }
            return builder.toString();
        }
        StringBuilder builder = new StringBuilder();
        int start = 0;
        int copyStart = 0;
        char charAt0 = sequence1.charAt(0);
        while (start < len && (firstIndex = this.indexOf(charAt0, start)) != -1) {
            boolean found = true;
            if (sequence1len > 1) {
                if (sequence1len > len - firstIndex) break;
                for (int i = 1; i < sequence1len; ++i) {
                    if (this.charAt(firstIndex + i) == sequence1.charAt(i)) continue;
                    found = false;
                    break;
                }
            }
            if (found) {
                builder.append(this.substring(copyStart, firstIndex)).append(sequence2);
                copyStart = start = firstIndex + sequence1len;
                continue;
            }
            start = firstIndex + 1;
        }
        if (builder.length() == 0 && copyStart == 0) {
            return this;
        }
        builder.append(this.substring(copyStart));
        return builder.toString();
    }

    public static String format(String format, Object ... args) {
        return new Formatter().format(format, args).toString();
    }

    public static String format(Locale locale, String format, Object ... args) {
        return new Formatter(locale).format(format, args).toString();
    }

    @Override
    public boolean isEmpty() {
        return this.lengthInternal() == 0;
    }

    public String(byte[] data, Charset charset) {
        this(data, 0, data.length, charset);
    }

    public String(byte[] data, int start, int length, Charset charset) {
        if (charset == null) {
            throw new NullPointerException();
        }
        if (start >= 0 && 0 <= length && length <= data.length - start) {
            char[] chars = StringCoding.decode((Charset)charset, (byte[])data, (int)start, (int)length);
            if (COMPACT_STRINGS) {
                if (String.canEncodeAsLatin1(chars, 0, chars.length)) {
                    this.value = new char[chars.length + 1 >>> 1];
                    this.count = chars.length;
                    String.compress(chars, 0, this.value, 0, chars.length);
                } else {
                    this.value = chars;
                    this.count = chars.length | Integer.MIN_VALUE;
                    String.initCompressionFlag();
                }
            } else {
                this.value = chars;
                this.count = chars.length;
            }
        } else {
            throw new StringIndexOutOfBoundsException();
        }
    }

    public byte[] getBytes(Charset charset) {
        char[] buffer;
        int currentLength = this.lengthInternal();
        if (COMPACT_STRINGS && this.count >= 0) {
            buffer = new char[currentLength];
            String.decompress(this.value, 0, buffer, 0, currentLength);
        } else {
            buffer = this.value;
        }
        return StringCoding.encode((Charset)charset, (char[])buffer, (int)0, (int)currentLength);
    }

    public static String join(CharSequence delimiter, CharSequence ... elements) {
        StringJoiner stringJoiner = new StringJoiner(delimiter);
        for (CharSequence element : elements) {
            stringJoiner.add(element);
        }
        return stringJoiner.toString();
    }

    public static String join(CharSequence delimiter, Iterable<? extends CharSequence> elements) {
        StringJoiner stringJoiner = new StringJoiner(delimiter);
        Iterator<? extends CharSequence> elementsIterator = elements.iterator();
        while (elementsIterator.hasNext()) {
            stringJoiner.add(elementsIterator.next());
        }
        return stringJoiner.toString();
    }

    static {
        char[] asciiValue;
        int i;
        COMPACT_STRINGS = VM.J9_STRING_COMPRESSION_ENABLED;
        CASE_INSENSITIVE_ORDER = new CaseInsensitiveComparator();
        emptyValue = new char[0];
        helpers = JITHelpers.getHelpers();
        stringArray = new String[10];
        compressedAsciiTable = new char[256][];
        for (i = 0; i < compressedAsciiTable.length; ++i) {
            asciiValue = new char[1];
            helpers.putByteInArrayByIndex(asciiValue, 0, (byte)i);
            String.compressedAsciiTable[i] = asciiValue;
        }
        decompressedAsciiTable = new char[256][];
        for (i = 0; i < decompressedAsciiTable.length; ++i) {
            asciiValue = new char[1];
            helpers.putCharInArrayByIndex(asciiValue, 0, (char)i);
            String.decompressedAsciiTable[i] = asciiValue;
        }
        startCombiningAbove = new char[]{'\u0300', '\u033d', '\u0346', '\u034a', '\u0350', '\u0357', '\u035b', '\u0363', '\u0483', '\u0592', '\u0597', '\u059c', '\u05a8', '\u05ab', '\u05af', '\u05c4', '\u0610', '\u0653', '\u0657', '\u065d', '\u06d6', '\u06df', '\u06e4', '\u06e7', '\u06eb', '\u0730', '\u0732', '\u0735', '\u073a', '\u073d', '\u073f', '\u0743', '\u0745', '\u0747', '\u0749', '\u07eb', '\u07f3', '\u0816', '\u081b', '\u0825', '\u0829', '\u08e4', '\u08e7', '\u08ea', '\u08f3', '\u08f7', '\u08fb', '\u0951', '\u0953', '\u0f82', '\u0f86', '\u135d', '\u17dd', '\u193a', '\u1a17', '\u1a75', '\u1b6b', '\u1b6d', '\u1cd0', '\u1cda', '\u1ce0', '\u1cf4', '\u1dc0', '\u1dc3', '\u1dcb', '\u1dd1', '\u1dfe', '\u20d0', '\u20d4', '\u20db', '\u20e1', '\u20e7', '\u20e9', '\u20f0', '\u2cef', '\u2de0', '\ua66f', '\ua674', '\ua69f', '\ua6f0', '\ua8e0', '\uaab0', '\uaab2', '\uaab7', '\uaabe', '\uaac1', '\ufe20'};
        endCombiningAbove = new char[]{'\u0314', '\u0344', '\u0346', '\u034c', '\u0352', '\u0357', '\u035b', '\u036f', '\u0487', '\u0595', '\u0599', '\u05a1', '\u05a9', '\u05ac', '\u05af', '\u05c4', '\u0617', '\u0654', '\u065b', '\u065e', '\u06dc', '\u06e2', '\u06e4', '\u06e8', '\u06ec', '\u0730', '\u0733', '\u0736', '\u073a', '\u073d', '\u0741', '\u0743', '\u0745', '\u0747', '\u074a', '\u07f1', '\u07f3', '\u0819', '\u0823', '\u0827', '\u082d', '\u08e5', '\u08e8', '\u08ec', '\u08f5', '\u08f8', '\u08fe', '\u0951', '\u0954', '\u0f83', '\u0f87', '\u135f', '\u17dd', '\u193a', '\u1a17', '\u1a7c', '\u1b6b', '\u1b73', '\u1cd2', '\u1cdb', '\u1ce0', '\u1cf4', '\u1dc1', '\u1dc9', '\u1dcc', '\u1de6', '\u1dfe', '\u20d1', '\u20d7', '\u20dc', '\u20e1', '\u20e7', '\u20e9', '\u20f0', '\u2cf1', '\u2dff', '\ua66f', '\ua67d', '\ua69f', '\ua6f1', '\ua8f1', '\uaab0', '\uaab3', '\uaab8', '\uaabf', '\uaac1', '\ufe26'};
        upperValues = new char[]{'S', 'S', '\u0000', '\u02bc', 'N', '\u0000', 'J', '\u030c', '\u0000', '\u0399', '\u0308', '\u0301', '\u03a5', '\u0308', '\u0301', '\u0535', '\u0552', '\u0000', 'H', '\u0331', '\u0000', 'T', '\u0308', '\u0000', 'W', '\u030a', '\u0000', 'Y', '\u030a', '\u0000', 'A', '\u02be', '\u0000', '\u03a5', '\u0313', '\u0000', '\u03a5', '\u0313', '\u0300', '\u03a5', '\u0313', '\u0301', '\u03a5', '\u0313', '\u0342', '\u1f08', '\u0399', '\u0000', '\u1f09', '\u0399', '\u0000', '\u1f0a', '\u0399', '\u0000', '\u1f0b', '\u0399', '\u0000', '\u1f0c', '\u0399', '\u0000', '\u1f0d', '\u0399', '\u0000', '\u1f0e', '\u0399', '\u0000', '\u1f0f', '\u0399', '\u0000', '\u1f08', '\u0399', '\u0000', '\u1f09', '\u0399', '\u0000', '\u1f0a', '\u0399', '\u0000', '\u1f0b', '\u0399', '\u0000', '\u1f0c', '\u0399', '\u0000', '\u1f0d', '\u0399', '\u0000', '\u1f0e', '\u0399', '\u0000', '\u1f0f', '\u0399', '\u0000', '\u1f28', '\u0399', '\u0000', '\u1f29', '\u0399', '\u0000', '\u1f2a', '\u0399', '\u0000', '\u1f2b', '\u0399', '\u0000', '\u1f2c', '\u0399', '\u0000', '\u1f2d', '\u0399', '\u0000', '\u1f2e', '\u0399', '\u0000', '\u1f2f', '\u0399', '\u0000', '\u1f28', '\u0399', '\u0000', '\u1f29', '\u0399', '\u0000', '\u1f2a', '\u0399', '\u0000', '\u1f2b', '\u0399', '\u0000', '\u1f2c', '\u0399', '\u0000', '\u1f2d', '\u0399', '\u0000', '\u1f2e', '\u0399', '\u0000', '\u1f2f', '\u0399', '\u0000', '\u1f68', '\u0399', '\u0000', '\u1f69', '\u0399', '\u0000', '\u1f6a', '\u0399', '\u0000', '\u1f6b', '\u0399', '\u0000', '\u1f6c', '\u0399', '\u0000', '\u1f6d', '\u0399', '\u0000', '\u1f6e', '\u0399', '\u0000', '\u1f6f', '\u0399', '\u0000', '\u1f68', '\u0399', '\u0000', '\u1f69', '\u0399', '\u0000', '\u1f6a', '\u0399', '\u0000', '\u1f6b', '\u0399', '\u0000', '\u1f6c', '\u0399', '\u0000', '\u1f6d', '\u0399', '\u0000', '\u1f6e', '\u0399', '\u0000', '\u1f6f', '\u0399', '\u0000', '\u1fba', '\u0399', '\u0000', '\u0391', '\u0399', '\u0000', '\u0386', '\u0399', '\u0000', '\u0391', '\u0342', '\u0000', '\u0391', '\u0342', '\u0399', '\u0391', '\u0399', '\u0000', '\u1fca', '\u0399', '\u0000', '\u0397', '\u0399', '\u0000', '\u0389', '\u0399', '\u0000', '\u0397', '\u0342', '\u0000', '\u0397', '\u0342', '\u0399', '\u0397', '\u0399', '\u0000', '\u0399', '\u0308', '\u0300', '\u0399', '\u0308', '\u0301', '\u0399', '\u0342', '\u0000', '\u0399', '\u0308', '\u0342', '\u03a5', '\u0308', '\u0300', '\u03a5', '\u0308', '\u0301', '\u03a1', '\u0313', '\u0000', '\u03a5', '\u0342', '\u0000', '\u03a5', '\u0308', '\u0342', '\u1ffa', '\u0399', '\u0000', '\u03a9', '\u0399', '\u0000', '\u038f', '\u0399', '\u0000', '\u03a9', '\u0342', '\u0000', '\u03a9', '\u0342', '\u0399', '\u03a9', '\u0399', '\u0000', 'F', 'F', '\u0000', 'F', 'I', '\u0000', 'F', 'L', '\u0000', 'F', 'F', 'I', 'F', 'F', 'L', 'S', 'T', '\u0000', 'S', 'T', '\u0000', '\u0544', '\u0546', '\u0000', '\u0544', '\u0535', '\u0000', '\u0544', '\u053b', '\u0000', '\u054e', '\u0546', '\u0000', '\u0544', '\u053d', '\u0000'};
        upperIndexs = new char[]{'\u000b', '\u0000', '\f', '\u0000', '\r', '\u0000', '\u000e', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '\u0000', '\u0000', '?', '@', 'A', '\u0000', 'B', 'C', '\u0000', '\u0000', '\u0000', '\u0000', 'D', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'E', 'F', 'G', '\u0000', 'H', 'I', '\u0000', '\u0000', '\u0000', '\u0000', 'J', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'K', 'L', '\u0000', '\u0000', 'M', 'N', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'O', 'P', 'Q', '\u0000', 'R', 'S', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'T', 'U', 'V', '\u0000', 'W', 'X', '\u0000', '\u0000', '\u0000', '\u0000', 'Y'};
        regexMetaChars = new char[]{'.', '$', '|', '(', ')', '[', ']', '{', '}', '^', '?', '*', '+', '\\'};
        serialPersistentFields = new ObjectStreamField[0];
    }

    private static class UnsafeHelpers {
        public static final long valueFieldOffset = UnsafeHelpers.getValueFieldOffset();

        private UnsafeHelpers() {
        }

        static long getValueFieldOffset() {
            try {
                return Unsafe.getUnsafe().objectFieldOffset(String.class.getDeclaredField("value"));
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class StringCompressionFlag
    implements Serializable {
        private static final long serialVersionUID = 1346155847239551492L;

        StringCompressionFlag() {
        }
    }

    private static final class CaseInsensitiveComparator
    implements Comparator<String>,
    Serializable {
        static final long serialVersionUID = 8575799808933029326L;

        private CaseInsensitiveComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    }
}

