/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom;

import java.io.IOException;

public class Cheat {
    public static byte[] convertXMLDSIGtoASN1(byte[] xmldsigBytes) throws IOException {
        int k;
        int rawLen;
        int i;
        if (xmldsigBytes.length < 48) {
            throw new IOException("Invalid XMLDSIG format of ECDSA signature");
        }
        for (i = rawLen = xmldsigBytes.length / 2; i > 0 && xmldsigBytes[rawLen - i] == 0; --i) {
        }
        int j = i;
        if (xmldsigBytes[rawLen - i] < 0) {
            ++j;
        }
        for (k = rawLen; k > 0 && xmldsigBytes[2 * rawLen - k] == 0; --k) {
        }
        int l = k;
        if (xmldsigBytes[2 * rawLen - k] < 0) {
            ++l;
        }
        byte[] asn1Bytes = new byte[6 + j + l];
        asn1Bytes[0] = 48;
        asn1Bytes[1] = (byte)(4 + j + l);
        asn1Bytes[2] = 2;
        asn1Bytes[3] = (byte)j;
        System.arraycopy(xmldsigBytes, rawLen - i, asn1Bytes, 4 + j - i, i);
        asn1Bytes[4 + j] = 2;
        asn1Bytes[5 + j] = (byte)l;
        System.arraycopy(xmldsigBytes, 2 * rawLen - k, asn1Bytes, 6 + j + l - k, k);
        return asn1Bytes;
    }
}

