/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.Security;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class Policy {
    private static Set<URI> disallowedAlgs = new HashSet<URI>();
    private static int maxTrans = Integer.MAX_VALUE;
    private static int maxRefs = Integer.MAX_VALUE;
    private static Set<String> disallowedRefUriSchemes = new HashSet<String>();
    private static Map<String, Integer> minKeyMap = new HashMap<String, Integer>();
    private static boolean noDuplicateIds = false;
    private static boolean noRMLoops = false;

    private Policy() {
    }

    private static void initialize() {
        String[] entries;
        String prop = AccessController.doPrivileged(() -> Security.getProperty("jdk.xml.dsig.secureValidationPolicy"));
        if (prop == null || prop.isEmpty()) {
            return;
        }
        block18: for (String entry : entries = prop.split(",")) {
            String type;
            String[] tokens = entry.split("\\s");
            switch (type = tokens[0]) {
                case "disallowAlg": {
                    if (tokens.length != 2) {
                        Policy.error(entry);
                    }
                    disallowedAlgs.add(URI.create(tokens[1]));
                    continue block18;
                }
                case "maxTransforms": {
                    if (tokens.length != 2) {
                        Policy.error(entry);
                    }
                    maxTrans = Integer.parseUnsignedInt(tokens[1]);
                    continue block18;
                }
                case "maxReferences": {
                    if (tokens.length != 2) {
                        Policy.error(entry);
                    }
                    maxRefs = Integer.parseUnsignedInt(tokens[1]);
                    continue block18;
                }
                case "disallowReferenceUriSchemes": {
                    if (tokens.length == 1) {
                        Policy.error(entry);
                    }
                    for (int i = 1; i < tokens.length; ++i) {
                        String scheme = tokens[i];
                        disallowedRefUriSchemes.add(scheme.toLowerCase(Locale.ROOT));
                    }
                    continue block18;
                }
                case "minKeySize": {
                    if (tokens.length != 3) {
                        Policy.error(entry);
                    }
                    minKeyMap.put(tokens[1], Integer.parseUnsignedInt(tokens[2]));
                    continue block18;
                }
                case "noDuplicateIds": {
                    if (tokens.length != 1) {
                        Policy.error(entry);
                    }
                    noDuplicateIds = true;
                    continue block18;
                }
                case "noRetrievalMethodLoops": {
                    if (tokens.length != 1) {
                        Policy.error(entry);
                    }
                    noRMLoops = true;
                    continue block18;
                }
                default: {
                    Policy.error(entry);
                }
            }
        }
    }

    public static boolean restrictAlg(String alg) {
        try {
            URI uri = new URI(alg);
            return disallowedAlgs.contains(uri);
        }
        catch (URISyntaxException use) {
            return false;
        }
    }

    public static boolean restrictNumTransforms(int numTrans) {
        return numTrans > maxTrans;
    }

    public static boolean restrictNumReferences(int numRefs) {
        return numRefs > maxRefs;
    }

    public static boolean restrictReferenceUriScheme(String uri) {
        String scheme;
        if (uri != null && (scheme = URI.create(uri).getScheme()) != null) {
            return disallowedRefUriSchemes.contains(scheme.toLowerCase(Locale.ROOT));
        }
        return false;
    }

    public static boolean restrictKey(String type, int size) {
        return size < minKeyMap.getOrDefault(type, 0);
    }

    public static boolean restrictDuplicateIds() {
        return noDuplicateIds;
    }

    public static boolean restrictRetrievalMethodLoops() {
        return noRMLoops;
    }

    public static Set<URI> disabledAlgs() {
        return Collections.unmodifiableSet(disallowedAlgs);
    }

    public static int maxTransforms() {
        return maxTrans;
    }

    public static int maxReferences() {
        return maxRefs;
    }

    public static Set<String> disabledReferenceUriSchemes() {
        return Collections.unmodifiableSet(disallowedRefUriSchemes);
    }

    public static int minKeySize(String type) {
        return minKeyMap.getOrDefault(type, 0);
    }

    private static void error(String entry) {
        throw new IllegalArgumentException("Invalid jdk.xml.dsig.secureValidationPolicy entry: " + entry);
    }

    static {
        try {
            Policy.initialize();
        }
        catch (Exception e) {
            throw new SecurityException("Cannot initialize the secure validation policy", e);
        }
    }
}

