/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.dataproviders.environment;

import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.environment.UlimitChecker;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.security.Security;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;

public class EnvironmentDataProvider {
    public static final String CAPABILITY_ULIMITS = "ulimits";
    public static final String CAPABILITY_GENERAL = "general_properties";
    public static final String CAPABILITY_SYSTEM_PROPERTIES = "system_properties";
    public static final String CAPABILITY_ENVIRONMENT_VARIABLES = "environment_variables";
    public static final String CAPABILITY_COMMAND_LINE = "command_line";
    public static final String CAPABILITY_ENVIRONMENT_SUBSYSTEM = "environment_subsystem";
    public static final String CAPABILITY_HEAP_DUMP = "capability.dump.heap";
    public static final String CAPABILITY_JAVA_DUMP = "capability.dump.java";
    public static final String CAPABILITY_SYSTEM_DUMP = "capability.dump.system";
    private static final String cacheTTL = "networkaddress.cache.ttl";
    private static final String negativeCacheTTL = "networkaddress.cache.negative.ttl";
    private static final String[] securityProps = new String[]{"networkaddress.cache.ttl", "networkaddress.cache.negative.ttl"};
    public static final String ARGUMENT_SEPARATOR = "@@@";
    private static final String NEWLINE = "\n";
    public static final String TAG = "EnvironmentSource";

    public static String getJMXData() {
        EnvironmentDataProvider eDP = new EnvironmentDataProvider();
        Properties properties = eDP.populateProperties();
        if (properties.size() > 0) {
            StringBuffer output = new StringBuffer();
            output.append("#EnvironmentSource");
            output.append(NEWLINE);
            for (String string : properties.keySet()) {
                String values = properties.getProperty(string);
                output.append(string + "=" + values);
                output.append(NEWLINE);
            }
            return output.toString();
        }
        return null;
    }

    private Properties populateProperties() {
        Properties properties = new Properties();
        this.reportCommandLine(properties);
        this.reportLauncherProperties(properties);
        this.reportSystemProperties(properties);
        this.reportEnvironmentVariables(properties);
        this.reportSecurityProperties(properties);
        this.reportUlimit(properties);
        return properties;
    }

    private void reportCommandLine(Properties properties) {
        List<String> arguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        StringBuffer flattenedList = new StringBuffer();
        Iterator<String> it = arguments.iterator();
        while (it.hasNext()) {
            flattenedList.append(it.next());
            if (!it.hasNext()) continue;
            flattenedList.append(ARGUMENT_SEPARATOR);
        }
        properties.put("command.line.arguments", flattenedList.toString());
    }

    private void reportAgentVersion(Properties properties) {
        properties.put("jar.version", "3.0.20.20210611");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportLauncherProperties(Properties properties) {
        File launcherProperties;
        this.reportAgentVersion(properties);
        properties.put("number.of.processors", String.valueOf(Runtime.getRuntime().availableProcessors()));
        properties.put("maximum.memory", String.valueOf(Runtime.getRuntime().maxMemory()));
        String javaHomeLocation = System.getProperty("java.home");
        File javaHome = new File(javaHomeLocation);
        File bin = new File(javaHome, "bin");
        if (bin.exists() && (launcherProperties = new File(bin, "launcher.properties")).exists()) {
            FileInputStream inStream = null;
            try {
                inStream = new FileInputStream(launcherProperties);
                Properties variables = new Properties();
                variables.load(inStream);
                for (Map.Entry<Object, Object> entry : variables.entrySet()) {
                    Object value = entry.getValue();
                    if (value == null) continue;
                    properties.put("launcher." + entry.getKey(), value);
                }
            }
            catch (IOException e) {
                System.out.println(e.toString());
            }
            finally {
                if (inStream != null) {
                    try {
                        ((InputStream)inStream).close();
                    }
                    catch (IOException e) {
                        System.out.println(e.toString());
                    }
                }
            }
        }
    }

    private void reportSystemProperties(Properties properties) {
        Properties systemProperties;
        int restarts = 0;
        boolean succeeded = false;
        while (!succeeded && restarts < 10) {
            systemProperties = System.getProperties();
            Iterator<Map.Entry<Object, Object>> entries = systemProperties.entrySet().iterator();
            try {
                while (entries.hasNext()) {
                    Map.Entry<Object, Object> entry = entries.next();
                    if (this.excluded(entry.getKey(), entry.getValue())) continue;
                    properties.put("system." + entry.getKey(), entry.getValue());
                }
                succeeded = true;
            }
            catch (ConcurrentModificationException e) {
                System.out.println(e.toString());
                ++restarts;
            }
        }
        if (!succeeded) {
            systemProperties = System.getProperties();
            Enumeration<Object> keys = systemProperties.keys();
            while (keys.hasMoreElements()) {
                try {
                    Object key = keys.nextElement();
                    if (this.excluded(key, systemProperties.get(key))) continue;
                    properties.put("system." + key, systemProperties.get(key));
                }
                catch (NoSuchElementException e) {
                    System.out.println(e.toString());
                }
            }
            succeeded = true;
        }
    }

    private boolean excluded(Object key, Object value) {
        if (key.toString().equals("wlp.password.encryption.key")) {
            return true;
        }
        String valueLC = value.toString().toLowerCase();
        if (valueLC.startsWith("{aes}")) {
            return true;
        }
        if (valueLC.startsWith("{xor}")) {
            return true;
        }
        return valueLC.startsWith("{hash}");
    }

    private void reportEnvironmentVariables(Properties properties) {
        Map<String, String> variables = System.getenv();
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            properties.put("environment." + entry.getKey(), entry.getValue());
        }
    }

    private void reportSecurityProperties(Properties properties) {
        for (String prop : securityProps) {
            String result = Security.getProperty(prop);
            if (result == null) {
                result = "";
            }
            properties.put("security." + prop, result);
        }
    }

    private void reportUlimit(Properties properties) {
        new UlimitChecker().writeProperties(properties);
    }
}

