/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.security.cert.AlgorithmChecker;
import com.ibm.security.cert.CertId;
import com.ibm.security.cert.CertPathSystemProperties;
import com.ibm.security.cert.OCSP;
import com.ibm.security.cert.ResponderId;
import com.ibm.security.util.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.KeyIdentifier;
import com.ibm.security.x509.PKIXExtensions;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLReason;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.Extension;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.misc.HexDumpEncoder;

public final class OCSPResponse {
    private static final ResponseStatus[] rsvalues = ResponseStatus.values();
    private static final Debug debug = Debug.getInstance((String)"certpath");
    private static final boolean dump = debug != null && Debug.isOn((String)"ocsp");
    private static final ObjectIdentifier OCSP_BASIC_RESPONSE_OID = ObjectIdentifier.newInternal((int[])new int[]{1, 3, 6, 1, 5, 5, 7, 48, 1, 1});
    private static final int CERT_STATUS_GOOD = 0;
    private static final int CERT_STATUS_REVOKED = 1;
    private static final int CERT_STATUS_UNKNOWN = 2;
    private static final int NAME_TAG = 1;
    private static final int KEY_TAG = 2;
    private static final String KP_OCSP_SIGNING_OID = "1.3.6.1.5.5.7.3.9";
    private static final int DEFAULT_MAX_CLOCK_SKEW = 900000;
    private static final int MAX_CLOCK_SKEW = OCSPResponse.initializeClockSkew();
    private static final CRLReason[] values = CRLReason.values();
    private final ResponseStatus responseStatus;
    private final Map<CertId, SingleResponse> singleResponseMap;
    private final AlgorithmId sigAlgId;
    private final byte[] signature;
    private final byte[] tbsResponseData;
    private final byte[] responseNonce;
    private List<X509CertImpl> certs;
    private X509CertImpl signerCert = null;
    private final ResponderId respId;
    private Date producedAtDate = null;
    private final Map<String, Extension> responseExtensions;

    private static int initializeClockSkew() {
        int tmp = CertPathSystemProperties.getOCSPClockSkew();
        if (debug != null) {
            System.out.println("OCSPResponse.java:  initializeClockSkew( ):  The OCSP CLOCK SKEW value to be used (millisecs) will be:  " + tmp);
        }
        return tmp;
    }

    public OCSPResponse(byte[] bytes) throws IOException {
        if (dump) {
            HexDumpEncoder hexEnc = new HexDumpEncoder();
            debug.println("OCSPResponse bytes...\n\n" + hexEnc.encode(bytes) + "\n");
        }
        DerValue der = new DerValue(bytes);
        if (der.tag != 48) {
            throw new IOException("Bad encoding in OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        DerInputStream derIn = der.getData();
        int status = derIn.getEnumerated().intValue();
        if (status < 0 || status >= rsvalues.length) {
            throw new IOException("Unknown OCSPResponse status: " + status);
        }
        this.responseStatus = rsvalues[status];
        if (debug != null) {
            debug.println("OCSP response status: " + (Object)((Object)this.responseStatus));
        }
        if (this.responseStatus != ResponseStatus.SUCCESSFUL) {
            this.singleResponseMap = Collections.emptyMap();
            this.certs = new ArrayList<X509CertImpl>();
            this.sigAlgId = null;
            this.signature = null;
            this.tbsResponseData = null;
            this.responseNonce = null;
            this.responseExtensions = Collections.emptyMap();
            this.respId = null;
            return;
        }
        der = derIn.getDerValue();
        if (!der.isContextSpecific((byte)0)) {
            throw new IOException("Bad encoding in responseBytes element of OCSP response: expected ASN.1 context specific tag 0.");
        }
        DerValue tmp = der.data.getDerValue();
        if (tmp.tag != 48) {
            throw new IOException("Bad encoding in responseBytes element of OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        derIn = tmp.data;
        ObjectIdentifier responseType = derIn.getOID();
        if (responseType.equals((Object)OCSP_BASIC_RESPONSE_OID)) {
            if (debug != null) {
                debug.println("OCSP response type: basic");
            }
        } else {
            if (debug != null) {
                debug.println("OCSP response type: " + responseType);
            }
            throw new IOException("Unsupported OCSP response type: " + responseType);
        }
        DerInputStream basicOCSPResponse = new DerInputStream(derIn.getOctetString());
        DerValue[] seqTmp = basicOCSPResponse.getSequence(3);
        if (seqTmp.length < 3) {
            throw new IOException("Unexpected BasicOCSPResponse value");
        }
        DerValue responseData = seqTmp[0];
        this.tbsResponseData = seqTmp[0].toByteArray();
        if (responseData.tag != 48) {
            throw new IOException("Bad encoding in tbsResponseData element of OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        DerInputStream seqDerIn = responseData.data;
        DerValue seq = seqDerIn.getDerValue();
        if (seq.isContextSpecific((byte)0) && seq.isConstructed() && seq.isContextSpecific()) {
            seq = seq.data.getDerValue();
            int version = seq.getInteger().intValue();
            if (seq.data.available() != 0) {
                throw new IOException("Bad encoding in version  element of OCSP response: bad format");
            }
            seq = seqDerIn.getDerValue();
        }
        this.respId = new ResponderId(seq.toByteArray());
        if (debug != null) {
            debug.println("Responder ID: " + this.respId);
        }
        seq = seqDerIn.getDerValue();
        this.producedAtDate = seq.getGeneralizedTime();
        if (debug != null) {
            debug.println("OCSP response produced at: " + this.producedAtDate);
        }
        DerValue[] singleResponseDer = seqDerIn.getSequence(1);
        this.singleResponseMap = new HashMap<CertId, SingleResponse>(singleResponseDer.length);
        if (debug != null) {
            debug.println("OCSP number of SingleResponses: " + singleResponseDer.length);
        }
        for (DerValue srDer : singleResponseDer) {
            SingleResponse singleResponse = new SingleResponse(srDer);
            this.singleResponseMap.put(singleResponse.getCertId(), singleResponse);
        }
        Map<String, Extension> tmpExtMap = new HashMap<String, Extension>();
        if (seqDerIn.available() > 0 && (seq = seqDerIn.getDerValue()).isContextSpecific((byte)1)) {
            tmpExtMap = OCSPResponse.parseExtensions(seq);
        }
        this.responseExtensions = tmpExtMap;
        com.ibm.security.x509.Extension nonceExt = (com.ibm.security.x509.Extension)tmpExtMap.get(PKIXExtensions.OCSPNonce_Id.toString());
        byte[] byArray = this.responseNonce = nonceExt != null ? nonceExt.getExtensionValue() : null;
        if (debug != null && this.responseNonce != null) {
            debug.println("Response nonce: " + Arrays.toString(this.responseNonce));
        }
        this.sigAlgId = AlgorithmId.parse((DerValue)seqTmp[1]);
        this.signature = seqTmp[2].getBitString();
        if (seqTmp.length > 3) {
            DerValue seqCert = seqTmp[3];
            if (!seqCert.isContextSpecific((byte)0)) {
                throw new IOException("Bad encoding in certs element of OCSP response: expected ASN.1 context specific tag 0.");
            }
            DerValue[] derCerts = seqCert.getData().getSequence(3);
            this.certs = new ArrayList<X509CertImpl>(derCerts.length);
            try {
                for (int i = 0; i < derCerts.length; ++i) {
                    X509CertImpl cert = new X509CertImpl(derCerts[i].toByteArray());
                    this.certs.add(cert);
                    if (debug == null) continue;
                    debug.println("OCSP response cert #" + (i + 1) + ": " + cert.getSubjectX500Principal());
                }
            }
            catch (CertificateException ce) {
                throw new IOException("Bad encoding in X509 Certificate", ce);
            }
        } else {
            this.certs = new ArrayList<X509CertImpl>();
        }
    }

    void verify(List<CertId> certIds, IssuerInfo issuerInfo, X509Certificate responderCert, Date date, byte[] nonce, String variant) throws CertPathValidatorException {
        switch (this.responseStatus) {
            case SUCCESSFUL: {
                break;
            }
            case TRY_LATER: 
            case INTERNAL_ERROR: {
                throw new CertPathValidatorException("OCSP response error: " + (Object)((Object)this.responseStatus), null, null, -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
            }
            default: {
                throw new CertPathValidatorException("OCSP response error: " + (Object)((Object)this.responseStatus));
            }
        }
        for (CertId certId : certIds) {
            SingleResponse sr = this.getSingleResponse(certId);
            if (sr == null) {
                if (debug != null) {
                    debug.println("No response found for CertId: " + certId);
                }
                throw new CertPathValidatorException("OCSP response does not include a response for a certificate supplied in the OCSP request");
            }
            if (debug == null) continue;
            debug.println("Status of certificate (with serial number " + certId.getSerialNumber() + ") is: " + (Object)((Object)sr.getCertStatus()));
        }
        if (debug != null) {
            System.out.println("VVVVVVVVVVVVVVVVVVVVVVVVVVVVVV  BEGINS HERE  VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV");
            System.out.println("OCSPResponse.java:  verify():  Trying to locate the signer cert returned by the Responder");
        }
        if (this.signerCert == null) {
            if (debug != null) {
                System.out.println("OCSPResponse.java:  verify():  The signerCert was found to be NULL, so let's find it");
                if (responderCert == null) {
                    System.out.println("OCSPResponse.java:  verify():  The responderCert is NULL");
                }
                if (issuerInfo.getCertificate() == null) {
                    System.out.println("OCSPResponse.java:  verify():  The issuerInfo.getCertificate() is NULL");
                }
            }
            try {
                if (issuerInfo.getCertificate() != null) {
                    this.certs.add(X509CertImpl.toImpl((X509Certificate)issuerInfo.getCertificate()));
                    if (debug != null) {
                        System.out.println("OCSPResponse.java:  verify():  Added the issuerInfo.getCertificate() to the 'certs' collection.");
                        System.out.println("                                      That cert was:                                                  ");
                        System.out.println(issuerInfo.getCertificate().toString());
                    }
                }
                if (responderCert != null) {
                    this.certs.add(X509CertImpl.toImpl((X509Certificate)responderCert));
                    if (debug != null) {
                        System.out.println("OCSPResponse.java:  verify():  Added the responderCert to the 'certs' collection.");
                        System.out.println("                                      That cert was:                                                  ");
                        System.out.println(responderCert.toString());
                    }
                } else if (debug != null) {
                    System.out.println("OCSPResponse.java:  verify():  The responderCert is NULL.  Not adding it to the 'certs' collection.");
                }
            }
            catch (CertificateException ce) {
                throw new CertPathValidatorException("Invalid issuer or trusted responder certificate", ce);
            }
            if (debug != null) {
                System.out.println("OCSPResponse.java:  The total number of certs in the 'certs' collection is:  " + this.certs.size());
            }
            if (this.respId.getType() == ResponderId.Type.BY_NAME) {
                if (debug != null) {
                    System.out.println("OCSPResponse.java:  if respId.getType() == ResponderId.Type.BY_NAME   PATH TAKEN");
                }
                X500Principal rName = this.respId.getResponderName();
                if (debug != null) {
                    System.out.println("OCSPResponse.java:  For each cert in the 'certs' collection, does it carry a SubjectX500Principal equal to:  " + rName.toString());
                }
                for (X509CertImpl cert : this.certs) {
                    if (!cert.getSubjectX500Principal().equals(rName)) continue;
                    this.signerCert = cert;
                    if (debug == null) break;
                    System.out.println("OCSPResponse.java:  Yes, the following cert was found that carries a SubjectX500Principal equal to:  " + rName.toString());
                    System.out.println(this.signerCert.toString());
                    break;
                }
            } else if (this.respId.getType() == ResponderId.Type.BY_KEY) {
                if (debug != null) {
                    System.out.println("OCSPResponse.java:  else if respId.getType() == ResponderId.Type.BY_KEY   PATH TAKEN");
                }
                KeyIdentifier ridKeyId = this.respId.getKeyIdentifier();
                if (debug != null) {
                    System.out.println("OCSPResponse.java:  For each cert in the 'certs' collection, does it carry a KeyIdentifier equal to that of the Reponder's KeyIndetifier which is:  " + ridKeyId.toString());
                }
                for (X509CertImpl cert : this.certs) {
                    KeyIdentifier certKeyId = new KeyIdentifier(cert.getSubjectKeyIdentifier());
                    if (debug != null) {
                        if (certKeyId == null) {
                            System.out.println("OCSPResponse.java:  The KeyIdentifier taken from the next 'cert' in the collection is NULL !!!!!!!!!!!!!!!!!!!!!!!!!!!");
                        } else {
                            System.out.println("OCSPResponse.java:  The KeyIdentifier taken from the next 'cert' in the collection is:  " + certKeyId.toString());
                            System.out.println("OCSPResponse.java:  Does this match the KeyIdentifier taken from ridKeyId:              " + ridKeyId.toString());
                        }
                        System.out.println("OCSPResponse.java:  certKeyId is: \n" + OCSPResponse.toHexString(certKeyId.getIdentifier()));
                        System.out.println("OCSPResponse.java:  ridKeyId is:  \n" + OCSPResponse.toHexString(ridKeyId.getIdentifier()));
                        System.out.println("OCSPResponse.java:  DO THEY MATCH ? ");
                    }
                    if (certKeyId != null && ridKeyId.equals((Object)certKeyId)) {
                        if (debug != null) {
                            System.out.println("OCSPResponse.java:  Yes, the KeyIdentifier of this 'cert' from the collection matches the KeyIdentifier of responder");
                            System.out.println("                    Therefore, the signerCert has been found and is no longer NULL");
                        }
                        this.signerCert = cert;
                        break;
                    }
                    try {
                        certKeyId = new KeyIdentifier(cert.getPublicKey());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (!ridKeyId.equals((Object)certKeyId)) continue;
                    if (debug != null) {
                        System.out.println("OCSPResponse.java:  Yes, a newly generated KeyIdentifier for this 'cert' in the collection is equal to that of the Reponder's KeyIdentifiere which is:  " + ridKeyId.toString());
                        System.out.println("                    Therefore, the signerCert has been found and is no longer NULL");
                    }
                    this.signerCert = cert;
                    break;
                }
            }
        }
        if (debug != null) {
            System.out.println("OCSPResponse.java:  verify():  By now the signerCert should have been found.  WAS IT ?");
        }
        if (this.signerCert != null) {
            if (debug != null) {
                System.out.println("OCSPResponse.java:  verify():  The signerCert was found.  It is no longer NULL");
                System.out.println("OCSPResponse.java:  verify():  Verifying whether the signerCert is trusted.");
            }
            if (this.signerCert.getSubjectX500Principal().equals(issuerInfo.getName()) && this.signerCert.getPublicKey().equals(issuerInfo.getPublicKey())) {
                if (debug != null) {
                    debug.println("OCSP response is signed by the target's Issuing CA");
                }
            } else if (this.signerCert.equals((Object)responderCert)) {
                if (debug != null) {
                    debug.println("OCSP response is signed by a Trusted Responder");
                }
            } else if (this.signerCert.getIssuerX500Principal().equals(issuerInfo.getName())) {
                try {
                    List keyPurposes = this.signerCert.getExtendedKeyUsage();
                    if (keyPurposes == null || !keyPurposes.contains(KP_OCSP_SIGNING_OID)) {
                        throw new CertPathValidatorException("Responder's certificate not valid for signing OCSP responses");
                    }
                }
                catch (CertificateParsingException cpe) {
                    throw new CertPathValidatorException("Responder's certificate not valid for signing OCSP responses", cpe);
                }
                AlgorithmChecker algChecker = new AlgorithmChecker(issuerInfo.getAnchor(), date, variant);
                algChecker.init(false);
                algChecker.check((Certificate)this.signerCert, Collections.emptySet());
                try {
                    if (date == null) {
                        this.signerCert.checkValidity();
                    } else {
                        this.signerCert.checkValidity(date);
                    }
                }
                catch (CertificateException certificateException) {
                    throw new CertPathValidatorException("Responder's certificate not within the validity period", certificateException);
                }
                com.ibm.security.x509.Extension extension = this.signerCert.getExtension(PKIXExtensions.OCSPNoCheck_Id);
                if (extension != null && debug != null) {
                    debug.println("Responder's certificate includes the extension id-pkix-ocsp-nocheck.");
                }
                try {
                    this.signerCert.verify(issuerInfo.getPublicKey());
                    if (debug != null) {
                        debug.println("OCSP response is signed by an Authorized Responder");
                    }
                }
                catch (GeneralSecurityException e) {
                    this.signerCert = null;
                }
            } else {
                throw new CertPathValidatorException("Responder's certificate is not authorized to sign OCSP responses");
            }
        }
        if (debug != null) {
            System.out.println("=============================================================================");
            System.out.println("OCSPResponse.java:  verify():  Now verify the signature on the OCSP response");
        }
        if (this.signerCert != null) {
            if (debug != null) {
                System.out.println("OCSPResponse.java:  verify():  The signerCert is NOT NULL");
            }
            AlgorithmChecker.check(this.signerCert.getPublicKey(), this.sigAlgId, variant, issuerInfo.getAnchor());
            if (debug != null) {
                System.out.println("OCSPResponse.java:  verify():  AlgorithmChecker.check() did not throw an exception");
                System.out.println("OCSPResponse.java:  verify():  Calling verifySignature() next");
            }
            if (!this.verifySignature((X509Certificate)this.signerCert)) {
                throw new CertPathValidatorException("Error verifying OCSP Response's signature");
            }
        } else {
            if (debug != null) {
                System.out.println("OCSPResponse.java:  verify():  The signerCert is NULL.  A CertPathValidatorExcepton will be thrown.");
            }
            throw new CertPathValidatorException("Unable to verify OCSP Response's signature");
        }
        if (nonce != null && this.responseNonce != null && !Arrays.equals(nonce, this.responseNonce)) {
            throw new CertPathValidatorException("Nonces don't match");
        }
        long now = date == null ? System.currentTimeMillis() : date.getTime();
        Date nowPlusSkew = new Date(now + (long)MAX_CLOCK_SKEW);
        Date nowMinusSkew = new Date(now - (long)MAX_CLOCK_SKEW);
        for (SingleResponse sr : this.singleResponseMap.values()) {
            if (debug != null) {
                String until = "";
                if (sr.nextUpdate != null) {
                    until = " until " + sr.nextUpdate;
                }
                debug.println("OCSP response validity interval is from " + sr.thisUpdate + until);
                debug.println("Checking validity of OCSP response on: " + new Date(now));
            }
            if (!nowPlusSkew.before(sr.thisUpdate) && !nowMinusSkew.after(sr.nextUpdate != null ? sr.nextUpdate : sr.thisUpdate)) continue;
            throw new CertPathValidatorException("Response is unreliable: its validity interval is out-of-date");
        }
    }

    public ResponseStatus getResponseStatus() {
        return this.responseStatus;
    }

    private boolean verifySignature(X509Certificate cert) throws CertPathValidatorException {
        try {
            Signature respSignature = Signature.getInstance(this.sigAlgId.getName());
            respSignature.initVerify(cert.getPublicKey());
            respSignature.update(this.tbsResponseData);
            if (respSignature.verify(this.signature)) {
                if (debug != null) {
                    debug.println("Verified signature of OCSP Response");
                }
                return true;
            }
            if (debug != null) {
                debug.println("Error verifying signature of OCSP Response");
            }
            return false;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new CertPathValidatorException(e);
        }
    }

    public SingleResponse getSingleResponse(CertId certId) {
        return this.singleResponseMap.get(certId);
    }

    public Set<CertId> getCertIds() {
        return Collections.unmodifiableSet(this.singleResponseMap.keySet());
    }

    X509Certificate getSignerCertificate() {
        return this.signerCert;
    }

    public ResponderId getResponderId() {
        return this.respId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OCSP Response:\n");
        sb.append("Response Status: ").append((Object)this.responseStatus).append("\n");
        sb.append("Responder ID: ").append(this.respId).append("\n");
        sb.append("Produced at: ").append(this.producedAtDate).append("\n");
        int count = this.singleResponseMap.size();
        sb.append(count).append(count == 1 ? " response:\n" : " responses:\n");
        for (SingleResponse sr : this.singleResponseMap.values()) {
            sb.append(sr).append("\n");
        }
        if (this.responseExtensions != null && this.responseExtensions.size() > 0) {
            count = this.responseExtensions.size();
            sb.append(count).append(count == 1 ? " extension:\n" : " extensions:\n");
            for (String extId : this.responseExtensions.keySet()) {
                sb.append(this.responseExtensions.get(extId)).append("\n");
            }
        }
        return sb.toString();
    }

    private static Map<String, Extension> parseExtensions(DerValue derVal) throws IOException {
        DerValue[] extDer = derVal.data.getSequence(3);
        HashMap<String, Extension> extMap = new HashMap<String, Extension>(extDer.length);
        for (DerValue extDerVal : extDer) {
            com.ibm.security.x509.Extension ext = new com.ibm.security.x509.Extension(extDerVal);
            if (debug != null) {
                debug.println("Extension: " + ext);
            }
            if (ext.isCritical()) {
                throw new IOException("Unsupported OCSP critical extension: " + ext.getExtensionId());
            }
            extMap.put(ext.getId(), (Extension)ext);
        }
        return extMap;
    }

    public static String toHexString(byte[] block) {
        StringBuffer buf = new StringBuffer();
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int len = block.length;
        int high = 0;
        int low = 0;
        for (int i = 0; i < len; ++i) {
            if (i % 16 == 0) {
                buf.append('\n');
            }
            high = (block[i] & 0xF0) >> 4;
            low = block[i] & 0xF;
            buf.append(hexChars[high]);
            buf.append(hexChars[low]);
            buf.append(' ');
        }
        return buf.toString();
    }

    static final class IssuerInfo {
        private final TrustAnchor anchor;
        private final X509Certificate certificate;
        private final X500Principal name;
        private final PublicKey pubKey;

        IssuerInfo(TrustAnchor anchor) {
            this(anchor, anchor != null ? anchor.getTrustedCert() : null);
        }

        IssuerInfo(X509Certificate issuerCert) {
            this(null, issuerCert);
        }

        IssuerInfo(TrustAnchor anchor, X509Certificate issuerCert) {
            if (anchor == null && issuerCert == null) {
                throw new NullPointerException("TrustAnchor and issuerCert cannot be null");
            }
            this.anchor = anchor;
            if (issuerCert != null) {
                this.name = issuerCert.getSubjectX500Principal();
                this.pubKey = issuerCert.getPublicKey();
                this.certificate = issuerCert;
            } else {
                this.name = anchor.getCA();
                this.pubKey = anchor.getCAPublicKey();
                this.certificate = anchor.getTrustedCert();
            }
        }

        X509Certificate getCertificate() {
            return this.certificate;
        }

        X500Principal getName() {
            return this.name;
        }

        PublicKey getPublicKey() {
            return this.pubKey;
        }

        TrustAnchor getAnchor() {
            return this.anchor;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Issuer Info:\n");
            sb.append("Name: ").append(this.name.toString()).append("\n");
            sb.append("Public Key:\n").append(this.pubKey.toString()).append("\n");
            return sb.toString();
        }
    }

    public static final class SingleResponse
    implements OCSP.RevocationStatus {
        private final CertId certId;
        private final OCSP.RevocationStatus.CertStatus certStatus;
        private final Date thisUpdate;
        private final Date nextUpdate;
        private final Date revocationTime;
        private final CRLReason revocationReason;
        private final Map<String, Extension> singleExtensions;

        private SingleResponse(DerValue der) throws IOException {
            if (der.tag != 48) {
                throw new IOException("Bad ASN.1 encoding in SingleResponse");
            }
            DerInputStream tmp = der.data;
            this.certId = new CertId(tmp.getDerValue().data);
            DerValue derVal = tmp.getDerValue();
            short tag = (byte)(derVal.tag & 0x1F);
            if (tag == 1) {
                this.certStatus = OCSP.RevocationStatus.CertStatus.REVOKED;
                this.revocationTime = derVal.data.getGeneralizedTime();
                if (derVal.data.available() != 0) {
                    int reason;
                    DerValue dv = derVal.data.getDerValue();
                    tag = (byte)(dv.tag & 0x1F);
                    this.revocationReason = tag == 0 ? ((reason = dv.data.getEnumerated().intValue()) >= 0 && reason < values.length ? values[reason] : CRLReason.UNSPECIFIED) : CRLReason.UNSPECIFIED;
                } else {
                    this.revocationReason = CRLReason.UNSPECIFIED;
                }
                if (debug != null) {
                    debug.println("Revocation time: " + this.revocationTime);
                    debug.println("Revocation reason: " + (Object)((Object)this.revocationReason));
                }
            } else {
                this.revocationTime = null;
                this.revocationReason = null;
                if (tag == 0) {
                    this.certStatus = OCSP.RevocationStatus.CertStatus.GOOD;
                } else if (tag == 2) {
                    this.certStatus = OCSP.RevocationStatus.CertStatus.UNKNOWN;
                } else {
                    throw new IOException("Invalid certificate status");
                }
            }
            this.thisUpdate = tmp.getGeneralizedTime();
            if (debug != null) {
                debug.println("thisUpdate: " + this.thisUpdate);
            }
            Date tmpNextUpdate = null;
            Map tmpMap = null;
            if (tmp.available() > 0) {
                derVal = tmp.getDerValue();
                if (derVal.isContextSpecific((byte)0)) {
                    tmpNextUpdate = derVal.data.getGeneralizedTime();
                    if (debug != null) {
                        debug.println("nextUpdate: " + tmpNextUpdate);
                    }
                    DerValue derValue = derVal = tmp.available() > 0 ? tmp.getDerValue() : null;
                }
                if (derVal != null) {
                    if (derVal.isContextSpecific((byte)1)) {
                        tmpMap = OCSPResponse.parseExtensions(derVal);
                        if (tmp.available() > 0) {
                            throw new IOException(tmp.available() + " bytes of additional data in singleResponse");
                        }
                    } else {
                        throw new IOException("Unsupported singleResponse item, tag = " + String.format("%02X", derVal.tag));
                    }
                }
            }
            this.nextUpdate = tmpNextUpdate;
            Map<String, Extension> map = this.singleExtensions = tmpMap != null ? tmpMap : Collections.emptyMap();
            if (debug != null) {
                for (Extension ext : this.singleExtensions.values()) {
                    debug.println("singleExtension: " + ext);
                }
            }
        }

        @Override
        public OCSP.RevocationStatus.CertStatus getCertStatus() {
            return this.certStatus;
        }

        public CertId getCertId() {
            return this.certId;
        }

        public Date getThisUpdate() {
            return this.thisUpdate != null ? (Date)this.thisUpdate.clone() : null;
        }

        public Date getNextUpdate() {
            return this.nextUpdate != null ? (Date)this.nextUpdate.clone() : null;
        }

        @Override
        public Date getRevocationTime() {
            return this.revocationTime != null ? (Date)this.revocationTime.clone() : null;
        }

        @Override
        public CRLReason getRevocationReason() {
            return this.revocationReason;
        }

        @Override
        public Map<String, Extension> getSingleExtensions() {
            return Collections.unmodifiableMap(this.singleExtensions);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("SingleResponse:\n");
            sb.append(this.certId);
            sb.append("\nCertStatus: ").append((Object)this.certStatus).append("\n");
            if (this.certStatus == OCSP.RevocationStatus.CertStatus.REVOKED) {
                sb.append("revocationTime is ");
                sb.append(this.revocationTime).append("\n");
                sb.append("revocationReason is ");
                sb.append((Object)this.revocationReason).append("\n");
            }
            sb.append("thisUpdate is ").append(this.thisUpdate).append("\n");
            if (this.nextUpdate != null) {
                sb.append("nextUpdate is ").append(this.nextUpdate).append("\n");
            }
            for (Extension ext : this.singleExtensions.values()) {
                sb.append("singleExtension: ");
                sb.append(ext.toString()).append("\n");
            }
            return sb.toString();
        }
    }

    public static enum ResponseStatus {
        SUCCESSFUL,
        MALFORMED_REQUEST,
        INTERNAL_ERROR,
        TRY_LATER,
        UNUSED,
        SIG_REQUIRED,
        UNAUTHORIZED;

    }
}

