/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.US_ASCII;
import sun.nio.cs.ext.DoubleByte;
import sun.nio.cs.ext.EUC_CN;
import sun.nio.cs.ext.EUC_TW;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.ISO2022;

public class ISO2022_CN
extends Charset
implements HistoricallyNamedCharset {
    private static final byte ISO_ESC = 27;
    private static final byte ISO_SI = 15;
    private static final byte ISO_SO = 14;
    private static final byte ISO_SS2_7 = 78;
    private static final byte ISO_SS3_7 = 79;
    private static final byte MSB = -128;
    private static final char REPLACE_CHAR = '\ufffd';
    private static final byte SODesigGB = 0;
    private static final byte SODesigCNS = 1;

    public ISO2022_CN() {
        super("ISO-2022-CN", ExtendedCharsets.aliasesFor("ISO-2022-CN"));
    }

    @Override
    public String historicalName() {
        return "ISO2022CN";
    }

    @Override
    public boolean contains(Charset charset) {
        return charset instanceof EUC_CN || charset instanceof US_ASCII || charset instanceof EUC_TW || charset instanceof ISO2022_CN;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Encoder
    extends ISO2022.Encoder {
        public Encoder(Charset charset) {
            super(charset, "CN");
        }
    }

    static class Decoder
    extends CharsetDecoder {
        private boolean shiftOut = false;
        private byte currentSODesig = 0;
        private static final Charset gb2312 = new EUC_CN();
        private static final Charset cns = new EUC_TW();
        private final DoubleByte.Decoder gb2312Decoder = (DoubleByte.Decoder)gb2312.newDecoder();
        private final EUC_TW.Decoder cnsDecoder = (EUC_TW.Decoder)cns.newDecoder();

        Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        @Override
        protected void implReset() {
            this.shiftOut = false;
            this.currentSODesig = 0;
        }

        private char cnsDecode(byte by, byte by2, byte by3) {
            by = (byte)(by | 0xFFFFFF80);
            by2 = (byte)(by2 | 0xFFFFFF80);
            int n = 0;
            if (by3 == 78) {
                n = 1;
            } else if (by3 == 79) {
                n = 2;
            } else {
                return '\ufffd';
            }
            char[] cArray = this.cnsDecoder.toUnicode(by & 0xFF, by2 & 0xFF, n);
            if (cArray == null || cArray.length == 2) {
                return '\ufffd';
            }
            return cArray[0];
        }

        private char SODecode(byte by, byte by2, byte by3) {
            by = (byte)(by | 0xFFFFFF80);
            by2 = (byte)(by2 | 0xFFFFFF80);
            if (by3 == 0) {
                return this.gb2312Decoder.decodeDouble(by & 0xFF, by2 & 0xFF);
            }
            char[] cArray = this.cnsDecoder.toUnicode(by & 0xFF, by2 & 0xFF, 0);
            if (cArray == null) {
                return '\ufffd';
            }
            return cArray[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private CoderResult decodeBufferLoop(ByteBuffer var1_1, CharBuffer var2_2) {
            var3_3 = var1_1.position();
            var4_4 = 0;
            var5_5 = 0;
            var6_6 = 0;
            var7_7 = 0;
            var8_8 = 0;
            var9_9 = '\ufffd';
            try {
                while (var1_1.hasRemaining()) {
                    var4_4 = var1_1.get();
                    var8_8 = 1;
                    while (var4_4 == 27 || var4_4 == 14 || var4_4 == 15) {
                        block55: {
                            block54: {
                                if (var4_4 != 27) ** GOTO lbl90
                                if (var1_1.remaining() < 1) {
                                    var10_10 = CoderResult.UNDERFLOW;
                                    return var10_10;
                                }
                                var5_5 = var1_1.get();
                                ++var8_8;
                                if ((var5_5 & -128) != 0) {
                                    var10_11 = CoderResult.malformedForLength(var8_8);
                                    return var10_11;
                                }
                                if (var5_5 != 36) ** GOTO lbl71
                                if (var1_1.remaining() < 1) {
                                    var10_12 = CoderResult.UNDERFLOW;
                                    return var10_12;
                                }
                                var6_6 = var1_1.get();
                                ++var8_8;
                                if ((var6_6 & -128) != 0) {
                                    var10_13 = CoderResult.malformedForLength(var8_8);
                                    return var10_13;
                                }
                                if (var6_6 != 65) break block54;
                                this.currentSODesig = 0;
                                break block55;
                            }
                            if (var6_6 != 41) ** GOTO lbl49
                            if (var1_1.remaining() < 1) {
                                var10_14 = CoderResult.UNDERFLOW;
                                return var10_14;
                            }
                            var7_7 = var1_1.get();
                            ++var8_8;
                            if (var7_7 == 65) {
                                this.currentSODesig = 0;
                            } else if (var7_7 == 71) {
                                this.currentSODesig = 1;
                            } else {
                                var10_15 = CoderResult.malformedForLength(var8_8);
                                return var10_15;
lbl49:
                                // 1 sources

                                if (var6_6 == 42) {
                                    if (var1_1.remaining() < 1) {
                                        var10_16 = CoderResult.UNDERFLOW;
                                        return var10_16;
                                    }
                                    var7_7 = var1_1.get();
                                    ++var8_8;
                                    if (var7_7 != 72) {
                                        var10_17 = CoderResult.malformedForLength(var8_8);
                                        return var10_17;
                                    }
                                } else if (var6_6 == 43) {
                                    if (var1_1.remaining() < 1) {
                                        var10_18 = CoderResult.UNDERFLOW;
                                        return var10_18;
                                    }
                                    var7_7 = var1_1.get();
                                    ++var8_8;
                                    if (var7_7 != 73) {
                                        var10_19 = CoderResult.malformedForLength(var8_8);
                                        return var10_19;
                                    }
                                } else {
                                    var10_20 = CoderResult.malformedForLength(var8_8);
                                    return var10_20;
lbl71:
                                    // 1 sources

                                    if (var5_5 == 78 || var5_5 == 79) {
                                        if (var1_1.remaining() < 2) {
                                            var10_21 = CoderResult.UNDERFLOW;
                                            return var10_21;
                                        }
                                        var6_6 = var1_1.get();
                                        var7_7 = var1_1.get();
                                        var8_8 += 2;
                                        if (var2_2.remaining() < 1) {
                                            var10_22 = CoderResult.OVERFLOW;
                                            return var10_22;
                                        }
                                        var9_9 = this.cnsDecode(var6_6, var7_7, var5_5);
                                        if (var9_9 == '\ufffd') {
                                            var10_23 = CoderResult.unmappableForLength(var8_8);
                                            return var10_23;
                                        }
                                        var2_2.put(var9_9);
                                    } else {
                                        var10_24 = CoderResult.malformedForLength(var8_8);
                                        return var10_24;
lbl90:
                                        // 1 sources

                                        if (var4_4 == 14) {
                                            this.shiftOut = true;
                                        } else if (var4_4 == 15) {
                                            this.shiftOut = false;
                                        }
                                    }
                                }
                            }
                        }
                        var3_3 += var8_8;
                        if (var1_1.remaining() < 1) {
                            var10_25 = CoderResult.UNDERFLOW;
                            return var10_25;
                        }
                        var4_4 = var1_1.get();
                        var8_8 = 1;
                    }
                    if (var2_2.remaining() < 1) {
                        var10_26 = CoderResult.OVERFLOW;
                        return var10_26;
                    }
                    if (!this.shiftOut) {
                        var2_2.put((char)(var4_4 & 255));
                        var3_3 += var8_8;
                        continue;
                    }
                    if (var1_1.remaining() < 1) {
                        var10_27 = CoderResult.UNDERFLOW;
                        return var10_27;
                    }
                    var5_5 = var1_1.get();
                    ++var8_8;
                    var9_9 = this.SODecode(var4_4, var5_5, this.currentSODesig);
                    if (var9_9 == '\ufffd') {
                        var10_28 = CoderResult.unmappableForLength(var8_8);
                        return var10_28;
                    }
                    var2_2.put(var9_9);
                    var3_3 += var8_8;
                }
                var10_29 = CoderResult.UNDERFLOW;
                return var10_29;
            }
            finally {
                var1_1.position(var3_3);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private CoderResult decodeArrayLoop(ByteBuffer var1_1, CharBuffer var2_2) {
            var3_3 = 0;
            var4_4 = 0;
            var5_5 = 0;
            var6_6 = 0;
            var7_7 = 0;
            var8_8 = 65533;
            var9_9 = var1_1.array();
            var10_10 = var1_1.arrayOffset() + var1_1.position();
            var11_11 = var1_1.arrayOffset() + var1_1.limit();
            if (!Decoder.$assertionsDisabled && var10_10 > var11_11) {
                throw new AssertionError();
            }
            var12_12 = var2_2.array();
            var13_13 = var2_2.arrayOffset() + var2_2.position();
            var14_14 = var2_2.arrayOffset() + var2_2.limit();
            if (!Decoder.$assertionsDisabled && var13_13 > var14_14) {
                throw new AssertionError();
            }
            var13_13 = var13_13 <= var14_14 ? var13_13 : var14_14;
            try {
                for (var10_10 = var10_10 <= var11_11 ? var10_10 : var11_11; var10_10 < var11_11; var10_10 += var3_3) {
                    var4_4 = var9_9[var10_10];
                    var3_3 = 1;
                    while (var4_4 == 27 || var4_4 == 14 || var4_4 == 15) {
                        block57: {
                            block56: {
                                if (var4_4 != 27) ** GOTO lbl99
                                if (var10_10 + 2 > var11_11) {
                                    var15_15 = CoderResult.UNDERFLOW;
                                    return var15_15;
                                }
                                var5_5 = var9_9[var10_10 + 1];
                                ++var3_3;
                                if ((var5_5 & -128) != 0) {
                                    var15_16 = CoderResult.malformedForLength(var3_3);
                                    return var15_16;
                                }
                                if (var5_5 != 36) ** GOTO lbl81
                                if (var10_10 + 3 > var11_11) {
                                    var15_17 = CoderResult.UNDERFLOW;
                                    return var15_17;
                                }
                                var6_6 = var9_9[var10_10 + 2];
                                ++var3_3;
                                if ((var6_6 & -128) != 0) {
                                    var15_18 = CoderResult.malformedForLength(var3_3);
                                    return var15_18;
                                }
                                if (var6_6 != 65) break block56;
                                this.currentSODesig = 0;
                                break block57;
                            }
                            if (var6_6 != 41) ** GOTO lbl59
                            if (var10_10 + 4 > var11_11) {
                                var15_19 = CoderResult.UNDERFLOW;
                                return var15_19;
                            }
                            var7_7 = var9_9[var10_10 + 3];
                            ++var3_3;
                            if (var7_7 == 65) {
                                this.currentSODesig = 0;
                            } else if (var7_7 == 71) {
                                this.currentSODesig = 1;
                            } else {
                                var15_20 = CoderResult.malformedForLength(var3_3);
                                return var15_20;
lbl59:
                                // 1 sources

                                if (var6_6 == 42) {
                                    if (var10_10 + 4 > var11_11) {
                                        var15_21 = CoderResult.UNDERFLOW;
                                        return var15_21;
                                    }
                                    var7_7 = var9_9[var10_10 + 3];
                                    ++var3_3;
                                    if (var7_7 != 72) {
                                        var15_22 = CoderResult.malformedForLength(var3_3);
                                        return var15_22;
                                    }
                                } else if (var6_6 == 43) {
                                    if (var10_10 + 4 > var11_11) {
                                        var15_23 = CoderResult.UNDERFLOW;
                                        return var15_23;
                                    }
                                    var7_7 = var9_9[var10_10 + 3];
                                    ++var3_3;
                                    if (var7_7 != 73) {
                                        var15_24 = CoderResult.malformedForLength(var3_3);
                                        return var15_24;
                                    }
                                } else {
                                    var15_25 = CoderResult.malformedForLength(var3_3);
                                    return var15_25;
lbl81:
                                    // 1 sources

                                    if (var5_5 == 78 || var5_5 == 79) {
                                        if (var10_10 + 4 > var11_11) {
                                            var15_26 = CoderResult.UNDERFLOW;
                                            return var15_26;
                                        }
                                        var6_6 = var9_9[var10_10 + 2];
                                        var7_7 = var9_9[var10_10 + 3];
                                        if (var14_14 - var13_13 < 1) {
                                            var15_27 = CoderResult.OVERFLOW;
                                            return var15_27;
                                        }
                                        var3_3 += 2;
                                        var8_8 = this.cnsDecode(var6_6, var7_7, var5_5);
                                        if (var8_8 == 65533) {
                                            var15_28 = CoderResult.unmappableForLength(var3_3);
                                            return var15_28;
                                        }
                                        var12_12[var13_13++] = var8_8;
                                    } else {
                                        var15_29 = CoderResult.malformedForLength(var3_3);
                                        return var15_29;
lbl99:
                                        // 1 sources

                                        if (var4_4 == 14) {
                                            this.shiftOut = true;
                                        } else if (var4_4 == 15) {
                                            this.shiftOut = false;
                                        }
                                    }
                                }
                            }
                        }
                        if ((var10_10 += var3_3) + 1 > var11_11) {
                            var15_30 = CoderResult.UNDERFLOW;
                            return var15_30;
                        }
                        var4_4 = var9_9[var10_10];
                        var3_3 = 1;
                    }
                    if (var14_14 - var13_13 < 1) {
                        var15_31 = CoderResult.OVERFLOW;
                        return var15_31;
                    }
                    if (!this.shiftOut) {
                        var12_12[var13_13++] = (char)(var4_4 & 255);
                        continue;
                    }
                    if (var10_10 + 2 > var11_11) {
                        var15_32 = CoderResult.UNDERFLOW;
                        return var15_32;
                    }
                    var5_5 = var9_9[var10_10 + 1];
                    ++var3_3;
                    var8_8 = this.SODecode(var4_4, var5_5, this.currentSODesig);
                    if (var8_8 == 65533) {
                        var15_33 = CoderResult.unmappableForLength(var3_3);
                        return var15_33;
                    }
                    var12_12[var13_13++] = var8_8;
                }
                var15_34 = CoderResult.UNDERFLOW;
                return var15_34;
            }
            finally {
                var1_1.position(var10_10 - var1_1.arrayOffset());
                var2_2.position(var13_13 - var2_2.arrayOffset());
            }
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }
    }
}

