/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs9;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs9.PKCS9DerObject;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.CertificateExtensions;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CertificateException;

public class ExtensionRequest
extends PKCS9DerObject
implements Cloneable {
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs9.ExtensionRequest";
    private CertificateExtensions certExtensions;

    public ExtensionRequest(CertificateExtensions certExt) {
        this.certExtensions = certExt;
    }

    public ExtensionRequest(byte[] der) throws IOException {
        super(der);
    }

    public ExtensionRequest(byte[] der, String provider) throws IOException {
        super(der, provider);
    }

    public ExtensionRequest(String filename, boolean base64) throws IOException {
        super(filename, base64);
    }

    public ExtensionRequest(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
    }

    @Override
    public boolean isTagValid(byte tag) {
        return tag == 48;
    }

    @Override
    public boolean isSingleValued() {
        return true;
    }

    @Override
    public String getAttributeName() {
        return "ExtensionRequest";
    }

    @Override
    public Object getValue() {
        if (this.certExtensions != null) {
            try {
                DerOutputStream stream = new DerOutputStream();
                this.certExtensions.encode(stream, true);
                DerInputStream in = new DerInputStream(stream.toByteArray());
                return new CertificateExtensions(in);
            }
            catch (Exception e) {
                if (debug != null) {
                    debug.exception(16384L, className, "getValue", e);
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public void encode(OutputStream os) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        if (this.certExtensions == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "ExtensionRequest object is not initialized.");
            }
            throw new IOException("ExtensionRequest object is not initialized.");
        }
        DerEncoder[] extensionReqSeq = new DerOutputStream[]{new DerOutputStream()};
        try {
            this.certExtensions.encode(extensionReqSeq[0], true);
        }
        catch (CertificateException ex) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Error encoding CertificateExtensions object.");
            }
            throw new IOException(ex.getMessage());
        }
        DerOutputStream attribute = new DerOutputStream();
        attribute.putOID(this.getObjectIdentifier());
        attribute.putOrderedSetOf((byte)49, extensionReqSeq);
        DerOutputStream attribSeq = new DerOutputStream();
        attribSeq.write((byte)48, attribute);
        os.write(attribSeq.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[\n");
        buffer.append("ExtensionRequest :\n");
        buffer.append(this.certExtensions.toString());
        buffer.append("\n]");
        return buffer.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ExtensionRequest)) {
            return false;
        }
        return this.certExtensions.equals(((ExtensionRequest)obj).getValue());
    }

    @Override
    public int hashCode() {
        return this.certExtensions.hashCode();
    }

    @Override
    protected void decode(DerValue encoding) throws IOException {
        super.decode(encoding);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        DerValue[] elems = null;
        if (encoding.getTag() == 48) {
            DerInputStream derIn = new DerInputStream(encoding.toByteArray());
            DerValue[] val = derIn.getSequence(2);
            elems = new DerInputStream(val[1].toByteArray()).getSet(1);
        } else {
            elems = new DerInputStream(encoding.toByteArray()).getSet(1);
        }
        this.certExtensions = new CertificateExtensions(new DerInputStream(elems[0].toByteArray()));
        if (debug != null) {
            debug.exit(16384L, (Object)className, "decode", encoding);
        }
    }

    @Override
    public ObjectIdentifier getObjectIdentifier() {
        return PKCSOID.EXTENSION_REQUEST_OID;
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            ExtensionRequest result = new ExtensionRequest(derout.toByteArray());
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", result);
            }
            return result;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }
}

