/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.rsa;

import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.PSSParameterSpec;

public final class RSAUtil {
    public static void checkParamsAgainstType(KeyType type, AlgorithmParameterSpec paramSpec) throws ProviderException {
        switch (type) {
            case RSA: {
                if (paramSpec == null) break;
                throw new ProviderException("null params expected for " + type.keyAlgo());
            }
            case PSS: {
                if (paramSpec == null || paramSpec instanceof PSSParameterSpec) break;
                throw new ProviderException("PSSParmeterSpec expected for " + type.keyAlgo());
            }
            default: {
                throw new ProviderException("Unsupported RSA algorithm " + (Object)((Object)type));
            }
        }
    }

    public static AlgorithmId createAlgorithmId(KeyType type, AlgorithmParameterSpec paramSpec) throws ProviderException {
        RSAUtil.checkParamsAgainstType(type, paramSpec);
        ObjectIdentifier oid = null;
        AlgorithmParameters params = null;
        try {
            switch (type) {
                case RSA: {
                    oid = AlgorithmId.RSAEncryption_oid;
                    break;
                }
                case PSS: {
                    if (paramSpec != null) {
                        params = AlgorithmParameters.getInstance(type.keyAlgo());
                        params.init(paramSpec);
                    }
                    oid = AlgorithmId.RSAPSS_oid;
                    break;
                }
                default: {
                    throw new ProviderException("Unsupported RSA algorithm " + (Object)((Object)type));
                }
            }
            AlgorithmId result = params == null ? new AlgorithmId(oid) : new AlgorithmId(oid, params);
            return result;
        }
        catch (NoSuchAlgorithmException | InvalidParameterSpecException e) {
            throw new ProviderException(e);
        }
    }

    public static AlgorithmParameterSpec getParamSpec(AlgorithmId algid) throws ProviderException {
        if (algid == null) {
            throw new ProviderException("AlgorithmId should not be null");
        }
        return RSAUtil.getParamSpec(algid.getAlgParameters());
    }

    public static AlgorithmParameterSpec getParamSpec(AlgorithmParameters params) throws ProviderException {
        if (params == null) {
            return null;
        }
        try {
            Class<PSSParameterSpec> specCls;
            String algName = params.getAlgorithm();
            KeyType type = KeyType.lookup(algName);
            switch (type) {
                case RSA: {
                    throw new ProviderException("No params accepted for " + type.keyAlgo());
                }
                case PSS: {
                    specCls = PSSParameterSpec.class;
                    break;
                }
                default: {
                    throw new ProviderException("Unsupported RSA algorithm: " + algName);
                }
            }
            return params.getParameterSpec(specCls);
        }
        catch (ProviderException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new ProviderException(e);
        }
    }

    public static enum KeyType {
        RSA("RSA"),
        PSS("RSAPSS");

        private final String algo;

        private KeyType(String keyAlgo) {
            this.algo = keyAlgo;
        }

        public String keyAlgo() {
            return this.algo;
        }

        public static KeyType lookup(String name) throws InvalidKeyException, ProviderException {
            if (name == null) {
                throw new InvalidKeyException("Null key algorithm");
            }
            for (KeyType kt : KeyType.values()) {
                if (!kt.keyAlgo().equalsIgnoreCase(name)) continue;
                return kt;
            }
            throw new ProviderException("Unsupported algorithm " + name);
        }
    }
}

