/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.util;

import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerIndefLenConverter;
import com.ibm.security.util.DerInputBuffer;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.util.UTFUtils;
import com.ibm.security.util.calendar.CalendarDate;
import com.ibm.security.util.calendar.CalendarSystem;
import com.ibm.security.util.calendar.Gregorian;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Date;
import java.util.Vector;

public final class DerInputStream {
    DerInputBuffer buffer;
    public byte tag;

    public DerInputStream(byte[] data) throws IOException {
        this.init(data, 0, data.length, true);
    }

    public DerInputStream(byte[] data, int offset, int len, boolean allowBER) throws IOException {
        this.init(data, offset, len, allowBER);
    }

    public DerInputStream(byte[] data, int offset, int len) throws IOException {
        this.init(data, offset, len, true);
    }

    private void init(byte[] data, int offset, int len, boolean allowBER) throws IOException {
        if (offset + 2 > data.length || offset + len > data.length) {
            throw new IOException("Encoding bytes too short");
        }
        if (DerIndefLenConverter.isIndefinite(data[offset + 1])) {
            if (!allowBER) {
                throw new IOException("Indefinite length BER encoding found");
            }
            byte[] inData = new byte[len];
            System.arraycopy(data, offset, inData, 0, len);
            byte[] bytes = DerIndefLenConverter.convertIndefToDef(inData);
            this.buffer = new DerInputBuffer(bytes, allowBER);
        } else {
            this.buffer = new DerInputBuffer(data, offset, len, allowBER);
        }
        this.buffer.mark(Integer.MAX_VALUE);
    }

    DerInputStream(DerInputBuffer buf) {
        this.buffer = buf;
        this.buffer.mark(Integer.MAX_VALUE);
    }

    public DerInputStream subStream(int len, boolean do_skip) throws IOException {
        DerInputBuffer newbuf = this.buffer.dup();
        newbuf.truncate(len);
        if (do_skip) {
            this.buffer.skip(len);
        }
        return new DerInputStream(newbuf);
    }

    public byte[] toByteArray() {
        return this.buffer.toByteArray();
    }

    public BigInteger getInteger() throws IOException {
        if (this.buffer.read() != 2) {
            throw new IOException("DER input, Integer tag error");
        }
        return this.buffer.getBigInteger(DerInputStream.getDefiniteLength(this.buffer), false);
    }

    public BigInteger getBigInteger() throws IOException {
        if (this.buffer.read() != 2) {
            throw new IOException("DER input, Integer tag error");
        }
        return this.buffer.getBigInteger(DerInputStream.getDefiniteLength(this.buffer), false);
    }

    public BigInteger getPositiveBigInteger() throws IOException {
        if (this.buffer.read() != 2) {
            throw new IOException("DER input, Integer tag error");
        }
        return this.buffer.getBigInteger(DerInputStream.getDefiniteLength(this.buffer), true);
    }

    public int getSignedInt() throws IOException {
        if (this.buffer.read() != 2) {
            throw new IOException("DER input, Integer tag error");
        }
        return this.buffer.getSigned(DerInputStream.getDefiniteLength(this.buffer));
    }

    public BigInteger getEnumerated() throws IOException {
        if (this.buffer.read() != 10) {
            throw new IOException("DER input, Enumerated tag error");
        }
        return this.buffer.getBigInteger(DerInputStream.getDefiniteLength(this.buffer), false);
    }

    public byte[] getBitString() throws IOException {
        byte[] retval;
        byte tag = (byte)this.buffer.read();
        if (tag != 3 && tag != 35) {
            throw new IOException("DER input not an bit string");
        }
        int length = DerInputStream.getDefiniteLength(this.buffer);
        int numOfPadBits = this.buffer.read();
        if (numOfPadBits < 0 || numOfPadBits > 7) {
            throw new IOException("Invalid number of padding bits");
        }
        if (this.buffer.read(retval = new byte[--length]) != length) {
            throw new IOException("short read of DER bit string");
        }
        if (numOfPadBits != 0) {
            int n = length - 1;
            retval[n] = (byte)(retval[n] & 255 << numOfPadBits);
        }
        return retval;
    }

    public BitArray getUnalignedBitString() throws IOException {
        if (this.buffer.read() != 3) {
            throw new IOException("DER input not a bit string");
        }
        int length = DerInputStream.getDefiniteLength(this.buffer);
        if (length == 0) {
            return new BitArray(0);
        }
        int excessBits = this.buffer.read();
        byte[] repn = new byte[--length];
        if (length != 0 && this.buffer.read(repn) != length) {
            throw new IOException("Short read of DER bit string");
        }
        int validBits = DerInputBuffer.checkPaddedBits(excessBits, repn, 0, repn.length, this.buffer.allowBER);
        return new BitArray(validBits, repn);
    }

    public byte[] getOctetString() throws IOException {
        byte tag = (byte)this.buffer.read();
        if (tag != 4 && tag != 36) {
            throw new IOException("DER input not an octet string");
        }
        int length = DerInputStream.getDefiniteLength(this.buffer);
        if (length == 0) {
            return new byte[0];
        }
        byte[] retval = new byte[length];
        int x = 0;
        x = this.buffer.read(retval);
        if (x != length) {
            throw new IOException("short read of DER octet string");
        }
        return retval;
    }

    public byte[] getBMPString() throws IOException {
        byte tag = (byte)this.buffer.read();
        if (tag != 30 && tag != 62) {
            throw new IOException("DER input not a BMP string; invalid tag");
        }
        int length = DerInputStream.getDefiniteLength(this.buffer);
        if (length % 2 != 0) {
            throw new IOException("DER input not a BMP string; invalid length");
        }
        byte[] retval = new byte[length];
        if (this.buffer.read(retval) != length) {
            throw new IOException("short read of DER BMPString");
        }
        return retval;
    }

    public void getBytes(byte[] val) throws IOException {
        if (val.length != 0 && this.buffer.read(val) != val.length) {
            throw new IOException("short read of DER octet string");
        }
    }

    public void getNull() throws IOException {
        if (this.buffer.read() != 5 || this.buffer.read() != 0) {
            throw new IOException("getNull, bad data");
        }
    }

    public ObjectIdentifier getOID() throws IOException {
        return new ObjectIdentifier(this);
    }

    public DerValue[] getSequence(int startLen) throws IOException {
        this.tag = (byte)this.buffer.read();
        if (this.tag != 48) {
            throw new IOException("Sequence tag error");
        }
        return this.readVector(startLen);
    }

    public DerValue[] getSet(int startLen) throws IOException {
        this.tag = (byte)this.buffer.read();
        if (this.tag != 49) {
            throw new IOException("Set tag error.  Found tag " + this.tag);
        }
        return this.readVector(startLen);
    }

    public DerValue[] getSet(int startLen, boolean implicit) throws IOException {
        this.tag = (byte)this.buffer.read();
        if (!implicit && this.tag != 49) {
            throw new IOException("Set tag error.  Found tag " + this.tag);
        }
        return this.readVector(startLen);
    }

    protected DerValue[] readVector(int startLen) throws IOException {
        byte lenByte = (byte)this.buffer.read();
        int len = DerInputStream.getLength(lenByte, this.buffer);
        if (len == -1) {
            int readLen = this.buffer.available();
            int offset = 2;
            byte[] indefData = new byte[readLen + offset];
            indefData[0] = this.tag;
            indefData[1] = lenByte;
            DataInputStream dis = new DataInputStream(this.buffer);
            dis.readFully(indefData, offset, readLen);
            dis.close();
            DerIndefLenConverter derIn = new DerIndefLenConverter();
            this.buffer = new DerInputBuffer(DerIndefLenConverter.convertIndefToDef(indefData), this.buffer.allowBER);
            if (this.tag != this.buffer.read()) {
                throw new IOException("Indefinite length encoding not supported");
            }
            len = DerInputStream.getDefiniteLength(this.buffer);
        }
        if (len == 0) {
            return new DerValue[0];
        }
        DerInputStream newstr = this.buffer.available() == len ? this : this.subStream(len, true);
        Vector<DerValue> vec = new Vector<DerValue>(startLen, 5);
        do {
            DerValue value = new DerValue(newstr.buffer, this.buffer.allowBER);
            vec.addElement(value);
        } while (newstr.available() > 0);
        if (newstr.available() != 0) {
            throw new IOException("extra data at end of vector");
        }
        int max = vec.size();
        DerValue[] retval = new DerValue[max];
        for (int i = 0; i < max; ++i) {
            retval[i] = (DerValue)vec.elementAt(i);
        }
        return retval;
    }

    public DerValue getDerValue() throws IOException {
        return new DerValue(this.buffer);
    }

    private String simpleGetString(int tag) throws IOException {
        int length = DerInputStream.getLength(this.buffer);
        byte[] retval = new byte[length];
        if (length != 0 && this.buffer.read(retval) != length) {
            throw new IOException("short read of DER Printable string");
        }
        String s = null;
        try {
            s = new String(retval, "8859_1");
        }
        catch (UnsupportedEncodingException e) {
            s = new String(retval);
        }
        return s;
    }

    public String getPrintableString() throws IOException {
        byte tag = (byte)this.buffer.read();
        if (tag != 19 && tag != 51) {
            throw new IOException("DER input not a Printable string");
        }
        return this.simpleGetString(tag);
    }

    public String getT61String() throws IOException {
        byte tag = (byte)this.buffer.read();
        if (tag != 20 && tag != 52) {
            throw new IOException("DER input not a T61 string");
        }
        return this.simpleGetString(tag);
    }

    public String getIA5String() throws IOException {
        byte tag = (byte)this.buffer.read();
        if (tag != 22 && tag != 54) {
            throw new IOException("DER input not an IA5 string");
        }
        return this.simpleGetString(tag);
    }

    public String getUTF8String() throws IOException {
        byte tag = (byte)this.buffer.read();
        if (tag != 12 && tag != 44) {
            throw new IOException("DER input not a UTF8 string");
        }
        int length = DerInputStream.getDefiniteLength(this.buffer);
        byte[] retval = new byte[length];
        if (length != 0 && this.buffer.read(retval) != length) {
            throw new IOException("short read of DER UTF8 string");
        }
        StringBuilder s = UTFUtils.fromUTF(retval);
        return new String(s);
    }

    public String getUniversalString() throws IOException {
        byte tag = (byte)this.buffer.read();
        if (tag != 28 && tag != 60) {
            throw new IOException("DER input not a Universal string");
        }
        int length = DerInputStream.getDefiniteLength(this.buffer);
        byte[] retval = new byte[length];
        if (length != 0 && this.buffer.read(retval) != length) {
            throw new IOException("short read of DER Universal string");
        }
        StringBuilder s = UTFUtils.fromUniv(retval);
        return new String(s);
    }

    public Date getUTCTime() throws IOException {
        if (this.buffer.read() != 23) {
            throw new IOException("DER input, UTCtime tag invalid ");
        }
        int len = DerInputStream.getDefiniteLength(this.buffer);
        if (len > this.available()) {
            throw new IOException("short read of DER UTC Time");
        }
        if (len < 11 || len > 17) {
            throw new IOException("DER getUTCTime length error");
        }
        return this.getTime(len, false);
    }

    public Date getGeneralizedTime() throws IOException {
        if (this.buffer.read() != 24) {
            throw new IOException("DER input, GeneralizedTime tag invalid ");
        }
        int len = DerInputStream.getDefiniteLength(this.buffer);
        if (len > this.available()) {
            throw new IOException("short read of DER Generalized Time");
        }
        if (len < 13) {
            throw new IOException("DER Generalized Time length error");
        }
        return this.getTime(len, true);
    }

    public String getGeneralString() throws IOException {
        byte tag = (byte)this.buffer.read();
        if (tag != 27) {
            throw new IOException("DER input not a General string");
        }
        return this.simpleGetString(tag);
    }

    int getByte() throws IOException {
        return 0xFF & this.buffer.read();
    }

    public int peekByte() throws IOException {
        return this.buffer.peek();
    }

    int getLength() throws IOException {
        return DerInputStream.getLength(this.buffer);
    }

    static int getLength(InputStream in) throws IOException {
        return DerInputStream.getLength(in.read(), in);
    }

    static int getLength(int lenByte, InputStream in) throws IOException {
        int value;
        if (lenByte == -1) {
            throw new IOException("Short read of DER length");
        }
        String mdName = "DerInputStream.getLength(): ";
        int tmp = lenByte;
        if ((tmp & 0x80) == 0) {
            value = tmp;
        } else {
            if ((tmp &= 0x7F) == 0) {
                return -1;
            }
            if (tmp < 0 || tmp > 4) {
                throw new IOException(mdName + "lengthTag=" + tmp + ", " + (tmp < 0 ? "incorrect DER encoding." : "too big."));
            }
            value = 0xFF & in.read();
            --tmp;
            if (value == 0) {
                throw new IOException(mdName + "Redundant length bytes found");
            }
            while (tmp-- > 0) {
                value <<= 8;
                value += 0xFF & in.read();
            }
            if (value < 0) {
                throw new IOException(mdName + "Invalid length bytes");
            }
            if (value <= 127) {
                throw new IOException(mdName + "Should use short form for length");
            }
        }
        return value;
    }

    int getDefiniteLength() throws IOException {
        return DerInputStream.getDefiniteLength(this.buffer);
    }

    static int getDefiniteLength(InputStream in) throws IOException {
        int len = DerInputStream.getLength(in);
        if (len < 0) {
            throw new IOException("Indefinite length encoding not supported");
        }
        return len;
    }

    public void mark(int value) {
        this.buffer.mark(value);
    }

    public void reset() {
        this.buffer.reset();
    }

    public int available() {
        return this.buffer.available();
    }

    private Date getTime(int len, boolean generalized) throws IOException {
        int second;
        int year;
        String type = null;
        char peek = '\u0000';
        if (generalized) {
            type = "Generalized";
            year = 1000 * DerInputStream.toDigit((byte)this.buffer.read(), type);
            year += 100 * DerInputStream.toDigit((byte)this.buffer.read(), type);
            year += 10 * DerInputStream.toDigit((byte)this.buffer.read(), type);
            year += DerInputStream.toDigit((byte)this.buffer.read(), type);
            len -= 2;
        } else {
            type = "UTC";
            year = 10 * DerInputStream.toDigit((byte)this.buffer.read(), type);
            year = (year += DerInputStream.toDigit((byte)this.buffer.read(), type)) < 50 ? (year += 2000) : (year += 1900);
        }
        int month = 10 * DerInputStream.toDigit((byte)this.buffer.read(), type);
        month += DerInputStream.toDigit((byte)this.buffer.read(), type);
        int day = 10 * DerInputStream.toDigit((byte)this.buffer.read(), type);
        day += DerInputStream.toDigit((byte)this.buffer.read(), type);
        int hour = 10 * DerInputStream.toDigit((byte)this.buffer.read(), type);
        hour += DerInputStream.toDigit((byte)this.buffer.read(), type);
        int minute = 10 * DerInputStream.toDigit((byte)this.buffer.read(), type);
        minute += DerInputStream.toDigit((byte)this.buffer.read(), type);
        int millis = 0;
        if ((len -= 10) > 2) {
            second = 10 * DerInputStream.toDigit((byte)this.buffer.read(), type);
            second += DerInputStream.toDigit((byte)this.buffer.read(), type);
            len -= 2;
            peek = (char)this.buffer.read();
            if (generalized && (peek == '.' || peek == ',')) {
                if (--len == 0) {
                    throw new IOException("Parse " + type + " time, empty fractional part");
                }
                int precision = 0;
                peek = (char)this.buffer.read();
                while (peek != 'Z' && peek != '+' && peek != '-') {
                    int thisDigit = DerInputStream.toDigit((byte)peek, type);
                    peek = (char)this.buffer.read();
                    ++precision;
                    if (--len == 0) {
                        throw new IOException("Parse " + type + " time, invalid fractional part");
                    }
                    switch (precision) {
                        case 1: {
                            millis += 100 * thisDigit;
                            break;
                        }
                        case 2: {
                            millis += 10 * thisDigit;
                            break;
                        }
                        case 3: {
                            millis += thisDigit;
                        }
                    }
                }
                if (precision == 0) {
                    throw new IOException("Parse " + type + " time, empty fractional part");
                }
            }
        } else {
            second = 0;
            peek = (char)this.buffer.read();
        }
        if (month == 0 || day == 0 || month > 12 || day > 31 || hour >= 24 || minute >= 60 || second >= 60) {
            throw new IOException("Parse " + type + " time, invalid format");
        }
        Gregorian gcal = CalendarSystem.getGregorianCalendar();
        CalendarDate date = ((CalendarSystem)gcal).newCalendarDate(null);
        date.setDate(year, month, day);
        date.setTimeOfDay(hour, minute, second, millis);
        long time = ((CalendarSystem)gcal).getTime(date);
        if (len != 1 && len != 5) {
            throw new IOException("Parse " + type + " time, invalid offset");
        }
        switch (peek) {
            case '+': {
                if (len != 5) {
                    throw new IOException("Parse " + type + " time, invalid offset");
                }
                int hr = 10 * DerInputStream.toDigit((byte)this.buffer.read(), type);
                int min = 10 * DerInputStream.toDigit((byte)this.buffer.read(), type);
                if ((hr += DerInputStream.toDigit((byte)this.buffer.read(), type)) >= 24 || (min += DerInputStream.toDigit((byte)this.buffer.read(), type)) >= 60) {
                    throw new IOException("Parse " + type + " time, +hhmm");
                }
                time -= (long)((hr * 60 + min) * 60 * 1000);
                break;
            }
            case '-': {
                if (len != 5) {
                    throw new IOException("Parse " + type + " time, invalid offset");
                }
                int hr = 10 * DerInputStream.toDigit((byte)this.buffer.read(), type);
                int min = 10 * DerInputStream.toDigit((byte)this.buffer.read(), type);
                if ((hr += DerInputStream.toDigit((byte)this.buffer.read(), type)) >= 24 || (min += DerInputStream.toDigit((byte)this.buffer.read(), type)) >= 60) {
                    throw new IOException("Parse " + type + " time, -hhmm");
                }
                time += (long)((hr * 60 + min) * 60 * 1000);
                break;
            }
            case 'Z': {
                if (len == 1) break;
                throw new IOException("Parse " + type + " time, invalid format");
            }
            default: {
                throw new IOException("Parse " + type + " time, garbage offset");
            }
        }
        return new Date(time);
    }

    private static int toDigit(byte b, String type) throws IOException {
        if (b < 48 || b > 57) {
            throw new IOException("Parse " + type + " time, invalid format");
        }
        return b - 48;
    }
}

