/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.certrequest.cmscertrequest;

import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.Buffer;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.IntableByteSequence;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestRecordEncoding;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestRecordEncodingFactory;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequence;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequenceIterator;
import com.ibm.security.cmskeystore.NonPrintableAsciiEncryptDecrypt;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs8.EncryptedPrivateKeyInfo;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;

final class RequestRecordEncodingFactory$RequestRecordEncodingImpl
implements RequestRecordEncoding {
    private final IntableByteSequence header;
    private final ByteSequence content;
    private DerValue recordID;
    private DerValue info;
    private DerValue alias;
    private DerValue recordFlags;
    private final ByteSequence sequence;

    private void initDerValues() throws IOException {
        byte[] byArray = new byte[this.header.toInt()];
        this.content.getInputStream().read(byArray);
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream.getSequence(4);
        if (derValueArray.length != 4) {
            throw new RuntimeException("Bad Record data.");
        }
        this.recordID = derValueArray[0];
        this.info = derValueArray[1];
        this.alias = derValueArray[2];
        this.recordFlags = derValueArray[3];
    }

    RequestRecordEncodingFactory$RequestRecordEncodingImpl(Buffer buffer) throws IOException {
        this.header = buffer.getHeader();
        this.content = buffer.getContent();
        this.sequence = buffer;
        this.initDerValues();
    }

    RequestRecordEncodingFactory$RequestRecordEncodingImpl(IntableByteSequence intableByteSequence, ByteSequence byteSequence) throws IOException {
        this.header = intableByteSequence;
        this.content = byteSequence;
        this.sequence = intableByteSequence.append(byteSequence);
        this.initDerValues();
    }

    public CertificationRequest getCertificationRequest() throws IOException {
        DerValue[] derValueArray = new DerInputStream(this.info.getDataBytes()).getSequence(2);
        return new CertificationRequest(derValueArray[0].toByteArray());
    }

    public PrivateKey getPrivateKey(char[] cArray) throws IOException, PKCSException {
        byte[] byArray;
        DerValue[] derValueArray = new DerInputStream(this.info.getDataBytes()).getSequence(2);
        if (derValueArray.length != 2) {
            throw new RuntimeException("Bad record encoding.");
        }
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(derValueArray[1].toByteArray());
        if (!RequestRecordEncodingFactory.access$000(cArray)) {
            AlgorithmId algorithmId = encryptedPrivateKeyInfo.getAlgorithmId();
            if (algorithmId.getOID().equals(new ObjectIdentifier("1.2.840.113549.1.12.5.1.3"))) {
                algorithmId = new AlgorithmId(new ObjectIdentifier("1.2.840.113549.1.12.1.3"), algorithmId.getEncodedParams());
                algorithmId = new AlgorithmId(new ObjectIdentifier("1.2.840.113549.1.12.5.1.3"), algorithmId.getAlgParameters());
            }
            byArray = NonPrintableAsciiEncryptDecrypt.decrypt((byte[])encryptedPrivateKeyInfo.getEncryptedData(), (char[])cArray, (AlgorithmId)algorithmId);
        } else {
            byArray = encryptedPrivateKeyInfo.decrypt(cArray);
        }
        return PrivateKeyInfo.parseKey((DerValue)new DerValue(byArray));
    }

    public boolean isDefaultKey() throws IOException {
        if (!this.isPrivateKeyPresent()) {
            return false;
        }
        this.recordFlags.reset();
        byte[] byArray = this.recordFlags.getBitString();
        if (byArray.length != 1) {
            throw new RuntimeException("Bad record encoding.");
        }
        return (byArray[0] & 0x40) == 64;
    }

    public boolean isTrusted() throws IOException {
        this.recordFlags.reset();
        byte[] byArray = this.recordFlags.getBitString();
        if (byArray.length != 1) {
            throw new RuntimeException("Bad record encoding.");
        }
        return (byArray[0] & 0xFFFFFF80) == -128;
    }

    public boolean isPrivateKeyPresent() {
        return this.info.getTag() == -94;
    }

    public IntableByteSequence getHeader() {
        return this.header;
    }

    public ByteSequence getContent() {
        return this.content;
    }

    public byte get(int n) throws IndexOutOfBoundsException {
        return this.sequence.get(n);
    }

    public int length() {
        return this.sequence.length();
    }

    public ByteSequence append(ByteSequence byteSequence) throws NullPointerException {
        return this.sequence.append(byteSequence);
    }

    public ByteSequence getSubSequence(int n, int n2) throws IndexOutOfBoundsException {
        return this.sequence.getSubSequence(n, n2);
    }

    public int indexOf(byte by) {
        return this.sequence.indexOf(by);
    }

    public int indexOf(int n, byte by) throws IndexOutOfBoundsException {
        return this.sequence.indexOf(n, by);
    }

    public int lastIndexOf(byte by) {
        return this.sequence.lastIndexOf(by);
    }

    public int lastIndexOf(int n, byte by) throws IndexOutOfBoundsException {
        return this.sequence.lastIndexOf(n, by);
    }

    public boolean isEmpty() {
        return this.sequence.isEmpty();
    }

    public InputStream getInputStream() {
        return this.sequence.getInputStream();
    }

    public ByteSequenceIterator getIterator() {
        return this.sequence.getIterator();
    }

    public ByteSequenceIterator getIterator(int n) throws IndexOutOfBoundsException {
        return this.sequence.getIterator(n);
    }

    public String toBinaryString() {
        return this.sequence.toBinaryString();
    }

    public String toOctalString() {
        return this.sequence.toOctalString();
    }

    public String toHexString() {
        return this.sequence.toHexString();
    }

    public boolean equals(Object object) {
        return this.sequence.equals(object);
    }

    public int hashCode() {
        return this.sequence.hashCode();
    }

    public String toString() {
        return this.sequence.toString();
    }
}

