/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.krb5.Credentials;
import com.ibm.security.krb5.KrbException;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.Refreshable;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KeyImpl;

public class KerberosTicket
implements Destroyable,
Refreshable,
Serializable {
    private static final long serialVersionUID = 7395334370157380539L;
    private static int FORWARDABLE_TICKET_FLAG = 1;
    private static int FORWARDED_TICKET_FLAG = 2;
    private static int PROXIABLE_TICKET_FLAG = 3;
    private static int PROXY_TICKET_FLAG = 4;
    private static int POSTDATED_TICKET_FLAG = 6;
    private static int RENEWABLE_TICKET_FLAG = 8;
    private static int INITIAL_TICKET_FLAG = 9;
    private static int NUM_FLAGS = 32;
    private byte[] asn1Encoding;
    private KeyImpl sessionKey;
    private boolean[] flags;
    private Date authTime;
    private Date startTime;
    private Date endTime;
    private Date renewTill;
    private KerberosPrincipal client;
    private KerberosPrincipal server;
    private InetAddress[] clientAddresses;
    KerberosTicket proxy = null;
    private transient boolean destroyed = false;

    public KerberosTicket(byte[] byArray, KerberosPrincipal kerberosPrincipal, KerberosPrincipal kerberosPrincipal2, byte[] byArray2, int n, boolean[] blArray, Date date, Date date2, Date date3, Date date4, InetAddress[] inetAddressArray) {
        this.init(byArray, kerberosPrincipal, kerberosPrincipal2, byArray2, n, blArray, date, date2, date3, date4, inetAddressArray);
    }

    private void init(byte[] byArray, KerberosPrincipal kerberosPrincipal, KerberosPrincipal kerberosPrincipal2, byte[] byArray2, int n, boolean[] blArray, Date date, Date date2, Date date3, Date date4, InetAddress[] inetAddressArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("ASN.1 encoding of ticket cannot be null");
        }
        this.asn1Encoding = byArray;
        if (kerberosPrincipal == null) {
            throw new IllegalArgumentException("Client name in ticket cannot be null");
        }
        this.client = kerberosPrincipal;
        if (kerberosPrincipal2 == null) {
            throw new IllegalArgumentException("Server name in ticket cannot be null");
        }
        this.server = kerberosPrincipal2;
        if (byArray2 == null) {
            throw new IllegalArgumentException("Session key for ticket cannot be null");
        }
        this.sessionKey = new KeyImpl(byArray2, n);
        if (blArray != null) {
            if (blArray.length >= NUM_FLAGS) {
                this.flags = (boolean[])blArray.clone();
            } else {
                this.flags = new boolean[NUM_FLAGS];
                for (int i = 0; i < blArray.length; ++i) {
                    this.flags[i] = blArray[i];
                }
            }
        } else {
            this.flags = new boolean[NUM_FLAGS];
        }
        if (this.flags[RENEWABLE_TICKET_FLAG]) {
            if (date4 == null) {
                throw new IllegalArgumentException("The renewable period end time cannot be null for renewable tickets.");
            }
            this.renewTill = date4;
        }
        this.authTime = date;
        Date date5 = this.startTime = date2 != null ? date2 : date;
        if (date3 == null) {
            throw new IllegalArgumentException("End time for ticket validity cannot be null");
        }
        this.endTime = date3;
        if (inetAddressArray != null) {
            this.clientAddresses = (InetAddress[])inetAddressArray.clone();
        }
    }

    public final KerberosPrincipal getClient() {
        return this.client;
    }

    public final KerberosPrincipal getServer() {
        return this.server;
    }

    public final SecretKey getSessionKey() {
        if (this.destroyed) {
            throw new IllegalStateException("This ticket is no longer valid");
        }
        return this.sessionKey;
    }

    public final int getSessionKeyType() {
        if (this.destroyed) {
            throw new IllegalStateException("This ticket is no longer valid");
        }
        return this.sessionKey.getKeyType();
    }

    public final boolean isForwardable() {
        return this.flags[FORWARDABLE_TICKET_FLAG];
    }

    public final boolean isForwarded() {
        return this.flags[FORWARDED_TICKET_FLAG];
    }

    public final boolean isProxiable() {
        return this.flags[PROXIABLE_TICKET_FLAG];
    }

    public final boolean isProxy() {
        return this.flags[PROXY_TICKET_FLAG];
    }

    public final boolean isPostdated() {
        return this.flags[POSTDATED_TICKET_FLAG];
    }

    public final boolean isRenewable() {
        return this.flags[RENEWABLE_TICKET_FLAG];
    }

    public final boolean isInitial() {
        return this.flags[INITIAL_TICKET_FLAG];
    }

    public final boolean[] getFlags() {
        return this.flags == null ? null : (boolean[])this.flags.clone();
    }

    public final Date getAuthTime() {
        return this.authTime;
    }

    public final Date getStartTime() {
        return this.startTime;
    }

    public final Date getEndTime() {
        return this.endTime;
    }

    public final Date getRenewTill() {
        return this.renewTill;
    }

    public final InetAddress[] getClientAddresses() {
        return this.clientAddresses == null ? null : (InetAddress[])this.clientAddresses.clone();
    }

    public final byte[] getEncoded() {
        if (this.destroyed) {
            throw new IllegalStateException("This ticket is no longer valid");
        }
        return (byte[])this.asn1Encoding.clone();
    }

    @Override
    public boolean isCurrent() {
        return System.currentTimeMillis() <= this.getEndTime().getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() throws RefreshFailedException {
        Serializable serializable;
        if (this.destroyed) {
            throw new RefreshFailedException("A destroyed ticket cannot be renewd.");
        }
        if (!this.isRenewable()) {
            throw new RefreshFailedException("This ticket is not renewable");
        }
        if (System.currentTimeMillis() > this.getRenewTill().getTime()) {
            throw new RefreshFailedException("This ticket is past its last renewal time.");
        }
        Throwable throwable = null;
        Credentials credentials = null;
        try {
            credentials = new Credentials(this.asn1Encoding, this.client.toString(), this.server.toString(), this.sessionKey.getEncoded(), this.sessionKey.getKeyType(), this.flags, this.authTime, this.startTime, this.endTime, this.renewTill, this.clientAddresses);
            credentials = credentials.renew();
        }
        catch (KrbException krbException) {
            throwable = krbException;
        }
        catch (IOException iOException) {
            throwable = iOException;
        }
        if (throwable != null) {
            serializable = new RefreshFailedException("Failed to renew Kerberos Ticket for client " + this.client + " and server " + this.server + " - " + throwable.getMessage());
            throw serializable;
        }
        serializable = this;
        synchronized (serializable) {
            try {
                this.destroy();
            }
            catch (DestroyFailedException destroyFailedException) {
                // empty catch block
            }
            this.init(credentials.getEncoded(), new KerberosPrincipal(credentials.getClient().getName()), new KerberosPrincipal(credentials.getServer().getName()), credentials.getSessionKey().getBytes(), credentials.getSessionKey().getEType(), credentials.getFlags(), credentials.getAuthTime(), credentials.getStartTime(), credentials.getEndTime(), credentials.getRenewTill(), credentials.getClientAddresses());
            this.destroyed = false;
        }
    }

    @Override
    public void destroy() throws DestroyFailedException {
        if (!this.destroyed) {
            Arrays.fill(this.asn1Encoding, (byte)0);
            this.client = null;
            this.server = null;
            this.sessionKey.destroy();
            this.flags = null;
            this.authTime = null;
            this.startTime = null;
            this.endTime = null;
            this.renewTill = null;
            this.clientAddresses = null;
            this.destroyed = true;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    public String toString() {
        if (this.destroyed) {
            return "Destroyed KerberosTicket";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.clientAddresses != null) {
            for (int i = 0; i < this.clientAddresses.length; ++i) {
                stringBuffer.append("clientAddresses[" + i + "] = " + this.clientAddresses[i].toString());
            }
        }
        return "Ticket (hex) = \n" + new HexDumpEncoder().encode(this.asn1Encoding) + "\nClient Principal = " + this.client.toString() + "\nServer Principal = " + this.server.toString() + "\nSession Key = " + this.sessionKey.toString() + "\nForwardable Ticket " + this.flags[FORWARDABLE_TICKET_FLAG] + "\nForwarded Ticket " + this.flags[FORWARDED_TICKET_FLAG] + "\nProxiable Ticket " + this.flags[PROXIABLE_TICKET_FLAG] + "\nProxy Ticket " + this.flags[PROXY_TICKET_FLAG] + "\nPostdated Ticket " + this.flags[POSTDATED_TICKET_FLAG] + "\nRenewable Ticket " + this.flags[RENEWABLE_TICKET_FLAG] + "\nInitial Ticket " + this.flags[RENEWABLE_TICKET_FLAG] + "\nAuth Time = " + String.valueOf(this.authTime) + "\nStart Time = " + String.valueOf(this.startTime) + "\nEnd Time = " + this.endTime.toString() + "\nRenew Till = " + String.valueOf(this.renewTill) + "\nClient Addresses " + (this.clientAddresses == null ? " Null " : stringBuffer.toString() + (this.proxy == null ? "" : "\nwith a proxy ticket") + "\n");
    }

    public int hashCode() {
        int n = 17;
        if (this.isDestroyed()) {
            return n;
        }
        n = n * 37 + Arrays.hashCode(this.getEncoded());
        n = n * 37 + this.endTime.hashCode();
        n = n * 37 + this.client.hashCode();
        n = n * 37 + this.server.hashCode();
        n = n * 37 + this.sessionKey.hashCode();
        if (this.authTime != null) {
            n = n * 37 + this.authTime.hashCode();
        }
        if (this.startTime != null) {
            n = n * 37 + this.startTime.hashCode();
        }
        if (this.renewTill != null) {
            n = n * 37 + this.renewTill.hashCode();
        }
        n = n * 37 + Arrays.hashCode(this.clientAddresses);
        if (this.proxy != null) {
            n = n * 37 + this.proxy.hashCode();
        }
        return n * 37 + Arrays.hashCode(this.flags);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof KerberosTicket)) {
            return false;
        }
        KerberosTicket kerberosTicket = (KerberosTicket)object;
        if (this.isDestroyed() || kerberosTicket.isDestroyed()) {
            return false;
        }
        if (!(Arrays.equals(this.getEncoded(), kerberosTicket.getEncoded()) && this.endTime.equals(kerberosTicket.getEndTime()) && this.server.equals(kerberosTicket.getServer()) && this.client.equals(kerberosTicket.getClient()) && this.sessionKey.equals(kerberosTicket.getSessionKey()) && Arrays.equals(this.clientAddresses, kerberosTicket.getClientAddresses()) && Arrays.equals(this.flags, kerberosTicket.getFlags()))) {
            return false;
        }
        if (this.authTime == null ? kerberosTicket.getAuthTime() != null : !this.authTime.equals(kerberosTicket.getAuthTime())) {
            return false;
        }
        if (this.startTime == null ? kerberosTicket.getStartTime() != null : !this.startTime.equals(kerberosTicket.getStartTime())) {
            return false;
        }
        if (this.renewTill == null ? kerberosTicket.getRenewTill() != null : !this.renewTill.equals(kerberosTicket.getRenewTill())) {
            return false;
        }
        return Objects.equals(this.proxy, kerberosTicket.proxy);
    }
}

