/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import com.ibm.security.jgss.i18n.PropertyResource;
import com.ibm.security.krb5.EncryptionKey;
import com.ibm.security.krb5.JavaxSecurityAuthKerberosAccess;
import com.ibm.security.krb5.KerberosSecrets;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.krb5.internal.RealmException;
import java.io.File;
import java.security.AccessControlException;
import java.util.Objects;
import javax.security.auth.kerberos.JavaxSecurityAuthKerberosAccessImpl;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;

public final class KeyTab {
    private final File file;
    private final KerberosPrincipal princ;
    private final boolean bound;

    private KeyTab(KerberosPrincipal kerberosPrincipal, File file, boolean bl) {
        this.princ = kerberosPrincipal;
        this.file = file;
        this.bound = bl;
    }

    public static KeyTab getInstance(File file) {
        if (file == null) {
            throw new NullPointerException("file must be non null");
        }
        return new KeyTab(null, file, true);
    }

    public static KeyTab getUnboundInstance(File file) {
        if (file == null) {
            throw new NullPointerException("file must be non null");
        }
        return new KeyTab(null, file, false);
    }

    public static KeyTab getInstance(KerberosPrincipal kerberosPrincipal, File file) {
        if (kerberosPrincipal == null) {
            throw new NullPointerException("princ must be non null");
        }
        if (file == null) {
            throw new NullPointerException("file must be non null");
        }
        return new KeyTab(kerberosPrincipal, file, true);
    }

    public static KeyTab getInstance() {
        return new KeyTab(null, null, true);
    }

    public static KeyTab getUnboundInstance() {
        return new KeyTab(null, null, false);
    }

    public static KeyTab getInstance(KerberosPrincipal kerberosPrincipal) {
        if (kerberosPrincipal == null) {
            throw new NullPointerException("princ must be non null");
        }
        return new KeyTab(kerberosPrincipal, null, true);
    }

    com.ibm.security.krb5.internal.ktab.KeyTab takeSnapshot() {
        try {
            return com.ibm.security.krb5.internal.ktab.KeyTab.getInstance((File)this.file);
        }
        catch (AccessControlException accessControlException) {
            if (this.file != null) {
                throw accessControlException;
            }
            PropertyResource propertyResource = PropertyResource.getGeneralInstance();
            String string = propertyResource.getFormattedString("KtabLoadError", (Object[])new String[]{null});
            AccessControlException accessControlException2 = new AccessControlException(string);
            accessControlException2.setStackTrace(accessControlException.getStackTrace());
            throw accessControlException2;
        }
    }

    public KerberosKey[] getKeys(KerberosPrincipal kerberosPrincipal) {
        try {
            if (this.princ != null && !kerberosPrincipal.equals(this.princ)) {
                return new KerberosKey[0];
            }
            PrincipalName principalName = new PrincipalName(kerberosPrincipal.getName());
            EncryptionKey[] encryptionKeyArray = this.takeSnapshot().readServiceKeys(principalName);
            if (null == encryptionKeyArray || encryptionKeyArray.length == 0) {
                return new KerberosKey[0];
            }
            KerberosKey[] kerberosKeyArray = new KerberosKey[encryptionKeyArray.length];
            for (int i = 0; i < kerberosKeyArray.length; ++i) {
                Integer n = encryptionKeyArray[i].getKeyVersionNumber();
                kerberosKeyArray[i] = new KerberosKey(kerberosPrincipal, encryptionKeyArray[i].getBytes(), encryptionKeyArray[i].getEType(), n == null ? 0 : n);
                encryptionKeyArray[i].destroy();
            }
            return kerberosKeyArray;
        }
        catch (RealmException realmException) {
            return new KerberosKey[0];
        }
    }

    EncryptionKey[] getEncryptionKeys(PrincipalName principalName) {
        return this.takeSnapshot().readServiceKeys(principalName);
    }

    public boolean exists() {
        return !this.takeSnapshot().isMissing();
    }

    public String toString() {
        String string;
        String string2 = string = this.file == null ? "Default keytab" : this.file.toString();
        if (!this.bound) {
            return string;
        }
        if (this.princ == null) {
            return string + " for someone";
        }
        return string + " for " + this.princ;
    }

    public int hashCode() {
        return Objects.hash(this.file, this.princ, this.bound);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof KeyTab)) {
            return false;
        }
        KeyTab keyTab = (KeyTab)object;
        return Objects.equals(keyTab.princ, this.princ) && Objects.equals(keyTab.file, this.file) && this.bound == keyTab.bound;
    }

    public KerberosPrincipal getPrincipal() {
        return this.princ;
    }

    public boolean isBound() {
        return this.bound;
    }

    static {
        KerberosSecrets.setJavaxSecurityAuthKerberosAccess((JavaxSecurityAuthKerberosAccess)new JavaxSecurityAuthKerberosAccessImpl());
    }
}

