/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Vector;
import javax.security.auth.kerberos.ServicePermission;

final class KrbServicePermissionCollection
extends PermissionCollection
implements Serializable {
    private Vector permissions = new Vector();

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof ServicePermission)) {
            return false;
        }
        ServicePermission servicePermission = (ServicePermission)permission;
        int n = servicePermission.getMask();
        if (n == 0) {
            Enumeration enumeration = this.permissions.elements();
            while (enumeration.hasMoreElements()) {
                ServicePermission servicePermission2 = (ServicePermission)enumeration.nextElement();
                if (!servicePermission2.impliesIgnoreMask(servicePermission)) continue;
                return true;
            }
            return false;
        }
        int n2 = 0;
        int n3 = n;
        Enumeration enumeration = this.permissions.elements();
        while (enumeration.hasMoreElements()) {
            ServicePermission servicePermission3 = (ServicePermission)enumeration.nextElement();
            if ((n3 & servicePermission3.getMask()) == 0 || !servicePermission3.impliesIgnoreMask(servicePermission)) continue;
            if (((n2 |= servicePermission3.getMask()) & n) == n) {
                return true;
            }
            n3 = n ^ n2;
        }
        return false;
    }

    @Override
    public void add(Permission permission) {
        if (!(permission instanceof ServicePermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        this.permissions.add(0, permission);
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }
}

