/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management.internal;

import com.ibm.java.lang.management.internal.GarbageCollectorMXBeanImpl;
import com.ibm.java.lang.management.internal.MemoryNotificationInfoUtil;
import com.ibm.lang.management.internal.ExtendedGarbageCollectorMXBeanImpl;
import com.ibm.lang.management.internal.ExtendedMemoryMXBeanImpl;
import com.ibm.lang.management.internal.MemoryNotificationThreadShutdown;
import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GcInfo;
import com.sun.management.internal.GarbageCollectionNotificationInfoUtil;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryUsage;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.management.Notification;

final class MemoryNotificationThread
implements Runnable {
    private final ExtendedMemoryMXBeanImpl memBean;

    MemoryNotificationThread(ExtendedMemoryMXBeanImpl mem) {
        this.memBean = mem;
    }

    private void dispatchGCNotificationHelper(String gcName, String gcAction, String gcCause, long index, long startTime, long endTime, long[] initialSize, long[] preUsed, long[] preCommitted, long[] preMax, long[] postUsed, long[] postCommitted, long[] postMax, long sequenceNumber) {
        GcInfo gcInfo = ExtendedGarbageCollectorMXBeanImpl.buildGcInfo(index, startTime, endTime, initialSize, preUsed, preCommitted, preMax, postUsed, postCommitted, postMax);
        GarbageCollectionNotificationInfo info = new GarbageCollectionNotificationInfo(gcName, gcAction, gcCause, gcInfo);
        for (MemoryManagerMXBean bean : this.memBean.getMemoryManagerMXBeans(false)) {
            if (!(bean instanceof GarbageCollectorMXBeanImpl) || !bean.getName().equals(gcName)) continue;
            Notification notification = new Notification("com.sun.management.gc.notification", "java.lang:type=GarbageCollector", sequenceNumber);
            notification.setUserData(GarbageCollectionNotificationInfoUtil.toCompositeData(info));
            ((GarbageCollectorMXBeanImpl)bean).sendNotification(notification);
            break;
        }
    }

    private void dispatchMemoryNotificationHelper(String poolName, long min, long used, long committed, long max, long count, long sequenceNumber, boolean isCollectionUsageNotification) {
        MemoryNotificationInfo info = new MemoryNotificationInfo(poolName, new MemoryUsage(min, used, committed, max), count);
        Notification notification = new Notification(isCollectionUsageNotification ? "java.management.memory.collection.threshold.exceeded" : "java.management.memory.threshold.exceeded", "java.lang:type=Memory", sequenceNumber);
        notification.setUserData(MemoryNotificationInfoUtil.toCompositeData(info));
        this.memBean.sendNotification(notification);
    }

    private native void processNotificationLoop();

    private static boolean registerShutdownHandler() {
        MemoryNotificationThreadShutdown notifier = new MemoryNotificationThreadShutdown(Thread.currentThread());
        PrivilegedAction<Boolean> action = () -> {
            try {
                Runtime.getRuntime().addShutdownHook(notifier);
                return Boolean.TRUE;
            }
            catch (IllegalStateException e) {
                return Boolean.FALSE;
            }
        };
        return AccessController.doPrivileged(action);
    }

    @Override
    public void run() {
        if (MemoryNotificationThread.registerShutdownHandler()) {
            this.processNotificationLoop();
        }
    }
}

