/*
 * Decompiled with CFR 0.152.
 */
package openj9.internal.tools.attach.target;

import com.ibm.oti.util.Msg;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.TimerTask;
import openj9.internal.tools.attach.target.FilelockTimer;
import openj9.internal.tools.attach.target.IPC;

public final class FileLock {
    long fileDescriptor;
    String lockFilepath;
    int fileMode;
    private boolean locked = false;
    private static FilelockTimer fileLockWatchdogTimer;
    private static syncObject shutdownSync;
    static boolean terminated;
    private volatile java.nio.channels.FileLock lockObject;
    private volatile RandomAccessFile lockFileRAF;

    boolean isLocked() {
        return this.locked;
    }

    public FileLock(String filePath, int mode) {
        if (null == filePath) {
            throw new NullPointerException("filePath is null");
        }
        this.lockFilepath = filePath;
        this.fileMode = mode;
        this.lockObject = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lockFile(boolean blocking, String callSite) throws IOException {
        String lockFileMsg = blocking ? "locking file " : "non-blocking locking file ";
        IPC.logMessage(callSite + " : " + lockFileMsg, this.lockFilepath);
        int FILE_LOCK_TIMEOUT = 20000;
        if (this.locked) {
            throw new IOException(Msg.getString("K0574"));
        }
        this.fileDescriptor = FileLock.lockFileImpl(this.lockFilepath, this.fileMode, false);
        boolean bl = this.locked = 0L <= this.fileDescriptor;
        if (!this.locked && blocking) {
            FileLockWatchdogTask wdog = new FileLockWatchdogTask();
            IPC.logMessage("lock failed, trying blocking lock, fileDescriptor = " + this.fileDescriptor);
            syncObject syncObject2 = shutdownSync;
            synchronized (syncObject2) {
                if (!terminated && null == fileLockWatchdogTimer) {
                    fileLockWatchdogTimer = new FilelockTimer("file lock watchdog");
                }
                if (null == fileLockWatchdogTimer) {
                    IPC.logMessage("FileLock.lockFile() returns false.");
                    return false;
                }
                IPC.logMessage("FileLock.lockFile() FILE_LOCK_TIMEOUT = 20000", new Throwable(""));
                fileLockWatchdogTimer.schedule((TimerTask)wdog, 20000L);
            }
            try {
                IPC.logMessage("FileLock.lockFile() before RandomAccessFile creation");
                this.lockFileRAF = new RandomAccessFile(this.lockFilepath, "rw");
                FileChannel lockFileChannel = this.lockFileRAF.getChannel();
                IPC.logMessage("FileLock.lockFile() before lockFileChannel.lock()");
                this.lockObject = lockFileChannel.lock();
                IPC.logMessage("FileLock.lockFile() blocking lock succeeded");
                this.locked = true;
            }
            catch (IOException e) {
                this.unlockFile("lockFile_IOException");
                IPC.logMessage("FileLock.lockFile() blocking lock failed with lockFilepath = " + this.lockFilepath + ", exception message: " + e.getMessage());
            }
            syncObject2 = shutdownSync;
            synchronized (syncObject2) {
                if (null != fileLockWatchdogTimer) {
                    wdog.cancel();
                }
            }
        }
        IPC.logMessage("FileLock.lockFile() locking file succeeded, locked = " + this.locked + ", fileDescriptor = " + this.fileDescriptor);
        return this.locked;
    }

    public void unlockFile(String callSite) {
        RandomAccessFile lockFileRAFCopy;
        java.nio.channels.FileLock lockObjectCopy;
        IPC.logMessage(callSite + "_unlockFile() ", this.lockFilepath);
        if (this.locked && this.fileDescriptor >= 0L) {
            IPC.logMessage(callSite + "_unlockFile : unlockFileImpl fileDescriptor " + this.fileDescriptor);
            FileLock.unlockFileImpl(this.fileDescriptor);
            this.fileDescriptor = -1L;
        }
        if (null != (lockObjectCopy = this.lockObject)) {
            IPC.logMessage("FileLock.unlockFile closing lockObjectCopy ", this.lockFilepath);
            try {
                lockObjectCopy.release();
                this.lockObject = null;
            }
            catch (IOException e) {
                IPC.logMessage("IOException at lockObjectCopy.release() with lockFilepath = " + this.lockFilepath, e);
            }
        }
        if ((lockFileRAFCopy = this.lockFileRAF) != null) {
            IPC.logMessage("FileLock.unlockFile closing lockFileRAFCopy ", this.lockFilepath);
            try {
                lockFileRAFCopy.close();
                this.lockFileRAF = null;
            }
            catch (IOException e) {
                IPC.logMessage("IOException at lockFileRAFCopy.close() with lockFilepath = " + this.lockFilepath, e);
            }
        }
        this.locked = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void shutDown() {
        syncObject syncObject2 = shutdownSync;
        synchronized (syncObject2) {
            terminated = true;
            if (null != fileLockWatchdogTimer) {
                fileLockWatchdogTimer.cancel();
                fileLockWatchdogTimer.purge();
            }
            fileLockWatchdogTimer = null;
        }
    }

    private static native long lockFileImpl(String var0, int var1, boolean var2);

    private static native int unlockFileImpl(long var0);

    static {
        shutdownSync = new syncObject();
    }

    final class FileLockWatchdogTask
    extends TimerTask {
        FileLockWatchdogTask() {
        }

        @Override
        public void run() {
            IPC.logMessage("waitAndCheckLock recreating ", FileLock.this.lockFilepath);
            File theFile = new File(FileLock.this.lockFilepath);
            if (!theFile.renameTo(new File(theFile.getParent(), ".trash_" + IPC.getRandomNumber()))) {
                IPC.logMessage("waitAndCheckLock could not rename ", theFile.getName());
                theFile.renameTo(new File(theFile.getParent(), ".trash_" + IPC.getRandomNumber()));
            }
            FileLock.this.unlockFile("FileLock.FileLockWatchdogTask");
            if (!theFile.delete()) {
                IPC.logMessage("waitAndCheckLock could not delete ", theFile.getAbsolutePath());
            } else {
                IPC.logMessage("waitAndCheckLock deleted ", theFile.getAbsolutePath());
            }
            IPC.logMessage("waitAndCheckLock normal return ");
        }
    }

    static final class syncObject {
        syncObject() {
        }
    }
}

