/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.crmf;

import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.GeneralName;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public final class CertId
extends CMPDerObject {
    private GeneralName issuer;
    private BigInteger serialNumber;

    public CertId(GeneralName generalName, BigInteger bigInteger) {
        if (generalName == null) {
            throw new IllegalArgumentException("CertId error, issuer not specified");
        }
        if (bigInteger == null) {
            throw new IllegalArgumentException("CertId error, serial number not specified");
        }
        this.issuer = generalName;
        this.serialNumber = bigInteger;
    }

    public CertId(byte[] byArray) throws IOException {
        super(byArray);
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            return new CertId(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (derValue.getTag() != 48) {
            throw new IOException("CertId parsing error, not a SEQUENCE");
        }
        this.issuer = null;
        this.serialNumber = null;
        if (derValue.getData().available() == 0) {
            throw new IOException("CertId parsing erro, missing data");
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        this.issuer = new GeneralName(derValue2);
        if (derValue.getData().available() == 0) {
            throw new IOException("CertId parsing erro, missing data");
        }
        this.serialNumber = derValue.getData().getInteger();
        if (derValue.getData().available() != 0) {
            throw new IOException("CertId parsing error, data overrun");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.issuer == null) {
            throw new IOException("CertId encoding error, Issuer not specified");
        }
        this.issuer.encode(derOutputStream);
        if (this.serialNumber == null) {
            throw new IOException("CertId encoding error, Serial number not specified");
        }
        derOutputStream.putInteger(this.serialNumber);
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    public boolean equals(CertId certId) {
        DerValue derValue;
        DerValue derValue2;
        if (certId == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            certId.encode((OutputStream)derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof CertId) {
            return this.equals((CertId)object);
        }
        return false;
    }

    public GeneralName getIssuerName() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.issuer.encode(derOutputStream);
            return new GeneralName(new DerValue(derOutputStream.toByteArray()));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public BigInteger getSerialNumber() {
        return new BigInteger(this.serialNumber.toByteArray());
    }

    public String toString() {
        String string = "CertId:";
        string = String.valueOf(string) + "\r\n\tissuer: " + this.issuer.toString();
        string = String.valueOf(string) + "\r\n\tserial number: " + this.serialNumber.toString();
        return string;
    }
}

