/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf.unwind;

import com.ibm.j9ddr.corereaders.elf.unwind.CIE;
import com.ibm.j9ddr.corereaders.elf.unwind.FDE;
import com.ibm.j9ddr.corereaders.elf.unwind.Unwind;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class UnwindTable {
    private FDE fde;
    private Unwind unwinder;
    private static final int CFA_RULE_ID = -1;
    private RuleState state;
    private long cfa = -1L;
    private Long[] registers;
    private Stack<RuleState> ruleStack = new Stack();

    public UnwindTable(FDE fde, Unwind unwinder, long instructionPointer) throws IOException {
        this.fde = fde;
        this.unwinder = unwinder;
        this.buildRuleTable(fde, instructionPointer);
    }

    private void buildRuleTable(FDE fde, long instructionPointer) throws IOException {
        PrintStream out = System.err;
        this.state = new RuleState();
        this.state.registerRules = new HashMap();
        ByteArrayInputStream i = new ByteArrayInputStream(fde.getCIE().getInitialInstructions());
        MemoryCacheImageInputStream initialInstructionStream = new MemoryCacheImageInputStream(i);
        initialInstructionStream.setByteOrder(fde.getCIE().byteOrder);
        while (initialInstructionStream.getStreamPosition() < (long)fde.getCIE().getInitialInstructions().length) {
            this.processInstruction(initialInstructionStream, fde.getCIE(), this.state, 0L);
        }
        this.state.cieRegisterRules = new HashMap();
        this.state.cieRegisterRules.putAll(this.state.registerRules);
        i = new ByteArrayInputStream(fde.getCallFrameInstructions());
        MemoryCacheImageInputStream instructionStream = new MemoryCacheImageInputStream(i);
        instructionStream.setByteOrder(fde.getCIE().byteOrder);
        HashMap fdeRules = new HashMap();
        long currentAddress = fde.getBaseAddress();
        while (instructionStream.getStreamPosition() < (long)fde.getCallFrameInstructions().length && instructionPointer >= currentAddress) {
            currentAddress = this.processInstruction(instructionStream, fde.getCIE(), this.state, currentAddress);
        }
    }

    public Map<String, Number> apply(Map<String, Number> elfRegisters, String[] registerMapping) throws MemoryFault {
        this.registers = new Long[registerMapping.length + 1];
        int cfaIndex = this.registers.length - 1;
        for (int i = 0; i < registerMapping.length; ++i) {
            String mappingName = null;
            Number regVal = null;
            mappingName = registerMapping[i];
            if (mappingName != null) {
                regVal = elfRegisters.get(mappingName);
            }
            this.registers[i] = regVal != null ? Long.valueOf(elfRegisters.get(registerMapping[i]).longValue()) : Long.valueOf(0L);
        }
        this.state.cfaRule.apply(this.registers, cfaIndex, this.unwinder.process);
        for (RegisterRule r : this.state.registerRules.values()) {
            if (r == null) continue;
            r.apply(this.registers, cfaIndex, this.unwinder.process);
        }
        HashMap<String, Number> newElfRegisters = new HashMap<String, Number>();
        for (int i = 0; i < registerMapping.length; ++i) {
            newElfRegisters.put(registerMapping[i], this.registers[i]);
        }
        this.cfa = this.registers[cfaIndex];
        return newElfRegisters;
    }

    public long getFrameAddress() {
        return this.cfa;
    }

    public long getReturnAddress() {
        Long returnAddress = this.registers[(int)this.fde.cie.returnAddressRegister];
        return returnAddress == null ? 0L : returnAddress;
    }

    public static void dumpInstructions(PrintStream out, byte[] instructions, CIE cie) throws IOException {
        try {
            ByteArrayInputStream i = new ByteArrayInputStream(instructions);
            MemoryCacheImageInputStream instructionStream = new MemoryCacheImageInputStream(i);
            instructionStream.setByteOrder(cie.byteOrder);
            while (instructionStream.getStreamPosition() < (long)instructions.length) {
                UnwindTable.dumpInstruction(out, instructionStream, cie);
                out.println();
            }
        }
        catch (Exception e) {
            out.println("Error dumping instructions: " + e);
            e.printStackTrace(out);
        }
    }

    private static void dumpInstruction(PrintStream out, ImageInputStream instructionStream, CIE cie) throws IOException {
        byte next = instructionStream.readByte();
        switch (next & 0xC0) {
            case 64: {
                byte delta = (byte)(next & 0x3F);
                out.printf("advance_loc: 0x%x, %d", delta, (long)delta * cie.codeAlignmentFactor);
                return;
            }
            case 128: {
                byte register = (byte)(next & 0x3F);
                long offset = Unwind.readUnsignedLEB128(instructionStream);
                out.printf("offset: r%d offset cfa%+d", register, offset *= cie.dataAlignmentFactor);
                return;
            }
            case 192: {
                byte register = (byte)(next & 0x3F);
                out.printf("restore: r%d", register);
                return;
            }
        }
        switch (next) {
            case 0: {
                break;
            }
            case 1: {
                long address = cie.wordSize == 8 ? instructionStream.readLong() : (long)(instructionStream.readInt() & 0xFFFFFFFF);
                out.printf("set_loc: 0x%x", address);
                break;
            }
            case 2: {
                long delta = (long)instructionStream.readByte() & 0xFFL;
                out.printf("advance_loc1: 0x%x, %d", delta, delta * cie.codeAlignmentFactor);
                break;
            }
            case 3: {
                long delta = (long)instructionStream.readShort() & 0xFFFFL;
                out.printf("advance_loc2: 0x%x, %d", delta, delta * cie.codeAlignmentFactor);
                break;
            }
            case 4: {
                long delta = (long)instructionStream.readInt() & 0xFFFFFFFFFFFFFFFFL;
                out.printf("advance_loc4: 0x%x, %d", delta, delta * cie.codeAlignmentFactor);
                break;
            }
            case 5: {
                long registerId = Unwind.readUnsignedLEB128(instructionStream);
                long offset = Unwind.readUnsignedLEB128(instructionStream);
                out.printf("offset_extended: r%d offset cfa%+d", registerId, offset *= cie.dataAlignmentFactor);
                break;
            }
            case 7: {
                long registerId = Unwind.readUnsignedLEB128(instructionStream);
                out.printf("undefined: r%d ", registerId);
                break;
            }
            case 8: {
                long registerId = Unwind.readUnsignedLEB128(instructionStream);
                out.printf("same_value: r%d ", registerId);
                break;
            }
            case 9: {
                long registerDest = Unwind.readUnsignedLEB128(instructionStream);
                long registerSource = Unwind.readUnsignedLEB128(instructionStream);
                out.printf("register: r%d is in r%d", registerDest, registerSource);
                break;
            }
            case 10: {
                out.printf("remember_state", new Object[0]);
                break;
            }
            case 11: {
                out.printf("restore_state", new Object[0]);
                break;
            }
            case 12: {
                long registerId = Unwind.readUnsignedLEB128(instructionStream);
                long offset = Unwind.readUnsignedLEB128(instructionStream);
                out.printf("def_cfa: r%d offset: %d", registerId, offset);
                break;
            }
            case 13: {
                long registerId = Unwind.readUnsignedLEB128(instructionStream);
                out.printf("def_cfa_register: r%d", registerId);
                break;
            }
            case 14: {
                long offset = Unwind.readUnsignedLEB128(instructionStream);
                out.printf("def_cfa_offset: offset: %d", offset);
                break;
            }
            case 18: {
                long registerId = Unwind.readUnsignedLEB128(instructionStream);
                long offset = Unwind.readSignedLEB128(instructionStream);
                long factoredOffset = offset * cie.dataAlignmentFactor;
                out.printf("def_cfa_sf: r%d offset: %d (%d)", registerId, offset, factoredOffset);
                break;
            }
            case 17: {
                long registerId = Unwind.readUnsignedLEB128(instructionStream);
                long offset = Unwind.readSignedLEB128(instructionStream);
                out.printf("offset_extended_sf: r%d offset cfa%+d", registerId, offset *= cie.dataAlignmentFactor);
                break;
            }
            default: {
                out.printf("?? 0x%x", next);
            }
        }
    }

    private long processInstruction(ImageInputStream instructionStream, CIE cie, RuleState currentState, long currentAddress) throws IOException {
        byte next = instructionStream.readByte();
        switch (next & 0xC0) {
            case 64: {
                byte delta = (byte)(next & 0x3F);
                return currentAddress + (long)delta * cie.codeAlignmentFactor;
            }
            case 128: {
                byte register = (byte)(next & 0x3F);
                long offset = Unwind.readUnsignedLEB128(instructionStream);
                currentState.registerRules.put(Integer.valueOf(register), new CFAOffsetRegisterRule(register, offset *= cie.dataAlignmentFactor));
                return currentAddress;
            }
            case 192: {
                byte register = (byte)(next & 0x3F);
                return currentAddress;
            }
        }
        switch (next) {
            case 0: {
                break;
            }
            case 1: {
                long address = cie.wordSize == 8 ? instructionStream.readLong() : (long)(instructionStream.readInt() & 0xFFFFFFFF);
                currentAddress = address;
                break;
            }
            case 2: {
                long delta = (long)instructionStream.readByte() & 0xFFL;
                currentAddress += delta * cie.codeAlignmentFactor;
                break;
            }
            case 3: {
                long delta = (long)instructionStream.readShort() & 0xFFFFL;
                currentAddress += delta * cie.codeAlignmentFactor;
                break;
            }
            case 4: {
                long delta = (long)instructionStream.readInt() & 0xFFFFFFFFFFFFFFFFL;
                currentAddress += delta * cie.codeAlignmentFactor;
                break;
            }
            case 5: {
                long registerId = Unwind.readUnsignedLEB128(instructionStream);
                long offset = Unwind.readUnsignedLEB128(instructionStream);
                currentState.registerRules.put((int)registerId, new CFAOffsetRegisterRule((int)registerId, offset *= cie.dataAlignmentFactor));
                break;
            }
            case 7: {
                long registerId = Unwind.readUnsignedLEB128(instructionStream);
                currentState.registerRules.put((int)registerId, new UndefinedRegisterRule((int)registerId));
                break;
            }
            case 8: {
                long registerId = Unwind.readUnsignedLEB128(instructionStream);
                currentState.registerRules.put((int)registerId, new SameValueRegisterRule((int)registerId));
                break;
            }
            case 9: {
                long registerDest = Unwind.readUnsignedLEB128(instructionStream);
                long registerSource = Unwind.readUnsignedLEB128(instructionStream);
                currentState.registerRules.put((int)registerDest, new RegisterRegisterRule((int)registerDest, (int)registerSource));
                break;
            }
            case 10: {
                RuleState savedState = new RuleState();
                savedState.registerRules = new HashMap();
                savedState.cieRegisterRules = new HashMap();
                savedState.registerRules.putAll(currentState.registerRules);
                savedState.cieRegisterRules.putAll(currentState.cieRegisterRules);
                savedState.cfaRule = currentState.cfaRule;
                this.ruleStack.push(savedState);
                break;
            }
            case 11: {
                RuleState restoredState = this.ruleStack.pop();
                currentState.cfaRule = restoredState.cfaRule;
                currentState.registerRules = restoredState.registerRules;
                currentState.cieRegisterRules = restoredState.cieRegisterRules;
                break;
            }
            case 12: {
                long registerId = Unwind.readUnsignedLEB128(instructionStream);
                long offset = Unwind.readUnsignedLEB128(instructionStream);
                currentState.cfaRule = new RegisterOffsetCFARule(UnwindTable.CFA_RULE_ID, (int)registerId, offset);
                break;
            }
            case 13: {
                long registerId = Unwind.readUnsignedLEB128(instructionStream);
                RegisterOffsetCFARule lastRule = currentState.cfaRule;
                currentState.cfaRule = new RegisterOffsetCFARule(UnwindTable.CFA_RULE_ID, (int)registerId, ((CFARule)lastRule).getOffset());
                break;
            }
            case 14: {
                long offset = Unwind.readUnsignedLEB128(instructionStream);
                RegisterOffsetCFARule lastRule = currentState.cfaRule;
                currentState.cfaRule = new RegisterOffsetCFARule(UnwindTable.CFA_RULE_ID, ((CFARule)lastRule).getBaseRegister(), offset);
                break;
            }
            case 18: {
                long registerId = Unwind.readUnsignedLEB128(instructionStream);
                long offset = Unwind.readSignedLEB128(instructionStream);
                long factoredOffset = offset * cie.dataAlignmentFactor;
                currentState.cfaRule = new RegisterOffsetCFARule(UnwindTable.CFA_RULE_ID, (int)registerId, factoredOffset);
                break;
            }
            case 17: {
                long registerId = Unwind.readUnsignedLEB128(instructionStream);
                long offset = Unwind.readSignedLEB128(instructionStream);
                currentState.registerRules.put((int)registerId, new CFAOffsetRegisterRule((int)registerId, offset *= cie.dataAlignmentFactor));
                break;
            }
        }
        return currentAddress;
    }

    private static class RegisterOffsetCFARule
    extends CFARule {
        int register;
        long offset;

        private RegisterOffsetCFARule(int registerNum, int register, long offset) {
            super(registerNum);
            this.register = register;
            this.offset = offset;
        }

        @Override
        public int getBaseRegister() {
            return this.register;
        }

        @Override
        public long getOffset() {
            return this.offset;
        }

        @Override
        public void apply(Long[] registers, int cfaIndex, IProcess process) {
            long regValue = registers[this.register];
            long cfaValue = regValue + this.offset;
            registers[cfaIndex] = cfaValue;
        }
    }

    private static abstract class CFARule
    extends RegisterRule {
        protected CFARule(int registerNum) {
            super(registerNum);
        }

        public abstract long getOffset();

        public abstract int getBaseRegister();
    }

    private static class CFAOffsetRegisterRule
    extends RegisterRule {
        private long offset;

        private CFAOffsetRegisterRule(int registerNum, long offset) {
            super(registerNum);
            this.offset = offset;
        }

        @Override
        public void apply(Long[] registers, int cfaIndex, IProcess process) throws MemoryFault {
            long cfa = registers[cfaIndex];
            long location = cfa + this.offset;
            registers[this.getRegister()] = process.getPointerAt(location);
        }
    }

    private static class UndefinedRegisterRule
    extends RegisterRule {
        private int sourceRegisterNum;

        private UndefinedRegisterRule(int registerNum) {
            super(registerNum);
        }

        @Override
        public void apply(Long[] registers, int cfaIndex, IProcess process) throws MemoryFault {
            registers[this.getRegister()] = null;
        }
    }

    private static class SameValueRegisterRule
    extends RegisterRegisterRule {
        private SameValueRegisterRule(int registerNum) {
            super(registerNum, registerNum);
        }
    }

    private static class RegisterRegisterRule
    extends RegisterRule {
        private int sourceRegisterNum;

        private RegisterRegisterRule(int registerNum, int sourceRegisterNum) {
            super(registerNum);
            this.sourceRegisterNum = sourceRegisterNum;
        }

        @Override
        public void apply(Long[] registers, int cfaIndex, IProcess process) throws MemoryFault {
            registers[this.getRegister()] = registers[this.sourceRegisterNum];
        }
    }

    private static abstract class RegisterRule {
        private int registerNum;

        protected RegisterRule(int registerId) {
            this.registerNum = registerId;
        }

        public int getRegister() {
            return this.registerNum;
        }

        public abstract void apply(Long[] var1, int var2, IProcess var3) throws MemoryFault;
    }

    private static class DW_CFA {
        static final int advance_loc = 64;
        static final int offset = 128;
        static final int restore = 192;
        static final int nop = 0;
        static final int set_loc = 1;
        static final int advance_loc1 = 2;
        static final int advance_loc2 = 3;
        static final int advance_loc4 = 4;
        static final int offset_extended = 5;
        static final int undefined = 7;
        static final int same_value = 8;
        static final int register = 9;
        static final int remember_state = 10;
        static final int restore_state = 11;
        static final int def_cfa = 12;
        static final int def_cfa_register = 13;
        static final int def_cfa_offset = 14;
        static final int offset_extended_sf = 17;
        static final int def_cfa_sf = 18;

        private DW_CFA() {
        }
    }

    private class RuleState {
        private RegisterOffsetCFARule cfaRule;
        private Map<Integer, RegisterRule> registerRules;
        private Map<Integer, RegisterRule> cieRegisterRules;

        private RuleState() {
        }
    }
}

