/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.util;

import com.ibm.j9ddr.corereaders.tdump.zebedee.util.IntEnumeration;

public class BitSetArray {
    private int[] roots;
    private int setsSize;
    private BitSet[] sets;
    private int[] tmpintervals;
    private int[] tmplengths;
    IntEnumeration nullEnum = new IntEnumeration(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }

        @Override
        public long nextInt() {
            return 0L;
        }
    };

    public BitSetArray(int size) {
        this.roots = new int[size];
        this.sets = new BitSet[size];
    }

    public BitSetArray() {
        this(16);
    }

    public void set(int index, int bit) {
        assert (bit >= 0);
        assert (index >= 0);
        this.ensureRootsCapacity(index + 1);
        int root = this.roots[index];
        if (root == 0) {
            this.roots[index] = bit | Integer.MIN_VALUE;
        } else if (root < 0) {
            this.roots[index] = this.addSet(new TwoMemberSet(root & Integer.MAX_VALUE, bit));
        } else {
            this.sets[root - 1] = this.sets[root - 1].set(bit);
        }
    }

    public void or(int toIndex, int fromIndex) {
        assert (toIndex >= 0 && toIndex < this.roots.length) : toIndex;
        assert (fromIndex >= 0 && fromIndex < this.roots.length) : fromIndex;
        if (this.roots[fromIndex] < 0) {
            this.set(toIndex, this.roots[fromIndex] & Integer.MAX_VALUE);
        } else if (this.roots[fromIndex] > 0) {
            int fromRoot = this.roots[fromIndex] - 1;
            if (this.roots[toIndex] == 0) {
                this.roots[toIndex] = this.addSet(this.sets[fromRoot].cloneSet());
            } else if (this.roots[toIndex] < 0) {
                int bit = this.roots[toIndex] & Integer.MAX_VALUE;
                this.roots[toIndex] = this.addSet(this.sets[fromRoot].cloneSet());
                this.set(toIndex, bit);
            } else {
                int toRoot = this.roots[toIndex] - 1;
                this.sets[toRoot] = this.sets[toRoot].or(this.sets[fromRoot]);
            }
        }
    }

    private int addSet(BitSet set) {
        this.ensureSetsCapacity(this.setsSize + 1);
        this.sets[this.setsSize++] = set;
        return this.setsSize;
    }

    private void ensureRootsCapacity(int minCapacity) {
        int oldCapacity = this.roots.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            int[] tmp = new int[newCapacity];
            System.arraycopy(this.roots, 0, tmp, 0, oldCapacity);
            this.roots = tmp;
        }
    }

    private void ensureSetsCapacity(int minCapacity) {
        int oldCapacity = this.sets.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            BitSet[] tmp = new BitSet[newCapacity];
            System.arraycopy(this.sets, 0, tmp, 0, oldCapacity);
            this.sets = tmp;
        }
    }

    static int[] arraycopy(int[] array, int size) {
        int[] newArray = new int[size];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public IntEnumeration elements(int index) {
        int root = this.roots[index];
        if (root == 0) {
            return this.nullEnum;
        }
        if (root < 0) {
            return null;
        }
        return null;
    }

    class IntervalSet
    implements BitSet,
    Cloneable {
        private int size;
        private int[] intervals;
        private int[] lengths;

        IntervalSet(int[] bits, int bit) {
            this.intervals = new int[bits.length << 1];
            this.lengths = new int[bits.length << 1];
            for (int i = 0; i < bits.length; ++i) {
                this.set(bits[i]);
            }
            this.set(bit);
        }

        @Override
        public BitSet set(int bit) {
            int low = 0;
            int high = this.size - 1;
            int mid = -1;
            int midVal = -1;
            int max = this.intervals.length;
            if (this.size == 0) {
                this.intervals[0] = bit;
                this.lengths[0] = 1;
                this.size = 1;
                return this;
            }
            while (low <= high) {
                mid = low + high >> 1;
                midVal = this.intervals[mid];
                if (bit >= midVal) {
                    if (bit < midVal + this.lengths[mid]) {
                        return this;
                    }
                    if (bit == midVal + this.lengths[mid]) {
                        this.lengths[mid] = this.lengths[mid] + 1;
                        if (mid < this.size - 1 && bit + 1 == this.intervals[mid + 1]) {
                            this.intervalMerge(mid);
                        }
                        return this;
                    }
                    low = mid + 1;
                    continue;
                }
                if (bit == midVal - 1) {
                    this.intervals[mid] = this.intervals[mid] - 1;
                    this.lengths[mid] = this.lengths[mid] + 1;
                    if (mid > 0 && bit == this.intervals[mid - 1] + this.lengths[mid - 1]) {
                        this.intervalMerge(mid - 1);
                    }
                    return this;
                }
                high = mid - 1;
            }
            if (this.size == max) {
                this.intervals = BitSetArray.arraycopy(this.intervals, max <<= 1);
                this.lengths = BitSetArray.arraycopy(this.lengths, max);
            }
            if (bit < this.intervals[0]) {
                System.arraycopy(this.intervals, 0, this.intervals, 1, this.size);
                System.arraycopy(this.lengths, 0, this.lengths, 1, this.size);
                this.intervals[0] = bit;
                this.lengths[0] = 1;
            } else if (bit > this.intervals[this.size - 1]) {
                this.intervals[this.size] = bit;
                this.lengths[this.size] = 1;
            } else {
                if (bit < midVal) {
                    --mid;
                }
                assert (this.size - mid - 1 > 0);
                System.arraycopy(this.intervals, mid + 1, this.intervals, mid + 2, this.size - mid - 1);
                System.arraycopy(this.lengths, mid + 1, this.lengths, mid + 2, this.size - mid - 1);
                this.intervals[mid + 1] = bit;
                this.lengths[mid + 1] = 1;
            }
            ++this.size;
            return this;
        }

        private void intervalMerge(int lower) {
            int bottom;
            int max = this.intervals.length;
            int lowInt = this.intervals[lower];
            int highInt = this.intervals[lower + 1];
            int lowLen = this.lengths[lower];
            int highLen = this.lengths[lower + 1];
            int lowTop = lowInt + lowLen;
            int highTop = highInt + highLen;
            if (lowInt < highInt) {
                this.intervals[lower] = lowInt;
                bottom = lowInt;
            } else {
                this.intervals[lower] = highInt;
                bottom = highInt;
            }
            this.lengths[lower] = lowTop < highTop ? highTop - bottom : lowTop - bottom;
            if (lower < this.size - 2) {
                int len = this.size - (lower + 2);
                System.arraycopy(this.intervals, lower + 2, this.intervals, lower + 1, len);
                System.arraycopy(this.lengths, lower + 2, this.lengths, lower + 1, len);
            }
            --this.size;
            assert (this.size > 0);
            if (this.size * 3 < max) {
                int[] nintervals = new int[max >>= 1];
                int[] nlengths = new int[max];
                System.arraycopy(this.intervals, 0, nintervals, 0, this.size);
                System.arraycopy(this.lengths, 0, nlengths, 0, this.size);
                this.intervals = nintervals;
                this.lengths = nlengths;
            }
            if (lower > 0 && this.intervals[lower] <= this.intervals[lower - 1] + this.lengths[lower - 1]) {
                this.intervalMerge(lower - 1);
            }
            if (lower < this.size - 1 && this.intervals[lower] + this.lengths[lower] >= this.intervals[lower + 1]) {
                this.intervalMerge(lower);
            }
        }

        @Override
        public BitSet or(BitSet set) {
            assert (false);
            return null;
        }

        @Override
        public BitSet cloneSet() {
            try {
                IntervalSet clone = (IntervalSet)super.clone();
                clone.intervals = (int[])this.intervals.clone();
                clone.lengths = (int[])this.lengths.clone();
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new Error("impossible");
            }
        }
    }

    class SmallSet
    implements BitSet,
    Cloneable {
        private int[] bits = new int[8];
        private int numBits = 4;
        private static final int MAX_SIZE = 16;

        SmallSet(int b1, int b2, int b3, int b4) {
            this.bits[0] = b1;
            this.bits[1] = b2;
            this.bits[2] = b3;
            this.bits[3] = b4;
        }

        @Override
        public BitSet set(int bit) {
            int[] oldBits;
            int[] newBits = oldBits = this.bits;
            int n = this.numBits;
            for (int i = 0; i <= n; ++i) {
                if (i == n || bit < oldBits[i]) {
                    int j;
                    if (n == oldBits.length) {
                        if (n < 16) {
                            this.bits = newBits = new int[n << 1];
                            for (j = 0; j < i; ++j) {
                                newBits[j] = oldBits[j];
                            }
                        } else {
                            return new IntervalSet(this.bits, bit);
                        }
                    }
                    for (j = n; j > i; --j) {
                        newBits[j] = oldBits[j - 1];
                    }
                    newBits[i] = bit;
                    ++this.numBits;
                    return this;
                }
                if (bit != oldBits[i]) continue;
                return this;
            }
            assert (false) : "should never reach here";
            return null;
        }

        @Override
        public BitSet or(BitSet set) {
            if (set.getClass() == TwoMemberSet.class) {
                TwoMemberSet tset = (TwoMemberSet)set;
                return this.set(tset.l).set(tset.h);
            }
            if (set.getClass() == ThreeMemberSet.class) {
                ThreeMemberSet tset = (ThreeMemberSet)set;
                return this.set(tset.l).set(tset.m).set(tset.h);
            }
            if (set.getClass() == SmallSet.class) {
                SmallSet oset = (SmallSet)set;
                BitSet nset = this;
                int n = oset.numBits;
                int[] obits = oset.bits;
                for (int i = 0; i < n; ++i) {
                    nset = nset.set(obits[i]);
                }
                return nset;
            }
            assert (set.getClass() == IntervalSet.class);
            return set.cloneSet().or(this);
        }

        @Override
        public BitSet cloneSet() {
            try {
                SmallSet clone = (SmallSet)super.clone();
                clone.bits = (int[])this.bits.clone();
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new Error("impossible");
            }
        }
    }

    class ThreeMemberSet
    implements BitSet,
    Cloneable {
        private int l;
        private int m;
        private int h;

        ThreeMemberSet(int l, int m, int h) {
            this.l = l;
            this.m = m;
            this.h = h;
        }

        @Override
        public BitSet set(int bit) {
            if (bit == this.l || bit == this.m || bit == this.h) {
                return this;
            }
            if (bit < this.l) {
                return new SmallSet(bit, this.l, this.m, this.h);
            }
            if (bit < this.m) {
                return new SmallSet(this.l, bit, this.m, this.h);
            }
            if (bit < this.h) {
                return new SmallSet(this.l, this.m, bit, this.h);
            }
            return new SmallSet(this.l, this.m, this.h, bit);
        }

        @Override
        public BitSet or(BitSet set) {
            if (set.getClass() == TwoMemberSet.class) {
                TwoMemberSet tset = (TwoMemberSet)set;
                return this.set(tset.l).set(tset.h);
            }
            if (set.getClass() == ThreeMemberSet.class) {
                ThreeMemberSet tset = (ThreeMemberSet)set;
                return this.set(tset.l).set(tset.m).set(tset.h);
            }
            return set.cloneSet().or(this);
        }

        @Override
        public BitSet cloneSet() {
            try {
                return (ThreeMemberSet)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new Error("impossible");
            }
        }
    }

    class TwoMemberSet
    implements BitSet,
    Cloneable {
        private int l;
        private int h;

        TwoMemberSet(int b1, int b2) {
            if (b1 < b2) {
                this.l = b1;
                this.h = b2;
            } else {
                this.l = b2;
                this.h = b1;
            }
        }

        @Override
        public BitSet set(int bit) {
            if (bit == this.l || bit == this.h) {
                return this;
            }
            if (bit < this.l) {
                return new ThreeMemberSet(bit, this.l, this.h);
            }
            if (bit < this.h) {
                return new ThreeMemberSet(this.l, bit, this.h);
            }
            return new ThreeMemberSet(this.l, this.h, bit);
        }

        @Override
        public BitSet or(BitSet set) {
            if (set.getClass() == TwoMemberSet.class) {
                TwoMemberSet tset = (TwoMemberSet)set;
                return this.set(tset.l).set(tset.h);
            }
            return set.cloneSet().or(this);
        }

        @Override
        public BitSet cloneSet() {
            try {
                return (TwoMemberSet)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new Error("impossible");
            }
        }
    }

    static interface BitSet {
        public BitSet set(int var1);

        public BitSet or(BitSet var1);

        public BitSet cloneSet();
    }

    class SmallEnum
    implements IntEnumeration {
        int[] bits = new int[16];
        int size;
        int index;

        SmallEnum(int bit) {
            this.reset(bit);
        }

        void reset(int bit) {
            this.bits[0] = bit;
            this.size = 1;
            this.index = 0;
        }

        @Override
        public boolean hasMoreElements() {
            return this.index < this.size;
        }

        public Object nextElement() {
            return null;
        }

        @Override
        public long nextInt() {
            return this.bits[this.index++];
        }
    }
}

