/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.events.EventManager;
import com.ibm.j9ddr.vm24.j9.AVLTree;
import com.ibm.j9ddr.vm24.j9.DataType;
import com.ibm.j9ddr.vm24.j9.HashTable;
import com.ibm.j9ddr.vm24.j9.IAVLSearchComparator;
import com.ibm.j9ddr.vm24.j9.Pool;
import com.ibm.j9ddr.vm24.j9.SlotIterator;
import com.ibm.j9ddr.vm24.pointer.AbstractPointer;
import com.ibm.j9ddr.vm24.pointer.PointerPointer;
import com.ibm.j9ddr.vm24.pointer.VoidPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9AVLTreeNodePointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9AVLTreePointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9PoolPointer;
import com.ibm.j9ddr.vm24.types.U32;
import com.ibm.j9ddr.vm24.types.UDATA;
import java.util.NoSuchElementException;

public class HashTable_V2<StructType extends AbstractPointer>
extends HashTable<StructType> {
    private static final long AVL_TREE_TAG_BIT = 1L;
    private boolean _isInline = false;
    private AVLTreeComparatorFunction _avlTreeComparatorFunction;
    private EqualFunctionWrapper _equalFunctionWrapper;

    protected HashTable_V2(J9HashTablePointer hashTablePointer, boolean isInline, Class<StructType> structType, HashTable.HashEqualFunction<StructType> equalFn, HashTable.HashFunction<StructType> hashFn) throws CorruptDataException {
        super(hashTablePointer, structType, equalFn, hashFn, null);
        this._equalFunctionWrapper = new EqualFunctionWrapper();
        this._isInline = isInline;
    }

    protected HashTable_V2(J9HashTablePointer hashTablePointer, boolean isInline, Class<StructType> structType, HashTable.HashFunction<StructType> hashFn, HashTable.HashComparatorFunction<StructType> comparatorFn) throws CorruptDataException {
        super(hashTablePointer, structType, null, hashFn, comparatorFn);
        this._avlTreeComparatorFunction = new AVLTreeComparatorFunction();
        this._equalFunctionWrapper = new EqualFunctionFromComparator();
        this._isInline = isInline;
    }

    private VoidPointer avlNodeToData(J9AVLTreeNodePointer p) {
        return VoidPointer.cast(p.add(1L));
    }

    private J9AVLTreePointer avlTreeUntag(VoidPointer p) {
        return J9AVLTreePointer.cast(p.untag(1L));
    }

    private PointerPointer nextEA(VoidPointer p) throws CorruptDataException {
        return PointerPointer.cast(p.addOffset(this._table.nodeSize()).subOffset(UDATA.SIZEOF));
    }

    private boolean isAVLTreeTagged(VoidPointer p) {
        return p.allBitsIn(1L);
    }

    @Override
    public String getTableName() {
        try {
            return this._table.tableName().getCStringAtOffset(0L);
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Error getting name", e, true);
            return null;
        }
    }

    @Override
    public long getCount() {
        try {
            return this._table.numberOfNodes().longValue();
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Error getting table count", e, true);
            return 0L;
        }
    }

    @Override
    public StructType find(StructType entry) throws CorruptDataException {
        U32 tableSize = this._table.tableSize();
        UDATA stringHash = this._hashFn.hash(entry);
        UDATA hash = stringHash.mod(tableSize);
        PointerPointer head = this._table.nodes().add(hash);
        VoidPointer findNode = VoidPointer.NULL;
        findNode = head.at(0L).isNull() ? VoidPointer.NULL : (this.isAVLTreeTagged(head.at(0L)) ? this.hashTableFindNodeInTree(this._table, entry, head) : this.hashTableFindNodeInList(this._table, entry, head));
        if (!this._isInline && findNode.notNull()) {
            findNode = PointerPointer.cast(findNode).at(0L);
        }
        AbstractPointer node = (AbstractPointer)DataType.getStructure(this._structType, findNode.getAddress());
        return (StructType)node;
    }

    private VoidPointer hashTableFindNodeInTree(J9HashTablePointer table, StructType entry, PointerPointer head) throws CorruptDataException {
        J9AVLTreePointer tree = this.avlTreeUntag(head.at(0L));
        AVLTree avlTree = AVLTree.fromJ9AVLTreePointer(tree, this._avlTreeComparatorFunction);
        J9AVLTreeNodePointer searchResult = avlTree.search(UDATA.cast(entry));
        if (searchResult.notNull()) {
            return this.avlNodeToData(searchResult);
        }
        return VoidPointer.NULL;
    }

    private VoidPointer hashTableFindNodeInList(J9HashTablePointer table, StructType entry, PointerPointer head) throws CorruptDataException {
        VoidPointer node = head.at(0L);
        AbstractPointer currentStruct = (AbstractPointer)DataType.getStructure(this._structType, node.getAddress());
        while (node.notNull() && !this._equalFunctionWrapper.equal(currentStruct, entry)) {
            node = this.nextEA(node).at(0L);
            currentStruct = (AbstractPointer)DataType.getStructure(this._structType, node.getAddress());
        }
        return VoidPointer.cast(currentStruct);
    }

    @Override
    public SlotIterator<StructType> iterator() {
        return new HashTableSlotIterator();
    }

    private class AVLTreeComparatorFunction
    implements IAVLSearchComparator {
        private AVLTreeComparatorFunction() {
        }

        @Override
        public int searchComparator(J9AVLTreePointer tree, UDATA searchValue, J9AVLTreeNodePointer node) throws CorruptDataException {
            VoidPointer data = HashTable_V2.this.avlNodeToData(node);
            AbstractPointer node1 = (AbstractPointer)DataType.getStructure(HashTable_V2.this._structType, searchValue.longValue());
            AbstractPointer node2 = null;
            node2 = HashTable_V2.this._isInline ? (AbstractPointer)DataType.getStructure(HashTable_V2.this._structType, data.longValue()) : (AbstractPointer)DataType.getStructure(HashTable_V2.this._structType, PointerPointer.cast(data).at(0L).longValue());
            return HashTable_V2.this._comparatorFn.compare(node1, node2);
        }
    }

    private class EqualFunctionFromComparator
    extends EqualFunctionWrapper {
        private EqualFunctionFromComparator() {
        }

        @Override
        public boolean equal(StructType entry1, StructType entry2) throws CorruptDataException {
            if (!HashTable_V2.this._isInline) {
                entry1 = (AbstractPointer)DataType.getStructure(HashTable_V2.this._structType, PointerPointer.cast(entry1).at(0L).longValue());
            }
            return 0 == HashTable_V2.this._comparatorFn.compare(entry1, entry2);
        }
    }

    private class EqualFunctionWrapper {
        private EqualFunctionWrapper() {
        }

        public boolean equal(StructType entry1, StructType entry2) throws CorruptDataException {
            if (!HashTable_V2.this._isInline) {
                entry1 = (AbstractPointer)DataType.getStructure(HashTable_V2.this._structType, PointerPointer.cast(entry1).at(0L).longValue());
            }
            return HashTable_V2.this._equalFn.equal(entry1, entry2);
        }
    }

    private final class HashTableSlotIterator
    implements SlotIterator<StructType> {
        SlotIterator<PointerPointer> listPoolIterator = null;
        SlotIterator<J9AVLTreeNodePointer> treePoolIterator = null;

        public HashTableSlotIterator() {
            try {
                this.listPoolIterator = Pool.fromJ9Pool(HashTable_V2.this._table.nodePool(), PointerPointer.class).iterator();
            }
            catch (CorruptDataException cde) {
                EventManager.raiseCorruptDataEvent("Error getting ListNodePool iterator", cde, false);
            }
            try {
                J9PoolPointer treeNodePool = HashTable_V2.this._table.treeNodePool();
                this.treePoolIterator = treeNodePool.notNull() ? Pool.fromJ9Pool(treeNodePool, J9AVLTreeNodePointer.class).iterator() : null;
            }
            catch (CorruptDataException cde) {
                EventManager.raiseCorruptDataEvent("Error getting TreeNodePool iterator", cde, false);
            }
        }

        @Override
        public boolean hasNext() {
            if (null != this.listPoolIterator && this.listPoolIterator.hasNext()) {
                return true;
            }
            return null != this.treePoolIterator && this.treePoolIterator.hasNext();
        }

        @Override
        public StructType next() {
            AbstractPointer result = null;
            PointerPointer data = null;
            if (this.listPoolIterator.hasNext()) {
                data = (PointerPointer)this.listPoolIterator.next();
            } else if (this.treePoolIterator.hasNext()) {
                J9AVLTreeNodePointer node = (J9AVLTreeNodePointer)this.treePoolIterator.next();
                data = PointerPointer.cast(HashTable_V2.this.avlNodeToData(node));
            } else {
                throw new NoSuchElementException("There are no more available elements");
            }
            try {
                result = HashTable_V2.this._isInline ? (AbstractPointer)DataType.getStructure(HashTable_V2.this._structType.getSimpleName(), data.getAddress()) : (AbstractPointer)DataType.getStructure(HashTable_V2.this._structType.getSimpleName(), PointerPointer.cast(data).at(0L).getAddress());
            }
            catch (CorruptDataException cde) {
                EventManager.raiseCorruptDataEvent("Pool element corrupted", cde, true);
            }
            return result;
        }

        @Override
        public VoidPointer nextAddress() {
            if (HashTable_V2.this._isInline) {
                throw new UnsupportedOperationException("Not supported.");
            }
            VoidPointer next = null;
            if (this.listPoolIterator.hasNext()) {
                next = this.listPoolIterator.nextAddress();
            } else if (this.treePoolIterator.hasNext()) {
                next = HashTable_V2.this.avlNodeToData((J9AVLTreeNodePointer)this.treePoolIterator.next());
            } else {
                throw new NoSuchElementException("There are no more available elements");
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("The J9HashTable is read only and cannot be modified.");
        }
    }
}

