/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm27.j9.walkers.MemoryCategoryIterator;
import com.ibm.j9ddr.vm27.pointer.generated.J9MemCategoryPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9PortLibraryPointer;
import com.ibm.j9ddr.vm27.types.U32;
import com.ibm.j9ddr.vm27.view.dtfj.DTFJContext;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class NativeMemInfoCommand
extends Command {
    private PrintStream out;
    private Map<U32, J9MemCategoryPointer> rootSetMap;
    private DecimalFormat myFormatter = new DecimalFormat("#,###");

    public NativeMemInfoCommand() {
        this.addCommand("nativememinfo", "", "Dump the native memory info");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        this.out = out;
        try {
            this.computeMap(DTFJContext.getVm().portLibrary());
            Iterator<? extends J9MemCategoryPointer> categories = MemoryCategoryIterator.iterateCategoryRootSet(DTFJContext.getVm().portLibrary());
            while (categories.hasNext()) {
                J9MemCategoryPointer next = categories.next();
                this.printSections(next, 0);
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    void printSections(J9MemCategoryPointer next, int level) throws CorruptDataException {
        ComponentSizeAllocation csa = this.computeSize(next);
        if (csa.size == 0L) {
            return;
        }
        this.printLine(level, next.name().getCStringAtOffset(0L), csa.size, csa.allocations);
        int numberOfChildren = next.numberOfChildren().intValue();
        for (int i = 0; i < numberOfChildren; ++i) {
            U32 childCode = next.children().at(i);
            J9MemCategoryPointer child = this.rootSetMap.get(childCode);
            this.printSections(child, level + 1);
        }
        long liveBytes = next.liveBytes().longValue();
        if (liveBytes < csa.size && liveBytes != 0L) {
            this.printLine(level + 1, "Other", liveBytes, next.liveAllocations().longValue());
        }
    }

    private void printLine(int level, String name, long liveBytes, long liveAllocations) {
        int i;
        for (i = 0; i < level; ++i) {
            this.out.print("|  ");
        }
        this.out.println();
        for (i = 0; i < level; ++i) {
            this.out.print(i == level - 1 ? "+--" : "|  ");
        }
        CommandUtils.dbgPrint(this.out, "%s: %s bytes / %d allocation%s\n", name, this.myFormatter.format(liveBytes), liveAllocations, liveAllocations > 1L ? "s" : "");
    }

    private ComponentSizeAllocation computeSize(J9MemCategoryPointer mcp) throws CorruptDataException {
        ComponentSizeAllocation csa = new ComponentSizeAllocation();
        csa.size += mcp.liveBytes().longValue();
        csa.allocations += mcp.liveAllocations().longValue();
        int numberOfChildren = mcp.numberOfChildren().intValue();
        for (int i = 0; i < numberOfChildren; ++i) {
            U32 childCode = mcp.children().at(i);
            J9MemCategoryPointer child = this.rootSetMap.get(childCode);
            csa.add(this.computeSize(child));
        }
        return csa;
    }

    private void computeMap(J9PortLibraryPointer portLibrary) throws CorruptDataException {
        this.rootSetMap = new HashMap<U32, J9MemCategoryPointer>();
        Iterator<J9MemCategoryPointer> categoryIt = MemoryCategoryIterator.iterateAllCategories(portLibrary);
        while (categoryIt.hasNext()) {
            J9MemCategoryPointer thisCategory = categoryIt.next();
            this.rootSetMap.put(thisCategory.categoryCode(), thisCategory);
        }
    }

    private class ComponentSizeAllocation {
        protected long size;
        protected long allocations;

        private ComponentSizeAllocation() {
        }

        public void add(ComponentSizeAllocation computeSize) {
            this.size += computeSize.size;
            this.allocations += computeSize.allocations;
        }
    }
}

