/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm28.events.EventManager;
import com.ibm.j9ddr.vm28.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm28.j9.DataType;
import com.ibm.j9ddr.vm28.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm28.j9.J9ObjectFieldOffsetIterator_V2;
import com.ibm.j9ddr.vm28.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm28.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm28.types.U32;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public abstract class J9ObjectFieldOffsetIterator
implements Iterator<J9ObjectFieldOffset> {
    public static Iterator<J9ObjectFieldOffset> J9ObjectFieldOffsetIteratorFor(J9ROMClassPointer romClass, J9ClassPointer clazz, J9ClassPointer superClazz, U32 flags) {
        try {
            return J9ObjectFieldOffsetIterator.getImpl(J9RASHelper.getVM(DataType.getJ9RASPointer()), romClass, clazz, superClazz, flags, "ALG_OBJECT_FIELD_OFFSET_VERSION");
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Could not create a field offset iterator", e, true);
            Set emptySet = Collections.emptySet();
            return emptySet.iterator();
        }
    }

    public static Iterator<J9ObjectFieldOffset> J9ObjectFieldOffsetIteratorFor(J9ClassPointer clazz, J9ClassPointer superClazz, U32 flags) {
        try {
            return J9ObjectFieldOffsetIterator.getImpl(J9RASHelper.getVM(DataType.getJ9RASPointer()), clazz.romClass(), clazz, superClazz, flags, "ALG_OBJECT_FIELD_OFFSET_VERSION");
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Could not create a field offset iterator", e, true);
            Set emptySet = Collections.emptySet();
            return emptySet.iterator();
        }
    }

    private static J9ObjectFieldOffsetIterator getImpl(J9JavaVMPointer vm, J9ROMClassPointer romClass, J9ClassPointer clazz, J9ClassPointer superClazz, U32 flags, String algorithmID) {
        switch (AlgorithmVersion.getVMMinorVersion()) {
            default: 
        }
        return new J9ObjectFieldOffsetIterator_V2(vm, romClass, clazz, superClazz, flags);
    }

    @Override
    public abstract boolean hasNext();

    @Override
    public abstract J9ObjectFieldOffset next();

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

