/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm28.events.EventManager;
import com.ibm.j9ddr.vm28.j9.gc.GCIterator;
import com.ibm.j9ddr.vm28.pointer.VoidPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ITablePointer;
import com.ibm.j9ddr.vm28.pointer.helper.J9ClassHelper;
import java.util.NoSuchElementException;

public class GCClassLocalInterfaceIterator
extends GCIterator {
    protected J9ITablePointer iTable;
    protected J9ITablePointer superclassITable;

    protected GCClassLocalInterfaceIterator(J9ClassPointer clazz) throws CorruptDataException {
        this.iTable = J9ITablePointer.cast(clazz.iTable());
        J9ClassPointer superclass = J9ClassHelper.superclass(clazz);
        this.superclassITable = superclass.isNull() ? J9ITablePointer.NULL : J9ITablePointer.cast(superclass.iTable());
    }

    public static GCClassLocalInterfaceIterator fromJ9Class(J9ClassPointer clazz) throws CorruptDataException {
        return new GCClassLocalInterfaceIterator(clazz);
    }

    @Override
    public boolean hasNext() {
        return !this.iTable.eq(this.superclassITable);
    }

    @Override
    public J9ClassPointer next() {
        if (this.hasNext()) {
            try {
                J9ClassPointer next = this.iTable.interfaceClass();
                this.iTable = this.iTable.next();
                return next;
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
                return null;
            }
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    @Override
    public VoidPointer nextAddress() {
        if (this.hasNext()) {
            try {
                VoidPointer next = VoidPointer.cast(this.iTable.interfaceClassEA());
                this.iTable = this.iTable.next();
                return next;
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
                return null;
            }
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }
}

