/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm28.j9.DataType;
import com.ibm.j9ddr.vm28.pointer.AbstractPointer;
import com.ibm.j9ddr.vm28.pointer.IDATAPointer;
import com.ibm.j9ddr.vm28.pointer.Pointer;
import com.ibm.j9ddr.vm28.pointer.VoidPointer;
import com.ibm.j9ddr.vm28.types.IDATA;
import com.ibm.j9ddr.vm28.types.Scalar;
import com.ibm.j9ddr.vm28.types.UDATA;

public class WideSelfRelativePointer
extends Pointer {
    public static final WideSelfRelativePointer NULL = new WideSelfRelativePointer(0L);
    public static final long SIZEOF = IDATAPointer.SIZEOF;

    protected WideSelfRelativePointer(long address) {
        super(address);
    }

    public static WideSelfRelativePointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new WideSelfRelativePointer(address);
    }

    public static WideSelfRelativePointer cast(UDATA address) {
        return WideSelfRelativePointer.cast(address.longValue());
    }

    public static WideSelfRelativePointer cast(AbstractPointer pointer) {
        return WideSelfRelativePointer.cast(pointer.address);
    }

    @Override
    public WideSelfRelativePointer add(long count) {
        return new WideSelfRelativePointer(this.address + count * SIZEOF);
    }

    @Override
    public WideSelfRelativePointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public WideSelfRelativePointer addOffset(long offset) {
        return new WideSelfRelativePointer(this.address + offset);
    }

    @Override
    public WideSelfRelativePointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public DataType at(long index) throws CorruptDataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataType at(Scalar index) throws CorruptDataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public WideSelfRelativePointer untag() {
        return this.untag(SIZEOF - 1L);
    }

    @Override
    public WideSelfRelativePointer untag(long mask) {
        return new WideSelfRelativePointer(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public WideSelfRelativePointer sub(long count) {
        return new WideSelfRelativePointer(this.address - count * SIZEOF);
    }

    @Override
    public WideSelfRelativePointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public WideSelfRelativePointer subOffset(long offset) {
        return new WideSelfRelativePointer(this.address - offset);
    }

    @Override
    public WideSelfRelativePointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    public VoidPointer get() throws CorruptDataException {
        IDATA offset = IDATAPointer.cast(this).at(0L);
        if (offset.eq(0L)) {
            return VoidPointer.NULL;
        }
        return VoidPointer.cast(this.addOffset(offset));
    }

    @Override
    protected long sizeOfBaseType() {
        return SIZEOF;
    }
}

