/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.view.dtfj.java;

import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaRuntimeMemoryCategory;
import com.ibm.dtfj.java.JavaRuntimeMemorySection;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.vm28.pointer.generated.J9MemTagPointer;
import com.ibm.j9ddr.vm28.pointer.helper.J9MemTagHelper;
import com.ibm.j9ddr.vm28.structure.J9PortLibrary;
import com.ibm.j9ddr.vm28.types.U32;
import com.ibm.j9ddr.vm28.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm28.view.dtfj.java.DTFJJavaRuntimeMemoryCategory;
import com.ibm.j9ddr.vm28.view.dtfj.java.DTFJJavaRuntimeMemorySectionBase;

public class DTFJMemoryTagRuntimeMemorySection
extends DTFJJavaRuntimeMemorySectionBase
implements JavaRuntimeMemorySection {
    private final J9MemTagPointer memoryTag;
    private final JavaRuntime runtime;

    public DTFJMemoryTagRuntimeMemorySection(JavaRuntime runtime, J9MemTagPointer memoryTag) {
        this.memoryTag = memoryTag;
        this.runtime = runtime;
    }

    public int getAllocationType() {
        try {
            U32 eyeCatcher = this.memoryTag.eyeCatcher();
            if (eyeCatcher.eq(J9PortLibrary.J9MEMTAG_EYECATCHER_ALLOC_HEADER)) {
                return 1;
            }
            return 2;
        }
        catch (Exception e) {
            J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), e);
        }
        catch (NoSuchFieldError e) {
            J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), e);
        }
        return 1;
    }

    public String getAllocator() throws com.ibm.dtfj.image.CorruptDataException, DataUnavailable {
        try {
            return this.memoryTag.callSite().getCStringAtOffset(0L);
        }
        catch (Exception e) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), e);
        }
        catch (NoSuchFieldError e) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), e);
        }
    }

    public JavaRuntimeMemoryCategory getMemoryCategory() throws com.ibm.dtfj.image.CorruptDataException, DataUnavailable {
        try {
            return new DTFJJavaRuntimeMemoryCategory(this.runtime, this.memoryTag.category());
        }
        catch (Exception e) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), e);
        }
        catch (NoSuchFieldError e) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), e);
        }
    }

    public String getName() {
        StringBuilder b = new StringBuilder();
        b.append("JVM malloc'd storage allocated by ");
        try {
            String name = this.memoryTag.callSite().getCStringAtOffset(0L);
            b.append(name);
        }
        catch (CorruptDataException e) {
            b.append("unknown (callsite unreadable)");
        }
        return b.toString();
    }

    public long getSize() {
        try {
            return this.memoryTag.allocSize().longValue();
        }
        catch (CorruptDataException corruptDataException) {
        }
        catch (Exception e) {
            J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), e);
        }
        catch (NoSuchFieldError e) {
            J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), e);
        }
        return 0L;
    }

    @Override
    protected long getBaseAddressAsLong() {
        return J9MemTagHelper.j9mem_get_memory_base(this.memoryTag).getAddress();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.memoryTag == null ? 0 : this.memoryTag.hashCode());
        result = 31 * result + (this.runtime == null ? 0 : this.runtime.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DTFJMemoryTagRuntimeMemorySection)) {
            return false;
        }
        DTFJMemoryTagRuntimeMemorySection other = (DTFJMemoryTagRuntimeMemorySection)obj;
        if (this.memoryTag == null ? other.memoryTag != null : !this.memoryTag.equals(other.memoryTag)) {
            return false;
        }
        return !(this.runtime == null ? other.runtime != null : !this.runtime.equals((Object)other.runtime));
    }
}

