/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.j9.ObjectModel;
import com.ibm.j9ddr.vm29.j9.gc.GCEmptyObjectIterator_V1;
import com.ibm.j9ddr.vm29.j9.gc.GCIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCMixedObjectIterator_V1;
import com.ibm.j9ddr.vm29.j9.gc.GCPointerArrayletIterator_V1;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.structure.J9Object;
import com.ibm.j9ddr.vm29.types.UDATA;

public abstract class GCObjectIterator
extends GCIterator {
    protected J9ObjectPointer object;
    protected boolean includeClassSlot;

    protected GCObjectIterator(J9ObjectPointer object, boolean includeClassSlot) throws CorruptDataException {
        this.object = object;
        this.includeClassSlot = includeClassSlot;
    }

    @Override
    public abstract boolean hasNext();

    @Override
    public abstract J9ObjectPointer next();

    @Override
    public abstract VoidPointer nextAddress();

    public static GCObjectIterator fromJ9Object(J9ObjectPointer object, boolean includeClassSlot) throws CorruptDataException {
        if (ObjectModel.isIndexable(object)) {
            UDATA classShape = ObjectModel.getClassShape(object);
            if (classShape.eq(J9Object.OBJECT_HEADER_SHAPE_POINTERS)) {
                return GCObjectIterator.getPointerArrayImpl(object, includeClassSlot);
            }
            return GCObjectIterator.getEmptyObjectIteratorImpl(object, includeClassSlot);
        }
        return GCObjectIterator.getMixedObjectIteratorImpl(object, includeClassSlot);
    }

    public static GCObjectIterator fromJ9Class(J9ClassPointer clazz, VoidPointer addr) throws CorruptDataException {
        if (J9ClassHelper.isArrayClass(clazz)) {
            UDATA classShape = ObjectModel.getClassShape(clazz);
            if (classShape.eq(J9Object.OBJECT_HEADER_SHAPE_POINTERS)) {
                return GCObjectIterator.getPointerArrayImpl(clazz, addr);
            }
            return GCObjectIterator.getEmptyObjectIteratorImpl(clazz, addr);
        }
        return GCObjectIterator.getMixedObjectIteratorImpl(clazz, addr);
    }

    private static GCObjectIterator getPointerArrayImpl(J9ObjectPointer object, boolean includeClassSlot) throws CorruptDataException {
        AlgorithmVersion version = AlgorithmVersion.getVersionOf("ALG_GC_POINTER_ARRAYLET_ITERATOR_VERSION");
        switch (version.getAlgorithmVersion()) {
            default: 
        }
        return new GCPointerArrayletIterator_V1(object, includeClassSlot);
    }

    private static GCObjectIterator getPointerArrayImpl(J9ClassPointer clazz, VoidPointer addr) throws CorruptDataException {
        throw new IllegalArgumentException("Not implemented yet");
    }

    private static GCObjectIterator getEmptyObjectIteratorImpl(J9ObjectPointer object, boolean includeClassSlot) throws CorruptDataException {
        AlgorithmVersion version = AlgorithmVersion.getVersionOf("ALG_GC_EMPTY_OBJECT_ITERATOR_VERSION");
        switch (version.getAlgorithmVersion()) {
            default: 
        }
        return new GCEmptyObjectIterator_V1(object, includeClassSlot);
    }

    private static GCObjectIterator getEmptyObjectIteratorImpl(J9ClassPointer clazz, VoidPointer addr) throws CorruptDataException {
        AlgorithmVersion version = AlgorithmVersion.getVersionOf("ALG_GC_EMPTY_OBJECT_ITERATOR_VERSION");
        switch (version.getAlgorithmVersion()) {
            default: 
        }
        return new GCEmptyObjectIterator_V1(null, false);
    }

    private static GCObjectIterator getMixedObjectIteratorImpl(J9ObjectPointer object, boolean includeClassSlot) throws CorruptDataException {
        AlgorithmVersion version = AlgorithmVersion.getVersionOf("ALG_GC_MIXED_OBJECT_ITERATOR_VERSION");
        switch (version.getAlgorithmVersion()) {
            default: 
        }
        return new GCMixedObjectIterator_V1(object, includeClassSlot);
    }

    private static GCObjectIterator getMixedObjectIteratorImpl(J9ClassPointer clazz, VoidPointer addr) throws CorruptDataException {
        AlgorithmVersion version = AlgorithmVersion.getVersionOf("ALG_GC_MIXED_OBJECT_ITERATOR_VERSION");
        switch (version.getAlgorithmVersion()) {
            default: 
        }
        return new GCMixedObjectIterator_V1(clazz, addr);
    }
}

