/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.util.PatternString;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.HashTable;
import com.ibm.j9ddr.vm29.j9.ModuleHashTable;
import com.ibm.j9ddr.vm29.j9.gc.GCClassLoaderIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ModulePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.JavaVersionHelper;
import java.io.PrintStream;
import java.util.Iterator;

public class FindAllReadsCommand
extends Command {
    public FindAllReadsCommand() {
        this.addCommand("findallreads", "<targetModuleAddress>", "find all modules that read target module");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (args.length != 1) {
            CommandUtils.dbgPrint(out, "Usage: !findallreads <targetModuleAddress>\n");
            return;
        }
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            if (JavaVersionHelper.ensureJava9AndUp(vm, out)) {
                GCClassLoaderIterator iterator = GCClassLoaderIterator.from();
                int hitCount = 0;
                String searchModuleAddress = args[0];
                PatternString pattern = new PatternString(searchModuleAddress);
                while (iterator.hasNext()) {
                    J9ClassLoaderPointer classLoaderPointer = iterator.next();
                    HashTable<J9ModulePointer> moduleHashTable = ModuleHashTable.fromJ9HashTable(classLoaderPointer.moduleHashTable());
                    Iterator slotIterator = moduleHashTable.iterator();
                    block3: while (slotIterator.hasNext()) {
                        J9ModulePointer modulePtr = (J9ModulePointer)slotIterator.next();
                        String moduleName = J9ObjectHelper.stringValue(modulePtr.moduleName());
                        String hexAddress = modulePtr.getHexAddress();
                        J9HashTablePointer readTable = modulePtr.readAccessHashTable();
                        HashTable<J9ModulePointer> readModuleHashTable = ModuleHashTable.fromJ9HashTable(readTable);
                        Iterator readSlotIterator = readModuleHashTable.iterator();
                        while (readSlotIterator.hasNext()) {
                            J9ModulePointer readModulePtr = (J9ModulePointer)readSlotIterator.next();
                            String readHexAddress = readModulePtr.getHexAddress();
                            if (!pattern.isMatch(readHexAddress)) continue;
                            ++hitCount;
                            out.printf("%-30s !j9module %s%n", moduleName, hexAddress);
                            continue block3;
                        }
                    }
                }
                out.printf("Found %d module(s) that read(s) from !j9module %s%n", hitCount, searchModuleAddress);
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }
}

