/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29_00.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29_00.events.EventManager;
import com.ibm.j9ddr.vm29_00.j9.DataType;
import com.ibm.j9ddr.vm29_00.j9.gc.GCCardCleaner;
import com.ibm.j9ddr.vm29_00.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm29_00.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm29_00.pointer.U8Pointer;
import com.ibm.j9ddr.vm29_00.pointer.VoidPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.MM_CardTablePointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm29_00.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29_00.structure.J9ModroncoreConstants;
import com.ibm.j9ddr.vm29_00.types.U8;
import com.ibm.j9ddr.vm29_00.types.UDATA;
import java.util.Iterator;

public class GCCardTable {
    private MM_CardTablePointer _cardTable;
    private U8Pointer _cardTableVirtualStart;
    private VoidPointer _heapBase;
    private U8Pointer _cardTableStart;
    static UDATA CARD_SIZE_SHIFT = new UDATA(J9ModroncoreConstants.CARD_SIZE_SHIFT);

    public GCCardTable(MM_CardTablePointer cardTable) throws CorruptDataException {
        this._cardTable = cardTable;
        this._cardTableVirtualStart = cardTable._cardTableVirtualStart();
        this._heapBase = cardTable._heapBase();
        this._cardTableStart = cardTable._cardTableStart();
    }

    public static GCCardTable from() throws CorruptDataException {
        J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
        MM_GCExtensionsPointer extensions = GCExtensions.getGCExtensionsPointer();
        MM_CardTablePointer cardTable = extensions.cardTable();
        return new GCCardTable(cardTable);
    }

    public U8Pointer heapAddrToCardAddr(VoidPointer heapAddr) {
        UDATA index = UDATA.cast(heapAddr).rightShift(CARD_SIZE_SHIFT);
        return this._cardTableVirtualStart.add(index);
    }

    public VoidPointer cardAddrToHeapAddr(U8Pointer cardAddr) {
        UDATA index = UDATA.cast(cardAddr).sub(UDATA.cast(this._cardTableStart));
        UDATA delta = index.leftShift(CARD_SIZE_SHIFT);
        return this._heapBase.addOffset(delta);
    }

    public void cleanRange(U8Pointer lowCard, U8Pointer highCard, GCCardCleaner cardCleaner) throws CorruptDataException {
        U8Pointer thisCard = lowCard;
        U8Pointer endCard = highCard;
        while (thisCard.lt(endCard)) {
            try {
                U8 card = thisCard.at(0L);
                if (!card.eq(J9ModroncoreConstants.CARD_CLEAN)) {
                    VoidPointer lowAddress = this.cardAddrToHeapAddr(thisCard);
                    VoidPointer highAddress = lowAddress.addOffset(J9ModroncoreConstants.CARD_SIZE);
                    cardCleaner.clean(lowAddress, highAddress, thisCard);
                }
            }
            catch (CorruptDataException cde) {
                EventManager.raiseCorruptDataEvent("Corrupt Card", cde, false);
            }
            thisCard = thisCard.add(1L);
        }
    }

    public void cleanCardsInRegion(GCHeapRegionDescriptor region, GCCardCleaner cardCleaner) throws CorruptDataException {
        U8Pointer lowCard = this.heapAddrToCardAddr(region.getLowAddress());
        U8Pointer highCard = this.heapAddrToCardAddr(region.getHighAddress());
        this.cleanRange(lowCard, highCard, cardCleaner);
    }

    public void cleanCardsInRegions(Iterator<GCHeapRegionDescriptor> regionIterator, GCCardCleaner cardCleaner) throws CorruptDataException {
        while (regionIterator.hasNext()) {
            GCHeapRegionDescriptor region = regionIterator.next();
            this.cleanCardsInRegion(region, cardCleaner);
        }
    }
}

