/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29_00.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29_00.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm29_00.j9.J9ObjectFieldOffsetIterator;
import com.ibm.j9ddr.vm29_00.pointer.BoolPointer;
import com.ibm.j9ddr.vm29_00.pointer.DoublePointer;
import com.ibm.j9ddr.vm29_00.pointer.FloatPointer;
import com.ibm.j9ddr.vm29_00.pointer.I16Pointer;
import com.ibm.j9ddr.vm29_00.pointer.I32Pointer;
import com.ibm.j9ddr.vm29_00.pointer.I64Pointer;
import com.ibm.j9ddr.vm29_00.pointer.I8Pointer;
import com.ibm.j9ddr.vm29_00.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29_00.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29_00.pointer.helper.J9ROMFieldShapeHelper;
import com.ibm.j9ddr.vm29_00.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29_00.structure.J9ROMFieldOffsetWalkState;
import com.ibm.j9ddr.vm29_00.types.U32;
import java.io.PrintStream;
import java.util.Iterator;

public class J9StaticsCommand
extends Command {
    public J9StaticsCommand() {
        this.addCommand("j9statics", "<ramclass>", "Display static fields of a ram class");
    }

    long staticFieldAddress(J9VMThreadPointer vmStruct, J9ROMClassPointer romClass, String fieldName, String signature, long options) {
        return 0L;
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            if (args.length != 1) {
                CommandUtils.dbgPrint(out, "Usage: !j9statics <classAddress>\n");
                return;
            }
            long address = CommandUtils.parsePointer(args[0], J9BuildFlags.env_data64);
            J9ClassPointer ramClass = J9ClassPointer.cast(address);
            J9ROMClassPointer romClass = ramClass.romClass();
            J9UTF8Pointer className = romClass.className();
            CommandUtils.dbgPrint(out, "Static fields in %s:\n", J9UTF8Helper.stringValue(className));
            Iterator<J9ObjectFieldOffset> ofoIterator = J9ObjectFieldOffsetIterator.J9ObjectFieldOffsetIteratorFor(ramClass, J9ClassHelper.superclass(ramClass), new U32(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_STATIC));
            block12: while (ofoIterator.hasNext()) {
                J9ObjectFieldOffset fieldOffset = ofoIterator.next();
                J9ROMFieldShapePointer field = fieldOffset.getField();
                String name = J9ROMFieldShapeHelper.getName(field);
                String sig = J9ROMFieldShapeHelper.getSignature(field);
                UDATAPointer fieldAddress = ramClass.ramStatics().addOffset(fieldOffset.getOffsetOrAddress());
                switch (sig.charAt(0)) {
                    case 'L': 
                    case '[': {
                        CommandUtils.dbgPrint(out, "\t%s %s %s (!j9romstaticstringfieldshape %s) = !j9object %s\n", fieldAddress.getHexAddress(), name, sig, field.getHexAddress(), fieldAddress.at(0L).getHexValue());
                        continue block12;
                    }
                    case 'D': {
                        DoublePointer doublePointer = DoublePointer.cast(fieldAddress);
                        CommandUtils.dbgPrint(out, "\t%s %s %s (!j9romstaticdoublefieldshape %s) = %s (%s)\n", fieldAddress.getHexAddress(), name, sig, field.getHexAddress(), doublePointer.getHexValue(), Double.valueOf(doublePointer.doubleAt(0L)).toString());
                        continue block12;
                    }
                    case 'F': {
                        FloatPointer floatPointer = FloatPointer.cast(fieldAddress);
                        CommandUtils.dbgPrint(out, "\t%s %s %s (!j9romstaticsinglefieldshape %s) = %s (%s)\n", fieldAddress.getHexAddress(), name, sig, field.getHexAddress(), floatPointer.getHexValue(), Float.valueOf(floatPointer.floatAt(0L)).toString());
                        continue block12;
                    }
                    case 'J': {
                        I64Pointer longPointer = I64Pointer.cast(fieldAddress);
                        CommandUtils.dbgPrint(out, "\t%s %s %s (!j9romstaticdoublefieldshape %s) = %s (%d)\n", fieldAddress.getHexAddress(), name, sig, field.getHexAddress(), longPointer.getHexValue(), longPointer.at(0L).longValue());
                        continue block12;
                    }
                    case 'I': {
                        I32Pointer intPointer = I32Pointer.cast(fieldAddress);
                        CommandUtils.dbgPrint(out, "\t%s %s %s (!j9romstaticsinglefieldshape %s) = %s (%d)\n", fieldAddress.getHexAddress(), name, sig, field.getHexAddress(), intPointer.getHexValue(), intPointer.at(0L).intValue());
                        continue block12;
                    }
                    case 'B': {
                        I8Pointer bytePointer = I8Pointer.cast(fieldAddress);
                        CommandUtils.dbgPrint(out, "\t%s %s %s (!j9romstaticsinglefieldshape %s) = %s (%s)\n", fieldAddress.getHexAddress(), name, sig, field.getHexAddress(), bytePointer.getHexValue(), bytePointer.at(0L).byteValue());
                        continue block12;
                    }
                    case 'S': {
                        I16Pointer shortPointer = I16Pointer.cast(fieldAddress);
                        CommandUtils.dbgPrint(out, "\t%s %s %s (!j9romstaticsinglefieldshape %s) = %s (%d)\n", fieldAddress.getHexAddress(), name, sig, field.getHexAddress(), shortPointer.getHexValue(), shortPointer.at(0L).shortValue());
                        continue block12;
                    }
                    case 'Z': {
                        BoolPointer booleanPointer = BoolPointer.cast(fieldAddress);
                        CommandUtils.dbgPrint(out, "\t%s %s %s (!j9romstaticsinglefieldshape %s) = %s (%s)\n", fieldAddress.getHexAddress(), name, sig, field.getHexAddress(), booleanPointer.getHexValue(), booleanPointer.boolAt(0L) ? "true" : "false");
                        continue block12;
                    }
                }
                CommandUtils.dbgPrint(out, "\t%s %s %s (!j9romstaticsinglefieldshape %s) = %s\n", fieldAddress.getHexAddress(), name, sig, field.getHexAddress(), fieldAddress.at(0L).getHexValue());
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }
}

