/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.List;
import sun.awt.IconInfo;
import sun.awt.X11.AwtGraphicsConfigData;
import sun.awt.X11.ColorData;
import sun.awt.X11.Native;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XDecoratedPeer;
import sun.awt.X11.XIconSize;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XVisualInfo;
import sun.awt.X11.XWM;
import sun.awt.X11.XWMHints;
import sun.awt.X11.XlibWrapper;
import sun.awt.X11.awtImageData;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.ToolkitImage;
import sun.util.logging.PlatformLogger;

public class XIconWindow
extends XBaseWindow {
    private static final PlatformLogger log = PlatformLogger.getLogger("sun.awt.X11.XIconWindow");
    XDecoratedPeer parent;
    Dimension size;
    long iconPixmap = 0L;
    long iconMask = 0L;
    int iconWidth = 0;
    int iconHeight = 0;

    XIconWindow(XDecoratedPeer xDecoratedPeer) {
        super(new XCreateWindowParams(new Object[]{"parent", xDecoratedPeer, "delayed", Boolean.TRUE}));
    }

    @Override
    void instantPreInit(XCreateWindowParams xCreateWindowParams) {
        super.instantPreInit(xCreateWindowParams);
        this.parent = (XDecoratedPeer)xCreateWindowParams.get("parent");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XIconSize[] getIconSizes() {
        XToolkit.awtLock();
        try {
            long l;
            AwtGraphicsConfigData awtGraphicsConfigData = this.parent.getGraphicsConfigurationData();
            long l2 = awtGraphicsConfigData.get_awt_visInfo().get_screen();
            long l3 = XToolkit.getDisplay();
            if (log.isLoggable(PlatformLogger.Level.FINEST)) {
                log.finest(awtGraphicsConfigData.toString());
            }
            if ((l = (long)XlibWrapper.XGetIconSizes(l3, XToolkit.getDefaultRootWindow(), XlibWrapper.larg1, XlibWrapper.iarg1)) == 0L) {
                XIconSize[] xIconSizeArray = null;
                return xIconSizeArray;
            }
            int n = Native.getInt(XlibWrapper.iarg1);
            long l4 = Native.getLong(XlibWrapper.larg1);
            if (log.isLoggable(PlatformLogger.Level.FINEST)) {
                log.finest("count = {1}, sizes_ptr = {0}", l4, n);
            }
            XIconSize[] xIconSizeArray = new XIconSize[n];
            int n2 = 0;
            while (n2 < n) {
                xIconSizeArray[n2] = new XIconSize(l4);
                if (log.isLoggable(PlatformLogger.Level.FINEST)) {
                    log.finest("sizes_ptr[{1}] = {0}", xIconSizeArray[n2], n2);
                }
                ++n2;
                l4 += (long)XIconSize.getSize();
            }
            XIconSize[] xIconSizeArray2 = xIconSizeArray;
            return xIconSizeArray2;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension calcIconSize(int n, int n2) {
        int n3;
        if (XWM.getWMID() == 10) {
            log.finest("Returning ICE_WM icon size: 16x16");
            return new Dimension(16, 16);
        }
        XIconSize[] xIconSizeArray = this.getIconSizes();
        if (log.isLoggable(PlatformLogger.Level.FINEST)) {
            log.finest("Icon sizes: {0}", xIconSizeArray);
        }
        if (xIconSizeArray == null) {
            return new Dimension(16, 16);
        }
        boolean bl = false;
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (n3 = 0; n3 < xIconSizeArray.length; ++n3) {
            int n8;
            if (n < xIconSizeArray[n3].get_min_width() || n > xIconSizeArray[n3].get_max_width() || n2 < xIconSizeArray[n3].get_min_height() || n2 > xIconSizeArray[n3].get_max_height()) continue;
            bl = true;
            if ((n - xIconSizeArray[n3].get_min_width()) % xIconSizeArray[n3].get_width_inc() == 0 && (n2 - xIconSizeArray[n3].get_min_height()) % xIconSizeArray[n3].get_height_inc() == 0) {
                n6 = n;
                n7 = n2;
                n4 = 0;
                break;
            }
            n5 = n - xIconSizeArray[n3].get_min_width();
            int n9 = n5 == 0 ? n : n - (n5 %= xIconSizeArray[n3].get_width_inc());
            int n10 = n9 * n9 + (n8 = (n5 = n2 - xIconSizeArray[n3].get_min_height()) == 0 ? n2 : n2 - (n5 %= xIconSizeArray[n3].get_height_inc())) * n8;
            if (n4 <= n10) continue;
            n6 = n9;
            n7 = n8;
            n4 = n10;
        }
        if (log.isLoggable(PlatformLogger.Level.FINEST)) {
            log.finest("found=" + bl);
        }
        if (!bl) {
            if (log.isLoggable(PlatformLogger.Level.FINEST)) {
                log.finest("widthHint=" + n + ", heightHint=" + n2 + ", saveWidth=" + n6 + ", saveHeight=" + n7 + ", max_width=" + xIconSizeArray[0].get_max_width() + ", max_height=" + xIconSizeArray[0].get_max_height() + ", min_width=" + xIconSizeArray[0].get_min_width() + ", min_height=" + xIconSizeArray[0].get_min_height());
            }
            if (n > xIconSizeArray[0].get_max_width() || n2 > xIconSizeArray[0].get_max_height()) {
                n3 = n - xIconSizeArray[0].get_max_width();
                int n11 = n2 - xIconSizeArray[0].get_max_height();
                if (log.isLoggable(PlatformLogger.Level.FINEST)) {
                    log.finest("wdiff=" + n3 + ", hdiff=" + n11);
                }
                if (n3 >= n11) {
                    n6 = xIconSizeArray[0].get_max_width();
                    n7 = (int)((double)xIconSizeArray[0].get_max_width() / (double)n * (double)n2);
                } else {
                    n6 = (int)((double)xIconSizeArray[0].get_max_height() / (double)n2 * (double)n);
                    n7 = xIconSizeArray[0].get_max_height();
                }
            } else if (n < xIconSizeArray[0].get_min_width() || n2 < xIconSizeArray[0].get_min_height()) {
                n6 = (xIconSizeArray[0].get_min_width() + xIconSizeArray[0].get_max_width()) / 2;
                n7 = (xIconSizeArray[0].get_min_height() + xIconSizeArray[0].get_max_height()) / 2;
            } else {
                n6 = n;
                n7 = n;
            }
        }
        XToolkit.awtLock();
        try {
            XlibWrapper.XFree(xIconSizeArray[0].pData);
        }
        finally {
            XToolkit.awtUnlock();
        }
        if (log.isLoggable(PlatformLogger.Level.FINEST)) {
            log.finest("return " + n6 + "x" + n7);
        }
        return new Dimension(n6, n7);
    }

    Dimension getIconSize(int n, int n2) {
        if (this.size == null) {
            this.size = this.calcIconSize(n, n2);
        }
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replaceImage(Image image) {
        Object object;
        Object object2;
        Object object3;
        if (this.parent == null) {
            return;
        }
        BufferedImage bufferedImage = null;
        if (image != null && this.iconWidth != 0 && this.iconHeight != 0) {
            object3 = this.parent.getGraphicsConfiguration().getDevice().getDefaultConfiguration();
            object2 = ((GraphicsConfiguration)object3).getColorModel();
            object = ((ColorModel)object2).createCompatibleWritableRaster(this.iconWidth, this.iconHeight);
            bufferedImage = new BufferedImage((ColorModel)object2, (WritableRaster)object, ((ColorModel)object2).isAlphaPremultiplied(), null);
            Graphics graphics = bufferedImage.getGraphics();
            try {
                graphics.setColor(SystemColor.window);
                graphics.fillRect(0, 0, this.iconWidth, this.iconHeight);
                if (graphics instanceof Graphics2D) {
                    ((Graphics2D)graphics).setComposite(AlphaComposite.Src);
                }
                graphics.drawImage(image, 0, 0, this.iconWidth, this.iconHeight, null);
            }
            finally {
                graphics.dispose();
            }
        }
        XToolkit.awtLock();
        try {
            int n;
            if (this.iconPixmap != 0L) {
                XlibWrapper.XFreePixmap(XToolkit.getDisplay(), this.iconPixmap);
                this.iconPixmap = 0L;
                log.finest("Freed previous pixmap");
            }
            if (bufferedImage == null || this.iconWidth == 0 || this.iconHeight == 0) {
                return;
            }
            object3 = this.parent.getGraphicsConfigurationData();
            object2 = ((AwtGraphicsConfigData)object3).get_awtImage(0);
            object = ((AwtGraphicsConfigData)object3).get_awt_visInfo();
            this.iconPixmap = XlibWrapper.XCreatePixmap(XToolkit.getDisplay(), XlibWrapper.RootWindow(XToolkit.getDisplay(), ((XVisualInfo)object).get_screen()), this.iconWidth, this.iconHeight, ((awtImageData)object2).get_Depth());
            if (this.iconPixmap == 0L) {
                log.finest("Can't create new pixmap for icon");
                return;
            }
            long l = 0L;
            DataBuffer dataBuffer = bufferedImage.getData().getDataBuffer();
            if (dataBuffer instanceof DataBufferByte) {
                byte[] byArray = ((DataBufferByte)dataBuffer).getData();
                ColorData colorData = ((AwtGraphicsConfigData)object3).get_color_data(0);
                n = colorData.get_awt_numICMcolors();
                for (int i = 0; i < byArray.length; ++i) {
                    byArray[i] = byArray[i] >= n ? (byte)0 : colorData.get_awt_icmLUT2Colors(byArray[i] & 0xFF);
                }
                l = Native.toData(byArray);
            } else if (dataBuffer instanceof DataBufferInt) {
                l = Native.toData(((DataBufferInt)dataBuffer).getData());
            } else if (dataBuffer instanceof DataBufferUShort) {
                l = Native.toData(((DataBufferUShort)dataBuffer).getData());
            } else {
                throw new IllegalArgumentException("Unknown data buffer: " + dataBuffer);
            }
            int n2 = ((awtImageData)object2).get_wsImageFormat().get_bits_per_pixel();
            int n3 = ((awtImageData)object2).get_wsImageFormat().get_scanline_pad();
            n = XIconWindow.paddedwidth(this.iconWidth * n2, n3) >> 3;
            if ((n << 3) / n2 < this.iconWidth) {
                log.finest("Image format doesn't fit to icon width");
                return;
            }
            long l2 = XlibWrapper.XCreateImage(XToolkit.getDisplay(), ((XVisualInfo)object).get_visual(), ((awtImageData)object2).get_Depth(), 2, 0, l, this.iconWidth, this.iconHeight, 32, n);
            if (l2 == 0L) {
                log.finest("Can't create XImage for icon");
                XlibWrapper.XFreePixmap(XToolkit.getDisplay(), this.iconPixmap);
                this.iconPixmap = 0L;
                return;
            }
            log.finest("Created XImage for icon");
            long l3 = XlibWrapper.XCreateGC(XToolkit.getDisplay(), this.iconPixmap, 0L, 0L);
            if (l3 == 0L) {
                log.finest("Can't create GC for pixmap");
                XlibWrapper.XFreePixmap(XToolkit.getDisplay(), this.iconPixmap);
                this.iconPixmap = 0L;
                return;
            }
            log.finest("Created GC for pixmap");
            try {
                XlibWrapper.XPutImage(XToolkit.getDisplay(), this.iconPixmap, l3, l2, 0, 0, 0, 0, this.iconWidth, this.iconHeight);
            }
            finally {
                XlibWrapper.XFreeGC(XToolkit.getDisplay(), l3);
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replaceMask(Image image) {
        Object object;
        if (this.parent == null) {
            return;
        }
        BufferedImage bufferedImage = null;
        if (image != null && this.iconWidth != 0 && this.iconHeight != 0) {
            bufferedImage = new BufferedImage(this.iconWidth, this.iconHeight, 2);
            object = bufferedImage.getGraphics();
            try {
                ((Graphics)object).drawImage(image, 0, 0, this.iconWidth, this.iconHeight, null);
            }
            finally {
                ((Graphics)object).dispose();
            }
        }
        XToolkit.awtLock();
        try {
            if (this.iconMask != 0L) {
                XlibWrapper.XFreePixmap(XToolkit.getDisplay(), this.iconMask);
                this.iconMask = 0L;
                log.finest("Freed previous mask");
            }
            if (bufferedImage == null || this.iconWidth == 0 || this.iconHeight == 0) {
                return;
            }
            object = this.parent.getGraphicsConfigurationData();
            awtImageData awtImageData2 = ((AwtGraphicsConfigData)object).get_awtImage(0);
            XVisualInfo xVisualInfo = ((AwtGraphicsConfigData)object).get_awt_visInfo();
            ColorModel colorModel = bufferedImage.getColorModel();
            DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
            int n = 0;
            int n2 = this.iconWidth + 7 >> 3;
            byte[] byArray = new byte[n2 * this.iconHeight];
            int n3 = 0;
            for (int i = 0; i < this.iconHeight; ++i) {
                int n4 = 0;
                int n5 = 0;
                for (int j = 0; j < this.iconWidth; ++j) {
                    if (colorModel.getAlpha(dataBuffer.getElem(n)) != 0) {
                        n5 += 1 << n4;
                    }
                    if (++n4 == 8) {
                        byArray[n3] = (byte)n5;
                        n5 = 0;
                        n4 = 0;
                        ++n3;
                    }
                    ++n;
                }
            }
            this.iconMask = XlibWrapper.XCreateBitmapFromData(XToolkit.getDisplay(), XlibWrapper.RootWindow(XToolkit.getDisplay(), xVisualInfo.get_screen()), Native.toData(byArray), this.iconWidth, this.iconHeight);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    void setIconImages(List<IconInfo> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        int n = Integer.MAX_VALUE;
        Image image = null;
        for (IconInfo iconInfo : list) {
            int n2;
            if (!iconInfo.isValid()) continue;
            Image image2 = iconInfo.getImage();
            Dimension dimension = this.calcIconSize(image2.getWidth(null), image2.getHeight(null));
            int n3 = Math.abs(dimension.width - image2.getWidth(null));
            if (n < n3 + (n2 = Math.abs(image2.getHeight(null) - dimension.height))) continue;
            n = n3 + n2;
            image = image2;
        }
        if (image != null) {
            if (log.isLoggable(PlatformLogger.Level.FINER)) {
                log.finer("Icon: {0}x{1}", image.getWidth(null), image.getHeight(null));
            }
            this.setIconImage(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIconImage(Image image) {
        Object object;
        if (image == null) {
            this.replaceImage(null);
            this.replaceMask(null);
        } else {
            int n;
            int n2;
            if (image instanceof ToolkitImage) {
                object = ((ToolkitImage)image).getImageRep();
                ((ImageRepresentation)object).reconstruct(32);
                n2 = ((ImageRepresentation)object).getWidth();
                n = ((ImageRepresentation)object).getHeight();
            } else {
                n2 = image.getWidth(null);
                n = image.getHeight(null);
            }
            object = this.getIconSize(n2, n);
            if (object != null) {
                if (log.isLoggable(PlatformLogger.Level.FINEST)) {
                    log.finest("Icon size: {0}", object);
                }
                this.iconWidth = ((Dimension)object).width;
                this.iconHeight = ((Dimension)object).height;
            } else {
                log.finest("Error calculating image size");
                this.iconWidth = 0;
                this.iconHeight = 0;
            }
            this.replaceImage(image);
            this.replaceMask(image);
        }
        XToolkit.awtLock();
        try {
            AwtGraphicsConfigData awtGraphicsConfigData = this.parent.getGraphicsConfigurationData();
            awtImageData awtImageData2 = awtGraphicsConfigData.get_awtImage(0);
            object = awtGraphicsConfigData.get_awt_visInfo();
            XWMHints xWMHints = this.parent.getWMHints();
            this.window = xWMHints.get_icon_window();
            if (this.window == 0L) {
                log.finest("Icon window wasn't set");
                XCreateWindowParams xCreateWindowParams = this.getDelayedParams();
                xCreateWindowParams.add((Object)"border pixel", (Object)XToolkit.getAwtDefaultFg());
                xCreateWindowParams.add((Object)"pixmap", this.iconPixmap);
                xCreateWindowParams.add((Object)"color map", awtGraphicsConfigData.get_awt_cmap());
                xCreateWindowParams.add((Object)"visual depth", awtImageData2.get_Depth());
                xCreateWindowParams.add((Object)"visual class", 1);
                xCreateWindowParams.add((Object)"visual", ((XVisualInfo)object).get_visual());
                xCreateWindowParams.add((Object)"value mask", 8201L);
                xCreateWindowParams.add((Object)"parent window", XlibWrapper.RootWindow(XToolkit.getDisplay(), ((XVisualInfo)object).get_screen()));
                xCreateWindowParams.add((Object)"bounds", new Rectangle(0, 0, this.iconWidth, this.iconHeight));
                xCreateWindowParams.remove("delayed");
                this.init(xCreateWindowParams);
                if (this.getWindow() == 0L) {
                    log.finest("Can't create new icon window");
                } else {
                    log.finest("Created new icon window");
                }
            }
            if (this.getWindow() != 0L) {
                XlibWrapper.XSetWindowBackgroundPixmap(XToolkit.getDisplay(), this.getWindow(), this.iconPixmap);
                XlibWrapper.XClearWindow(XToolkit.getDisplay(), this.getWindow());
            }
            long l = xWMHints.get_flags() | 4L | 0x20L;
            if (this.getWindow() != 0L) {
                l |= 8L;
            }
            xWMHints.set_flags(l);
            xWMHints.set_icon_pixmap(this.iconPixmap);
            xWMHints.set_icon_mask(this.iconMask);
            xWMHints.set_icon_window(this.getWindow());
            XlibWrapper.XSetWMHints(XToolkit.getDisplay(), this.parent.getShell(), xWMHints.pData);
            log.finest("Set icon window hint");
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    static int paddedwidth(int n, int n2) {
        return n + (n2 - 1) & ~(n2 - 1);
    }
}

