/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import sun.nio.ch.AllocatedNativeObject;
import sun.nio.ch.IOUtil;
import sun.nio.ch.RDMANet;

class RDMAEPollArrayWrapper {
    private static final int EPOLLIN = 1;
    private static final int EPOLL_CTL_ADD = 1;
    private static final int EPOLL_CTL_DEL = 2;
    private static final int EPOLL_CTL_MOD = 3;
    private static final int SIZE_EPOLLEVENT = RDMAEPollArrayWrapper.sizeofEPollEvent();
    private static final int EVENT_OFFSET = 0;
    private static final int DATA_OFFSET;
    private static final int PTR_OFFSET;
    private static final int OPEN_MAX;
    private static final int NUM_EPOLLEVENTS;
    private static final boolean archDataModel32;
    private static final short SIZE_RSOCKPTR;
    private final long epRsockPtr = this.epollCreate();
    private final AllocatedNativeObject pollArray;
    private final long pollArrayAddress;
    private int outgoingInterruptFD;
    private long intrRsockPtr;
    private int interruptedIndex;
    int updated;
    private Map<Long, Boolean> ptrRegister;
    private boolean interrupted = false;

    RDMAEPollArrayWrapper() throws IOException {
        int n = NUM_EPOLLEVENTS * SIZE_EPOLLEVENT;
        this.pollArray = new AllocatedNativeObject(n, true);
        this.pollArrayAddress = this.pollArray.address();
        this.ptrRegister = new HashMap<Long, Boolean>();
    }

    void initInterrupt(int n, int n2) {
        this.outgoingInterruptFD = n2;
        this.intrRsockPtr = RDMANet.createDummyRsocket(n);
        this.epollCtl(this.epRsockPtr, 1, this.intrRsockPtr, 1);
    }

    void freeInterrupt() throws IOException {
        this.epollCtl(this.epRsockPtr, 2, this.intrRsockPtr, 0);
        RDMANet.closeDummyRsocket(this.intrRsockPtr);
    }

    void closeEPollWrapper() throws IOException {
        RDMANet.closeDummyRsocket(this.epRsockPtr);
        this.pollArray.free();
    }

    void putEventOps(int n, int n2) {
        int n3 = SIZE_EPOLLEVENT * n + 0;
        this.pollArray.putInt(n3, n2);
    }

    void putRsocketPtr(int n, long l) {
        int n2 = SIZE_EPOLLEVENT * n + PTR_OFFSET;
        if (archDataModel32) {
            this.pollArray.putInt(n2, (int)l);
        } else {
            this.pollArray.putLong(n2, l);
        }
    }

    int getEventOps(int n) {
        int n2 = SIZE_EPOLLEVENT * n + 0;
        return this.pollArray.getInt(n2);
    }

    long getRsocketPtr(int n) {
        int n2 = SIZE_EPOLLEVENT * n + PTR_OFFSET;
        return archDataModel32 ? (long)this.pollArray.getInt(n2) : this.pollArray.getLong(n2);
    }

    void add(long l) {
        Boolean bl = this.ptrRegister.get(l);
        assert (bl == null);
        this.ptrRegister.put(l, new Boolean(false));
    }

    void setInterest(long l, int n) {
        int n2 = 0;
        Boolean bl = this.ptrRegister.get(l);
        if (bl == null) {
            return;
        }
        n2 = bl != false ? 3 : 1;
        if (n2 != 0) {
            this.epollCtl(this.epRsockPtr, n2, l, n);
        }
        if (n2 == 1) {
            this.ptrRegister.put(l, new Boolean(true));
        }
    }

    void remove(long l) {
        Boolean bl = this.ptrRegister.get(l);
        if (bl == null) {
            return;
        }
        if (bl.booleanValue()) {
            this.epollCtl(this.epRsockPtr, 2, l, 0);
        }
        this.ptrRegister.remove(l);
    }

    int poll(long l) throws IOException {
        this.updated = this.epollWait(this.pollArrayAddress, NUM_EPOLLEVENTS, l, this.epRsockPtr);
        for (int i = 0; i < this.updated; ++i) {
            if (this.getRsocketPtr(i) != this.intrRsockPtr) continue;
            this.interruptedIndex = i;
            this.interrupted = true;
            break;
        }
        return this.updated;
    }

    public void interrupt() {
        RDMANet.interrupt(this.outgoingInterruptFD);
    }

    public int interruptedIndex() {
        return this.interruptedIndex;
    }

    boolean interrupted() {
        return this.interrupted;
    }

    void clearInterrupted() {
        this.interrupted = false;
    }

    private native long epollCreate();

    private native void epollCtl(long var1, int var3, long var4, int var6);

    private native int epollWait(long var1, int var3, long var4, long var6) throws IOException;

    private static native int sizeofEPollEvent();

    private static native int offsetofData();

    private static native void init();

    static {
        PTR_OFFSET = DATA_OFFSET = RDMAEPollArrayWrapper.offsetofData();
        OPEN_MAX = IOUtil.fdLimit();
        NUM_EPOLLEVENTS = Math.min(OPEN_MAX, 8192);
        archDataModel32 = System.getProperty("sun.arch.data.model").equals("32");
        SIZE_RSOCKPTR = (short)(archDataModel32 ? 4 : 8);
        IOUtil.load();
        RDMAEPollArrayWrapper.init();
    }
}

