/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyBoundException;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NoConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import sun.net.NetworkProvider;
import sun.net.SocketAction;
import sun.nio.ch.ExtendedSocketOption;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NIONetworkSelector;
import sun.nio.ch.NativeThread;
import sun.nio.ch.Net;
import sun.nio.ch.RDMAIOUtil;
import sun.nio.ch.RDMANet;
import sun.nio.ch.RDMASelChImpl;
import sun.nio.ch.RDMASocketAdaptor;
import sun.nio.ch.RDMASocketDispatcher;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SocketChannelImpl;

class RDMASocketChannelImpl
extends SocketChannelImpl
implements RDMASelChImpl {
    private final long rsockPtr;
    private boolean providerSwitchDone = false;
    private static RDMASocketDispatcher rsd;
    private static final int ST_UNINITIALIZED = -1;
    private static final int ST_UNCONNECTED = 0;
    private static final int ST_PENDING = 1;
    private static final int ST_CONNECTED = 2;
    private static final int ST_KILLPENDING = 3;
    private static final int ST_KILLED = 4;
    private int state = -1;
    private InetSocketAddress localAddress;
    private InetSocketAddress remoteAddress;
    private boolean isReuseAddress;
    private int ipTos;
    private final Object readLock = new Object();
    private final Object writeLock = new Object();
    private final Object stateLock = new Object();
    private volatile long readerThread = 0L;
    private volatile long writerThread = 0L;
    private boolean isInputOpen = true;
    private boolean isOutputOpen = true;
    private boolean readyToConnect = false;
    private Socket socket;

    RDMASocketChannelImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
        this.rsockPtr = RDMANet.socket(false);
        this.state = 0;
        if (NIONetworkSelector.isDebugOn()) {
            System.out.printf("JSORI:NIO:%X: RDMA socketchannel created%n", this.hashCode());
        }
    }

    RDMASocketChannelImpl(SelectorProvider selectorProvider, FileDescriptor fileDescriptor, InetSocketAddress inetSocketAddress) throws IOException {
        super(selectorProvider, fileDescriptor, inetSocketAddress);
        this.rsockPtr = RDMANet.socket(false);
        this.state = 2;
        this.remoteAddress = inetSocketAddress;
        this.localAddress = Net.localAddress(fileDescriptor);
        this.providerSwitchDone = false;
        if (NIONetworkSelector.isDebugOn()) {
            System.out.printf("JSORI:NIO:%X: Dummy RDMA socketchannel created for TCP fd %d%n", this.hashCode(), IOUtil.fdVal(fileDescriptor));
        }
    }

    RDMASocketChannelImpl(SelectorProvider selectorProvider, long l, InetSocketAddress inetSocketAddress) throws IOException {
        super(selectorProvider);
        this.rsockPtr = l;
        this.state = 2;
        this.localAddress = RDMANet.localAddress(l);
        this.remoteAddress = inetSocketAddress;
        this.providerSwitchDone = true;
        if (NIONetworkSelector.isDebugOn()) {
            System.out.printf("JSORI:NIO:%X: RDMA socketchannel bound to %s connected to %s created%n", this.hashCode(), this.localAddress, this.remoteAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket socket() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.socket == null) {
                this.socket = RDMASocketAdaptor.create(this);
                if (NIONetworkSelector.isDebugOn()) {
                    System.out.printf("JSORI:NIO:%X: RDMA socketchannel adaptor created%n", this.hashCode());
                }
            }
            return this.socket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketAddress getLocalAddress() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.providerSwitchDone) {
                return super.getLocalAddress();
            }
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (NIONetworkSelector.isDebugOn()) {
                System.out.printf("JSORI:NIO:%X: Retrieved RDMA socketchannel local addr %s%n", this.hashCode(), Net.getRevealedLocalAddress(this.localAddress));
            }
            return Net.getRevealedLocalAddress(this.localAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.providerSwitchDone) {
                return super.getRemoteAddress();
            }
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (NIONetworkSelector.isDebugOn()) {
                System.out.printf("JSORI:NIO:%X: Retrieved RDMA socketchannel remote addr %s%n", this.hashCode(), this.remoteAddress);
            }
            return this.remoteAddress;
        }
    }

    public final Set<SocketOption<?>> rdmaSupportedOptions() {
        return RDMASupportedOptionsHolder.optionSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> SocketChannel setOption(SocketOption<T> socketOption, T t) throws IOException {
        if (socketOption == null) {
            throw new NullPointerException();
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.providerSwitchDone) {
                return super.setOption((SocketOption)socketOption, (Object)t);
            }
            if (!this.rdmaSupportedOptions().contains(socketOption)) {
                throw new UnsupportedOperationException("'" + socketOption + "' not supported");
            }
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (socketOption == StandardSocketOptions.SO_REUSEADDR && Net.useExclusiveBind()) {
                this.isReuseAddress = (Boolean)t;
            } else if (socketOption == StandardSocketOptions.IP_TOS) {
                this.ipTos = (Integer)t;
            } else {
                RDMANet.setSocketOption(this.rsockPtr, socketOption, t);
            }
            if (NIONetworkSelector.isDebugOn()) {
                System.out.printf("JSORI:NIO:%X: RDMA socketchannel option %s set to %s%n", this.hashCode(), socketOption, t);
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getOption(SocketOption<T> socketOption) throws IOException {
        if (socketOption == null) {
            throw new NullPointerException();
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.providerSwitchDone) {
                return super.getOption(socketOption);
            }
            if (!this.rdmaSupportedOptions().contains(socketOption)) {
                throw new UnsupportedOperationException("'" + socketOption + "' not supported");
            }
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            Object object2 = socketOption == StandardSocketOptions.SO_REUSEADDR && Net.useExclusiveBind() ? Boolean.valueOf(this.isReuseAddress) : (socketOption == StandardSocketOptions.IP_TOS ? Integer.valueOf(this.ipTos) : RDMANet.getSocketOption(this.rsockPtr, socketOption));
            if (NIONetworkSelector.isDebugOn()) {
                System.out.printf("JSORI:NIO:%X: RDMA socketchannel option %s value %s%n", this.hashCode(), socketOption, object2);
            }
            return (T)object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InetSocketAddress localAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.providerSwitchDone) {
                return super.localAddress();
            }
            if (NIONetworkSelector.isDebugOn()) {
                System.out.printf("JSORI:NIO:%X: Retrieved RDMA socketchannel local addr %s%n", this.hashCode(), this.localAddress);
            }
            return this.localAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketAddress remoteAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.providerSwitchDone) {
                return super.remoteAddress();
            }
            if (NIONetworkSelector.isDebugOn()) {
                System.out.printf("JSORI:NIO:%X: Retrieved RDMA socketchannel remote addr %s%n", this.hashCode(), this.remoteAddress);
            }
            return this.remoteAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketChannel bind(SocketAddress socketAddress) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    InetAddress inetAddress;
                    NetworkProvider networkProvider;
                    if (!this.isOpen()) {
                        throw new ClosedChannelException();
                    }
                    if (this.state == 1) {
                        throw new ConnectionPendingException();
                    }
                    if (this.localAddress != null) {
                        throw new AlreadyBoundException();
                    }
                    InetSocketAddress inetSocketAddress = socketAddress == null ? new InetSocketAddress(0) : Net.checkAddress(socketAddress);
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        securityManager.checkListen(inetSocketAddress.getPort());
                    }
                    if ((networkProvider = NIONetworkSelector.getNetworkProvider(SocketAction.BIND, inetSocketAddress.getAddress(), inetSocketAddress.getPort(), null)) == null) {
                        if (NIONetworkSelector.isDebugOn()) {
                            System.out.printf("JSORW:NIO:%X: RDMA network provider not avail for bind addr %s%n", this.hashCode(), inetSocketAddress);
                        }
                        return super.bind(socketAddress);
                    }
                    if (networkProvider.getPreferredAddress() != null && ((inetAddress = inetSocketAddress.getAddress()).isAnyLocalAddress() || inetAddress.isLoopbackAddress())) {
                        inetSocketAddress = new InetSocketAddress(networkProvider.getPreferredAddress(), inetSocketAddress.getPort());
                    }
                    RDMANet.bind(this.rsockPtr, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                    this.providerSwitchDone = true;
                    this.localAddress = RDMANet.localAddress(this.rsockPtr);
                    if (NIONetworkSelector.isDebugOn()) {
                        System.out.printf("JSORI:NIO:%X: RDMA socketchannel bound to addr %s%n", this.hashCode(), this.localAddress);
                    }
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.providerSwitchDone) {
                return super.isConnected();
            }
            return this.state == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnectionPending() {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.providerSwitchDone) {
                return super.isConnectionPending();
            }
            return this.state == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readerCleanup() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.readerThread = 0L;
            if (this.state == 3) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writerCleanup() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.writerThread = 0L;
            if (this.state == 3) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ensureReadOpen() throws ClosedChannelException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
            return this.isInputOpen;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureWriteOpen() throws ClosedChannelException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
            if (!this.isOutputOpen) {
                throw new ClosedChannelException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            super.kill();
            if (this.state == 4) {
                return;
            }
            if (this.state == -1) {
                this.state = 4;
                return;
            }
            assert (!this.isOpen() && !this.isRegistered());
            if (this.readerThread == 0L && this.writerThread == 0L) {
                rsd.close(this.rsockPtr);
                this.state = 4;
                if (NIONetworkSelector.isDebugOn()) {
                    System.out.printf("JSORI:NIO:%X: RDMA socketchannel closed%n", this.hashCode());
                }
            } else {
                this.state = 3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean connect(SocketAddress socketAddress) throws IOException {
        Object object;
        Object object2;
        Object object3 = this.readLock;
        // MONITORENTER : object3
        Object object4 = this.writeLock;
        // MONITORENTER : object4
        InetSocketAddress inetSocketAddress = Net.checkAddress(socketAddress);
        Object object5 = this.stateLock;
        // MONITORENTER : object5
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.state == 2) {
            throw new AlreadyConnectedException();
        }
        if (this.state == 1) {
            throw new ConnectionPendingException();
        }
        if (this.localAddress == null && (object2 = NIONetworkSelector.getNetworkProvider(SocketAction.CONNECT, inetSocketAddress.getAddress(), inetSocketAddress.getPort(), null)) != null) {
            InetAddress inetAddress;
            this.providerSwitchDone = true;
            if (object2.getPreferredAddress() != null && ((inetAddress = inetSocketAddress.getAddress()).isAnyLocalAddress() || inetAddress.isLoopbackAddress())) {
                inetAddress = object2.getPreferredAddress();
                inetSocketAddress = new InetSocketAddress(inetAddress, inetSocketAddress.getPort());
            }
        }
        if (!this.providerSwitchDone) {
            if (NIONetworkSelector.isDebugOn()) {
                System.out.printf("JSORW:NIO:%X: RDMA network provider not avail for connect addr %s%n", this.hashCode(), inetSocketAddress);
            }
            // MONITOREXIT : object5
            // MONITOREXIT : object4
            // MONITOREXIT : object3
            return super.connect(socketAddress);
        }
        // MONITOREXIT : object5
        object5 = System.getSecurityManager();
        if (object5 != null) {
            ((SecurityManager)object5).checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
        }
        object2 = this.blockingLock();
        // MONITORENTER : object2
        int n = 0;
        boolean bl = false;
        try {
            block38: {
                this.begin();
                object = this.stateLock;
                // MONITORENTER : object
                if (this.isOpen()) break block38;
                boolean bl2 = false;
                // MONITOREXIT : object
                this.readerCleanup();
                this.end(n > 0 || n == -2);
                assert (IOStatus.check(n));
                // MONITOREXIT : object2
                // MONITOREXIT : object4
                // MONITOREXIT : object3
                return bl2;
            }
            try {
                if (this.readyToConnect) {
                    bl = true;
                    this.readyToConnect = false;
                }
                this.readerThread = NativeThread.current();
                // MONITOREXIT : object
                do {
                    if (super.localAddress() == null) continue;
                    RDMANet.bind(this.rsockPtr, super.localAddress().getAddress(), super.localAddress().getPort());
                } while ((n = RDMANet.connect(this.rsockPtr, inetSocketAddress.getAddress(), inetSocketAddress.getPort(), bl)) == -3 && this.isOpen());
            }
            catch (Throwable throwable) {
                this.readerCleanup();
                this.end(n > 0 || n == -2);
                if ($assertionsDisabled) throw throwable;
                if (IOStatus.check(n)) throw throwable;
                throw new AssertionError();
            }
            this.readerCleanup();
            this.end(n > 0 || n == -2);
            assert (IOStatus.check(n));
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
        object = this.stateLock;
        // MONITORENTER : object
        this.remoteAddress = inetSocketAddress;
        if (n > 0) {
            this.state = 2;
            if (this.isOpen()) {
                this.localAddress = RDMANet.localAddress(this.rsockPtr);
            }
            if (NIONetworkSelector.isDebugOn()) {
                System.out.printf("JSORI:NIO:%X: RDMA socketchannel bound to %s connected to %s%n", this.hashCode(), this.localAddress, this.remoteAddress);
            }
            // MONITOREXIT : object
            // MONITOREXIT : object2
            // MONITOREXIT : object4
            // MONITOREXIT : object3
            return true;
        }
        if (!this.isBlocking()) {
            this.state = 1;
        } else assert (false);
        // MONITOREXIT : object
        // MONITOREXIT : object2
        if (NIONetworkSelector.isDebugOn()) {
            System.out.printf("JSORI:NIO:%X: RDMA socketchannel failed to connect %s%n", this.hashCode(), this.remoteAddress);
        }
        // MONITOREXIT : object4
        // MONITOREXIT : object3
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean finishConnect() throws IOException {
        Object object;
        Object object2 = this.readLock;
        // MONITORENTER : object2
        Object object3 = this.writeLock;
        // MONITORENTER : object3
        Object object4 = this.stateLock;
        // MONITORENTER : object4
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!this.providerSwitchDone) {
            // MONITOREXIT : object4
            // MONITOREXIT : object3
            // MONITOREXIT : object2
            return super.finishConnect();
        }
        if (this.state == 2) {
            // MONITOREXIT : object4
            // MONITOREXIT : object3
            // MONITOREXIT : object2
            return true;
        }
        if (this.state != 1) {
            throw new NoConnectionPendingException();
        }
        // MONITOREXIT : object4
        int n = 0;
        try {
            block30: {
                this.begin();
                object = this.blockingLock();
                // MONITORENTER : object
                Object object5 = this.stateLock;
                // MONITORENTER : object5
                if (this.isOpen()) break block30;
                boolean bl = false;
                // MONITOREXIT : object5
                // MONITOREXIT : object
                this.readerCleanup();
                this.end(n > 0 || n == -2);
                assert (IOStatus.check(n));
                // MONITOREXIT : object3
                // MONITOREXIT : object2
                return bl;
            }
            try {
                this.readerThread = NativeThread.current();
                // MONITOREXIT : object5
                while ((n = RDMASocketChannelImpl.finishConnect0(this.rsockPtr, true)) == -3 && this.isOpen()) {
                }
                // MONITOREXIT : object
            }
            catch (Throwable throwable) {
                this.readerCleanup();
                this.end(n > 0 || n == -2);
                if ($assertionsDisabled) throw throwable;
                if (IOStatus.check(n)) throw throwable;
                throw new AssertionError();
            }
            this.readerCleanup();
            this.end(n > 0 || n == -2);
            assert (IOStatus.check(n));
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
        if (n <= 0) {
            // MONITOREXIT : object3
            // MONITOREXIT : object2
            return false;
        }
        object = this.stateLock;
        // MONITORENTER : object
        this.state = 2;
        if (this.isOpen()) {
            this.localAddress = RDMANet.localAddress(this.rsockPtr);
        }
        if (NIONetworkSelector.isDebugOn()) {
            System.out.printf("JSORI:NIO:%X: RDMA socketchannel bound to %s connected to %s%n", this.hashCode(), this.localAddress, this.remoteAddress);
        }
        // MONITOREXIT : object
        // MONITOREXIT : object3
        // MONITOREXIT : object2
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketChannel shutdownInput() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.providerSwitchDone) {
                return super.shutdownInput();
            }
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
            if (this.isInputOpen) {
                RDMANet.shutdown(this.rsockPtr, 0);
                if (this.readerThread != 0L) {
                    NativeThread.signal(this.readerThread);
                }
                this.isInputOpen = false;
            }
            if (NIONetworkSelector.isDebugOn()) {
                System.out.printf("JSORI:NIO:%X: RDMA socketchannel closed for read%n", this.hashCode());
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketChannel shutdownOutput() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.providerSwitchDone) {
                return super.shutdownOutput();
            }
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
            if (this.isOutputOpen) {
                RDMANet.shutdown(this.rsockPtr, 1);
                if (this.writerThread != 0L) {
                    NativeThread.signal(this.writerThread);
                }
                this.isOutputOpen = false;
            }
            if (NIONetworkSelector.isDebugOn()) {
                System.out.printf("JSORI:NIO:%X: RDMA socketchannel closed for write%n", this.hashCode());
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInputOpen() {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.providerSwitchDone) {
                return super.isInputOpen();
            }
            return this.isInputOpen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOutputOpen() {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.providerSwitchDone) {
                return super.isOutputOpen();
            }
            return this.isOutputOpen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int n;
        int n2;
        block23: {
            if (byteBuffer == null) {
                throw new NullPointerException();
            }
            if (!this.providerSwitchDone) {
                return super.read(byteBuffer);
            }
            Object object = this.readLock;
            // MONITORENTER : object
            if (!this.ensureReadOpen()) {
                // MONITOREXIT : object
                return -1;
            }
            n2 = 0;
            this.begin();
            Object object2 = this.stateLock;
            // MONITORENTER : object2
            if (this.isOpen()) break block23;
            int n3 = 0;
            // MONITOREXIT : object2
            this.readerCleanup();
            this.end(n2 > 0 || n2 == -2);
            Object object3 = this.stateLock;
            // MONITORENTER : object3
            if (n2 <= 0 && !this.isInputOpen) {
                // MONITOREXIT : object3
                // MONITOREXIT : object
                return -1;
            }
            // MONITOREXIT : object3
            assert (IOStatus.check(n2));
            // MONITOREXIT : object
            return n3;
        }
        try {
            this.readerThread = NativeThread.current();
            // MONITOREXIT : object2
            while ((n2 = RDMAIOUtil.read(this.rsockPtr, byteBuffer, rsd, this.isBlocking())) == -3 && this.isOpen()) {
            }
            n = IOStatus.normalize(n2);
        }
        catch (Throwable throwable) {
            this.readerCleanup();
            this.end(n2 > 0 || n2 == -2);
            Object object = this.stateLock;
            // MONITORENTER : object
            if (n2 <= 0 && !this.isInputOpen) {
                // MONITOREXIT : object
                // MONITOREXIT : object
                return -1;
            }
            // MONITOREXIT : object
            if ($assertionsDisabled) throw throwable;
            if (IOStatus.check(n2)) throw throwable;
            throw new AssertionError();
        }
        this.readerCleanup();
        this.end(n2 > 0 || n2 == -2);
        Object object = this.stateLock;
        // MONITORENTER : object
        if (n2 <= 0 && !this.isInputOpen) {
            // MONITOREXIT : object
            // MONITOREXIT : object
            return -1;
        }
        // MONITOREXIT : object
        assert (IOStatus.check(n2));
        // MONITOREXIT : object
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        long l;
        long l2;
        block23: {
            if (n < 0) throw new IndexOutOfBoundsException();
            if (n2 < 0) throw new IndexOutOfBoundsException();
            if (n > byteBufferArray.length - n2) {
                throw new IndexOutOfBoundsException();
            }
            if (!this.providerSwitchDone) {
                return super.read(byteBufferArray, n, n2);
            }
            Object object = this.readLock;
            // MONITORENTER : object
            if (!this.ensureReadOpen()) {
                // MONITOREXIT : object
                return -1L;
            }
            l2 = 0L;
            this.begin();
            Object object2 = this.stateLock;
            // MONITORENTER : object2
            if (this.isOpen()) break block23;
            long l3 = 0L;
            // MONITOREXIT : object2
            this.readerCleanup();
            this.end(l2 > 0L || l2 == -2L);
            Object object3 = this.stateLock;
            // MONITORENTER : object3
            if (l2 <= 0L && !this.isInputOpen) {
                // MONITOREXIT : object3
                // MONITOREXIT : object
                return -1L;
            }
            // MONITOREXIT : object3
            assert (IOStatus.check(l2));
            // MONITOREXIT : object
            return l3;
        }
        try {
            this.readerThread = NativeThread.current();
            // MONITOREXIT : object2
            while ((l2 = RDMAIOUtil.read(this.rsockPtr, byteBufferArray, n, n2, rsd, this.isBlocking())) == -3L && this.isOpen()) {
            }
            l = IOStatus.normalize(l2);
        }
        catch (Throwable throwable) {
            this.readerCleanup();
            this.end(l2 > 0L || l2 == -2L);
            Object object = this.stateLock;
            // MONITORENTER : object
            if (l2 <= 0L && !this.isInputOpen) {
                // MONITOREXIT : object
                // MONITOREXIT : object
                return -1L;
            }
            // MONITOREXIT : object
            if ($assertionsDisabled) throw throwable;
            if (IOStatus.check(l2)) throw throwable;
            throw new AssertionError();
        }
        this.readerCleanup();
        this.end(l2 > 0L || l2 == -2L);
        Object object = this.stateLock;
        // MONITORENTER : object
        if (l2 <= 0L && !this.isInputOpen) {
            // MONITOREXIT : object
            // MONITOREXIT : object
            return -1L;
        }
        // MONITOREXIT : object
        assert (IOStatus.check(l2));
        // MONITOREXIT : object
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        int n;
        int n2;
        block22: {
            if (byteBuffer == null) {
                throw new NullPointerException();
            }
            if (!this.providerSwitchDone) {
                return super.write(byteBuffer);
            }
            Object object = this.writeLock;
            // MONITORENTER : object
            this.ensureWriteOpen();
            n2 = 0;
            this.begin();
            Object object2 = this.stateLock;
            // MONITORENTER : object2
            if (this.isOpen()) break block22;
            int n3 = 0;
            // MONITOREXIT : object2
            this.writerCleanup();
            this.end(n2 > 0 || n2 == -2);
            Object object3 = this.stateLock;
            // MONITORENTER : object3
            if (n2 <= 0 && !this.isOutputOpen) {
                throw new AsynchronousCloseException();
            }
            // MONITOREXIT : object3
            assert (IOStatus.check(n2));
            // MONITOREXIT : object
            return n3;
        }
        try {
            this.writerThread = NativeThread.current();
            // MONITOREXIT : object2
            while ((n2 = RDMAIOUtil.write(this.rsockPtr, byteBuffer, rsd, this.isBlocking())) == -3 && this.isOpen()) {
            }
            n = IOStatus.normalize(n2);
        }
        catch (Throwable throwable) {
            this.writerCleanup();
            this.end(n2 > 0 || n2 == -2);
            Object object = this.stateLock;
            // MONITORENTER : object
            if (n2 <= 0 && !this.isOutputOpen) {
                throw new AsynchronousCloseException();
            }
            // MONITOREXIT : object
            if ($assertionsDisabled) throw throwable;
            if (IOStatus.check(n2)) throw throwable;
            throw new AssertionError();
        }
        this.writerCleanup();
        this.end(n2 > 0 || n2 == -2);
        Object object = this.stateLock;
        // MONITORENTER : object
        if (n2 <= 0 && !this.isOutputOpen) {
            throw new AsynchronousCloseException();
        }
        // MONITOREXIT : object
        assert (IOStatus.check(n2));
        // MONITOREXIT : object
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        long l;
        long l2;
        block22: {
            if (n < 0) throw new IndexOutOfBoundsException();
            if (n2 < 0) throw new IndexOutOfBoundsException();
            if (n > byteBufferArray.length - n2) {
                throw new IndexOutOfBoundsException();
            }
            if (!this.providerSwitchDone) {
                return super.write(byteBufferArray, n, n2);
            }
            Object object = this.writeLock;
            // MONITORENTER : object
            this.ensureWriteOpen();
            l2 = 0L;
            this.begin();
            Object object2 = this.stateLock;
            // MONITORENTER : object2
            if (this.isOpen()) break block22;
            long l3 = 0L;
            // MONITOREXIT : object2
            this.writerCleanup();
            this.end(l2 > 0L || l2 == -2L);
            Object object3 = this.stateLock;
            // MONITORENTER : object3
            if (l2 <= 0L && !this.isOutputOpen) {
                throw new AsynchronousCloseException();
            }
            // MONITOREXIT : object3
            assert (IOStatus.check(l2));
            // MONITOREXIT : object
            return l3;
        }
        try {
            this.writerThread = NativeThread.current();
            // MONITOREXIT : object2
            while ((l2 = RDMAIOUtil.write(this.rsockPtr, byteBufferArray, n, n2, rsd, this.isBlocking())) == -3L && this.isOpen()) {
            }
            l = IOStatus.normalize(l2);
        }
        catch (Throwable throwable) {
            this.writerCleanup();
            this.end(l2 > 0L || l2 == -2L);
            Object object = this.stateLock;
            // MONITORENTER : object
            if (l2 <= 0L && !this.isOutputOpen) {
                throw new AsynchronousCloseException();
            }
            // MONITOREXIT : object
            if ($assertionsDisabled) throw throwable;
            if (IOStatus.check(l2)) throw throwable;
            throw new AssertionError();
        }
        this.writerCleanup();
        this.end(l2 > 0L || l2 == -2L);
        Object object = this.stateLock;
        // MONITORENTER : object
        if (l2 <= 0L && !this.isOutputOpen) {
            throw new AsynchronousCloseException();
        }
        // MONITOREXIT : object
        assert (IOStatus.check(l2));
        // MONITOREXIT : object
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    int sendOutOfBandData(byte by) throws IOException {
        int n;
        int n2;
        block21: {
            if (!this.providerSwitchDone) {
                return super.sendOutOfBandData(by);
            }
            Object object = this.writeLock;
            // MONITORENTER : object
            this.ensureWriteOpen();
            n2 = 0;
            this.begin();
            Object object2 = this.stateLock;
            // MONITORENTER : object2
            if (this.isOpen()) break block21;
            int n3 = 0;
            // MONITOREXIT : object2
            this.writerCleanup();
            this.end(n2 > 0 || n2 == -2);
            Object object3 = this.stateLock;
            // MONITORENTER : object3
            if (n2 <= 0 && !this.isOutputOpen) {
                throw new AsynchronousCloseException();
            }
            // MONITOREXIT : object3
            assert (IOStatus.check(n2));
            // MONITOREXIT : object
            return n3;
        }
        try {
            this.writerThread = NativeThread.current();
            // MONITOREXIT : object2
            while ((n2 = RDMASocketChannelImpl.sendOutOfBandData0(this.rsockPtr, by)) == -3 && this.isOpen()) {
            }
            n = IOStatus.normalize(n2);
        }
        catch (Throwable throwable) {
            this.writerCleanup();
            this.end(n2 > 0 || n2 == -2);
            Object object = this.stateLock;
            // MONITORENTER : object
            if (n2 <= 0 && !this.isOutputOpen) {
                throw new AsynchronousCloseException();
            }
            // MONITOREXIT : object
            if ($assertionsDisabled) throw throwable;
            if (IOStatus.check(n2)) throw throwable;
            throw new AssertionError();
        }
        this.writerCleanup();
        this.end(n2 > 0 || n2 == -2);
        Object object = this.stateLock;
        // MONITORENTER : object
        if (n2 <= 0 && !this.isOutputOpen) {
            throw new AsynchronousCloseException();
        }
        // MONITOREXIT : object
        assert (IOStatus.check(n2));
        // MONITOREXIT : object
        return n;
    }

    @Override
    protected void implConfigureBlocking(boolean bl) throws IOException {
        super.implConfigureBlocking(bl);
        RDMAIOUtil.configureBlocking(this.rsockPtr, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append('[');
        if (!this.isOpen()) {
            stringBuffer.append("closed");
        } else {
            Object object = this.stateLock;
            synchronized (object) {
                switch (this.state) {
                    case 0: {
                        stringBuffer.append("unconnected");
                        break;
                    }
                    case 1: {
                        stringBuffer.append("connection-pending");
                        break;
                    }
                    case 2: {
                        stringBuffer.append("connected");
                        if (!this.isInputOpen) {
                            stringBuffer.append(" ishut");
                        }
                        if (this.isOutputOpen) break;
                        stringBuffer.append(" oshut");
                    }
                }
                InetSocketAddress inetSocketAddress = this.localAddress();
                if (inetSocketAddress != null) {
                    stringBuffer.append(" local=");
                    stringBuffer.append(Net.getRevealedLocalAddressAsString(inetSocketAddress));
                }
                if (this.remoteAddress() != null) {
                    stringBuffer.append(" remote=");
                    stringBuffer.append(this.remoteAddress().toString());
                }
            }
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private static native int finishConnect0(long var0, boolean var2) throws IOException;

    private static native int sendOutOfBandData0(long var0, byte var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implCloseSelectableChannel() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.isInputOpen = false;
            this.isOutputOpen = false;
            if (this.readerThread != 0L) {
                NativeThread.signal(this.readerThread);
            }
            if (this.writerThread != 0L) {
                NativeThread.signal(this.writerThread);
            }
            rsd.preClose(this.rsockPtr);
            if (!this.isRegistered()) {
                this.kill();
            }
            super.implCloseSelectableChannel();
        }
    }

    @Override
    public boolean translateReadyOps(int n, int n2, SelectionKeyImpl selectionKeyImpl) {
        if (!this.providerSwitchDone) {
            return super.translateReadyOps(n, n2, selectionKeyImpl);
        }
        int n3 = selectionKeyImpl.nioInterestOps();
        int n4 = selectionKeyImpl.nioReadyOps();
        int n5 = n2;
        if ((n & Net.POLLNVAL) != 0) {
            return false;
        }
        if ((n & (Net.POLLERR | Net.POLLHUP)) != 0) {
            n5 = n3;
            selectionKeyImpl.nioReadyOps(n5);
            this.readyToConnect = true;
            return (n5 & ~n4) != 0;
        }
        if ((n & Net.POLLIN) != 0 && (n3 & 1) != 0 && this.state == 2) {
            n5 |= 1;
        }
        if ((n & Net.POLLCONN) != 0 && (n3 & 8) != 0) {
            n5 |= 8;
            this.readyToConnect = true;
        }
        if ((n & Net.POLLOUT) != 0 && (n3 & 4) != 0 && this.state == 2) {
            n5 |= 4;
        }
        selectionKeyImpl.nioReadyOps(n5);
        return (n5 & ~n4) != 0;
    }

    @Override
    public boolean translateAndUpdateReadyOps(int n, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n, selectionKeyImpl.nioReadyOps(), selectionKeyImpl);
    }

    @Override
    public boolean translateAndSetReadyOps(int n, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n, 0, selectionKeyImpl);
    }

    @Override
    public void translateAndSetInterestOps(int n, SelectionKeyImpl selectionKeyImpl) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= Net.POLLIN;
        }
        if ((n & 4) != 0) {
            n2 |= Net.POLLOUT;
        }
        if ((n & 8) != 0) {
            n2 |= Net.POLLCONN;
        }
        selectionKeyImpl.selector.putEventOps(selectionKeyImpl, n2);
    }

    @Override
    public long getRsocketPtr() {
        return this.rsockPtr;
    }

    @Override
    public int getTcpFD() {
        if (this.providerSwitchDone) {
            return -1;
        }
        return IOUtil.fdVal(super.getFD());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    int poll(int n, long l) throws IOException {
        int n2;
        block14: {
            block13: {
                int n3;
                if (!$assertionsDisabled) {
                    if (!Thread.holdsLock(this.blockingLock())) throw new AssertionError();
                    if (this.isBlocking()) {
                        throw new AssertionError();
                    }
                }
                Object object = this.stateLock;
                // MONITORENTER : object
                if (!this.providerSwitchDone) {
                    // MONITOREXIT : object
                    return super.poll(n, l);
                }
                // MONITOREXIT : object
                object = this.readLock;
                // MONITORENTER : object
                n2 = 0;
                try {
                    this.begin();
                    Object object2 = this.stateLock;
                    // MONITORENTER : object2
                    if (this.isOpen()) break block13;
                    n3 = 0;
                    // MONITOREXIT : object2
                }
                catch (Throwable throwable) {
                    this.readerCleanup();
                    this.end(n2 > 0);
                    throw throwable;
                }
                this.readerCleanup();
                this.end(n2 > 0);
                // MONITOREXIT : object
                return n3;
            }
            this.readerThread = NativeThread.current();
            // MONITOREXIT : object2
            n2 = RDMANet.poll(this.rsockPtr, n, l);
            if (n2 <= 0 || (n & Net.POLLCONN) == 0) break block14;
            this.readyToConnect = true;
        }
        this.readerCleanup();
        this.end(n2 > 0);
        return n2;
    }

    static {
        RDMAIOUtil.load();
        rsd = new RDMASocketDispatcher();
    }

    private static class RDMASupportedOptionsHolder {
        static final Set<SocketOption<?>> optionSet = RDMASupportedOptionsHolder.supportedOptions();

        private RDMASupportedOptionsHolder() {
        }

        private static Set<SocketOption<?>> supportedOptions() {
            HashSet<SocketOption<Comparable<Integer>>> hashSet = new HashSet<SocketOption<Comparable<Integer>>>(8);
            hashSet.add(StandardSocketOptions.SO_SNDBUF);
            hashSet.add(StandardSocketOptions.SO_RCVBUF);
            hashSet.add(StandardSocketOptions.SO_KEEPALIVE);
            hashSet.add(StandardSocketOptions.SO_REUSEADDR);
            hashSet.add(StandardSocketOptions.SO_LINGER);
            hashSet.add(StandardSocketOptions.TCP_NODELAY);
            hashSet.add(StandardSocketOptions.IP_TOS);
            hashSet.add(ExtendedSocketOption.SO_OOBINLINE);
            return Collections.unmodifiableSet(hashSet);
        }
    }
}

