/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectStreamClass;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.AccessException;
import java.rmi.MarshalException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.rmi.UnmarshalException;
import java.rmi.server.ExportException;
import java.rmi.server.Operation;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteStub;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.ServerRef;
import java.rmi.server.Skeleton;
import java.rmi.server.SkeletonNotFoundException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import sun.misc.ObjectInputFilter;
import sun.rmi.runtime.Log;
import sun.rmi.server.DeserializationChecker;
import sun.rmi.server.Dispatcher;
import sun.rmi.server.MarshalInputStream;
import sun.rmi.server.UnicastRef;
import sun.rmi.server.Util;
import sun.rmi.server.WeakClassHashMap;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.StreamRemoteCall;
import sun.rmi.transport.Target;
import sun.rmi.transport.tcp.TCPTransport;
import sun.security.action.GetBooleanAction;

public class UnicastServerRef
extends UnicastRef
implements ServerRef,
Dispatcher {
    public static final boolean logCalls = AccessController.doPrivileged(new GetBooleanAction("java.rmi.server.logCalls"));
    public static final Log callLog = Log.getLog("sun.rmi.server.call", "RMI", logCalls);
    private static final long serialVersionUID = -7384275867073752268L;
    private static final boolean wantExceptionLog = AccessController.doPrivileged(new GetBooleanAction("sun.rmi.server.exceptionTrace"));
    private boolean forceStubUse = false;
    private static final boolean suppressStackTraces = AccessController.doPrivileged(new GetBooleanAction("sun.rmi.server.suppressStackTraces"));
    private transient Skeleton skel;
    private final transient ObjectInputFilter filter;
    private transient Map<Long, Method> hashToMethod_Map = null;
    private static final WeakClassHashMap<Map<Long, Method>> hashToMethod_Maps = new HashToMethod_Maps();
    private static final Map<Class<?>, ?> withoutSkeletons = Collections.synchronizedMap(new WeakHashMap());
    private final AtomicInteger methodCallIDCount = new AtomicInteger(0);

    public UnicastServerRef() {
        this.filter = null;
    }

    public UnicastServerRef(LiveRef liveRef) {
        super(liveRef);
        this.filter = null;
    }

    public UnicastServerRef(LiveRef liveRef, ObjectInputFilter objectInputFilter) {
        super(liveRef);
        this.filter = objectInputFilter;
    }

    public UnicastServerRef(int n) {
        super(new LiveRef(n));
        this.filter = null;
    }

    public UnicastServerRef(boolean bl) {
        this(0);
        this.forceStubUse = bl;
    }

    @Override
    public RemoteStub exportObject(Remote remote, Object object) throws RemoteException {
        this.forceStubUse = true;
        return (RemoteStub)this.exportObject(remote, object, false);
    }

    public Remote exportObject(Remote remote, Object object, boolean bl) throws RemoteException {
        Remote remote2;
        Class<?> clazz = remote.getClass();
        try {
            remote2 = Util.createProxy(clazz, this.getClientRef(), this.forceStubUse);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ExportException("remote object implements illegal remote interface", illegalArgumentException);
        }
        if (remote2 instanceof RemoteStub) {
            this.setSkeleton(remote);
        }
        Target target = new Target(remote, this, remote2, this.ref.getObjID(), bl);
        this.ref.exportObject(target);
        if (remote == null) {
            throw new RemoteException("Cannot export null object");
        }
        this.hashToMethod_Map = hashToMethod_Maps.get(clazz);
        return remote2;
    }

    @Override
    public String getClientHost() throws ServerNotActiveException {
        return TCPTransport.getClientHost();
    }

    public void setSkeleton(Remote remote) throws RemoteException {
        if (!withoutSkeletons.containsKey(remote.getClass())) {
            try {
                this.skel = Util.createSkeleton(remote);
            }
            catch (SkeletonNotFoundException skeletonNotFoundException) {
                withoutSkeletons.put(remote.getClass(), null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(Remote remote, RemoteCall remoteCall) throws IOException {
        try {
            Object object;
            long l;
            int n;
            ObjectInput objectInput;
            try {
                objectInput = remoteCall.getInputStream();
                n = objectInput.readInt();
            }
            catch (Exception exception) {
                throw new UnmarshalException("error unmarshalling call header", exception);
            }
            if (this.skel != null) {
                this.oldDispatch(remote, remoteCall, n);
                return;
            }
            if (n >= 0) {
                throw new UnmarshalException("skeleton class not found but required for client version");
            }
            try {
                l = objectInput.readLong();
            }
            catch (Exception exception) {
                throw new UnmarshalException("error unmarshalling call header", exception);
            }
            MarshalInputStream marshalInputStream = (MarshalInputStream)objectInput;
            marshalInputStream.skipDefaultResolveClass();
            Method method = this.hashToMethod_Map.get(l);
            if (method == null) {
                throw new UnmarshalException("unrecognized method hash: method not supported by remote object");
            }
            this.logCall(remote, method);
            Object[] objectArray = null;
            try {
                this.unmarshalCustomCallData(objectInput);
                objectArray = this.unmarshalParameters(remote, method, marshalInputStream);
            }
            catch (AccessException accessException) {
                ((StreamRemoteCall)remoteCall).discardPendingRefs();
                throw accessException;
            }
            catch (IOException | ClassNotFoundException exception) {
                ((StreamRemoteCall)remoteCall).discardPendingRefs();
                throw new UnmarshalException("error unmarshalling arguments", exception);
            }
            finally {
                remoteCall.releaseInputStream();
            }
            try {
                object = method.invoke(remote, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getTargetException();
            }
            try {
                ObjectOutput objectOutput = remoteCall.getResultStream(true);
                Class<?> clazz = method.getReturnType();
                if (clazz != Void.TYPE) {
                    UnicastServerRef.marshalValue(clazz, object, objectOutput);
                }
            }
            catch (IOException iOException) {
                throw new MarshalException("error marshalling return", iOException);
            }
        }
        catch (Throwable throwable) {
            RemoteException remoteException;
            Throwable throwable2 = throwable;
            this.logCallException(throwable);
            ObjectOutput objectOutput = remoteCall.getResultStream(false);
            if (throwable instanceof Error) {
                remoteException = new ServerError("Error occurred in server thread", (Error)throwable);
            } else if (throwable instanceof RemoteException) {
                remoteException = new ServerException("RemoteException occurred in server thread", (Exception)throwable);
            }
            if (suppressStackTraces) {
                UnicastServerRef.clearStackTraces(remoteException);
            }
            objectOutput.writeObject(remoteException);
            if (throwable2 instanceof AccessException) {
                throw new IOException("Connection is not reusable", throwable2);
            }
        }
        finally {
            remoteCall.releaseInputStream();
            remoteCall.releaseOutputStream();
        }
    }

    protected void unmarshalCustomCallData(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        if (this.filter != null && objectInput instanceof ObjectInputStream) {
            final ObjectInputStream objectInputStream = (ObjectInputStream)objectInput;
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    ObjectInputFilter.Config.setObjectInputFilter(objectInputStream, UnicastServerRef.this.filter);
                    return null;
                }
            });
        }
    }

    private void oldDispatch(Remote remote, RemoteCall remoteCall, int n) throws Exception {
        long l;
        Operation[] operationArray;
        ObjectInput objectInput = remoteCall.getInputStream();
        try {
            operationArray = Class.forName("sun.rmi.transport.DGCImpl_Skel");
            if (operationArray.isAssignableFrom(this.skel.getClass())) {
                ((MarshalInputStream)objectInput).useCodebaseOnly();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            l = objectInput.readLong();
        }
        catch (Exception exception) {
            throw new UnmarshalException("error unmarshalling call header", exception);
        }
        operationArray = this.skel.getOperations();
        this.logCall(remote, n >= 0 && n < operationArray.length ? operationArray[n] : "op: " + n);
        this.unmarshalCustomCallData(objectInput);
        this.skel.dispatch(remote, remoteCall, n, l);
    }

    public static void clearStackTraces(Throwable throwable) {
        StackTraceElement[] stackTraceElementArray = new StackTraceElement[]{};
        while (throwable != null) {
            throwable.setStackTrace(stackTraceElementArray);
            throwable = throwable.getCause();
        }
    }

    private void logCall(Remote remote, Object object) {
        if (callLog.isLoggable(Log.VERBOSE)) {
            String string;
            try {
                string = this.getClientHost();
            }
            catch (ServerNotActiveException serverNotActiveException) {
                string = "(local)";
            }
            callLog.log(Log.VERBOSE, "[" + string + ": " + remote.getClass().getName() + this.ref.getObjID().toString() + ": " + object + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logCallException(Throwable throwable) {
        Object object;
        if (callLog.isLoggable(Log.BRIEF)) {
            object = "";
            try {
                object = "[" + this.getClientHost() + "] ";
            }
            catch (ServerNotActiveException serverNotActiveException) {
                // empty catch block
            }
            callLog.log(Log.BRIEF, (String)object + "exception: ", throwable);
        }
        if (wantExceptionLog) {
            Object object2 = object = System.err;
            synchronized (object2) {
                ((PrintStream)object).println();
                ((PrintStream)object).println("Exception dispatching call to " + this.ref.getObjID() + " in thread \"" + Thread.currentThread().getName() + "\" at " + new Date() + ":");
                throwable.printStackTrace((PrintStream)object);
            }
        }
    }

    @Override
    public String getRefClass(ObjectOutput objectOutput) {
        return "UnicastServerRef";
    }

    protected RemoteRef getClientRef() {
        return new UnicastRef(this.ref);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.ref = null;
        this.skel = null;
    }

    private Object[] unmarshalParameters(Object object, Method method, MarshalInputStream marshalInputStream) throws IOException, ClassNotFoundException {
        return object instanceof DeserializationChecker ? this.unmarshalParametersChecked((DeserializationChecker)object, method, marshalInputStream) : this.unmarshalParametersUnchecked(method, marshalInputStream);
    }

    private Object[] unmarshalParametersUnchecked(Method method, ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Class<?>[] classArray = method.getParameterTypes();
        Object[] objectArray = new Object[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            objectArray[i] = UnicastServerRef.unmarshalValue(classArray[i], objectInput);
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] unmarshalParametersChecked(DeserializationChecker deserializationChecker, Method method, MarshalInputStream marshalInputStream) throws IOException, ClassNotFoundException {
        int n = this.methodCallIDCount.getAndIncrement();
        MyChecker myChecker = new MyChecker(deserializationChecker, method, n);
        marshalInputStream.setStreamChecker(myChecker);
        try {
            Class<?>[] classArray = method.getParameterTypes();
            Object[] objectArray = new Object[classArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                myChecker.setIndex(i);
                objectArray[i] = UnicastServerRef.unmarshalValue(classArray[i], marshalInputStream);
            }
            myChecker.end(n);
            Object[] objectArray2 = objectArray;
            return objectArray2;
        }
        finally {
            marshalInputStream.setStreamChecker(null);
        }
    }

    private static class MyChecker
    implements MarshalInputStream.StreamChecker {
        private final DeserializationChecker descriptorCheck;
        private final Method method;
        private final int callID;
        private int parameterIndex;

        MyChecker(DeserializationChecker deserializationChecker, Method method, int n) {
            this.descriptorCheck = deserializationChecker;
            this.method = method;
            this.callID = n;
        }

        @Override
        public void validateDescriptor(ObjectStreamClass objectStreamClass) {
            this.descriptorCheck.check(this.method, objectStreamClass, this.parameterIndex, this.callID);
        }

        @Override
        public void checkProxyInterfaceNames(String[] stringArray) {
            this.descriptorCheck.checkProxyClass(this.method, stringArray, this.parameterIndex, this.callID);
        }

        void setIndex(int n) {
            this.parameterIndex = n;
        }

        void end(int n) {
            this.descriptorCheck.end(n);
        }
    }

    private static class HashToMethod_Maps
    extends WeakClassHashMap<Map<Long, Method>> {
        HashToMethod_Maps() {
        }

        @Override
        protected Map<Long, Method> computeValue(Class<?> clazz) {
            HashMap<Long, Method> hashMap = new HashMap<Long, Method>();
            for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                for (Class<?> clazz3 : clazz2.getInterfaces()) {
                    if (!Remote.class.isAssignableFrom(clazz3)) continue;
                    Method[] methodArray = clazz3.getMethods();
                    int n = methodArray.length;
                    for (int i = 0; i < n; ++i) {
                        Method method;
                        final Method method2 = method = methodArray[i];
                        AccessController.doPrivileged(new PrivilegedAction<Void>(){

                            @Override
                            public Void run() {
                                method2.setAccessible(true);
                                return null;
                            }
                        });
                        hashMap.put(Util.computeMethodHash(method2), method2);
                    }
                }
            }
            return hashMap;
        }
    }
}

