/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.Map;

final class SunEntries {
    private static final String PROP_EGD = "java.security.egd";
    private static final String PROP_RNDSOURCE = "securerandom.source";
    static final String URL_DEV_RANDOM = "file:/dev/random";
    static final String URL_DEV_URANDOM = "file:/dev/urandom";
    private static final String seedSource = AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            String string = System.getProperty(SunEntries.PROP_EGD, "");
            if (string.length() != 0) {
                return string;
            }
            string = Security.getProperty(SunEntries.PROP_RNDSOURCE);
            if (string == null) {
                return "";
            }
            return string;
        }
    });

    private SunEntries() {
    }

    static void putEntries(Map<Object, Object> map) {
        map.put("Policy.JavaPolicy", "sun.security.provider.PolicySpiFile");
    }

    static String getSeedSource() {
        return seedSource;
    }

    static File getDeviceFile(URL uRL) throws IOException {
        try {
            URI uRI = uRL.toURI();
            if (uRI.isOpaque()) {
                URI uRI2 = new File(System.getProperty("user.dir")).toURI();
                String string = uRI2.toString() + uRI.toString().substring(5);
                return new File(URI.create(string));
            }
            return new File(uRI);
        }
        catch (URISyntaxException uRISyntaxException) {
            return new File(uRL.getPath());
        }
    }
}

